/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.ControlFlowInstructionVisitor;

public class GoToInstruction
extends BranchingInstruction {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.controlFlow.GoToInstruction");
    public final boolean isReturn;

    public GoToInstruction(int offset2) {
        this(offset2, BranchingInstruction.Role.END);
    }

    public GoToInstruction(int offset2, BranchingInstruction.Role role) {
        this(offset2, role, false);
    }

    public GoToInstruction(int offset2, BranchingInstruction.Role role, boolean isReturn) {
        super(offset2, role);
        this.isReturn = isReturn;
    }

    @Override
    public String toString() {
        String sRole = "[" + this.role.toString() + "]";
        return "GOTO " + sRole + " " + this.offset + (this.isReturn ? " RETURN" : "");
    }

    @Override
    public int nNext() {
        return 1;
    }

    @Override
    public int getNext(int index2, int no) {
        LOG.assertTrue(no == 0);
        return this.offset;
    }

    @Override
    public void accept(ControlFlowInstructionVisitor visitor2, int offset2, int nextOffset) {
        visitor2.visitGoToInstruction(this, offset2, nextOffset);
    }
}

