/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.XCollection;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractCollectionBinding
extends NotNullDeserializeBinding
implements MultiNodeBinding {
    private List<Binding> itemBindings;
    protected final Class<?> itemType;
    @Nullable
    private final AbstractCollection annotation;
    @Nullable
    protected final XCollection newAnnotation;
    private Serializer serializer;

    public AbstractCollectionBinding(@NotNull Class elementType, @Nullable MutableAccessor accessor) {
        if (elementType == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(0);
        }
        super(accessor);
        this.itemType = elementType;
        XCollection xCollection = this.newAnnotation = accessor == null ? null : accessor.getAnnotation(XCollection.class);
        this.annotation = this.newAnnotation == null ? (accessor == null ? null : accessor.getAnnotation(AbstractCollection.class)) : null;
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    @Override
    public void init(@NotNull Type originalType, @NotNull Serializer serializer) {
        if (originalType == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(1);
        }
        if (serializer == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(2);
        }
        this.serializer = serializer;
    }

    private boolean isSurroundWithTag() {
        return this.newAnnotation == null && (this.annotation == null || this.annotation.surroundWithTag());
    }

    @NotNull
    private Class<?>[] getElementTypes() {
        if (this.newAnnotation != null) {
            Class<?>[] classArray = this.newAnnotation.elementTypes();
            if (classArray == null) {
                AbstractCollectionBinding.$$$reportNull$$$0(3);
            }
            return classArray;
        }
        Class[] classArray = this.annotation == null ? ArrayUtil.EMPTY_CLASS_ARRAY : this.annotation.elementTypes();
        if (classArray == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(4);
        }
        return classArray;
    }

    @NotNull
    private synchronized List<Binding> getElementBindings() {
        if (this.itemBindings == null) {
            Binding binding = this.serializer.getBinding(this.itemType);
            Class<?>[] elementTypes = this.getElementTypes();
            if (elementTypes.length == 0) {
                this.itemBindings = binding == null ? Collections.emptyList() : Collections.singletonList(binding);
            } else {
                this.itemBindings = new SmartList<Binding>();
                if (binding != null) {
                    this.itemBindings.add(binding);
                }
                for (Class<?> aClass2 : elementTypes) {
                    Binding b = this.serializer.getBinding(aClass2);
                    if (b == null || this.itemBindings.contains(b)) continue;
                    this.itemBindings.add(b);
                }
                if (this.itemBindings.isEmpty()) {
                    this.itemBindings = Collections.emptyList();
                }
            }
        }
        List<Binding> list2 = this.itemBindings;
        if (list2 == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Nullable
    private Binding getElementBinding(@NotNull Element element) {
        if (element == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(6);
        }
        for (Binding binding : this.getElementBindings()) {
            if (!binding.isBoundTo(element)) continue;
            return binding;
        }
        return null;
    }

    @NotNull
    abstract Object processResult(@NotNull Collection var1, @Nullable Object var2);

    @Override
    @Nullable
    public Object deserializeList(@Nullable Object context, @NotNull List<Element> elements) {
        Collection<Object> result2;
        if (elements == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(8);
        }
        if (this.getTagName(context) == null) {
            if (context instanceof Collection) {
                result2 = (SmartList)context;
                result2.clear();
            } else {
                result2 = new SmartList();
            }
            for (Element node : elements) {
                result2.add(this.deserializeItem(node, context));
            }
            if (result2 == context) {
                return result2;
            }
        } else {
            assert (elements.size() == 1);
            result2 = this.deserializeSingle(context, elements.get(0));
        }
        return this.processResult(result2, context);
    }

    private Object deserializeItem(@NotNull Element node, @Nullable Object context) {
        Binding binding;
        if (node == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(9);
        }
        if ((binding = this.getElementBinding(node)) == null) {
            String attributeName = this.getValueAttributeName();
            String value = attributeName.isEmpty() ? XmlSerializerImpl.getTextValue(node, "") : node.getAttributeValue(attributeName);
            return XmlSerializerImpl.convert(value, this.itemType);
        }
        return binding.deserializeUnsafe(context, node);
    }

    @NotNull
    private String getElementName() {
        if (this.newAnnotation != null) {
            String string = this.newAnnotation.elementName();
            if (string == null) {
                AbstractCollectionBinding.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = this.annotation == null ? "option" : this.annotation.elementTag();
        if (string == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private String getValueAttributeName() {
        if (this.newAnnotation != null) {
            String string = this.newAnnotation.valueAttributeName();
            if (string == null) {
                AbstractCollectionBinding.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = this.annotation == null ? "value" : this.annotation.elementValueAttribute();
        if (string == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @NotNull
    public Object deserialize(@Nullable Object context, @NotNull Element element) {
        SmartList<Object> result2;
        if (element == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(14);
        }
        if (this.getTagName(context) == null) {
            if (context instanceof Collection) {
                result2 = (Collection)context;
                result2.clear();
            } else {
                result2 = new SmartList<Object>();
            }
            result2.add(this.deserializeItem(element, context));
            if (result2 == context) {
                SmartList<Object> smartList = result2;
                if (smartList == null) {
                    AbstractCollectionBinding.$$$reportNull$$$0(15);
                }
                return smartList;
            }
        } else {
            result2 = this.deserializeSingle(context, element);
        }
        Object object = this.processResult(result2, context);
        if (object == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(16);
        }
        return object;
    }

    @NotNull
    private Collection deserializeSingle(Object context, @NotNull Element node) {
        if (node == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(17);
        }
        Collection result2 = this.createCollection(node.getName());
        for (Element child : node.getChildren()) {
            result2.add(this.deserializeItem(child, context));
        }
        Collection collection = result2;
        if (collection == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(18);
        }
        return collection;
    }

    protected Collection createCollection(@NotNull String tagName) {
        if (tagName == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(19);
        }
        return new SmartList();
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        String tagName;
        if (element == null) {
            AbstractCollectionBinding.$$$reportNull$$$0(20);
        }
        if ((tagName = this.getTagName(element)) != null) {
            return element.getName().equals(tagName);
        }
        if (this.getElementBindings().isEmpty()) {
            return element.getName().equals(this.getElementName());
        }
        return this.getElementBinding(element) != null;
    }

    @Nullable
    private String getTagName(@Nullable Object target) {
        return this.isSurroundWithTag() ? this.getCollectionTagName(target) : null;
    }

    protected abstract String getCollectionTagName(@Nullable Object var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/AbstractCollectionBinding";
                break;
            }
            case 6: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/AbstractCollectionBinding";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementBindings";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAttributeName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeSingle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementBinding";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deserializeItem";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "deserializeSingle";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createCollection";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

