/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.analyze;

import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.context.ContextKt;
import org.jetbrains.kotlin.context.ModuleContext;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.frontend.js.di.InjectionKt;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.resolve.BindingContextSlicesJsKt;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.CompilerDeserializationConfiguration;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.PackagesWithHeaderMetadata;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0007J.\u0010\n\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS;", "", "()V", "analyzeFiles", "Lorg/jetbrains/kotlin/js/analyzer/JsAnalysisResult;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "config", "Lorg/jetbrains/kotlin/js/config/JsConfig;", "analyzeFilesWithGivenTrace", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "moduleContext", "Lorg/jetbrains/kotlin/context/ModuleContext;", "checkForErrors", "", "allFiles", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "js.frontend"})
public final class TopDownAnalyzerFacadeForJS {
    public static final TopDownAnalyzerFacadeForJS INSTANCE;

    @JvmStatic
    @NotNull
    public static final JsAnalysisResult analyzeFiles(@NotNull Collection<? extends KtFile> files2, @NotNull JsConfig config) {
        ModuleDescriptorImpl moduleDescriptorImpl;
        JsModuleDescriptor it;
        Collection<ModuleDescriptorImpl> collection;
        Iterable $receiver$iv$iv;
        Object $receiver$iv;
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Project project = config.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"config.project");
        ProjectContext projectContext = ContextKt.ProjectContext(project);
        Name name = Name.special('<' + config.getModuleId() + '>');
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.special(\"<${config.moduleId}>\")");
        MutableModuleContext context = ContextKt.ContextForNewModule(projectContext, name, JsPlatform.INSTANCE.getBuiltIns(), null);
        LookupTracker lookupTracker = config.getConfiguration().get(CommonConfigurationKeys.LOOKUP_TRACKER);
        config.getConfiguration().put(CommonConfigurationKeys.LOOKUP_TRACKER, LookupTracker.DO_NOTHING.INSTANCE);
        ModuleDescriptorImpl moduleDescriptorImpl2 = context.getModule();
        Collection collection2 = CollectionsKt.listOf((Object)context.getModule());
        List<JsModuleDescriptor<ModuleDescriptorImpl>> list2 = config.getModuleDescriptors();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"config.moduleDescriptors");
        Iterable iterable = list2;
        Collection collection3 = collection2;
        ModuleDescriptorImpl moduleDescriptorImpl3 = moduleDescriptorImpl2;
        void var5_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            JsModuleDescriptor jsModuleDescriptor = (JsModuleDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            moduleDescriptorImpl = (ModuleDescriptorImpl)it.getData();
            collection.add(moduleDescriptorImpl);
        }
        collection = (List)destination$iv$iv;
        List list3 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection3, (Iterable)collection), (Iterable)CollectionsKt.listOf((Object)JsPlatform.INSTANCE.getBuiltIns().getBuiltInsModule()));
        List<JsModuleDescriptor<ModuleDescriptorImpl>> list4 = config.getFriendModuleDescriptors();
        Intrinsics.checkExpressionValueIsNotNull(list4, (String)"config.friendModuleDescriptors");
        $receiver$iv = list4;
        collection3 = list3;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (JsModuleDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            moduleDescriptorImpl = (ModuleDescriptorImpl)it.getData();
            collection.add(moduleDescriptorImpl);
        }
        collection = (List)destination$iv$iv;
        moduleDescriptorImpl3.setDependencies((List<ModuleDescriptorImpl>)collection3, CollectionsKt.toSet((Iterable)collection));
        LookupTracker lookupTracker2 = lookupTracker;
        if (lookupTracker2 != null) {
            Object it2 = $receiver$iv = lookupTracker2;
            config.getConfiguration().put(CommonConfigurationKeys.LOOKUP_TRACKER, it2);
        }
        BindingTraceContext trace = new BindingTraceContext();
        trace.record(BindingContextSlicesJsKt.MODULE_KIND, context.getModule(), config.getModuleKind());
        return TopDownAnalyzerFacadeForJS.analyzeFilesWithGivenTrace(files2, trace, context, config);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final JsAnalysisResult analyzeFilesWithGivenTrace(@NotNull Collection<? extends KtFile> files2, @NotNull BindingTrace trace, @NotNull ModuleContext moduleContext, @NotNull JsConfig config) {
        PackageFragmentProvider packageFragmentProvider;
        ExpectActualTracker expectActualTracker;
        LookupTracker lookupTracker;
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)moduleContext, (String)"moduleContext");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        LookupTracker lookupTracker2 = config.getConfiguration().get(CommonConfigurationKeys.LOOKUP_TRACKER);
        if (lookupTracker2 == null) {
            lookupTracker2 = lookupTracker = (LookupTracker)LookupTracker.DO_NOTHING.INSTANCE;
        }
        if ((expectActualTracker = config.getConfiguration().get(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER)) == null) {
            expectActualTracker = ExpectActualTracker.DoNothing.INSTANCE;
        }
        ExpectActualTracker expectActualTracker2 = expectActualTracker;
        CompilerConfiguration compilerConfiguration = config.getConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)compilerConfiguration, (String)"config.configuration");
        LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(compilerConfiguration);
        IncrementalDataProvider incrementalDataProvider = config.getConfiguration().get(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER);
        if (incrementalDataProvider != null) {
            Collection<byte[]> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            IncrementalDataProvider incrementalDataProvider2;
            IncrementalDataProvider it = incrementalDataProvider2 = incrementalDataProvider;
            Iterable iterable = it.getCompiledPackageParts().values();
            byte[] byArray = it.getHeaderMetadata();
            void var14_11 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it2;
                TranslationResultValue translationResultValue = (TranslationResultValue)item$iv$iv;
                collection = destination$iv$iv;
                byte[] byArray2 = it2.getMetadata();
                collection.add(byArray2);
            }
            collection = (List)destination$iv$iv;
            List list2 = collection;
            byte[] byArray3 = byArray;
            PackagesWithHeaderMetadata metadata2 = new PackagesWithHeaderMetadata(byArray3, list2);
            packageFragmentProvider = KotlinJavascriptSerializationUtil.INSTANCE.readDescriptors(metadata2, moduleContext.getStorageManager(), moduleContext.getModule(), new CompilerDeserializationConfiguration(languageVersionSettings), lookupTracker);
        } else {
            packageFragmentProvider = null;
        }
        PackageFragmentProvider packageFragment = packageFragmentProvider;
        LazyTopDownAnalyzer analyzerForJs = InjectionKt.createTopDownAnalyzerForJs(moduleContext, trace, new FileBasedDeclarationProviderFactory(moduleContext.getStorageManager(), files2), languageVersionSettings, lookupTracker, expectActualTracker2, packageFragment);
        LazyTopDownAnalyzer.analyzeDeclarations$default(analyzerForJs, TopDownAnalysisMode.TopLevelDeclarations, files2, null, 4, null);
        return JsAnalysisResult.Companion.success(trace, moduleContext.getModule());
    }

    @JvmStatic
    public static final void checkForErrors(@NotNull Collection<? extends KtFile> allFiles, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull(allFiles, (String)"allFiles");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
        AnalyzingUtils.throwExceptionOnErrors(bindingContext);
        for (KtFile ktFile : allFiles) {
            AnalyzingUtils.checkForSyntacticErrors(ktFile);
        }
    }

    private TopDownAnalyzerFacadeForJS() {
    }

    static {
        TopDownAnalyzerFacadeForJS topDownAnalyzerFacadeForJS;
        INSTANCE = topDownAnalyzerFacadeForJS = new TopDownAnalyzerFacadeForJS();
    }
}

