/*
 * Decompiled with CFR 0.152.
 */
package javaslang.concurrent;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javaslang.Value;
import javaslang.collection.Iterator;
import javaslang.control.Option;
import javaslang.control.Try;

public interface Future<T>
extends Value<T> {
    public static final ExecutorService DEFAULT_EXECUTOR_SERVICE = Executors.newCachedThreadPool();

    public void await();

    public Option<Try<T>> getValue();

    public boolean isCompleted();

    public Future<T> onComplete(Consumer<? super Try<T>> var1);

    @Override
    default public void forEach(Consumer<? super T> action2) {
        Objects.requireNonNull(action2, "action is null");
        this.onComplete(result2 -> result2.forEach(action2));
    }

    @Override
    default public T get() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("get on failed future");
        }
        return this.getValue().get().get();
    }

    @Override
    default public boolean isEmpty() {
        if (!this.isCompleted()) {
            this.await();
        }
        return this.getValue().get().isEmpty();
    }

    @Override
    default public boolean isSingleValued() {
        return true;
    }

    @Override
    default public Iterator<T> iterator() {
        return this.isEmpty() ? Iterator.empty() : Iterator.of(this.get());
    }

    @Override
    default public String stringPrefix() {
        return "Future";
    }
}

