/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u00020\u0001B+\u0012\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u0002\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ=\u0010\t\u001a\n \u000b*\u0004\u0018\u0001H\nH\n\"\u0004\b\u0000\u0010\n\"\u0004\b\u0001\u0010\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\f0\u000e2\u0006\u0010\u000f\u001a\u0002H\fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/ArrayValue;", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "", "value", "computeType", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "accept", "R", "kotlin.jvm.PlatformType", "D", "visitor", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;", "data", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "equals", "", "other", "", "getType", "module", "hashCode", "", "descriptors"})
public final class ArrayValue
extends ConstantValue<List<? extends ConstantValue<?>>> {
    private final Function1<ModuleDescriptor, KotlinType> computeType;

    @Override
    @NotNull
    public KotlinType getType(@NotNull ModuleDescriptor module2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        Object object = this.computeType.invoke((Object)module2);
        KotlinType type2 = (KotlinType)object;
        boolean bl2 = bl = KotlinBuiltIns.isArray(type2) || KotlinBuiltIns.isPrimitiveArray(type2);
        if (_Assertions.ENABLED && !bl) {
            String string = "Type should be an array, but was " + type2 + ": " + (List)this.getValue();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return (KotlinType)object;
    }

    @Override
    public <R, D> R accept(@NotNull AnnotationArgumentVisitor<R, D> visitor2, D data) {
        Intrinsics.checkParameterIsNotNull(visitor2, (String)"visitor");
        return visitor2.visitArrayValue(this, data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        List list2 = (List)this.getValue();
        Object object = other;
        if (!(object instanceof ArrayValue)) {
            object = null;
        }
        ArrayValue arrayValue = (ArrayValue)object;
        if (!Intrinsics.areEqual((Object)list2, (Object)(arrayValue != null ? (List)arrayValue.getValue() : null))) return false;
        return true;
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public ArrayValue(@NotNull List<? extends ConstantValue<?>> value, @NotNull Function1<? super ModuleDescriptor, ? extends KotlinType> computeType) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        Intrinsics.checkParameterIsNotNull(computeType, (String)"computeType");
        super(value);
        this.computeType = computeType;
    }
}

