/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.Patches;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class BoundedTaskExecutor
extends AbstractExecutorService {
    private static final Logger LOG = Logger.getInstance(BoundedTaskExecutor.class);
    private volatile boolean myShutdown;
    @NotNull
    private final String myName;
    private final Executor myBackendExecutor;
    private final int myMaxTasks;
    private final AtomicLong myStatus;
    private final BlockingQueue<Runnable> myTaskQueue;

    public BoundedTaskExecutor(@NotNull String name, @NotNull Executor backendExecutor, int maxSimultaneousTasks) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/concurrency/BoundedTaskExecutor", "<init>"));
        }
        if (backendExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backendExecutor", "com/intellij/util/concurrency/BoundedTaskExecutor", "<init>"));
        }
        this.myStatus = new AtomicLong();
        this.myTaskQueue = new LinkedBlockingQueue<Runnable>();
        this.myName = name;
        this.myBackendExecutor = backendExecutor;
        if (maxSimultaneousTasks < 1) {
            throw new IllegalArgumentException("maxSimultaneousTasks must be >=1 but got: " + maxSimultaneousTasks);
        }
        if (backendExecutor instanceof BoundedTaskExecutor) {
            throw new IllegalArgumentException("backendExecutor is already BoundedTaskExecutor: " + backendExecutor);
        }
        this.myMaxTasks = maxSimultaneousTasks;
    }

    public BoundedTaskExecutor(@NotNull String name, @NotNull Executor backendExecutor, int maxSimultaneousTasks, @NotNull Disposable parent2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/concurrency/BoundedTaskExecutor", "<init>"));
        }
        if (backendExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backendExecutor", "com/intellij/util/concurrency/BoundedTaskExecutor", "<init>"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/concurrency/BoundedTaskExecutor", "<init>"));
        }
        this(name, backendExecutor, maxSimultaneousTasks);
        Disposer.register(parent2, new Disposable(){

            @Override
            public void dispose() {
                BoundedTaskExecutor.this.shutdownNow();
            }
        });
    }

    static Object info(Runnable info) {
        Runnable task = info;
        String extra = null;
        if (task instanceof FutureTask) {
            extra = ((FutureTask)task).isCancelled() ? " (future cancelled)" : (((FutureTask)task).isDone() ? " (future done)" : null);
            task = ObjectUtils.chooseNotNull(ReflectionUtil.getField(task.getClass(), task, Callable.class, "callable"), task);
        }
        if (task instanceof Callable && task.getClass().getName().equals("java.util.concurrent.Executors$RunnableAdapter")) {
            task = ObjectUtils.chooseNotNull(ReflectionUtil.getField(task.getClass(), task, Runnable.class, "task"), task);
        }
        return extra == null ? task : (task == null ? extra : task.getClass() + extra);
    }

    @Override
    public void shutdown() {
        if (this.myShutdown) {
            throw new IllegalStateException("Already shutdown: " + this);
        }
        this.myShutdown = true;
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        this.shutdown();
        List<Runnable> list2 = this.clearAndCancelAll();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/BoundedTaskExecutor", "shutdownNow"));
        }
        return list2;
    }

    @Override
    public boolean isShutdown() {
        return this.myShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.myShutdown;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/util/concurrency/BoundedTaskExecutor", "awaitTermination"));
        }
        if (!this.isShutdown()) {
            throw new IllegalStateException("you must call shutdown() or shutdownNow() first");
        }
        try {
            void unit;
            this.waitAllTasksExecuted(timeout, (TimeUnit)unit);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (TimeoutException e) {
            return false;
        }
        return true;
    }

    @Override
    public void execute(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/concurrency/BoundedTaskExecutor", "execute"));
        }
        if (this.isShutdown() && !(task instanceof LastTask)) {
            throw new RejectedExecutionException("Already shutdown");
        }
        long status2 = this.incrementCounterAndTimestamp();
        int inProgress = (int)status2;
        assert (inProgress > 0) : inProgress;
        if (inProgress <= this.myMaxTasks) {
            this.wrapAndExecute(task, status2);
            return;
        }
        if (!this.myTaskQueue.offer(task)) {
            throw new RejectedExecutionException();
        }
        Runnable next = this.pollOrGiveUp(status2);
        if (next != null) {
            this.wrapAndExecute(next, status2);
        }
    }

    private long incrementCounterAndTimestamp() {
        long newStatus;
        long status2;
        while (!this.myStatus.compareAndSet(status2 = this.myStatus.get(), newStatus = status2 + 1L + 0x100000000L & Long.MAX_VALUE)) {
        }
        return newStatus;
    }

    private Runnable pollOrGiveUp(long status2) {
        while (true) {
            Runnable next;
            int inProgress = (int)status2;
            assert (inProgress > 0) : inProgress;
            if (inProgress <= this.myMaxTasks && (next = (Runnable)this.myTaskQueue.poll()) != null) {
                return next;
            }
            if (this.myStatus.compareAndSet(status2, status2 - 1L)) break;
            status2 = this.myStatus.get();
        }
        return null;
    }

    private void wrapAndExecute(@NotNull Runnable firstTask, final long status2) {
        if (firstTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstTask", "com/intellij/util/concurrency/BoundedTaskExecutor", "wrapAndExecute"));
        }
        try {
            final AtomicReference<Runnable> currentTask = new AtomicReference<Runnable>(firstTask);
            this.myBackendExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    Runnable task = (Runnable)currentTask.get();
                    do {
                        currentTask.set(task);
                        try {
                            task.run();
                        }
                        catch (Throwable e) {
                            try {
                                LOG.error(e);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    } while ((task = BoundedTaskExecutor.this.pollOrGiveUp(status2)) != null);
                }

                public String toString() {
                    return String.valueOf(BoundedTaskExecutor.info((Runnable)currentTask.get()));
                }
            });
        }
        catch (Error e) {
            this.myStatus.decrementAndGet();
            throw e;
        }
        catch (RuntimeException e) {
            this.myStatus.decrementAndGet();
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void waitAllTasksExecuted(long timeout, @NotNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        void unit;
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/util/concurrency/BoundedTaskExecutor", "waitAllTasksExecuted"));
        }
        final CountDownLatch started = new CountDownLatch(this.myMaxTasks);
        final CountDownLatch readyToFinish = new CountDownLatch(1);
        List<Future> futures = ContainerUtil.map(Collections.nCopies(this.myMaxTasks, null), new Function<Object, Future>(){

            @Override
            public Future fun(Object o) {
                LastTask wait = new LastTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            started.countDown();
                            readyToFinish.await();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                BoundedTaskExecutor.this.execute(wait);
                return wait;
            }
        });
        try {
            if (!started.await(timeout, (TimeUnit)unit)) {
                throw new TimeoutException("Interrupted by timeout. " + this);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            readyToFinish.countDown();
        }
        for (Future future : futures) {
            future.get(timeout, (TimeUnit)unit);
        }
    }

    @NotNull
    public List<Runnable> clearAndCancelAll() {
        ArrayList<Runnable> queued = new ArrayList<Runnable>();
        this.myTaskQueue.drainTo(queued);
        for (Runnable task : queued) {
            if (!(task instanceof FutureTask)) continue;
            ((FutureTask)task).cancel(false);
        }
        ArrayList<Runnable> arrayList = queued;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/BoundedTaskExecutor", "clearAndCancelAll"));
        }
        return arrayList;
    }

    public String toString() {
        return "BoundedExecutor(" + this.myMaxTasks + ") " + (this.isShutdown() ? "SHUTDOWN " : "") + "inProgress: " + (int)this.myStatus.get() + "; " + (this.myTaskQueue.isEmpty() ? "" : "Queue size: " + this.myTaskQueue.size() + "; tasks in queue: [" + ContainerUtil.map(this.myTaskQueue, new Function<Runnable, Object>(){

            @Override
            public Object fun(Runnable runnable) {
                return BoundedTaskExecutor.info(runnable);
            }
        }) + "]") + "name: " + this.myName;
    }

    static {
        assert (Patches.USE_REFLECTION_TO_ACCESS_JDK8);
    }

    private static class LastTask
    extends FutureTask<Void> {
        LastTask(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/util/concurrency/BoundedTaskExecutor$LastTask", "<init>"));
            }
            super(runnable, null);
        }
    }
}

