/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeDeserializer;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.checker.StrictEqualityTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/serialization/js/DynamicTypeDeserializer;", "Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;", "()V", "id", "", "getId", "()Ljava/lang/String;", "create", "Lorg/jetbrains/kotlin/types/KotlinType;", "proto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Type;", "flexibleId", "lowerBound", "Lorg/jetbrains/kotlin/types/SimpleType;", "upperBound", "js.serializer"})
public final class DynamicTypeDeserializer
implements FlexibleTypeDeserializer {
    @NotNull
    private static final String id = "kotlin.DynamicType";
    public static final DynamicTypeDeserializer INSTANCE;

    @NotNull
    public final String getId() {
        return id;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public KotlinType create(@NotNull ProtoBuf.Type proto, @NotNull String flexibleId, @NotNull SimpleType lowerBound, @NotNull SimpleType upperBound) {
        KotlinType kotlinType;
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)flexibleId, (String)"flexibleId");
        Intrinsics.checkParameterIsNotNull((Object)lowerBound, (String)"lowerBound");
        Intrinsics.checkParameterIsNotNull((Object)upperBound, (String)"upperBound");
        if (Intrinsics.areEqual((Object)flexibleId, (Object)id) ^ true) {
            SimpleType simpleType2 = ErrorUtils.createErrorType("Unexpected id: " + flexibleId + ". (" + lowerBound + ".." + upperBound + ')');
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"ErrorUtils.createErrorTy\u2026owerBound..$upperBound)\")");
            return simpleType2;
        }
        SimpleType simpleType3 = TypeUtilsKt.getBuiltIns(lowerBound).getNothingType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"lowerBound.builtIns.nothingType");
        if (StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(lowerBound, simpleType3)) {
            SimpleType simpleType4 = TypeUtilsKt.getBuiltIns(upperBound).getNullableAnyType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType4, (String)"upperBound.builtIns.nullableAnyType");
            if (StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(upperBound, simpleType4)) {
                kotlinType = DynamicTypesKt.createDynamicType(TypeUtilsKt.getBuiltIns(lowerBound));
                return kotlinType;
            }
        }
        SimpleType simpleType5 = ErrorUtils.createErrorType("Illegal type range for dynamic type: " + lowerBound + ".." + upperBound);
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType5, (String)"ErrorUtils.createErrorTy\u2026lowerBound..$upperBound\")");
        kotlinType = simpleType5;
        return kotlinType;
    }

    private DynamicTypeDeserializer() {
        INSTANCE = this;
        id = id;
    }

    static {
        new DynamicTypeDeserializer();
    }
}

