/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionsDataFlowExtras;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/RuntimeAssertionsOnExtensionReceiverCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkReceiver", "receiverParameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "receiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "frontend.java"})
public final class RuntimeAssertionsOnExtensionReceiverCallChecker
implements CallChecker {
    public static final RuntimeAssertionsOnExtensionReceiverCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (CallUtilKt.isSafeCall(resolvedCall2.getCall())) {
            return;
        }
        Object callee = resolvedCall2.getResultingDescriptor();
        this.checkReceiver(callee.getExtensionReceiverParameter(), resolvedCall2.getExtensionReceiver(), context);
    }

    private final void checkReceiver(ReceiverParameterDescriptor receiverParameter, ReceiverValue receiverValue, CallCheckerContext context) {
        if (receiverParameter == null || receiverValue == null) {
            return;
        }
        ReceiverValue $receiver$iv = receiverValue;
        ReceiverValue receiverValue2 = $receiver$iv;
        if (!(receiverValue2 instanceof ExpressionReceiver)) {
            receiverValue2 = null;
        }
        ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue2;
        if (expressionReceiver == null) {
            return;
        }
        ExpressionReceiver expressionReceiverValue = expressionReceiver;
        KtExpression receiverExpression = expressionReceiverValue.getExpression();
        ResolutionContext<?> c = context.getResolutionContext();
        KotlinType kotlinType = receiverValue.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"receiverValue.type");
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiverExpression, kotlinType, c);
        KotlinType kotlinType2 = receiverParameter.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"receiverParameter.type");
        KotlinType kotlinType3 = receiverValue.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"receiverValue.type");
        RuntimeAssertionInfo assertionInfo = RuntimeAssertionInfo.Companion.create(kotlinType2, kotlinType3, new RuntimeAssertionsDataFlowExtras(c, dataFlowValue, receiverExpression));
        if (assertionInfo != null) {
            c.trace.record(JvmBindingContextSlices.RECEIVER_RUNTIME_ASSERTION_INFO, expressionReceiverValue, assertionInfo);
        }
    }

    private RuntimeAssertionsOnExtensionReceiverCallChecker() {
        INSTANCE = this;
    }

    static {
        new RuntimeAssertionsOnExtensionReceiverCallChecker();
    }
}

