/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstUtilKt;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.BinaryOperationKey;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorVisitor;
import org.jetbrains.kotlin.resolve.constants.evaluate.OperationsMapGeneratedKt;
import org.jetbrains.kotlin.resolve.constants.evaluate.UnaryOperationKey;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u00fb\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\f\b\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001fB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J*\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J&\u0010\u0019\u001a\u0014\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001b\u0018\u00010\u001a2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0002J&\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J&\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u00032\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%H\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010\"2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u001e\u0010+\u001a\u0004\u0018\u00010\"2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010-\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003J*\u0010.\u001a\u0004\u0018\u00010\u00142\u0006\u0010/\u001a\u00020\"2\u0006\u0010)\u001a\u00020\"2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0011H\u0002J(\u00103\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u00102\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0002J\"\u00105\u001a\u0004\u0018\u00010\u00142\u0006\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0011H\u0002JV\u00106\u001a8\u0012\u001a\u0012\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0004\u0012\u00020\u001408\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020908\u0018\u0001072\u0006\u0010/\u001a\u00020\"2\u0006\u0010)\u001a\u00020\"2\u0006\u00100\u001a\u000201H\u0002J\u001a\u0010:\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0014\u0018\u00010%2\u0006\u0010;\u001a\u00020\u0003H\u0002J\u001a\u0010<\u001a\u00020\u000f2\u0006\u00100\u001a\u0002012\b\u0010)\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010A\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010B\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J*\u0010C\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00020\u001b2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0\u001b2\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010F\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010G\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010H\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020I2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010J\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020K2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010L\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020M2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010N\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020O2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010P\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020Q2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010R\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020S2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010T\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010U\u001a\u00020V2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010W\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020X2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010Y\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020Z2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010[\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\\2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010]\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020^2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010_\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020`2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016JF\u0010c\u001a\b\u0012\u0004\u0012\u0002Hd0\u001a\"\u0004\b\u0000\u0010d*\b\u0012\u0004\u0012\u0002Hd0\u001c2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010e\u001a\u00020\u000f2\b\b\u0002\u0010G\u001a\u00020\u000f2\b\b\u0002\u0010F\u001a\u00020\u000fH\u0002J&\u0010c\u001a\b\u0012\u0004\u0012\u0002Hd0\u001a\"\u0004\b\u0000\u0010d*\b\u0012\u0004\u0012\u0002Hd0\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006g"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lorg/jetbrains/kotlin/types/KotlinType;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "factory", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValueFactory;", "stringExpressionEvaluator", "org/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$stringExpressionEvaluator$1", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$stringExpressionEvaluator$1;", "canBeUsedInAnnotation", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "createCompileTimeConstant", "value", "", "parameters", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "expectedType", "createConstant", "createConstantValueForArrayFunctionCall", "Lorg/jetbrains/kotlin/resolve/constants/TypedCompileTimeConstant;", "", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "call", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "createIntegerCompileTimeConstant", "", "createOperationArgument", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$OperationArgument;", "parameterType", "compileTimeType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "createOperationArgumentForFirstParameter", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "createOperationArgumentForReceiver", "resolvedCall", "evaluate", "evaluateBinaryAndCheck", "receiver", "name", "", "callExpression", "evaluateCall", "receiverExpression", "evaluateUnaryAndCheck", "getBinaryOperation", "Lkotlin/Pair;", "Lkotlin/Function2;", "Ljava/math/BigInteger;", "getCompileTimeType", "c", "isDivisionByZero", "isPropertyCompileTimeConstant", "descriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "isPureConstant", "isStandaloneOnlyConstant", "isZero", "resolveArguments", "valueArguments", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "usesNonConstValAsConstant", "usesVariableAsConstant", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitClassLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "visitCollectionLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;", "visitConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "visitKtElement", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "visitLabeledExpression", "Lorg/jetbrains/kotlin/psi/KtLabeledExpression;", "visitParenthesizedExpression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "visitQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitStringTemplateExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "wrap", "T", "isPure", "OperationArgument", "frontend"})
final class ConstantExpressionEvaluatorVisitor
extends KtVisitor<CompileTimeConstant<?>, KotlinType> {
    private final ConstantValueFactory factory;
    private final stringExpressionEvaluator.1 stringExpressionEvaluator;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    private final BindingTrace trace;

    @Nullable
    public final CompileTimeConstant<?> evaluate(@NotNull KtExpression expression2, @Nullable KotlinType expectedType2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        CompileTimeConstant<?> recordedCompileTimeConstant = ConstantExpressionEvaluator.Companion.getPossiblyErrorConstant(expression2, bindingContext);
        if (recordedCompileTimeConstant != null) {
            return recordedCompileTimeConstant;
        }
        KtVisitor ktVisitor = this;
        KotlinType kotlinType = expectedType2;
        if (kotlinType == null) {
            kotlinType = TypeUtils.NO_EXPECTED_TYPE;
        }
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)expression2.accept(ktVisitor, kotlinType);
        if (compileTimeConstant != null) {
            this.trace.record(BindingContext.COMPILE_TIME_VALUE, expression2, compileTimeConstant);
            return compileTimeConstant;
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitConstantExpression(@NotNull KtConstantExpression expression2, @Nullable KotlinType expectedType2) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        String string = expression2.getText();
        if (string == null) {
            return null;
        }
        String text2 = string;
        IElementType nodeElementType = expression2.getNode().getElementType();
        if (Intrinsics.areEqual((Object)nodeElementType, (Object)KtNodeTypes.NULL)) {
            return ConstantExpressionEvaluatorVisitor.wrap$default(this, this.factory.createNullValue(), false, false, false, false, 15, null);
        }
        IElementType iElementType = nodeElementType;
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.INTEGER_CONSTANT) || Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FLOAT_CONSTANT)) {
            IElementType iElementType2 = nodeElementType;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"nodeElementType");
            object = ConstantExpressionEvaluatorKt.access$parseNumericLiteral(text2, iElementType2);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BOOLEAN_CONSTANT)) {
            object = ConstantExpressionEvaluatorKt.access$parseBoolean(text2);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CHARACTER_CONSTANT)) {
            object = CompileTimeConstantChecker.parseChar(expression2);
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported constant: " + expression2);
        }
        if (object == null) {
            return null;
        }
        Object result2 = object;
        if (result2 instanceof Double) {
            double d = ((Number)result2).doubleValue();
            if (Double.isInfinite(d)) {
                this.trace.report(Errors.FLOAT_LITERAL_CONFORMS_INFINITY.on((KtConstantExpression)((PsiElement)expression2)));
            }
            if (Intrinsics.areEqual((Object)result2, (Object)0.0) && !TypeConversionUtil.isFPZero(text2)) {
                this.trace.report(Errors.FLOAT_LITERAL_CONFORMS_ZERO.on((KtConstantExpression)((PsiElement)expression2)));
            }
        }
        if (result2 instanceof Float) {
            float f = ((Number)result2).floatValue();
            if (Float.isInfinite(f)) {
                this.trace.report(Errors.FLOAT_LITERAL_CONFORMS_INFINITY.on((KtConstantExpression)((PsiElement)expression2)));
            }
            if (Intrinsics.areEqual((Object)result2, (Object)Float.valueOf(0.0f)) && !TypeConversionUtil.isFPZero(text2)) {
                this.trace.report(Errors.FLOAT_LITERAL_CONFORMS_ZERO.on((KtConstantExpression)((PsiElement)expression2)));
            }
        }
        boolean isLongWithSuffix = Intrinsics.areEqual((Object)nodeElementType, (Object)KtNodeTypes.INTEGER_CONSTANT) && ConstantExpressionEvaluatorKt.access$hasLongSuffix(text2);
        return this.createConstant(result2, expectedType2, new CompileTimeConstant.Parameters(true, !isLongWithSuffix, false, false));
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2, @Nullable KotlinType expectedType2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtExpression deparenthesizedExpression = KtPsiUtil.deparenthesize(expression2);
        if (deparenthesizedExpression != null && Intrinsics.areEqual((Object)deparenthesizedExpression, (Object)expression2) ^ true) {
            return this.evaluate(deparenthesizedExpression, expectedType2);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitLabeledExpression(@NotNull KtLabeledExpression expression2, @Nullable KotlinType expectedType2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtExpression baseExpression = expression2.getBaseExpression();
        if (baseExpression != null) {
            return this.evaluate(baseExpression, expectedType2);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, @Nullable KotlinType expectedType2) {
        CompileTimeConstant<?> compileTimeConstant;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        StringBuilder sb = new StringBuilder();
        boolean interupted = false;
        boolean canBeUsedInAnnotation = true;
        int usesVariableAsConstant = 0;
        boolean usesNonConstantVariableAsConstant = false;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = expression2.getEntries();
        for (n = 0; n < ktStringTemplateEntryArray.length; ++n) {
            KtStringTemplateEntry entry;
            KtStringTemplateEntry ktStringTemplateEntry = entry = ktStringTemplateEntryArray[n];
            Intrinsics.checkExpressionValueIsNotNull((Object)ktStringTemplateEntry, (String)"entry");
            TypedCompileTimeConstant<String> constant = this.stringExpressionEvaluator.evaluate(ktStringTemplateEntry);
            if (constant == null) {
                interupted = true;
                break;
            }
            if (!constant.getCanBeUsedInAnnotations()) {
                canBeUsedInAnnotation = false;
            }
            if (constant.getUsesVariableAsConstant()) {
                usesVariableAsConstant = 1;
            }
            if (constant.getUsesNonConstValAsConstant()) {
                usesNonConstantVariableAsConstant = true;
            }
            sb.append(constant.getConstantValue().getValue());
        }
        if (!interupted) {
            boolean bl = usesNonConstantVariableAsConstant;
            n = usesVariableAsConstant;
            boolean bl2 = canBeUsedInAnnotation;
            boolean bl3 = false;
            compileTimeConstant = this.createConstant(sb.toString(), expectedType2, new CompileTimeConstant.Parameters(bl2, bl3, n != 0, bl));
        } else {
            compileTimeConstant = null;
        }
        return compileTimeConstant;
    }

    private final boolean isStandaloneOnlyConstant(KtExpression expression2) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        if (compileTimeConstant == null) {
            return false;
        }
        return ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(compileTimeConstant);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2, @Nullable KotlinType expectedType2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtExpression ktExpression = expression2.getLeft();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left");
        CompileTimeConstant<?> compileTimeConstant = this.evaluate(ktExpression, expectedType2);
        if (compileTimeConstant != null && expectedType2 != null && !TypeUtils.noExpectedType(expectedType2)) {
            KotlinType kotlinType;
            CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
            if (compileTimeConstant2 instanceof TypedCompileTimeConstant) {
                kotlinType = ((TypedCompileTimeConstant)compileTimeConstant).getType();
            } else if (compileTimeConstant2 instanceof IntegerValueTypeConstant) {
                kotlinType = ((IntegerValueTypeConstant)compileTimeConstant).getType(expectedType2);
            } else {
                throw (Throwable)new IllegalStateException("Unexpected compileTimeConstant class: " + compileTimeConstant.getClass().getCanonicalName());
            }
            KotlinType constantType = kotlinType;
            if (!TypeUtilsKt.isSubtypeOf(constantType, expectedType2)) {
                return null;
            }
        }
        return compileTimeConstant;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitBinaryExpression(@NotNull KtBinaryExpression expression2, @Nullable KotlinType expectedType2) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            return null;
        }
        KtExpression leftExpression = ktExpression;
        IElementType operationToken = expression2.getOperationToken();
        Map map3 = map2 = (Map)OperatorConventions.BOOLEAN_OPERATIONS;
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        if (map3.containsKey(operationToken)) {
            boolean bl;
            KtExpression rightExpression;
            SimpleType booleanType = this.constantExpressionEvaluator.getBuiltIns$frontend().getBooleanType();
            KtExpression ktExpression2 = leftExpression;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"leftExpression");
            CompileTimeConstant<?> compileTimeConstant = this.evaluate(ktExpression2, booleanType);
            if (compileTimeConstant == null) {
                return null;
            }
            CompileTimeConstant<?> leftConstant = compileTimeConstant;
            KtExpression ktExpression3 = expression2.getRight();
            if (ktExpression3 == null) {
                return null;
            }
            KtExpression ktExpression4 = rightExpression = ktExpression3;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"rightExpression");
            CompileTimeConstant<?> compileTimeConstant2 = this.evaluate(ktExpression4, booleanType);
            if (compileTimeConstant2 == null) {
                return null;
            }
            CompileTimeConstant<?> rightConstant = compileTimeConstant2;
            SimpleType simpleType2 = booleanType;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"booleanType");
            Object leftValue = leftConstant.getValue(simpleType2);
            Object rightValue = rightConstant.getValue(booleanType);
            if (!(leftValue instanceof Boolean) || !(rightValue instanceof Boolean)) {
                return null;
            }
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.ANDAND)) {
                bl = ((Boolean)leftValue).booleanValue() && ((Boolean)rightValue).booleanValue();
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.OROR)) {
                bl = ((Boolean)leftValue).booleanValue() || ((Boolean)rightValue).booleanValue();
            } else {
                throw (Throwable)new IllegalArgumentException("Unknown boolean operation token " + operationToken);
            }
            boolean result2 = bl;
            return this.createConstant(result2, expectedType2, new CompileTimeConstant.Parameters(true, false, leftConstant.getUsesVariableAsConstant() || rightConstant.getUsesVariableAsConstant(), leftConstant.getUsesNonConstValAsConstant() || rightConstant.getUsesNonConstValAsConstant()));
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = expression2.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"expression.operationReference");
        KtExpression ktExpression5 = ktOperationReferenceExpression;
        KtExpression ktExpression6 = leftExpression;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression6, (String)"leftExpression");
        return this.evaluateCall(ktExpression5, ktExpression6, expectedType2);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitCollectionLiteralExpression(@NotNull KtCollectionLiteralExpression expression2, @Nullable KotlinType expectedType2) {
        ResolvedCall resolvedCall2;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        ResolvedCall resolvedCall3 = (ResolvedCall)this.trace.getBindingContext().get(BindingContext.COLLECTION_LITERAL_CALL, expression2);
        if (resolvedCall3 == null) {
            return null;
        }
        ResolvedCall resolvedCall4 = resolvedCall2 = resolvedCall3;
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedCall4, (String)"resolvedCall");
        return this.createConstantValueForArrayFunctionCall(resolvedCall4);
    }

    /*
     * WARNING - void declaration
     */
    private final CompileTimeConstant<?> evaluateCall(KtExpression callExpression, KtExpression receiverExpression, KotlinType expectedType2) {
        KtElement ktElement = callExpression;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (!KotlinBuiltIns.isUnderKotlinPackage(resolvedCall3.getResultingDescriptor())) {
            return null;
        }
        Name resultingDescriptorName = resolvedCall3.getResultingDescriptor().getName();
        OperationArgument operationArgument = this.createOperationArgumentForReceiver(resolvedCall3, receiverExpression);
        if (operationArgument == null) {
            return null;
        }
        OperationArgument argumentForReceiver = operationArgument;
        if (this.isStandaloneOnlyConstant(argumentForReceiver.getExpression())) {
            return null;
        }
        Set<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> argumentsEntrySet = resolvedCall3.getValueArguments().entrySet();
        if (argumentsEntrySet.isEmpty()) {
            String string = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resultingDescriptorName.asString()");
            Object object = this.evaluateUnaryAndCheck(argumentForReceiver, string, callExpression);
            if (object == null) {
                return null;
            }
            Object result2 = object;
            boolean isArgumentPure = this.isPureConstant(argumentForReceiver.getExpression());
            boolean canBeUsedInAnnotation = this.canBeUsedInAnnotation(argumentForReceiver.getExpression());
            boolean usesVariableAsConstant = this.usesVariableAsConstant(argumentForReceiver.getExpression());
            boolean usesNonConstValAsConstant = this.usesNonConstValAsConstant(argumentForReceiver.getExpression());
            boolean isNumberConversionMethod = OperatorConventions.NUMBER_CONVERSIONS.contains(resultingDescriptorName);
            return this.createConstant(result2, expectedType2, new CompileTimeConstant.Parameters(canBeUsedInAnnotation, !isNumberConversionMethod && isArgumentPure, usesVariableAsConstant, usesNonConstValAsConstant));
        }
        if (argumentsEntrySet.size() == 1) {
            CompileTimeConstant compileTimeConstant;
            void parameter;
            ResolvedValueArgument argument;
            Map.Entry canBeUsedInAnnotation;
            Map.Entry usesVariableAsConstant = canBeUsedInAnnotation = (Map.Entry)CollectionsKt.first((Iterable)argumentsEntrySet);
            ValueParameterDescriptor result2 = (ValueParameterDescriptor)usesVariableAsConstant.getKey();
            usesVariableAsConstant = canBeUsedInAnnotation;
            ResolvedValueArgument resolvedValueArgument = argument = (ResolvedValueArgument)usesVariableAsConstant.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedValueArgument, (String)"argument");
            void v7 = parameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"parameter");
            OperationArgument operationArgument2 = this.createOperationArgumentForFirstParameter(resolvedValueArgument, (ValueParameterDescriptor)v7);
            if (operationArgument2 == null) {
                return null;
            }
            OperationArgument argumentForParameter = operationArgument2;
            if (this.isStandaloneOnlyConstant(argumentForParameter.getExpression())) {
                return null;
            }
            String string = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resultingDescriptorName.asString()");
            if (this.isDivisionByZero(string, argumentForParameter.getValue())) {
                KtExpression ktExpression = PsiTreeUtil.getParentOfType((PsiElement)receiverExpression, KtExpression.class);
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                KtExpression parentExpression = ktExpression;
                this.trace.report(Errors.DIVISION_BY_ZERO.on((KtExpression)((PsiElement)parentExpression)));
                if (ConstantExpressionEvaluatorKt.isIntegerType(argumentForReceiver.getValue()) && ConstantExpressionEvaluatorKt.isIntegerType(argumentForParameter.getValue()) || !this.constantExpressionEvaluator.getLanguageVersionSettings$frontend().supportsFeature(LanguageFeature.DivisionByZeroInConstantExpressions)) {
                    return ConstantExpressionEvaluatorVisitor.wrap$default(this, this.factory.createErrorValue("Division by zero"), false, false, false, false, 15, null);
                }
            }
            String string2 = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"resultingDescriptorName.asString()");
            Object object = this.evaluateBinaryAndCheck(argumentForReceiver, argumentForParameter, string2, callExpression);
            if (object == null) {
                return null;
            }
            Object result3 = object;
            boolean areArgumentsPure = this.isPureConstant(argumentForReceiver.getExpression()) && this.isPureConstant(argumentForParameter.getExpression());
            boolean canBeUsedInAnnotation2 = this.canBeUsedInAnnotation(argumentForReceiver.getExpression()) && this.canBeUsedInAnnotation(argumentForParameter.getExpression());
            boolean usesVariableAsConstant2 = this.usesVariableAsConstant(argumentForReceiver.getExpression()) || this.usesVariableAsConstant(argumentForParameter.getExpression());
            boolean usesNonConstValAsConstant = this.usesNonConstValAsConstant(argumentForReceiver.getExpression()) || this.usesNonConstValAsConstant(argumentForParameter.getExpression());
            CompileTimeConstant.Parameters parameters2 = new CompileTimeConstant.Parameters(canBeUsedInAnnotation2, areArgumentsPure, usesVariableAsConstant2, usesNonConstValAsConstant);
            Name name = resultingDescriptorName;
            if (Intrinsics.areEqual((Object)name, (Object)OperatorNameConventions.COMPARE_TO)) {
                ConstantValue constantValue = ConstantExpressionEvaluatorKt.access$createCompileTimeConstantForCompareTo(result3, callExpression, this.factory);
                compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters2) : null;
            } else if (Intrinsics.areEqual((Object)name, (Object)OperatorNameConventions.EQUALS)) {
                ConstantValue constantValue = ConstantExpressionEvaluatorKt.access$createCompileTimeConstantForEquals(result3, callExpression, this.factory);
                compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters2) : null;
            } else {
                compileTimeConstant = this.createConstant(result3, expectedType2, parameters2);
            }
            return compileTimeConstant;
        }
        return null;
    }

    private final boolean usesVariableAsConstant(KtExpression expression2) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.getUsesVariableAsConstant() : false;
    }

    private final boolean usesNonConstValAsConstant(KtExpression expression2) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.getUsesNonConstValAsConstant() : false;
    }

    private final boolean canBeUsedInAnnotation(KtExpression expression2) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.getCanBeUsedInAnnotations() : false;
    }

    private final boolean isPureConstant(KtExpression expression2) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.isPure() : false;
    }

    /*
     * WARNING - void declaration
     */
    private final Object evaluateUnaryAndCheck(OperationArgument receiver, String name, KtExpression callExpression) {
        void function2;
        Pair<Function1<Object, Object>, Function1<Long, Long>> functions2;
        Pair<Function1<Object, Object>, Function1<Long, Long>> pair = OperationsMapGeneratedKt.getUnaryOperations().get(new UnaryOperationKey(receiver.getCtcType(), name));
        if (pair == null) {
            return null;
        }
        Pair<Function1<Object, Object>, Function1<Long, Long>> pair2 = functions2 = pair;
        Function1 function1 = (Function1)pair2.component1();
        Function1 check2 = (Function1)pair2.component2();
        Object result2 = function2.invoke(receiver.getValue());
        if (Intrinsics.areEqual((Object)check2, OperationsMapGeneratedKt.getEmptyUnaryFun())) {
            return result2;
        }
        boolean bl = ConstantExpressionEvaluatorKt.isIntegerType(receiver.getValue());
        if (_Assertions.ENABLED && !bl) {
            String string = "Only integer constants should be checked for overflow";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl2 = bl = Intrinsics.areEqual((Object)name, (Object)"minus") || Intrinsics.areEqual((Object)name, (Object)"unaryMinus");
        if (_Assertions.ENABLED && !bl) {
            String string = "Only negation should be checked for overflow";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (Intrinsics.areEqual((Object)receiver.getValue(), (Object)result2) && !this.isZero(receiver.getValue())) {
            void $receiver$iv;
            PsiElement psiElement = callExpression;
            DiagnosticFactory0<KtExpression> diagnosticFactory0 = Errors.INTEGER_OVERFLOW;
            BindingTrace bindingTrace = this.trace;
            KtExpression ktExpression = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtExpression.class, true);
            KtExpression ktExpression2 = ktExpression;
            if (ktExpression2 == null) {
                ktExpression2 = callExpression;
            }
            bindingTrace.report(diagnosticFactory0.on((KtExpression)((PsiElement)ktExpression2)));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final Object evaluateBinaryAndCheck(OperationArgument receiver, OperationArgument parameter, String name, KtExpression callExpression) {
        Function2 function2;
        boolean bl;
        Object object;
        Pair<Function2<Object, Object, Object>, Function2<BigInteger, BigInteger, BigInteger>> functions2;
        Pair<Function2<Object, Object, Object>, Function2<BigInteger, BigInteger, BigInteger>> pair = this.getBinaryOperation(receiver, parameter, name);
        if (pair == null) {
            return null;
        }
        Pair<Function2<Object, Object, Object>, Function2<BigInteger, BigInteger, BigInteger>> pair2 = functions2 = pair;
        Function2 function22 = (Function2)pair2.component1();
        Function2 checker = (Function2)pair2.component2();
        try {
            void function3;
            object = function3.invoke(receiver.getValue(), parameter.getValue());
        }
        catch (Exception e) {
            object = null;
        }
        Object actualResult = object;
        if (Intrinsics.areEqual((Object)checker, OperationsMapGeneratedKt.getEmptyBinaryFun())) {
            return actualResult;
        }
        boolean bl2 = bl = ConstantExpressionEvaluatorKt.isIntegerType(receiver.getValue()) && ConstantExpressionEvaluatorKt.isIntegerType(parameter.getValue());
        if (_Assertions.ENABLED && !bl) {
            String string = "Only integer constants should be checked for overflow";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        evaluateBinaryAndCheck.2 toBigInteger$ = evaluateBinaryAndCheck.2.INSTANCE;
        if (Intrinsics.areEqual((Object)name, (Object)OperatorNameConventions.MOD.asString())) {
            String string = OperatorNameConventions.REM.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"OperatorNameConventions.REM.asString()");
            function2 = this.getBinaryOperation(receiver, parameter, string);
            if (function2 == null || (function2 = (Function2)function2.getSecond()) == null) {
                return null;
            }
        } else {
            function2 = checker;
        }
        Function2 refinedChecker = function2;
        Object object2 = toBigInteger$.invoke(receiver.getValue());
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"toBigInteger(receiver.value)");
        Object object3 = toBigInteger$.invoke(parameter.getValue());
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"toBigInteger(parameter.value)");
        BigInteger resultInBigIntegers = (BigInteger)refinedChecker.invoke(object2, object3);
        if (Intrinsics.areEqual((Object)toBigInteger$.invoke(actualResult), (Object)resultInBigIntegers) ^ true) {
            void $receiver$iv;
            PsiElement psiElement = callExpression;
            DiagnosticFactory0<KtExpression> diagnosticFactory0 = Errors.INTEGER_OVERFLOW;
            BindingTrace bindingTrace = this.trace;
            KtExpression ktExpression = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtExpression.class, true);
            KtExpression ktExpression2 = ktExpression;
            if (ktExpression2 == null) {
                ktExpression2 = callExpression;
            }
            bindingTrace.report(diagnosticFactory0.on((KtExpression)((PsiElement)ktExpression2)));
        }
        return actualResult;
    }

    private final Pair<Function2<Object, Object, Object>, Function2<BigInteger, BigInteger, BigInteger>> getBinaryOperation(OperationArgument receiver, OperationArgument parameter, String name) {
        return OperationsMapGeneratedKt.getBinaryOperations().get(new BinaryOperationKey(receiver.getCtcType(), parameter.getCtcType(), name));
    }

    private final boolean isDivisionByZero(String name, Object parameter) {
        return ConstantExpressionEvaluatorKt.access$getDIVISION_OPERATION_NAMES$p().contains(name) && this.isZero(parameter);
    }

    private final boolean isZero(Object value) {
        boolean bl;
        if (ConstantExpressionEvaluatorKt.isIntegerType(value)) {
            Object object = value;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
            }
            bl = ((Number)object).longValue() == 0L;
        } else {
            bl = value instanceof Float || value instanceof Double ? ((Number)value).doubleValue() == 0.0 : false;
        }
        return bl;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitUnaryExpression(@NotNull KtUnaryExpression expression2, @Nullable KotlinType expectedType2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtExpression ktExpression = expression2.getBaseExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression leftExpression = ktExpression;
        KtSimpleNameExpression ktSimpleNameExpression = expression2.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"expression.operationReference");
        KtExpression ktExpression2 = ktSimpleNameExpression;
        KtExpression ktExpression3 = leftExpression;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"leftExpression");
        return this.evaluateCall(ktExpression2, ktExpression3, expectedType2);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @Nullable KotlinType expectedType2) {
        CallableDescriptor callableDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        DeclarationDescriptor enumDescriptor = (DeclarationDescriptor)this.trace.getBindingContext().get(BindingContext.REFERENCE_TARGET, expression2);
        if (enumDescriptor != null && DescriptorUtils.isEnumEntry(enumDescriptor)) {
            return ConstantExpressionEvaluatorVisitor.wrap$default(this, this.factory.createEnumValue((ClassDescriptor)enumDescriptor), false, false, false, false, 15, null);
        }
        KtElement ktElement = expression2;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 != null && (callableDescriptor = resolvedCall2.getResultingDescriptor()) instanceof VariableDescriptor) {
            if (callableDescriptor instanceof PropertyDescriptor && Intrinsics.areEqual((Object)((Object)((PropertyDescriptor)callableDescriptor).getModality()), (Object)((Object)Modality.FINAL)) ^ true) {
                return null;
            }
            ConstantValue<?> constantValue = ((VariableDescriptor)callableDescriptor).getCompileTimeInitializer();
            if (constantValue == null) {
                return null;
            }
            ConstantValue<?> variableInitializer = constantValue;
            return this.createConstant(variableInitializer.getValue(), expectedType2, new CompileTimeConstant.Parameters(this.isPropertyCompileTimeConstant((VariableDescriptor)callableDescriptor), false, true, !((VariableDescriptor)callableDescriptor).isConst()));
        }
        return null;
    }

    private final boolean isPropertyCompileTimeConstant(VariableDescriptor descriptor2) {
        if (descriptor2.isVar()) {
            return false;
        }
        if (DescriptorUtils.isObject(descriptor2.getContainingDeclaration()) || DescriptorUtils.isStaticDeclaration(descriptor2)) {
            return ConstUtilKt.canBeUsedForConstVal(descriptor2.getType());
        }
        return false;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitQualifiedExpression(@NotNull KtQualifiedExpression expression2, @Nullable KotlinType expectedType2) {
        CompileTimeConstant<?> result2;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtExpression selectorExpression = expression2.getSelectorExpression();
        if (selectorExpression instanceof KtCallExpression) {
            CompileTimeConstant<?> qualifiedCallValue = this.evaluate(selectorExpression, expectedType2);
            if (qualifiedCallValue != null) {
                return qualifiedCallValue;
            }
            KtExpression calleeExpression = ((KtCallExpression)selectorExpression).getCalleeExpression();
            if (!(calleeExpression instanceof KtSimpleNameExpression)) {
                return null;
            }
            KtExpression receiverExpression = expression2.getReceiverExpression();
            return this.evaluateCall(calleeExpression, receiverExpression, expectedType2);
        }
        if (selectorExpression instanceof KtSimpleNameExpression && (result2 = this.evaluateCall(selectorExpression, expression2.getReceiverExpression(), expectedType2)) != null) {
            return result2;
        }
        if (selectorExpression != null) {
            return this.evaluate(selectorExpression, expectedType2);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitCallExpression(@NotNull KtCallExpression expression2, @Nullable KotlinType expectedType2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtElement ktElement = expression2;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> call2 = resolvedCall2;
        CallableDescriptor resultingDescriptor = call2.getResultingDescriptor();
        if (CompileTimeConstantUtils.isArrayFunctionCall(call2)) {
            return this.createConstantValueForArrayFunctionCall(call2);
        }
        if (resultingDescriptor instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)resultingDescriptor).getConstructedClass();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"resultingDescriptor.constructedClass");
            ClassDescriptor classDescriptor2 = classDescriptor;
            if (DescriptorUtils.isAnnotationClass(classDescriptor2)) {
                AnnotationDescriptorImpl descriptor2 = new AnnotationDescriptorImpl(classDescriptor2.getDefaultType(), this.constantExpressionEvaluator.resolveAnnotationArguments$frontend(call2, this.trace), SourceElement.NO_SOURCE);
                return ConstantExpressionEvaluatorVisitor.wrap$default(this, new AnnotationValue(descriptor2), false, false, false, false, 15, null);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final TypedCompileTimeConstant<List<ConstantValue<?>>> createConstantValueForArrayFunctionCall(ResolvedCall<?> call2) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        ConstantExpressionEvaluatorVisitor constantExpressionEvaluatorVisitor;
        Object object;
        block10: {
            CompileTimeConstant it;
            boolean bl5;
            Iterable $receiver$iv;
            List arguments2;
            block9: {
                Collection collection;
                void $receiver$iv$iv;
                Iterable $receiver$iv$iv2;
                Iterable $receiver$iv2;
                KotlinType kotlinType = call2.getResultingDescriptor().getReturnType();
                if (kotlinType == null) {
                    return null;
                }
                KotlinType returnType = kotlinType;
                KotlinType componentType = this.constantExpressionEvaluator.getBuiltIns$frontend().getArrayElementType(returnType);
                Iterable iterable = $receiver$iv2 = (Iterable)call2.getValueArguments().values();
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv2) {
                    ResolvedValueArgument it2 = (ResolvedValueArgument)element$iv$iv;
                    List<ValueArgument> list2 = it2.getArguments();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"it.arguments");
                    KotlinType kotlinType2 = componentType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"componentType");
                    Iterable list$iv$iv = this.resolveArguments(list2, kotlinType2);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                arguments2 = (List)destination$iv$iv;
                List evaluatedArguments = CollectionsKt.filterNotNull((Iterable)arguments2);
                $receiver$iv$iv2 = evaluatedArguments;
                object = this.factory;
                constantExpressionEvaluatorVisitor = this;
                destination$iv$iv = $receiver$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it3;
                    CompileTimeConstant $i$a$1$flatMap = (CompileTimeConstant)item$iv$iv;
                    collection = destination$iv$iv2;
                    KotlinType kotlinType3 = componentType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"componentType");
                    ConstantValue constantValue = it3.toConstantValue(kotlinType3);
                    collection.add(constantValue);
                }
                collection = (List)destination$iv$iv2;
                KotlinType kotlinType4 = returnType;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType4, (String)"returnType");
                $receiver$iv = evaluatedArguments;
                bl4 = false;
                bl3 = false;
                object = ((ConstantValueFactory)object).createArrayValue((List<? extends ConstantValue<?>>)collection, kotlinType4);
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl5 = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        it = (CompileTimeConstant)element$iv;
                        if (!it.getUsesVariableAsConstant()) continue;
                        bl5 = true;
                        break block9;
                    }
                    bl5 = false;
                }
            }
            bl2 = bl5;
            $receiver$iv = arguments2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    it = (CompileTimeConstant)element$iv;
                    if (!(it == null || it.getUsesNonConstValAsConstant())) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        boolean bl6 = bl;
        return ConstantExpressionEvaluatorVisitor.wrap$default(constantExpressionEvaluatorVisitor, (ConstantValue)object, bl3, bl4, bl2, bl6, 3, null);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression2, @Nullable KotlinType expectedType2) {
        KotlinType type2;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KotlinType kotlinType = this.trace.getType(expression2);
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        if (KotlinTypeKt.isError(type2 = kotlinType)) {
            return null;
        }
        KotlinType kotlinType2 = type2;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"type");
        return ConstantExpressionEvaluatorVisitor.wrap$default(this, new KClassValue(kotlinType2), false, false, false, false, 15, null);
    }

    private final List<CompileTimeConstant<?>> resolveArguments(List<? extends ValueArgument> valueArguments, KotlinType expectedType2) {
        ArrayList constants = new ArrayList();
        for (ValueArgument valueArgument : valueArguments) {
            KtExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null) continue;
            constants.add(this.evaluate(argumentExpression, expectedType2));
        }
        return constants;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitKtElement(@NotNull KtElement element, @Nullable KotlinType expectedType2) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return null;
    }

    private final OperationArgument createOperationArgumentForReceiver(ResolvedCall<?> resolvedCall2, KtExpression expression2) {
        KotlinType kotlinType = ConstantExpressionEvaluatorKt.access$getReceiverExpressionType(resolvedCall2);
        if (kotlinType == null) {
            return null;
        }
        KotlinType receiverExpressionType = kotlinType;
        CompileTimeType<? extends Object> compileTimeType = this.getCompileTimeType(receiverExpressionType);
        if (compileTimeType == null) {
            return null;
        }
        CompileTimeType<? extends Object> receiverCompileTimeType = compileTimeType;
        return this.createOperationArgument(expression2, receiverExpressionType, receiverCompileTimeType);
    }

    private final OperationArgument createOperationArgumentForFirstParameter(ResolvedValueArgument argument, ValueParameterDescriptor parameter) {
        KotlinType kotlinType = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"parameter.type");
        CompileTimeType<? extends Object> compileTimeType = this.getCompileTimeType(kotlinType);
        if (compileTimeType == null) {
            return null;
        }
        CompileTimeType<? extends Object> argumentCompileTimeType = compileTimeType;
        List<ValueArgument> arguments2 = argument.getArguments();
        if (arguments2.size() != 1) {
            return null;
        }
        KtExpression ktExpression = ((ValueArgument)CollectionsKt.first(arguments2)).getArgumentExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression argumentExpression = ktExpression;
        KotlinType kotlinType2 = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"parameter.type");
        return this.createOperationArgument(argumentExpression, kotlinType2, argumentCompileTimeType);
    }

    private final CompileTimeType<? extends Object> getCompileTimeType(KotlinType c) {
        KotlinBuiltIns builtIns = this.constantExpressionEvaluator.getBuiltIns$frontend();
        KotlinType kotlinType = TypeUtils.makeNotNullable(c);
        return Intrinsics.areEqual((Object)kotlinType, (Object)builtIns.getIntType()) ? ConstantExpressionEvaluatorKt.getINT() : (Intrinsics.areEqual((Object)kotlinType, (Object)builtIns.getByteType()) ? ConstantExpressionEvaluatorKt.getBYTE() : (Intrinsics.areEqual((Object)kotlinType, (Object)builtIns.getShortType()) ? ConstantExpressionEvaluatorKt.getSHORT() : (Intrinsics.areEqual((Object)kotlinType, (Object)builtIns.getLongType()) ? ConstantExpressionEvaluatorKt.getLONG() : (Intrinsics.areEqual((Object)kotlinType, (Object)builtIns.getDoubleType()) ? ConstantExpressionEvaluatorKt.getDOUBLE() : (Intrinsics.areEqual((Object)kotlinType, (Object)builtIns.getFloatType()) ? ConstantExpressionEvaluatorKt.getFLOAT() : (Intrinsics.areEqual((Object)kotlinType, (Object)builtIns.getCharType()) ? ConstantExpressionEvaluatorKt.getCHAR() : (Intrinsics.areEqual((Object)kotlinType, (Object)builtIns.getBooleanType()) ? ConstantExpressionEvaluatorKt.getBOOLEAN() : (Intrinsics.areEqual((Object)kotlinType, (Object)builtIns.getStringType()) ? ConstantExpressionEvaluatorKt.getSTRING() : (Intrinsics.areEqual((Object)kotlinType, (Object)builtIns.getAnyType()) ? ConstantExpressionEvaluatorKt.getANY() : null)))))))));
    }

    private final OperationArgument createOperationArgument(KtExpression expression2, KotlinType parameterType, CompileTimeType<?> compileTimeType) {
        CompileTimeConstant<?> compileTimeConstant = this.constantExpressionEvaluator.evaluateExpression(expression2, this.trace, parameterType);
        if (compileTimeConstant == null) {
            return null;
        }
        CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
        if (compileTimeConstant2 instanceof TypedCompileTimeConstant && !TypeUtilsKt.isSubtypeOf(((TypedCompileTimeConstant)compileTimeConstant2).getType(), parameterType)) {
            return null;
        }
        Object obj = compileTimeConstant2.getValue(parameterType);
        if (obj == null) {
            return null;
        }
        Object evaluationResult = obj;
        return new OperationArgument(evaluationResult, compileTimeType, expression2);
    }

    private final CompileTimeConstant<?> createConstant(Object value, KotlinType expectedType2, CompileTimeConstant.Parameters parameters2) {
        if (parameters2.isPure()) {
            KotlinType kotlinType = expectedType2;
            if (kotlinType == null) {
                SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"TypeUtils.NO_EXPECTED_TYPE");
                kotlinType = simpleType2;
            }
            return this.createCompileTimeConstant(value, parameters2, kotlinType);
        }
        ConstantValue<?> constantValue = this.factory.createConstantValue(value);
        return constantValue != null ? this.wrap(constantValue, parameters2) : null;
    }

    private final CompileTimeConstant<?> createCompileTimeConstant(Object value, CompileTimeConstant.Parameters parameters2, KotlinType expectedType2) {
        CompileTimeConstant compileTimeConstant;
        Object object = value;
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
            Object object2 = value;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
            }
            compileTimeConstant = this.createIntegerCompileTimeConstant(((Number)object2).longValue(), parameters2, expectedType2);
        } else {
            ConstantValue<?> constantValue = this.factory.createConstantValue(value);
            compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters2) : null;
        }
        return compileTimeConstant;
    }

    private final CompileTimeConstant<?> createIntegerCompileTimeConstant(long value, CompileTimeConstant.Parameters parameters2, KotlinType expectedType2) {
        if (TypeUtils.noExpectedType(expectedType2) || KotlinTypeKt.isError(expectedType2)) {
            return new IntegerValueTypeConstant(value, this.constantExpressionEvaluator.getBuiltIns$frontend(), parameters2);
        }
        ConstantValue<?> integerValue = this.factory.createIntegerConstantValue(value, expectedType2);
        if (integerValue != null) {
            return this.wrap(integerValue, parameters2);
        }
        long l = value;
        return this.wrap(l == (long)((int)value) ? (IntegerValueConstant)this.factory.createIntValue((int)value) : (IntegerValueConstant)this.factory.createLongValue(value), parameters2);
    }

    private final <T> TypedCompileTimeConstant<T> wrap(@NotNull ConstantValue<? extends T> $receiver, CompileTimeConstant.Parameters parameters2) {
        return new TypedCompileTimeConstant<T>($receiver, parameters2);
    }

    private final <T> TypedCompileTimeConstant<T> wrap(@NotNull ConstantValue<? extends T> $receiver, boolean canBeUsedInAnnotation, boolean isPure, boolean usesVariableAsConstant, boolean usesNonConstValAsConstant) {
        return this.wrap($receiver, new CompileTimeConstant.Parameters(canBeUsedInAnnotation, isPure, usesVariableAsConstant, usesNonConstValAsConstant));
    }

    static /* bridge */ /* synthetic */ TypedCompileTimeConstant wrap$default(ConstantExpressionEvaluatorVisitor constantExpressionEvaluatorVisitor, ConstantValue constantValue, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
        if ((n & 1) != 0) {
            boolean bl5 = bl = !(constantValue instanceof NullValue);
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        if ((n & 8) != 0) {
            bl4 = false;
        }
        return constantExpressionEvaluatorVisitor.wrap(constantValue, bl, bl2, bl3, bl4);
    }

    public ConstantExpressionEvaluatorVisitor(@NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)constantExpressionEvaluator, (String)"constantExpressionEvaluator");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.trace = trace;
        this.factory = this.constantExpressionEvaluator.getConstantValueFactory$frontend();
        this.stringExpressionEvaluator = new KtVisitor(this){
            final /* synthetic */ ConstantExpressionEvaluatorVisitor this$0;

            private final TypedCompileTimeConstant<String> createStringConstant(CompileTimeConstant<?> compileTimeConstant) {
                SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"TypeUtils.NO_EXPECTED_TYPE");
                ConstantValue<?> constantValue = compileTimeConstant.toConstantValue(simpleType2);
                if (ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(constantValue)) {
                    return null;
                }
                ConstantValue<?> constantValue2 = constantValue;
                if (constantValue2 instanceof ErrorValue || constantValue2 instanceof EnumValue) {
                    return null;
                }
                return ConstantExpressionEvaluatorVisitor.access$wrap(this.this$0, constantValue2 instanceof NullValue ? ConstantExpressionEvaluatorVisitor.access$getFactory$p(this.this$0).createStringValue("null") : ConstantExpressionEvaluatorVisitor.access$getFactory$p(this.this$0).createStringValue(String.valueOf(constantValue.getValue())), compileTimeConstant.getParameters());
            }

            @Nullable
            public final TypedCompileTimeConstant<String> evaluate(@NotNull KtStringTemplateEntry entry) {
                Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                return (TypedCompileTimeConstant)entry.accept(this, null);
            }

            @Nullable
            public TypedCompileTimeConstant<String> visitStringTemplateEntryWithExpression(@NotNull KtStringTemplateEntryWithExpression entry, @Nullable Void data) {
                TypedCompileTimeConstant<String> typedCompileTimeConstant;
                KtExpression expression2;
                Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                KtExpression ktExpression = entry.getExpression();
                if (ktExpression == null) {
                    return null;
                }
                KtExpression ktExpression2 = expression2 = ktExpression;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression");
                CompileTimeConstant<?> compileTimeConstant = this.this$0.evaluate(ktExpression2, ConstantExpressionEvaluatorVisitor.access$getConstantExpressionEvaluator$p(this.this$0).getBuiltIns$frontend().getStringType());
                if (compileTimeConstant != null) {
                    CompileTimeConstant<?> compileTimeConstant2;
                    CompileTimeConstant<?> it = compileTimeConstant2 = compileTimeConstant;
                    typedCompileTimeConstant = this.createStringConstant(it);
                } else {
                    typedCompileTimeConstant = null;
                }
                return typedCompileTimeConstant;
            }

            @NotNull
            public TypedCompileTimeConstant<String> visitLiteralStringTemplateEntry(@NotNull KtLiteralStringTemplateEntry entry, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                ConstantValueFactory constantValueFactory = ConstantExpressionEvaluatorVisitor.access$getFactory$p(this.this$0);
                String string = entry.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.text");
                return ConstantExpressionEvaluatorVisitor.wrap$default(this.this$0, constantValueFactory.createStringValue(string), false, false, false, false, 15, null);
            }

            @NotNull
            public TypedCompileTimeConstant<String> visitEscapeStringTemplateEntry(@NotNull KtEscapeStringTemplateEntry entry, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                ConstantValueFactory constantValueFactory = ConstantExpressionEvaluatorVisitor.access$getFactory$p(this.this$0);
                String string = entry.getUnescapedValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.unescapedValue");
                return ConstantExpressionEvaluatorVisitor.wrap$default(this.this$0, constantValueFactory.createStringValue(string), false, false, false, false, 15, null);
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @NotNull
    public static final /* synthetic */ TypedCompileTimeConstant access$wrap(ConstantExpressionEvaluatorVisitor $this, @NotNull ConstantValue $receiver, @NotNull CompileTimeConstant.Parameters parameters2) {
        return $this.wrap($receiver, parameters2);
    }

    @NotNull
    public static final /* synthetic */ ConstantValueFactory access$getFactory$p(ConstantExpressionEvaluatorVisitor $this) {
        return $this.factory;
    }

    @NotNull
    public static final /* synthetic */ ConstantExpressionEvaluator access$getConstantExpressionEvaluator$p(ConstantExpressionEvaluatorVisitor $this) {
        return $this.constantExpressionEvaluator;
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$OperationArgument;", "", "value", "ctcType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "getCtcType", "()Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "getValue", "()Ljava/lang/Object;", "frontend"})
    private static final class OperationArgument {
        @NotNull
        private final Object value;
        @NotNull
        private final CompileTimeType<?> ctcType;
        @NotNull
        private final KtExpression expression;

        @NotNull
        public final Object getValue() {
            return this.value;
        }

        @NotNull
        public final CompileTimeType<?> getCtcType() {
            return this.ctcType;
        }

        @NotNull
        public final KtExpression getExpression() {
            return this.expression;
        }

        public OperationArgument(@NotNull Object value, @NotNull CompileTimeType<?> ctcType, @NotNull KtExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull(ctcType, (String)"ctcType");
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            this.value = value;
            this.ctcType = ctcType;
            this.expression = expression2;
        }
    }
}

