/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\b\u00a8\u0006\t"}, d2={"createSynthesizedFunctionWithFirstParameterAsReceiver", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "descriptor", "createSynthesizedInvokes", "", "functions", "isSynthesizedInvoke", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "resolution"})
public final class SynthesizedInvokesKt {
    @NotNull
    public static final Collection<FunctionDescriptor> createSynthesizedInvokes(@NotNull Collection<? extends FunctionDescriptor> functions2) {
        Intrinsics.checkParameterIsNotNull(functions2, (String)"functions");
        ArrayList<FunctionDescriptor> result2 = new ArrayList<FunctionDescriptor>(1);
        for (FunctionDescriptor functionDescriptor : functions2) {
            FunctionDescriptor functionDescriptor2;
            if (Intrinsics.areEqual((Object)functionDescriptor.getName(), (Object)OperatorNameConventions.INVOKE) ^ true || functionDescriptor.getValueParameters().isEmpty()) continue;
            DeclarationDescriptor declarationDescriptor = functionDescriptor.getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            ClassId containerClassId = DescriptorUtilsKt.getClassId((ClassDescriptor)declarationDescriptor);
            if (containerClassId != null && FunctionTypesKt.isBuiltinFunctionClass(containerClassId)) {
                functionDescriptor2 = SynthesizedInvokesKt.createSynthesizedFunctionWithFirstParameterAsReceiver(functionDescriptor);
            } else {
                FunctionDescriptor invokeDeclaration;
                if ((FunctionDescriptor)CollectionsKt.singleOrNull((Iterable)functionDescriptor.getOverriddenDescriptors()) == null) {
                    String string = "No single overridden invoke for " + functionDescriptor + ": " + functionDescriptor.getOverriddenDescriptors();
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                FunctionDescriptor synthesizedSuperFun = SynthesizedInvokesKt.createSynthesizedFunctionWithFirstParameterAsReceiver(invokeDeclaration);
                FunctionDescriptor fakeOverride = synthesizedSuperFun.copy(functionDescriptor.getContainingDeclaration(), synthesizedSuperFun.getModality(), synthesizedSuperFun.getVisibility(), CallableMemberDescriptor.Kind.FAKE_OVERRIDE, false);
                DescriptorUtilsKt.setSingleOverridden(fakeOverride, synthesizedSuperFun);
                FunctionDescriptor functionDescriptor3 = fakeOverride;
                functionDescriptor2 = functionDescriptor3;
                Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor3, (String)"fakeOverride");
            }
            FunctionDescriptor synthesized = functionDescriptor2;
            ReceiverParameterDescriptor receiverParameterDescriptor = functionDescriptor.getDispatchReceiverParameter();
            if (receiverParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            FunctionDescriptor functionDescriptor4 = synthesized.substitute(TypeSubstitutor.create(receiverParameterDescriptor.getType()));
            if (functionDescriptor4 == null) {
                continue;
            }
            result2.add(functionDescriptor4);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final FunctionDescriptor createSynthesizedFunctionWithFirstParameterAsReceiver(FunctionDescriptor descriptor2) {
        Collection<ValueParameterDescriptor> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        FunctionDescriptor.CopyBuilder<? extends FunctionDescriptor> copyBuilder;
        FunctionDescriptor.CopyBuilder<? extends FunctionDescriptor> $receiver = copyBuilder = descriptor2.getOriginal().newCopyBuilder();
        $receiver.setExtensionReceiverType(((ValueParameterDescriptor)CollectionsKt.first(descriptor2.getOriginal().getValueParameters())).getType());
        Iterable iterable = CollectionsKt.drop((Iterable)descriptor2.getOriginal().getValueParameters(), (int)1);
        FunctionDescriptor.CopyBuilder<? extends FunctionDescriptor> copyBuilder2 = $receiver;
        void var5_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            FunctionDescriptor functionDescriptor = descriptor2.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"descriptor.original");
            CallableDescriptor callableDescriptor = functionDescriptor;
            Name name = Name.identifier("" + 'p' + (p.getIndex() + 1));
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(\"p${p.index + 1}\")");
            ValueParameterDescriptor valueParameterDescriptor2 = p.copy(callableDescriptor, name, p.getIndex() - 1);
            collection.add(valueParameterDescriptor2);
        }
        collection = (List)destination$iv$iv;
        copyBuilder2.setValueParameters((List<ValueParameterDescriptor>)collection);
        FunctionDescriptor functionDescriptor = copyBuilder.build();
        if (functionDescriptor == null) {
            Intrinsics.throwNpe();
        }
        return functionDescriptor;
    }

    public static final boolean isSynthesizedInvoke(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (Intrinsics.areEqual((Object)descriptor2.getName(), (Object)OperatorNameConventions.INVOKE) ^ true || !(descriptor2 instanceof FunctionDescriptor)) {
            return false;
        }
        FunctionDescriptor real = (FunctionDescriptor)descriptor2;
        while (!real.getKind().isReal()) {
            if ((FunctionDescriptor)CollectionsKt.singleOrNull((Iterable)real.getOverriddenDescriptors()) != null) continue;
            return false;
        }
        return Intrinsics.areEqual((Object)((Object)real.getKind()), (Object)((Object)CallableMemberDescriptor.Kind.SYNTHESIZED)) && FunctionTypesKt.getFunctionalClassKind(real.getContainingDeclaration()) != null;
    }
}

