/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.builtins.ReflectionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.NotFoundClasses;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.AbstractReflectionApiCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageKt;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000eH\u0014J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH$J\f\u0010\"\u001a\u00020\n*\u00020\u000eH\u0002R\u0012\u0010\t\u001a\u00020\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/AbstractReflectionApiCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "notFoundClasses", "Lorg/jetbrains/kotlin/descriptors/NotFoundClasses;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/descriptors/NotFoundClasses;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "isWholeReflectionApiAvailable", "", "()Z", "kPropertyClasses", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getKPropertyClasses", "()Ljava/util/Set;", "kPropertyClasses$delegate", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isAllowedReflectionApi", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "containingClass", "isReflectionSource", "report", "element", "isKPropertyClass", "frontend"})
public abstract class AbstractReflectionApiCallChecker
implements CallChecker {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final NotNullLazyValue kPropertyClasses$delegate;
    private final ModuleDescriptor module;
    private final NotFoundClasses notFoundClasses;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AbstractReflectionApiCallChecker.class), "kPropertyClasses", "getKPropertyClasses()Ljava/util/Set;"))};
    }

    protected abstract boolean isWholeReflectionApiAvailable();

    protected abstract void report(@NotNull PsiElement var1, @NotNull CallCheckerContext var2);

    private final Set<ClassDescriptor> getKPropertyClasses() {
        return (Set)StorageKt.getValue(this.kPropertyClasses$delegate, (Object)this, $$delegatedProperties[0]);
    }

    @Override
    public final void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (this.isWholeReflectionApiAvailable()) {
            return;
        }
        if (this.isReflectionSource(reportOn)) {
            return;
        }
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor containingClass = classDescriptor;
        if (!ReflectionTypes.Companion.isReflectionClass(containingClass)) {
            return;
        }
        Object obj = descriptor2;
        Intrinsics.checkExpressionValueIsNotNull(obj, (String)"descriptor");
        if (!this.isAllowedReflectionApi((CallableDescriptor)obj, containingClass)) {
            this.report(reportOn, context);
        }
    }

    protected boolean isAllowedReflectionApi(@NotNull CallableDescriptor descriptor2, @NotNull ClassDescriptor containingClass) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)containingClass, (String)"containingClass");
        Name name = descriptor2.getName();
        return AbstractReflectionApiCallCheckerKt.access$getANY_MEMBER_NAMES$p().contains(name.asString()) || Intrinsics.areEqual((Object)name, (Object)OperatorNameConventions.INVOKE) || Intrinsics.areEqual((Object)name.asString(), (Object)"name") || (Intrinsics.areEqual((Object)name.asString(), (Object)"get") || Intrinsics.areEqual((Object)name.asString(), (Object)"set")) && this.isKPropertyClass(containingClass);
    }

    private final boolean isKPropertyClass(@NotNull ClassDescriptor $receiver) {
        boolean bl;
        block3: {
            Iterable $receiver$iv = this.getKPropertyClasses();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ClassDescriptor kProperty = (ClassDescriptor)element$iv;
                    if (!DescriptorUtils.isSubclass($receiver, kProperty)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isReflectionSource(PsiElement reportOn) {
        PsiFile psiFile = reportOn.getContainingFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if (ktFile == null) {
            return false;
        }
        KtFile file = ktFile;
        FqNameUnsafe fqName2 = file.getPackageFqName().toUnsafe();
        return Intrinsics.areEqual((Object)fqName2, (Object)ReflectionTypesKt.getKOTLIN_REFLECT_FQ_NAME().toUnsafe()) || StringsKt.startsWith$default((String)fqName2.asString(), (String)(ReflectionTypesKt.getKOTLIN_REFLECT_FQ_NAME().asString() + "."), (boolean)false, (int)2, null);
    }

    public AbstractReflectionApiCallChecker(@NotNull ModuleDescriptor module2, @NotNull NotFoundClasses notFoundClasses, @NotNull StorageManager storageManager) {
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)notFoundClasses, (String)"notFoundClasses");
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        this.module = module2;
        this.notFoundClasses = notFoundClasses;
        this.kPropertyClasses$delegate = storageManager.createLazyValue((Function0)new Function0<Set<? extends ClassDescriptor>>(this){
            final /* synthetic */ AbstractReflectionApiCallChecker this$0;

            @NotNull
            public final Set<ClassDescriptor> invoke() {
                ReflectionTypes reflectionTypes = new ReflectionTypes(AbstractReflectionApiCallChecker.access$getModule$p(this.this$0), AbstractReflectionApiCallChecker.access$getNotFoundClasses$p(this.this$0));
                return SetsKt.setOf((Object[])new ClassDescriptor[]{reflectionTypes.getKProperty0(), reflectionTypes.getKProperty1(), reflectionTypes.getKProperty2()});
            }
            {
                this.this$0 = abstractReflectionApiCallChecker;
                super(0);
            }
        });
    }

    @NotNull
    public static final /* synthetic */ ModuleDescriptor access$getModule$p(AbstractReflectionApiCallChecker $this) {
        return $this.module;
    }

    @NotNull
    public static final /* synthetic */ NotFoundClasses access$getNotFoundClasses$p(AbstractReflectionApiCallChecker $this) {
        return $this.notFoundClasses;
    }
}

