/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtClassElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J5\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0004J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0012\u0010\u001f\u001a\u00020\u001d2\b\u0010 \u001a\u0004\u0018\u00010\u0013H\u0016J\u0006\u0010!\u001a\u00020\u001dJ\u0006\u0010\"\u001a\u00020\u001dJ\u0006\u0010#\u001a\u00020\u001dR\u0016\u0010\b\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/psi/KtClass;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;)V", "_stub", "get_stub", "()Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;", "accept", "R", "D", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getClassOrInterfaceKeyword", "Lcom/intellij/psi/PsiElement;", "getColon", "getCompanionObjects", "", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "getProperties", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getQualifiedName", "", "isData", "", "isEnum", "isEquivalentTo", "another", "isInner", "isInterface", "isSealed", "frontend"})
public class KtClass
extends KtClassOrObject {
    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        Intrinsics.checkParameterIsNotNull(visitor2, (String)"visitor");
        return visitor2.visitClass(this, data);
    }

    private final KotlinClassStub get_stub() {
        KotlinClassOrObjectStub kotlinClassOrObjectStub = (KotlinClassOrObjectStub)this.getStub();
        if (!(kotlinClassOrObjectStub instanceof KotlinClassStub)) {
            kotlinClassOrObjectStub = null;
        }
        return (KotlinClassStub)kotlinClassOrObjectStub;
    }

    @Nullable
    public final PsiElement getColon() {
        return this.findChildByType(KtTokens.COLON);
    }

    @NotNull
    public final List<KtProperty> getProperties() {
        KtClassBody ktClassBody = this.getBody();
        List list2 = ktClassBody != null ? ktClassBody.getProperties() : null;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    public final boolean isInterface() {
        KotlinClassStub kotlinClassStub = this.get_stub();
        return kotlinClassStub != null ? kotlinClassStub.isInterface() : this.findChildByType(KtTokens.INTERFACE_KEYWORD) != null;
    }

    public final boolean isEnum() {
        return this.hasModifier(KtTokens.ENUM_KEYWORD);
    }

    public final boolean isData() {
        return this.hasModifier(KtTokens.DATA_KEYWORD);
    }

    public final boolean isSealed() {
        return this.hasModifier(KtTokens.SEALED_KEYWORD);
    }

    public final boolean isInner() {
        return this.hasModifier(KtTokens.INNER_KEYWORD);
    }

    @Override
    public boolean isEquivalentTo(@Nullable PsiElement another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof KtClass)) {
            return false;
        }
        String string = this.getQualifiedName();
        if (string == null) {
            return false;
        }
        String fq1 = string;
        String string2 = ((KtClass)another).getQualifiedName();
        if (string2 == null) {
            return false;
        }
        String fq2 = string2;
        if (Intrinsics.areEqual((Object)fq1, (Object)fq2)) {
            boolean thisLocal = this.isLocal();
            if (thisLocal != ((KtClass)another).isLocal()) {
                return false;
            }
            return !thisLocal;
        }
        return false;
    }

    @Nullable
    protected final String getQualifiedName() {
        KotlinClassOrObjectStub stub = (KotlinClassOrObjectStub)this.getStub();
        if (stub != null) {
            FqName fqName2;
            FqName fqName3 = fqName2 = stub.getFqName();
            return fqName3 != null ? fqName3.asString() : null;
        }
        ArrayList<String> parts = new ArrayList<String>();
        KtClassOrObject current = this;
        while (current != null) {
            String string = current.getName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            parts.add(string);
            current = PsiTreeUtil.getParentOfType((PsiElement)current, KtClassOrObject.class);
        }
        PsiFile psiFile = this.getContainingFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if (ktFile == null) {
            return null;
        }
        KtFile file = ktFile;
        String fileQualifiedName = file.getPackageFqName().asString();
        CharSequence charSequence = fileQualifiedName;
        if (!(charSequence.length() == 0)) {
            parts.add(fileQualifiedName);
        }
        Collections.reverse((List)parts);
        return StringUtil.join((Collection<String>)parts, ".");
    }

    @Override
    @NotNull
    public List<KtObjectDeclaration> getCompanionObjects() {
        KtClassBody ktClassBody = this.getBody();
        List list2 = ktClassBody != null ? ktClassBody.getAllCompanionObjects() : null;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    @Nullable
    public final PsiElement getClassOrInterfaceKeyword() {
        return this.findChildByType(TokenSet.create(KtTokens.CLASS_KEYWORD, KtTokens.INTERFACE_KEYWORD));
    }

    public KtClass(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        super(node);
    }

    public KtClass(@NotNull KotlinClassStub stub) {
        Intrinsics.checkParameterIsNotNull((Object)stub, (String)"stub");
        KotlinClassOrObjectStub kotlinClassOrObjectStub = stub;
        KtClassElementType ktClassElementType = KtStubElementTypes.CLASS;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktClassElementType, (String)"KtStubElementTypes.CLASS");
        super(kotlinClassOrObjectStub, (IStubElementType)ktClassElementType);
    }
}

