/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.translate.context.InlineFunctionContext;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006*\u00020\u0002H\u0002\u001a \u0010\t\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u001a\u001a\u0010\u000f\u001a\u00020\u0010*\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\"\u0010\u0015\u001a\u00020\u0016*\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0018"}, d2={"requiresExtensionReceiverParameter", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getRequiresExtensionReceiverParameter", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "getCorrectTypeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "kotlin.jvm.PlatformType", "translateAndAliasParameters", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "descriptor", "targetList", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "translateFunction", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "wrapWithInlineMetadata", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "outerContext", "kotlin-compiler"})
public final class FunctionTranslatorKt {
    @NotNull
    public static final TranslationContext translateAndAliasParameters(@NotNull TranslationContext $receiver, @NotNull FunctionDescriptor descriptor2, @NotNull List<JsParameter> targetList2) {
        Object object;
        Object suggestedName;
        Object object2;
        Object object3;
        Object paramNameForType;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(targetList2, "targetList");
        Map aliases = new LinkedHashMap();
        for (TypeParameterDescriptor type2 : FunctionTranslatorKt.getCorrectTypeParameters(descriptor2)) {
            JsNameRef jsNameRef;
            if (!type2.isReified()) continue;
            paramNameForType = $receiver.getNameForDescriptor(type2);
            object3 = targetList2;
            object2 = new JsParameter((JsName)paramNameForType);
            object3.add(object2);
            suggestedName = Namer.isInstanceSuggestedName(type2);
            JsName paramName = JsScope.declareTemporaryName((String)suggestedName);
            object = targetList2;
            Object object4 = new JsParameter(paramName);
            object.add(object4);
            object = aliases;
            TypeParameterDescriptor typeParameterDescriptor = type2;
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "type");
            object4 = typeParameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(paramName.makeRef(), "paramName.makeRef()");
            object.put(object4, jsNameRef);
        }
        if (FunctionTranslatorKt.getRequiresExtensionReceiverParameter(descriptor2)) {
            JsName receiverParameterName = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            JsNameRef receiverRef = receiverParameterName.makeRef();
            JsExpression jsExpression = receiverRef;
            ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            MetadataProperties.setType(jsExpression, receiverParameterDescriptor.getType());
            paramNameForType = aliases;
            ReceiverParameterDescriptor receiverParameterDescriptor2 = descriptor2.getExtensionReceiverParameter();
            if (receiverParameterDescriptor2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(receiverParameterDescriptor2, "descriptor.extensionReceiverParameter!!");
            suggestedName = receiverParameterDescriptor2;
            Object object5 = receiverRef;
            Intrinsics.checkExpressionValueIsNotNull(object5, "receiverRef");
            object2 = object5;
            paramNameForType.put(suggestedName, object2);
            paramNameForType = targetList2;
            suggestedName = new JsParameter(receiverParameterName);
            paramNameForType.add(suggestedName);
        }
        for (ValueParameterDescriptor valueParameter : descriptor2.getValueParameters()) {
            JsNameRef $i$a$1$also;
            JsName name = $receiver.getNameForDescriptor(valueParameter);
            object2 = JsScope.declareTemporaryName(name.getIdent());
            HasMetadata it = object2;
            MetadataProperties.setDescriptor((JsName)it, (DeclarationDescriptor)valueParameter);
            HasMetadata tmpName = object2;
            object2 = aliases;
            ValueParameterDescriptor valueParameterDescriptor = valueParameter;
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "valueParameter");
            object = valueParameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(JsAstUtils.pureFqn((JsName)tmpName, null), "JsAstUtils.pureFqn(tmpName, null)");
            object2.put(object, $i$a$1$also);
            object2 = targetList2;
            Object $receiver2 = object = new JsParameter((JsName)tmpName);
            MetadataProperties.setHasDefaultValue((JsParameter)$receiver2, DescriptorUtilsKt.hasDefaultValue(valueParameter));
            object2.add(object);
        }
        VariableDescriptor continuationDescriptor = $receiver.getContinuationParameterDescriptor();
        if (continuationDescriptor != null) {
            JsExpression jsExpression;
            JsParameter jsParameter = new JsParameter($receiver.getNameForDescriptor(continuationDescriptor));
            Object object6 = targetList2;
            object6.add(jsParameter);
            object6 = aliases;
            if (!UtilsKt.requiresStateMachineTransformation(descriptor2, $receiver)) {
                JsNameRef jsNameRef = JsAstUtils.pureFqn(jsParameter.getName(), null);
                Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "JsAstUtils.pureFqn(jsParameter.name, null)");
                jsExpression = jsNameRef;
            } else {
                JsExpression jsExpression2 = JsAstUtils.stateMachineReceiver();
                jsExpression = jsExpression2;
                Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "JsAstUtils.stateMachineReceiver()");
            }
            object3 = jsExpression;
            object6.put(continuationDescriptor, object3);
        }
        TranslationContext translationContext = $receiver.innerContextWithDescriptorsAliased(aliases);
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "this.innerContextWithDescriptorsAliased(aliases)");
        return translationContext;
    }

    private static final List<TypeParameterDescriptor> getCorrectTypeParameters(@NotNull FunctionDescriptor $receiver) {
        List<TypeParameterDescriptor> list2;
        FunctionDescriptor functionDescriptor = $receiver;
        if (!(functionDescriptor instanceof PropertyAccessorDescriptor)) {
            functionDescriptor = null;
        }
        if ((list2 = (PropertyAccessorDescriptor)functionDescriptor) == null || (list2 = list2.getCorrespondingProperty()) == null || (list2 = list2.getTypeParameters()) == null) {
            list2 = $receiver.getTypeParameters();
        }
        return list2;
    }

    private static final boolean getRequiresExtensionReceiverParameter(@NotNull FunctionDescriptor $receiver) {
        return DescriptorUtils.isExtension($receiver);
    }

    public static final void translateFunction(@NotNull TranslationContext $receiver, @NotNull KtDeclarationWithBody declaration, @NotNull JsFunction function2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(function2, "function");
        FunctionDescriptor descriptor2 = BindingUtils.getFunctionDescriptor($receiver.bindingContext(), declaration);
        if (declaration.hasBody()) {
            JsBlock body = FunctionBodyTranslator.translateFunctionBody(descriptor2, declaration, $receiver);
            Collection collection = function2.getBody().getStatements();
            List<JsStatement> list2 = body.getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, "body.statements");
            Iterable iterable = list2;
            CollectionsKt.addAll(collection, iterable);
        }
        MetadataProperties.setFunctionDescriptor(function2, descriptor2);
    }

    @NotNull
    public static final JsExpression wrapWithInlineMetadata(@NotNull TranslationContext $receiver, @NotNull TranslationContext outerContext, @NotNull JsFunction function2, @NotNull FunctionDescriptor descriptor2) {
        JsExpression jsExpression;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(outerContext, "outerContext");
        Intrinsics.checkParameterIsNotNull(function2, "function");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        PsiElement sourceInfo = KotlinSourceElementKt.getPsi(descriptor2.getSource());
        if (descriptor2.isInline()) {
            DeclarationDescriptor declarationDescriptor = descriptor2;
            JsConfig jsConfig = $receiver.getConfig();
            Intrinsics.checkExpressionValueIsNotNull(jsConfig, "config");
            if (org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.shouldBeExported(declarationDescriptor, jsConfig)) {
                InlineMetadata metadata2 = InlineMetadata.Companion.compose(function2, descriptor2, $receiver);
                JsExpression functionWithMetadata = metadata2.functionWithMetadata(outerContext, sourceInfo);
                IncrementalResultsConsumer incrementalResultsConsumer = $receiver.getConfig().getConfiguration().get(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER);
                if (incrementalResultsConsumer != null) {
                    Object object;
                    IncrementalResultsConsumer incrementalResultsConsumer2;
                    IncrementalResultsConsumer $receiver2 = incrementalResultsConsumer2 = incrementalResultsConsumer;
                    SourceFile sourceFile = descriptor2.getSource().getContainingFile();
                    if (!(sourceFile instanceof PsiSourceFile)) {
                        sourceFile = null;
                    }
                    if ((object = (PsiSourceFile)sourceFile) == null || (object = ((PsiSourceFile)object).getPsiFile()) == null) {
                    } else {
                        String string;
                        Object psiFile = object;
                        File file = VfsUtilCore.virtualToIoFile(psiFile.getVirtualFile());
                        FunctionDescriptor functionDescriptor = descriptor2;
                        if (functionDescriptor instanceof PropertyGetterDescriptor) {
                            string = "<get>" + DescriptorUtilsKt.getFqNameSafe(((PropertyGetterDescriptor)descriptor2).getCorrespondingProperty()).asString();
                        } else if (functionDescriptor instanceof PropertySetterDescriptor) {
                            string = "<set>" + DescriptorUtilsKt.getFqNameSafe(((PropertySetterDescriptor)descriptor2).getCorrespondingProperty()).asString();
                        } else {
                            String string2 = DescriptorUtilsKt.getFqNameSafe(descriptor2).asString();
                            string = string2;
                            Intrinsics.checkExpressionValueIsNotNull(string2, "descriptor.fqNameSafe.asString()");
                        }
                        String fqName2 = string;
                        File file2 = file;
                        Intrinsics.checkExpressionValueIsNotNull(file2, "file");
                        $receiver2.processInlineFunction(file2, fqName2, functionWithMetadata);
                    }
                }
                jsExpression = functionWithMetadata;
            } else {
                InlineFunctionContext inlineFunctionContext;
                InlineFunctionContext inlineFunctionContext2 = $receiver.getInlineFunctionContext();
                if (inlineFunctionContext2 == null) {
                    Intrinsics.throwNpe();
                }
                InlineFunctionContext it = inlineFunctionContext = inlineFunctionContext2;
                Collection collection = it.getImportBlock().getStatements();
                List<JsStatement> list2 = it.getPrototypeBlock().getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list2, "it.prototypeBlock.statements");
                Collection collection2 = CollectionsKt.plus(collection, (Iterable)list2);
                List<JsStatement> list3 = it.getDeclarationsBlock().getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list3, "it.declarationsBlock.statements");
                JsBlock block = new JsBlock(CollectionsKt.plus((Collection)CollectionsKt.plus(collection2, (Iterable)list3), new JsReturn(function2)));
                jsExpression = InlineMetadata.Companion.wrapFunction(outerContext, new FunctionWithWrapper(function2, block), sourceInfo);
            }
        } else {
            jsExpression = function2;
        }
        return jsExpression;
    }
}

