/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaCodeStyleManager {
    public static final int DO_NOT_ADD_IMPORTS = 4096;
    public static final int INCOMPLETE_CODE = 8192;
    public static final int UNCOMPLETE_CODE = 8192;

    public static JavaCodeStyleManager getInstance(Project project) {
        return ServiceManager.getService(project, JavaCodeStyleManager.class);
    }

    public abstract boolean addImport(@NotNull PsiJavaFile var1, @NotNull PsiClass var2);

    @NotNull
    public abstract PsiElement shortenClassReferences(@NotNull PsiElement var1, int var2) throws IncorrectOperationException;

    @NotNull
    public abstract String getPrefixByVariableKind(@NotNull VariableKind var1);

    @NotNull
    public abstract String getSuffixByVariableKind(@NotNull VariableKind var1);

    public abstract int findEntryIndex(@NotNull PsiImportStatementBase var1);

    @NotNull
    public abstract PsiElement shortenClassReferences(@NotNull PsiElement var1) throws IncorrectOperationException;

    public abstract void shortenClassReferences(@NotNull PsiElement var1, int var2, int var3) throws IncorrectOperationException;

    public abstract void optimizeImports(@NotNull PsiFile var1) throws IncorrectOperationException;

    public abstract PsiImportList prepareOptimizeImportsResult(@NotNull PsiJavaFile var1);

    public boolean hasConflictingOnDemandImport(@NotNull PsiJavaFile file, @NotNull PsiClass psiClass, @NotNull String referenceName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/JavaCodeStyleManager", "hasConflictingOnDemandImport"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/codeStyle/JavaCodeStyleManager", "hasConflictingOnDemandImport"));
        }
        if (referenceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceName", "com/intellij/psi/codeStyle/JavaCodeStyleManager", "hasConflictingOnDemandImport"));
        }
        return false;
    }

    @NotNull
    public VariableKind getVariableKind(@NotNull PsiVariable variable2) {
        if (variable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/codeStyle/JavaCodeStyleManager", "getVariableKind"));
        }
        if (variable2 instanceof PsiField) {
            if (variable2.hasModifierProperty("static")) {
                if (variable2.hasModifierProperty("final")) {
                    VariableKind variableKind = VariableKind.STATIC_FINAL_FIELD;
                    if (variableKind == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/JavaCodeStyleManager", "getVariableKind"));
                    }
                    return variableKind;
                }
                VariableKind variableKind = VariableKind.STATIC_FIELD;
                if (variableKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/JavaCodeStyleManager", "getVariableKind"));
                }
                return variableKind;
            }
            VariableKind variableKind = VariableKind.FIELD;
            if (variableKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/JavaCodeStyleManager", "getVariableKind"));
            }
            return variableKind;
        }
        if (variable2 instanceof PsiParameter) {
            if (((PsiParameter)variable2).getDeclarationScope() instanceof PsiForeachStatement) {
                VariableKind variableKind = VariableKind.LOCAL_VARIABLE;
                if (variableKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/JavaCodeStyleManager", "getVariableKind"));
                }
                return variableKind;
            }
            VariableKind variableKind = VariableKind.PARAMETER;
            if (variableKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/JavaCodeStyleManager", "getVariableKind"));
            }
            return variableKind;
        }
        VariableKind variableKind = VariableKind.LOCAL_VARIABLE;
        if (variableKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/JavaCodeStyleManager", "getVariableKind"));
        }
        return variableKind;
    }

    public SuggestedNameInfo suggestVariableName(@NotNull VariableKind kind, @Nullable String propertyName, @Nullable PsiExpression expr, @Nullable PsiType type2) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/psi/codeStyle/JavaCodeStyleManager", "suggestVariableName"));
        }
        return this.suggestVariableName(kind, propertyName, expr, type2, true);
    }

    @NotNull
    public SuggestedNameInfo suggestCompiledParameterName(@NotNull PsiType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/codeStyle/JavaCodeStyleManager", "suggestCompiledParameterName"));
        }
        SuggestedNameInfo suggestedNameInfo = this.suggestVariableName(VariableKind.PARAMETER, null, null, type2, true);
        if (suggestedNameInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/JavaCodeStyleManager", "suggestCompiledParameterName"));
        }
        return suggestedNameInfo;
    }

    @NotNull
    public abstract SuggestedNameInfo suggestVariableName(@NotNull VariableKind var1, @Nullable String var2, @Nullable PsiExpression var3, @Nullable PsiType var4, boolean var5);

    @NotNull
    public abstract String variableNameToPropertyName(@NonNls @NotNull String var1, @NotNull VariableKind var2);

    @NotNull
    public abstract String propertyNameToVariableName(@NonNls @NotNull String var1, @NotNull VariableKind var2);

    @NotNull
    public abstract String suggestUniqueVariableName(@NonNls @NotNull String var1, PsiElement var2, boolean var3);

    @NotNull
    public SuggestedNameInfo suggestUniqueVariableName(@NotNull SuggestedNameInfo baseNameInfo, PsiElement place, boolean lookForward) {
        if (baseNameInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseNameInfo", "com/intellij/psi/codeStyle/JavaCodeStyleManager", "suggestUniqueVariableName"));
        }
        SuggestedNameInfo suggestedNameInfo = this.suggestUniqueVariableName(baseNameInfo, place, false, lookForward);
        if (suggestedNameInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/JavaCodeStyleManager", "suggestUniqueVariableName"));
        }
        return suggestedNameInfo;
    }

    @NotNull
    public abstract String suggestUniqueVariableName(@NotNull String var1, PsiElement var2, Predicate<PsiVariable> var3);

    @NotNull
    public abstract SuggestedNameInfo suggestUniqueVariableName(@NotNull SuggestedNameInfo var1, PsiElement var2, boolean var3, boolean var4);

    @NotNull
    public abstract PsiElement qualifyClassReferences(@NotNull PsiElement var1);

    public abstract void removeRedundantImports(@NotNull PsiJavaFile var1) throws IncorrectOperationException;

    @Nullable
    public abstract Collection<PsiImportStatementBase> findRedundantImports(@NotNull PsiJavaFile var1);
}

