/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.inline;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineStrategy;

public class InlineUtil {
    public static boolean isInlineLambdaParameter(@NotNull ParameterDescriptor valueParameterOrReceiver) {
        if (valueParameterOrReceiver == null) {
            InlineUtil.$$$reportNull$$$0(0);
        }
        return (!(valueParameterOrReceiver instanceof ValueParameterDescriptor) || !((ValueParameterDescriptor)valueParameterOrReceiver).isNoinline()) && FunctionTypesKt.isFunctionType(valueParameterOrReceiver.getOriginal().getType());
    }

    public static boolean isInline(@Nullable DeclarationDescriptor descriptor2) {
        return descriptor2 instanceof FunctionDescriptor && InlineUtil.getInlineStrategy((FunctionDescriptor)descriptor2).isInline();
    }

    public static boolean hasInlineAccessors(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            InlineUtil.$$$reportNull$$$0(1);
        }
        PropertyGetterDescriptor getter2 = propertyDescriptor.getGetter();
        PropertySetterDescriptor setter2 = propertyDescriptor.getSetter();
        return getter2 != null && getter2.isInline() || setter2 != null && setter2.isInline();
    }

    public static boolean isPropertyWithAllAccessorsAreInline(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            InlineUtil.$$$reportNull$$$0(2);
        }
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return false;
        }
        PropertyGetterDescriptor getter2 = ((PropertyDescriptor)descriptor2).getGetter();
        if (getter2 == null || !getter2.isInline()) {
            return false;
        }
        if (((PropertyDescriptor)descriptor2).isVar()) {
            PropertySetterDescriptor setter2 = ((PropertyDescriptor)descriptor2).getSetter();
            return setter2 != null && setter2.isInline();
        }
        return true;
    }

    public static boolean isInlineOrContainingInline(@Nullable DeclarationDescriptor descriptor2) {
        if (InlineUtil.isInline(descriptor2)) {
            return true;
        }
        if (descriptor2 == null) {
            return false;
        }
        return InlineUtil.isInlineOrContainingInline(descriptor2.getContainingDeclaration());
    }

    @NotNull
    private static InlineStrategy getInlineStrategy(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            InlineUtil.$$$reportNull$$$0(3);
        }
        if (descriptor2.isInline()) {
            InlineStrategy inlineStrategy = InlineStrategy.AS_FUNCTION;
            if (inlineStrategy == null) {
                InlineUtil.$$$reportNull$$$0(4);
            }
            return inlineStrategy;
        }
        InlineStrategy inlineStrategy = InlineStrategy.NOT_INLINE;
        if (inlineStrategy == null) {
            InlineUtil.$$$reportNull$$$0(5);
        }
        return inlineStrategy;
    }

    public static boolean checkNonLocalReturnUsage(@NotNull DeclarationDescriptor fromFunction, @NotNull KtExpression startExpression, @NotNull ResolutionContext<?> context) {
        Object containingFunction;
        if (fromFunction == null) {
            InlineUtil.$$$reportNull$$$0(6);
        }
        if (startExpression == null) {
            InlineUtil.$$$reportNull$$$0(7);
        }
        if (context == null) {
            InlineUtil.$$$reportNull$$$0(8);
        }
        if ((containingFunction = context.getContextParentOfType(startExpression, KtClassOrObject.class, KtDeclarationWithBody.class)) == null) {
            return false;
        }
        return InlineUtil.checkNonLocalReturnUsage(fromFunction, context.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, containingFunction), containingFunction, context.trace.getBindingContext());
    }

    public static boolean checkNonLocalReturnUsage(@NotNull DeclarationDescriptor fromFunction, @Nullable DeclarationDescriptor containingFunctionDescriptor, @Nullable PsiElement containingFunction, @NotNull BindingContext bindingContext) {
        if (fromFunction == null) {
            InlineUtil.$$$reportNull$$$0(9);
        }
        if (bindingContext == null) {
            InlineUtil.$$$reportNull$$$0(10);
        }
        if (containingFunctionDescriptor == null) {
            return false;
        }
        while (InlineUtil.canBeInlineArgument(containingFunction) && fromFunction != containingFunctionDescriptor) {
            if (!InlineUtil.isInlinedArgument((KtFunction)containingFunction, bindingContext, true)) {
                return false;
            }
            containingFunction = (containingFunctionDescriptor = InlineUtil.getContainingClassOrFunctionDescriptor(containingFunctionDescriptor, true)) != null ? DescriptorToSourceUtils.descriptorToDeclaration(containingFunctionDescriptor) : null;
        }
        return fromFunction == containingFunctionDescriptor;
    }

    public static boolean isInlinedArgument(@NotNull KtFunction argument, @NotNull BindingContext bindingContext, boolean checkNonLocalReturn) {
        ValueParameterDescriptor descriptor2;
        if (argument == null) {
            InlineUtil.$$$reportNull$$$0(11);
        }
        if (bindingContext == null) {
            InlineUtil.$$$reportNull$$$0(12);
        }
        if ((descriptor2 = InlineUtil.getInlineArgumentDescriptor(argument, bindingContext)) != null) {
            return !checkNonLocalReturn || InlineUtil.allowsNonLocalReturns(descriptor2);
        }
        return false;
    }

    @Nullable
    public static ValueParameterDescriptor getInlineArgumentDescriptor(@NotNull KtFunction argument, @NotNull BindingContext bindingContext) {
        if (argument == null) {
            InlineUtil.$$$reportNull$$$0(13);
        }
        if (bindingContext == null) {
            InlineUtil.$$$reportNull$$$0(14);
        }
        if (!InlineUtil.canBeInlineArgument(argument)) {
            return null;
        }
        KtExpression call2 = KtPsiUtil.getParentCallIfPresent(argument);
        if (call2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(call2, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        CallableDescriptor descriptor2 = resolvedCall2.getResultingDescriptor();
        if (!InlineUtil.isInline(descriptor2) && !InlineUtil.isArrayConstructorWithLambda(descriptor2)) {
            return null;
        }
        ValueArgument valueArgument = CallUtilKt.getValueArgumentForExpression(resolvedCall2.getCall(), argument);
        if (valueArgument == null) {
            return null;
        }
        ArgumentMapping mapping2 = resolvedCall2.getArgumentMapping(valueArgument);
        if (!(mapping2 instanceof ArgumentMatch)) {
            return null;
        }
        ValueParameterDescriptor parameter = ((ArgumentMatch)mapping2).getValueParameter();
        return InlineUtil.isInlineLambdaParameter(parameter) ? parameter : null;
    }

    public static boolean canBeInlineArgument(@Nullable PsiElement functionalExpression) {
        return functionalExpression instanceof KtFunctionLiteral || functionalExpression instanceof KtNamedFunction;
    }

    public static boolean isArrayConstructorWithLambda(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            InlineUtil.$$$reportNull$$$0(15);
        }
        return descriptor2.getValueParameters().size() == 2 && descriptor2 instanceof ConstructorDescriptor && KotlinBuiltIns.isArrayOrPrimitiveArray(((ConstructorDescriptor)descriptor2).getConstructedClass());
    }

    @Nullable
    public static DeclarationDescriptor getContainingClassOrFunctionDescriptor(@NotNull DeclarationDescriptor descriptor2, boolean strict) {
        DeclarationDescriptor current;
        if (descriptor2 == null) {
            InlineUtil.$$$reportNull$$$0(16);
        }
        DeclarationDescriptor declarationDescriptor = current = strict ? descriptor2.getContainingDeclaration() : descriptor2;
        while (current != null) {
            if (current instanceof FunctionDescriptor || current instanceof ClassDescriptor) {
                return current;
            }
            current = current.getContainingDeclaration();
        }
        return null;
    }

    public static boolean allowsNonLocalReturns(@NotNull CallableDescriptor lambda2) {
        if (lambda2 == null) {
            InlineUtil.$$$reportNull$$$0(17);
        }
        return !(lambda2 instanceof ValueParameterDescriptor) || !((ValueParameterDescriptor)lambda2).isCrossinline();
    }

    public static boolean containsReifiedTypeParameters(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            InlineUtil.$$$reportNull$$$0(18);
        }
        for (TypeParameterDescriptor typeParameterDescriptor : descriptor2.getTypeParameters()) {
            if (!typeParameterDescriptor.isReified()) continue;
            return true;
        }
        return false;
    }

    public static boolean isInlinableParameterExpression(@Nullable KtExpression deparenthesized) {
        return deparenthesized instanceof KtLambdaExpression || deparenthesized instanceof KtNamedFunction || deparenthesized instanceof KtCallableReferenceExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParameterOrReceiver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 2: 
            case 3: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/inline/InlineUtil";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFunction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startExpression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambda";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/inline/InlineUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInlineLambdaParameter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasInlineAccessors";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyWithAllAccessorsAreInline";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInlineStrategy";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkNonLocalReturnUsage";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isInlinedArgument";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getInlineArgumentDescriptor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isArrayConstructorWithLambda";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClassOrFunctionDescriptor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "allowsNonLocalReturns";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "containsReifiedTypeParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

