/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.lang.reflect.Field;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.arguments.Argument;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;

public class Usage {
    @NotNull
    public static <A extends CommonToolArguments> String render(@NotNull CLITool<A> tool, @NotNull A arguments2) {
        if (tool == null) {
            Usage.$$$reportNull$$$0(0);
        }
        if (arguments2 == null) {
            Usage.$$$reportNull$$$0(1);
        }
        StringBuilder sb = new StringBuilder();
        Usage.appendln(sb, "Usage: " + tool.executableScriptFileName() + " <options> <source files>");
        Usage.appendln(sb, "where " + (arguments2.extraHelp ? "advanced" : "possible") + " options include:");
        for (Class<?> clazz = arguments2.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                Usage.fieldUsage(sb, field, arguments2.extraHelp);
            }
        }
        if (arguments2.extraHelp) {
            Usage.appendln(sb, "");
            Usage.appendln(sb, "Advanced options are non-standard and may be changed or removed without any notice.");
        }
        String string = sb.toString();
        if (string == null) {
            Usage.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static void fieldUsage(@NotNull StringBuilder sb, @NotNull Field field, boolean extraHelp) {
        Argument argument;
        if (sb == null) {
            Usage.$$$reportNull$$$0(3);
        }
        if (field == null) {
            Usage.$$$reportNull$$$0(4);
        }
        if ((argument = field.getAnnotation(Argument.class)) == null) {
            return;
        }
        if (extraHelp != ParseCommandLineArgumentsKt.isAdvanced(argument)) {
            return;
        }
        int startLength = sb.length();
        sb.append("  ");
        sb.append(argument.value());
        if (!argument.shortName().isEmpty()) {
            sb.append(" (");
            sb.append(argument.shortName());
            sb.append(")");
        }
        if (!argument.valueDescription().isEmpty()) {
            sb.append(ParseCommandLineArgumentsKt.isAdvanced(argument) ? "=" : " ");
            sb.append(argument.valueDescription());
        }
        int margin = startLength + 29 - 1;
        if (sb.length() >= margin + 5) {
            sb.append("\n");
            margin += sb.length() - startLength;
        }
        while (sb.length() < margin) {
            sb.append(" ");
        }
        sb.append(" ");
        Usage.appendln(sb, argument.description().replace("\n", "\n" + StringsKt.repeat(" ", 29)));
    }

    private static void appendln(@NotNull StringBuilder sb, @NotNull String string) {
        if (sb == null) {
            Usage.$$$reportNull$$$0(5);
        }
        if (string == null) {
            Usage.$$$reportNull$$$0(6);
        }
        sb.append(string);
        StringsKt.appendln(sb);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/common/Usage";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/Usage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fieldUsage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendln";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

