/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallableReferenceImpl;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.BodyGenerator;
import org.jetbrains.kotlin.psi2ir.generators.DeclarationGenerator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/LocalFunctionGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "generateFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "ktFun", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "generateFunctionDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "generateLambda", "ktLambda", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "kotlin-compiler"})
public final class LocalFunctionGenerator
extends StatementGeneratorExtension {
    @NotNull
    public final IrStatement generateLambda(@NotNull KtLambdaExpression ktLambda) {
        Intrinsics.checkParameterIsNotNull(ktLambda, "ktLambda");
        KtFunctionLiteral ktFun = ktLambda.getFunctionLiteral();
        KotlinType lambdaExpressionType = GeneratorKt.getInferredTypeWithImplicitCastsOrFail(this, ktLambda);
        WritableSlice<PsiElement, SimpleFunctionDescriptor> writableSlice = BindingContext.FUNCTION;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.FUNCTION");
        SimpleFunctionDescriptor lambdaDescriptor = (SimpleFunctionDescriptor)GeneratorKt.getOrFail(this, writableSlice, ktFun);
        IrBlockImpl irBlock = new IrBlockImpl(ktLambda.getStartOffset(), PsiUtilsKt.getEndOffset(ktLambda), lambdaExpressionType, IrStatementOrigin.LAMBDA.INSTANCE);
        int n = PsiUtilsKt.getStartOffset(ktFun);
        int n2 = PsiUtilsKt.getEndOffset(ktFun);
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.LOCAL_FUNCTION_FOR_LAMBDA.INSTANCE;
        SimpleFunctionDescriptor simpleFunctionDescriptor = lambdaDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(simpleFunctionDescriptor, "lambdaDescriptor");
        IrFunctionImpl irFun = new IrFunctionImpl(n, n2, irDeclarationOrigin, simpleFunctionDescriptor);
        SimpleFunctionDescriptor simpleFunctionDescriptor2 = lambdaDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(simpleFunctionDescriptor2, "lambdaDescriptor");
        BodyGenerator bodyGenerator = new BodyGenerator(simpleFunctionDescriptor2, this.getStatementGenerator().getContext());
        KtFunctionLiteral ktFunctionLiteral = ktFun;
        Intrinsics.checkExpressionValueIsNotNull(ktFunctionLiteral, "ktFun");
        irFun.setBody(bodyGenerator.generateLambdaBody(ktFunctionLiteral));
        irBlock.getStatements().add(irFun);
        List<IrStatement> list2 = irBlock.getStatements();
        int n3 = ktLambda.getStartOffset();
        int n4 = PsiUtilsKt.getEndOffset(ktLambda);
        SimpleFunctionDescriptor simpleFunctionDescriptor3 = lambdaDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(simpleFunctionDescriptor3, "lambdaDescriptor");
        list2.add(new IrCallableReferenceImpl(n3, n4, lambdaExpressionType, simpleFunctionDescriptor3, null, (IrStatementOrigin)IrStatementOrigin.LAMBDA.INSTANCE));
        return irBlock;
    }

    @NotNull
    public final IrStatement generateFunction(@NotNull KtNamedFunction ktFun) {
        IrStatement irStatement;
        Intrinsics.checkParameterIsNotNull(ktFun, "ktFun");
        if (ktFun.getName() != null) {
            irStatement = this.generateFunctionDeclaration(ktFun);
        } else {
            KotlinType funExpressionType = GeneratorKt.getInferredTypeWithImplicitCastsOrFail(this, ktFun);
            IrBlockImpl irBlock = new IrBlockImpl(PsiUtilsKt.getStartOffset(ktFun), PsiUtilsKt.getEndOffset(ktFun), funExpressionType, IrStatementOrigin.ANONYMOUS_FUNCTION.INSTANCE);
            IrFunction irFun = this.generateFunctionDeclaration(ktFun);
            irBlock.getStatements().add(irFun);
            irBlock.getStatements().add(new IrCallableReferenceImpl(PsiUtilsKt.getStartOffset(ktFun), PsiUtilsKt.getEndOffset(ktFun), funExpressionType, irFun.getDescriptor(), null, (IrStatementOrigin)IrStatementOrigin.ANONYMOUS_FUNCTION.INSTANCE));
            irStatement = irBlock;
        }
        return irStatement;
    }

    private final IrFunction generateFunctionDeclaration(KtNamedFunction ktFun) {
        return new DeclarationGenerator(this.getContext()).generateFunctionDeclaration(ktFun);
    }

    public LocalFunctionGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkParameterIsNotNull(statementGenerator, "statementGenerator");
        super(statementGenerator);
    }
}

