/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.ElementBase;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ExceptionLogger;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.annotation.AnnotatedWithFakeAnnotations;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.CodegenContextUtil;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassContextBase;
import org.jetbrains.kotlin.codegen.context.MultifileClassFacadeContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassPartContext;
import org.jetbrains.kotlin.codegen.context.PackageContext;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationSplitter;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPropertyDescriptor;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class PropertyCodegen {
    private final GenerationState state;
    private final ClassBuilder v;
    private final FunctionCodegen functionCodegen;
    private final KotlinTypeMapper typeMapper;
    private final BindingContext bindingContext;
    private final FieldOwnerContext context;
    private final MemberCodegen<?> memberCodegen;
    private final OwnerKind kind;

    public PropertyCodegen(@NotNull FieldOwnerContext context, @NotNull ClassBuilder v, @NotNull FunctionCodegen functionCodegen, @NotNull MemberCodegen<?> memberCodegen) {
        if (context == null) {
            PropertyCodegen.$$$reportNull$$$0(0);
        }
        if (v == null) {
            PropertyCodegen.$$$reportNull$$$0(1);
        }
        if (functionCodegen == null) {
            PropertyCodegen.$$$reportNull$$$0(2);
        }
        if (memberCodegen == null) {
            PropertyCodegen.$$$reportNull$$$0(3);
        }
        this.state = functionCodegen.state;
        this.v = v;
        this.functionCodegen = functionCodegen;
        this.typeMapper = this.state.getTypeMapper();
        this.bindingContext = this.state.getBindingContext();
        this.context = context;
        this.memberCodegen = memberCodegen;
        this.kind = context.getContextKind();
    }

    public void gen(@NotNull KtProperty property) {
        VariableDescriptor variableDescriptor;
        if (property == null) {
            PropertyCodegen.$$$reportNull$$$0(4);
        }
        if (!((variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, property)) instanceof PropertyDescriptor)) {
            throw ExceptionLogger.logDescriptorNotFound("Property " + property.getName() + " should have a property descriptor: " + variableDescriptor, property);
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variableDescriptor;
        this.gen(property, propertyDescriptor, property.getGetter(), property.getSetter());
    }

    public void generateInPackageFacade(@NotNull DeserializedPropertyDescriptor deserializedProperty) {
        if (deserializedProperty == null) {
            PropertyCodegen.$$$reportNull$$$0(5);
        }
        assert (this.context instanceof MultifileClassFacadeContext) : "should be called only for generating facade: " + this.context;
        this.gen(null, deserializedProperty, null, null);
    }

    private void gen(@Nullable KtProperty declaration, @NotNull PropertyDescriptor descriptor2, @Nullable KtPropertyAccessor getter2, @Nullable KtPropertyAccessor setter2) {
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(6);
        }
        assert (this.kind == OwnerKind.PACKAGE || this.kind == OwnerKind.IMPLEMENTATION || this.kind == OwnerKind.DEFAULT_IMPLS) : "Generating property with a wrong kind (" + (Object)((Object)this.kind) + "): " + descriptor2;
        this.genBackingFieldAndAnnotations(declaration, descriptor2, false);
        if (this.isAccessorNeeded(declaration, descriptor2, getter2)) {
            this.generateGetter(declaration, descriptor2, getter2);
        }
        if (this.isAccessorNeeded(declaration, descriptor2, setter2)) {
            this.generateSetter(declaration, descriptor2, setter2);
        }
    }

    private void genBackingFieldAndAnnotations(@Nullable KtNamedDeclaration declaration, @NotNull PropertyDescriptor descriptor2, boolean isParameter) {
        boolean isBackingFieldOwner;
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(7);
        }
        boolean hasBackingField = this.hasBackingField(descriptor2);
        boolean hasDelegate = declaration instanceof KtProperty && ((KtProperty)declaration).hasDelegate();
        AnnotationSplitter annotationSplitter = AnnotationSplitter.create(LockBasedStorageManager.NO_LOCKS, descriptor2.getAnnotations(), AnnotationSplitter.getTargetSet(isParameter, descriptor2.isVar(), hasBackingField, hasDelegate));
        Annotations propertyAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY);
        boolean bl = descriptor2.isConst() && !Visibilities.isPrivate(descriptor2.getVisibility()) ? !(this.context instanceof MultifileClassPartContext) : (isBackingFieldOwner = CodegenContextUtil.isImplClassOwner(this.context));
        if (isBackingFieldOwner) {
            Annotations fieldAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.FIELD);
            Annotations delegateAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD);
            assert (declaration != null) : "Declaration is null: " + descriptor2 + " (context=" + this.context + ")";
            this.generateBackingField(declaration, descriptor2, fieldAnnotations, delegateAnnotations);
            this.generateSyntheticMethodIfNeeded(descriptor2, propertyAnnotations);
        }
        if (!propertyAnnotations.getAllAnnotations().isEmpty() && this.kind != OwnerKind.DEFAULT_IMPLS && CodegenContextUtil.isImplClassOwner(this.context)) {
            this.v.getSerializationBindings().put(JvmSerializationBindings.SYNTHETIC_METHOD_FOR_PROPERTY, descriptor2, this.getSyntheticMethodSignature(descriptor2));
        }
    }

    private boolean isAccessorNeeded(@Nullable KtProperty declaration, @NotNull PropertyDescriptor descriptor2, @Nullable KtPropertyAccessor accessor) {
        boolean isDefaultAccessor;
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(8);
        }
        if (JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(descriptor2)) {
            return false;
        }
        boolean bl = isDefaultAccessor = accessor == null || !accessor.hasBody();
        if (this.kind == OwnerKind.DEFAULT_IMPLS && isDefaultAccessor) {
            return false;
        }
        if (declaration == null) {
            return true;
        }
        if (declaration.hasDelegate() || declaration.getReceiverTypeReference() != null) {
            return true;
        }
        if (DescriptorUtils.isCompanionObject(descriptor2.getContainingDeclaration())) {
            return true;
        }
        if (PropertyCodegen.isNonConstTopLevelPropertyInMultifileClass(declaration, descriptor2)) {
            return true;
        }
        if (Visibilities.isPrivate(descriptor2.getVisibility())) {
            return !isDefaultAccessor;
        }
        return true;
    }

    private static boolean isNonConstTopLevelPropertyInMultifileClass(@NotNull KtProperty declaration, @NotNull PropertyDescriptor descriptor2) {
        if (declaration == null) {
            PropertyCodegen.$$$reportNull$$$0(9);
        }
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(10);
        }
        return !descriptor2.isConst() && descriptor2.getContainingDeclaration() instanceof PackageFragmentDescriptor && JvmFileClassUtilKt.isInsideJvmMultifileClassFile(declaration);
    }

    private static boolean areAccessorsNeededForPrimaryConstructorProperty(@NotNull PropertyDescriptor descriptor2) {
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(11);
        }
        if (org.jetbrains.kotlin.resolve.jvm.annotations.AnnotationUtilKt.hasJvmFieldAnnotation(descriptor2)) {
            return false;
        }
        return !Visibilities.isPrivate(descriptor2.getVisibility());
    }

    public void generatePrimaryConstructorProperty(@NotNull KtParameter p, @NotNull PropertyDescriptor descriptor2) {
        if (p == null) {
            PropertyCodegen.$$$reportNull$$$0(12);
        }
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(13);
        }
        this.genBackingFieldAndAnnotations(p, descriptor2, true);
        if (PropertyCodegen.areAccessorsNeededForPrimaryConstructorProperty(descriptor2)) {
            this.generateGetter(p, descriptor2, null);
            this.generateSetter(p, descriptor2, null);
        }
    }

    public void generateConstructorPropertyAsMethodForAnnotationClass(KtParameter p, PropertyDescriptor descriptor2) {
        JvmMethodGenericSignature signature2 = this.typeMapper.mapAnnotationParameterSignature(descriptor2);
        String name = p.getName();
        if (name == null) {
            return;
        }
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(p, (DeclarationDescriptor)descriptor2), 1025, name, signature2.getAsmMethod().getDescriptor(), signature2.getGenericsSignature(), null);
        KtExpression defaultValue = p.getDefaultValue();
        if (defaultValue != null) {
            ConstantValue<?> constant = ExpressionCodegen.getCompileTimeConstant(defaultValue, this.bindingContext, true, this.state.getShouldInlineConstVals());
            assert (!this.state.getClassBuilderMode().generateBodies || constant != null) : "Default value for annotation parameter should be compile time value: " + defaultValue.getText();
            if (constant != null) {
                AnnotationCodegen annotationCodegen = AnnotationCodegen.forAnnotationDefaultValue(mv, this.memberCodegen, this.typeMapper);
                annotationCodegen.generateAnnotationDefaultValue(constant, descriptor2.getType());
            }
        }
        mv.visitEnd();
    }

    private boolean hasBackingField(@NotNull PropertyDescriptor descriptor2) {
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(14);
        }
        return !JvmCodegenUtil.isJvmInterface(descriptor2.getContainingDeclaration()) && this.kind != OwnerKind.DEFAULT_IMPLS && !Boolean.FALSE.equals(this.bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2));
    }

    private boolean generateBackingField(@NotNull KtNamedDeclaration p, @NotNull PropertyDescriptor descriptor2, @NotNull Annotations backingFieldAnnotations, @NotNull Annotations delegateAnnotations) {
        if (p == null) {
            PropertyCodegen.$$$reportNull$$$0(15);
        }
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(16);
        }
        if (backingFieldAnnotations == null) {
            PropertyCodegen.$$$reportNull$$$0(17);
        }
        if (delegateAnnotations == null) {
            PropertyCodegen.$$$reportNull$$$0(18);
        }
        if (JvmCodegenUtil.isJvmInterface(descriptor2.getContainingDeclaration()) || this.kind == OwnerKind.DEFAULT_IMPLS) {
            return false;
        }
        if (p instanceof KtProperty && ((KtProperty)p).hasDelegate()) {
            this.generatePropertyDelegateAccess((KtProperty)p, descriptor2, delegateAnnotations);
        } else if (Boolean.TRUE.equals(this.bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2))) {
            this.generateBackingFieldAccess(p, descriptor2, backingFieldAnnotations);
        } else {
            return false;
        }
        return true;
    }

    private void generateSyntheticMethodIfNeeded(@NotNull PropertyDescriptor descriptor2, @NotNull Annotations annotations2) {
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(19);
        }
        if (annotations2 == null) {
            PropertyCodegen.$$$reportNull$$$0(20);
        }
        if (annotations2.getAllAnnotations().isEmpty()) {
            return;
        }
        Object contextDescriptor = this.context.getContextDescriptor();
        if (!DescriptorUtils.isInterface(contextDescriptor) || FunctionCodegen.processInterface(contextDescriptor, this.kind, this.state) || this.kind == OwnerKind.DEFAULT_IMPLS && this.state.getGenerateDefaultImplsForJvm8()) {
            this.memberCodegen.generateSyntheticAnnotationsMethod(descriptor2, this.getSyntheticMethodSignature(descriptor2), annotations2, AnnotationUseSiteTarget.PROPERTY);
        }
    }

    @NotNull
    private Method getSyntheticMethodSignature(@NotNull PropertyDescriptor descriptor2) {
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(21);
        }
        ReceiverParameterDescriptor receiver = descriptor2.getExtensionReceiverParameter();
        String name = JvmAbi.getSyntheticMethodNameForAnnotatedProperty(descriptor2.getName());
        String desc = receiver == null ? "()V" : "(" + this.typeMapper.mapType(receiver.getType()) + ")V";
        Method method = new Method(name, desc);
        if (method == null) {
            PropertyCodegen.$$$reportNull$$$0(22);
        }
        return method;
    }

    private void generateBackingField(KtNamedDeclaration element, PropertyDescriptor propertyDescriptor, boolean isDelegate, KotlinType kotlinType, Object defaultValue, Annotations annotations2) {
        int modifiers2 = AsmUtil.getDeprecatedAccessFlag(propertyDescriptor);
        for (AnnotationCodegen.JvmFlagAnnotation flagAnnotation : AnnotationCodegen.FIELD_FLAGS) {
            if (!flagAnnotation.hasAnnotation(propertyDescriptor.getOriginal())) continue;
            modifiers2 |= flagAnnotation.getJvmFlag();
        }
        if (this.kind == OwnerKind.PACKAGE) {
            modifiers2 |= 8;
        }
        if (!(propertyDescriptor.isLateInit() || propertyDescriptor.isVar() && !isDelegate)) {
            modifiers2 |= 0x10;
        }
        if (AnnotationUtilKt.hasJvmSyntheticAnnotation(propertyDescriptor)) {
            modifiers2 |= 0x1000;
        }
        Type type2 = this.typeMapper.mapType(kotlinType);
        ClassBuilder builder = this.v;
        FieldOwnerContext backingFieldContext = this.context;
        if (AsmUtil.isInstancePropertyWithStaticBackingField(propertyDescriptor)) {
            modifiers2 |= 8;
            if (JvmAbi.isPropertyWithBackingFieldInOuterClass(propertyDescriptor)) {
                ImplementationBodyCodegen codegen = (ImplementationBodyCodegen)this.memberCodegen.getParentCodegen();
                builder = codegen.v;
                backingFieldContext = codegen.context;
            }
        }
        modifiers2 |= AsmUtil.getVisibilityForBackingField(propertyDescriptor, isDelegate);
        if (AsmUtil.isPropertyWithBackingFieldCopyInOuterClass(propertyDescriptor)) {
            ImplementationBodyCodegen parentBodyCodegen = (ImplementationBodyCodegen)this.memberCodegen.getParentCodegen();
            parentBodyCodegen.addCompanionObjectPropertyToCopy(propertyDescriptor, defaultValue);
        }
        String name = backingFieldContext.getFieldName(propertyDescriptor, isDelegate);
        this.v.getSerializationBindings().put(JvmSerializationBindings.FIELD_FOR_PROPERTY, propertyDescriptor, Pair.create(type2, name));
        FieldVisitor fv = builder.newField(JvmDeclarationOriginKt.OtherOrigin(element, (DeclarationDescriptor)propertyDescriptor), modifiers2, name, type2.getDescriptor(), isDelegate ? null : this.typeMapper.mapFieldSignature(kotlinType, propertyDescriptor), defaultValue);
        AnnotatedWithFakeAnnotations fieldAnnotated = new AnnotatedWithFakeAnnotations(propertyDescriptor, annotations2);
        AnnotationCodegen.forField(fv, this.memberCodegen, this.typeMapper).genAnnotations(fieldAnnotated, type2, isDelegate ? AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD : AnnotationUseSiteTarget.FIELD);
    }

    private void generatePropertyDelegateAccess(@NotNull KtProperty p, @NotNull PropertyDescriptor propertyDescriptor, @NotNull Annotations annotations2) {
        if (p == null) {
            PropertyCodegen.$$$reportNull$$$0(23);
        }
        if (propertyDescriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(24);
        }
        if (annotations2 == null) {
            PropertyCodegen.$$$reportNull$$$0(25);
        }
        KotlinType delegateType = this.getDelegateTypeForProperty(p, propertyDescriptor);
        this.generateBackingField(p, propertyDescriptor, true, delegateType, null, annotations2);
    }

    @NotNull
    private KotlinType getDelegateTypeForProperty(@NotNull KtProperty p, @NotNull PropertyDescriptor propertyDescriptor) {
        if (p == null) {
            PropertyCodegen.$$$reportNull$$$0(26);
        }
        if (propertyDescriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(27);
        }
        KotlinType delegateType = null;
        ResolvedCall<FunctionDescriptor> provideDelegateResolvedCall = this.bindingContext.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, propertyDescriptor);
        KtExpression delegateExpression = p.getDelegateExpression();
        if (provideDelegateResolvedCall != null) {
            delegateType = provideDelegateResolvedCall.getResultingDescriptor().getReturnType();
        } else if (delegateExpression != null) {
            delegateType = this.bindingContext.getType(delegateExpression);
        }
        if (delegateType == null) {
            delegateType = ErrorUtils.createErrorType("Delegate type");
        }
        KotlinType kotlinType = delegateType;
        if (kotlinType == null) {
            PropertyCodegen.$$$reportNull$$$0(28);
        }
        return kotlinType;
    }

    private void generateBackingFieldAccess(@NotNull KtNamedDeclaration p, @NotNull PropertyDescriptor propertyDescriptor, @NotNull Annotations annotations2) {
        ConstantValue<?> initializer2;
        if (p == null) {
            PropertyCodegen.$$$reportNull$$$0(29);
        }
        if (propertyDescriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(30);
        }
        if (annotations2 == null) {
            PropertyCodegen.$$$reportNull$$$0(31);
        }
        Object value = null;
        if (this.shouldWriteFieldInitializer(propertyDescriptor) && (initializer2 = propertyDescriptor.getCompileTimeInitializer()) != null) {
            value = initializer2.getValue();
        }
        this.generateBackingField(p, propertyDescriptor, false, propertyDescriptor.getType(), value, annotations2);
    }

    private boolean shouldWriteFieldInitializer(@NotNull PropertyDescriptor descriptor2) {
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(32);
        }
        if (!descriptor2.isVar()) {
            Type type2 = this.typeMapper.mapType(descriptor2);
            return AsmUtil.isPrimitive(type2) || "java.lang.String".equals(type2.getClassName());
        }
        return false;
    }

    private void generateGetter(@Nullable KtNamedDeclaration p, @NotNull PropertyDescriptor descriptor2, @Nullable KtPropertyAccessor getter2) {
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(33);
        }
        this.generateAccessor(p, getter2, descriptor2.getGetter() != null ? descriptor2.getGetter() : DescriptorFactory.createDefaultGetter(descriptor2, Annotations.Companion.getEMPTY()));
    }

    private void generateSetter(@Nullable KtNamedDeclaration p, @NotNull PropertyDescriptor descriptor2, @Nullable KtPropertyAccessor setter2) {
        if (descriptor2 == null) {
            PropertyCodegen.$$$reportNull$$$0(34);
        }
        if (!descriptor2.isVar()) {
            return;
        }
        this.generateAccessor(p, setter2, descriptor2.getSetter() != null ? descriptor2.getSetter() : DescriptorFactory.createDefaultSetter(descriptor2, Annotations.Companion.getEMPTY()));
    }

    private void generateAccessor(@Nullable KtNamedDeclaration p, @Nullable KtPropertyAccessor accessor, @NotNull PropertyAccessorDescriptor accessorDescriptor) {
        if (accessorDescriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(35);
        }
        if (this.context instanceof MultifileClassFacadeContext && (Visibilities.isPrivate(accessorDescriptor.getVisibility()) || AsmUtil.getVisibilityAccessFlag(accessorDescriptor) == 2)) {
            return;
        }
        FunctionGenerationStrategy.CodegenBased strategy = accessor == null || !accessor.hasBody() ? (p instanceof KtProperty && ((KtProperty)p).hasDelegate() ? new DelegatedPropertyAccessorStrategy(this.state, accessorDescriptor, PropertyCodegen.indexOfDelegatedProperty((KtProperty)p)) : new DefaultPropertyAccessorStrategy(this.state, accessorDescriptor)) : new FunctionGenerationStrategy.FunctionDefault(this.state, accessor);
        this.functionCodegen.generateMethod(JvmDeclarationOriginKt.OtherOrigin(accessor != null ? accessor : p, (DeclarationDescriptor)accessorDescriptor), accessorDescriptor, strategy);
    }

    public static int indexOfDelegatedProperty(@NotNull KtProperty property) {
        ElementBase container2;
        PsiElement parent2;
        if (property == null) {
            PropertyCodegen.$$$reportNull$$$0(36);
        }
        if ((parent2 = property.getParent()) instanceof KtClassBody) {
            container2 = (KtClassOrObject)parent2.getParent();
        } else if (parent2 instanceof KtFile) {
            container2 = (KtFile)parent2;
        } else if (KtPsiUtil.isScriptDeclaration(property)) {
            container2 = KtPsiUtil.getScript(property);
            assert (container2 != null) : "Script declaration for property '" + property.getText() + "' should be not null!";
        } else {
            throw new UnsupportedOperationException("Unknown delegated property container: " + parent2);
        }
        int index2 = 0;
        for (KtDeclaration declaration : container2.getDeclarations()) {
            if (!(declaration instanceof KtProperty) || !((KtProperty)declaration).hasDelegate()) continue;
            if (declaration == property) {
                return index2;
            }
            ++index2;
        }
        throw new IllegalStateException("Delegated property not found in its parent: " + PsiUtilsKt.getElementTextWithContext(property));
    }

    public static StackValue invokeDelegatedPropertyConventionMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull ExpressionCodegen codegen, @NotNull KotlinTypeMapper typeMapper, @NotNull ResolvedCall<FunctionDescriptor> resolvedCall2, int indexInPropertyMetadataArray, int propertyMetadataArgumentIndex) {
        if (propertyDescriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(37);
        }
        if (codegen == null) {
            PropertyCodegen.$$$reportNull$$$0(38);
        }
        if (typeMapper == null) {
            PropertyCodegen.$$$reportNull$$$0(39);
        }
        if (resolvedCall2 == null) {
            PropertyCodegen.$$$reportNull$$$0(40);
        }
        StackValue.Property receiver = codegen.intermediateValueForProperty(propertyDescriptor, true, null, StackValue.LOCAL_0);
        return PropertyCodegen.invokeDelegatedPropertyConventionMethodWithReceiver(codegen, typeMapper, resolvedCall2, indexInPropertyMetadataArray, propertyMetadataArgumentIndex, receiver, propertyDescriptor);
    }

    public static StackValue invokeDelegatedPropertyConventionMethodWithReceiver(@NotNull ExpressionCodegen codegen, @NotNull KotlinTypeMapper typeMapper, @NotNull ResolvedCall<FunctionDescriptor> resolvedCall2, final int indexInPropertyMetadataArray, int propertyMetadataArgumentIndex, @Nullable StackValue receiver, @NotNull PropertyDescriptor propertyDescriptor) {
        if (codegen == null) {
            PropertyCodegen.$$$reportNull$$$0(41);
        }
        if (typeMapper == null) {
            PropertyCodegen.$$$reportNull$$$0(42);
        }
        if (resolvedCall2 == null) {
            PropertyCodegen.$$$reportNull$$$0(43);
        }
        if (propertyDescriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(44);
        }
        final Type owner = JvmAbi.isPropertyWithBackingFieldInOuterClass(propertyDescriptor) ? codegen.getState().getTypeMapper().mapOwner(propertyDescriptor) : PropertyCodegen.getDelegatedPropertyMetadataOwner(codegen, typeMapper);
        codegen.tempVariables.put(resolvedCall2.getCall().getValueArguments().get(propertyMetadataArgumentIndex).asElement(), new StackValue(AsmTypes.K_PROPERTY_TYPE){

            @Override
            public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (v == null) {
                    1.$$$reportNull$$$0(1);
                }
                StackValue.Field array = StackValue.field(Type.getType("[" + AsmTypes.K_PROPERTY_TYPE), owner, "$$delegatedProperties", true, StackValue.none());
                StackValue.arrayElement(AsmTypes.K_PROPERTY_TYPE, array, StackValue.constant(indexInPropertyMetadataArray, Type.INT_TYPE)).put(type2, v);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "v";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/PropertyCodegen$1";
                objectArray[2] = "putSelector";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return codegen.invokeFunction(resolvedCall2, receiver);
    }

    private static Type getDelegatedPropertyMetadataOwner(@NotNull ExpressionCodegen codegen, @NotNull KotlinTypeMapper typeMapper) {
        CodegenContext<ClassOrPackageFragmentDescriptor> ownerContext;
        if (codegen == null) {
            PropertyCodegen.$$$reportNull$$$0(45);
        }
        if (typeMapper == null) {
            PropertyCodegen.$$$reportNull$$$0(46);
        }
        if ((ownerContext = codegen.getContext().getClassOrPackageParentContext()) instanceof ClassContext) {
            return typeMapper.mapClass((ClassifierDescriptor)((ClassContext)ownerContext).getContextDescriptor());
        }
        if (ownerContext instanceof PackageContext) {
            return ((PackageContext)ownerContext).getPackagePartType();
        }
        if (ownerContext instanceof MultifileClassContextBase) {
            return ((MultifileClassContextBase)ownerContext).getFilePartType();
        }
        throw new UnsupportedOperationException("Unknown context: " + ownerContext);
    }

    public void genDelegate(@NotNull PropertyDescriptor delegate2, @NotNull PropertyDescriptor delegateTo, @NotNull StackValue field) {
        PropertySetterDescriptor setter2;
        if (delegate2 == null) {
            PropertyCodegen.$$$reportNull$$$0(47);
        }
        if (delegateTo == null) {
            PropertyCodegen.$$$reportNull$$$0(48);
        }
        if (field == null) {
            PropertyCodegen.$$$reportNull$$$0(49);
        }
        ClassDescriptor toClass = (ClassDescriptor)delegateTo.getContainingDeclaration();
        PropertyGetterDescriptor getter2 = delegate2.getGetter();
        if (getter2 != null) {
            this.functionCodegen.genDelegate(getter2, delegateTo.getGetter().getOriginal(), toClass, field);
        }
        if ((setter2 = delegate2.getSetter()) != null) {
            this.functionCodegen.genDelegate(setter2, delegateTo.getSetter().getOriginal(), toClass, field);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCodegen";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberCodegen";
                break;
            }
            case 4: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deserializedProperty";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 12: 
            case 15: 
            case 23: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backingFieldAnnotations";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateAnnotations";
                break;
            }
            case 20: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/PropertyCodegen";
                break;
            }
            case 24: 
            case 27: 
            case 30: 
            case 37: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorDescriptor";
                break;
            }
            case 38: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 39: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateTo";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/PropertyCodegen";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyntheticMethodSignature";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegateTypeForProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "gen";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateInPackageFacade";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "genBackingFieldAndAnnotations";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAccessorNeeded";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isNonConstTopLevelPropertyInMultifileClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "areAccessorsNeededForPrimaryConstructorProperty";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generatePrimaryConstructorProperty";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasBackingField";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "generateBackingField";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "generateSyntheticMethodIfNeeded";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSyntheticMethodSignature";
                break;
            }
            case 22: 
            case 28: {
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "generatePropertyDelegateAccess";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDelegateTypeForProperty";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "generateBackingFieldAccess";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "shouldWriteFieldInitializer";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "generateGetter";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "generateSetter";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "generateAccessor";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "indexOfDelegatedProperty";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "invokeDelegatedPropertyConventionMethod";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "invokeDelegatedPropertyConventionMethodWithReceiver";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getDelegatedPropertyMetadataOwner";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "genDelegate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 22: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DelegatedPropertyAccessorStrategy
    extends FunctionGenerationStrategy.CodegenBased {
        private final int index;
        private final PropertyAccessorDescriptor propertyAccessorDescriptor;

        public DelegatedPropertyAccessorStrategy(@NotNull GenerationState state2, @NotNull PropertyAccessorDescriptor descriptor2, int index2) {
            if (state2 == null) {
                DelegatedPropertyAccessorStrategy.$$$reportNull$$$0(0);
            }
            if (descriptor2 == null) {
                DelegatedPropertyAccessorStrategy.$$$reportNull$$$0(1);
            }
            super(state2);
            this.index = index2;
            this.propertyAccessorDescriptor = descriptor2;
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature2) {
            if (codegen == null) {
                DelegatedPropertyAccessorStrategy.$$$reportNull$$$0(2);
            }
            if (signature2 == null) {
                DelegatedPropertyAccessorStrategy.$$$reportNull$$$0(3);
            }
            InstructionAdapter v = codegen.v;
            BindingContext bindingContext = this.state.getBindingContext();
            ResolvedCall<FunctionDescriptor> resolvedCall2 = bindingContext.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, this.propertyAccessorDescriptor);
            assert (resolvedCall2 != null) : "Resolve call should be recorded for delegate call " + signature2.toString();
            StackValue lastValue = PropertyCodegen.invokeDelegatedPropertyConventionMethod(this.propertyAccessorDescriptor.getCorrespondingProperty(), codegen, this.state.getTypeMapper(), resolvedCall2, this.index, 1);
            Type asmType = signature2.getReturnType();
            lastValue.put(asmType, v);
            v.areturn(asmType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codegen";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signature";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/PropertyCodegen$DelegatedPropertyAccessorStrategy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doGenerateBody";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DefaultPropertyAccessorStrategy
    extends FunctionGenerationStrategy.CodegenBased {
        private final PropertyAccessorDescriptor propertyAccessorDescriptor;

        public DefaultPropertyAccessorStrategy(@NotNull GenerationState state2, @NotNull PropertyAccessorDescriptor descriptor2) {
            if (state2 == null) {
                DefaultPropertyAccessorStrategy.$$$reportNull$$$0(0);
            }
            if (descriptor2 == null) {
                DefaultPropertyAccessorStrategy.$$$reportNull$$$0(1);
            }
            super(state2);
            this.propertyAccessorDescriptor = descriptor2;
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature2) {
            if (codegen == null) {
                DefaultPropertyAccessorStrategy.$$$reportNull$$$0(2);
            }
            if (signature2 == null) {
                DefaultPropertyAccessorStrategy.$$$reportNull$$$0(3);
            }
            InstructionAdapter v = codegen.v;
            PropertyDescriptor propertyDescriptor = this.propertyAccessorDescriptor.getCorrespondingProperty();
            StackValue.Property property = codegen.intermediateValueForProperty(propertyDescriptor, true, null, StackValue.LOCAL_0);
            PsiElement jetProperty = DescriptorToSourceUtils.descriptorToDeclaration(propertyDescriptor);
            if (jetProperty instanceof KtProperty || jetProperty instanceof KtParameter) {
                codegen.markLineNumber((KtElement)jetProperty, false);
            }
            if (this.propertyAccessorDescriptor instanceof PropertyGetterDescriptor) {
                Type type2 = signature2.getReturnType();
                property.put(type2, v);
                v.areturn(type2);
            } else if (this.propertyAccessorDescriptor instanceof PropertySetterDescriptor) {
                List<ValueParameterDescriptor> valueParameters = this.propertyAccessorDescriptor.getValueParameters();
                assert (valueParameters.size() == 1) : "Property setter should have only one value parameter but has " + this.propertyAccessorDescriptor;
                int parameterIndex = codegen.lookupLocalIndex(valueParameters.get(0));
                assert (parameterIndex >= 0) : "Local index for setter parameter should be positive or zero: " + this.propertyAccessorDescriptor;
                Type type3 = codegen.typeMapper.mapType(propertyDescriptor);
                property.store(StackValue.local(parameterIndex, type3), codegen.v);
                v.visitInsn(177);
            } else {
                throw new IllegalStateException("Unknown property accessor: " + this.propertyAccessorDescriptor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codegen";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signature";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doGenerateBody";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

