/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.asJava.FilteredJvmDiagnostics;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFileCollection;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.output.outputUtils.OutputUtilsKt;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.config.JavaSourceRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.config.Kapt2EnabledKeyKt;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.GeneratedClassLoader;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.GenerationStateEventCallback;
import org.jetbrains.kotlin.codegen.state.GenerationStateKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRoot;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityManager;
import org.jetbrains.kotlin.modules.JavaRootPath;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.modules.TargetIdKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.script.ReflectionUtilKt;
import org.jetbrains.kotlin.util.PerformanceCounter;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001<B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u0005J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u0005J\u0016\u0010\u0017\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019J%\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001b2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0082\bJ\u001c\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001b2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u001eJ\u001c\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001b2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J$\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00142\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020#H\u0002J \u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u000e2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u0014H\u0002J8\u0010-\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#2\u0006\u0010.\u001a\u00020\t2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020,0\u00142\b\u00100\u001a\u0004\u0018\u00010%H\u0002J\u001e\u00101\u001a\b\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00100\u001a\u00020%H\u0002J&\u00102\u001a\u0004\u0018\u00010\t2\b\u0010.\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u00103\u001a\u00020!2\u0006\u00104\u001a\u000205H\u0002J\u001e\u00106\u001a\u00020!2\u0006\u0010\u0003\u001a\u00020\u00042\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00190\u0014H\u0002J\"\u00108\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010)H\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler;", "", "()V", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "getMessageCollector", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "analyze", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "environment", "targetDescription", "", "analyzeAndGenerate", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "compileAndExecuteScript", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "scriptArgs", "", "compileBunchOfSources", "", "compileModules", "directory", "Ljava/io/File;", "compileScript", "Ljava/lang/Class;", "makeParentClassLoader", "Lkotlin/Function0;", "Ljava/lang/ClassLoader;", "parentClassLoader", "configureSourceRoots", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "chunk", "Lorg/jetbrains/kotlin/modules/Module;", "createOutputFilesFlushingCallbackIfPossible", "Lorg/jetbrains/kotlin/codegen/state/GenerationStateEventCallback;", "findMainClass", "Lorg/jetbrains/kotlin/name/FqName;", "generationState", "files", "Lorg/jetbrains/kotlin/psi/KtFile;", "generate", "result", "sourceFiles", "module", "getAbsolutePaths", "repeatAnalysisIfNeeded", "reportExceptionFromScript", "exception", "", "reportRuntimeConflicts", "jvmClasspathRoots", "writeOutput", "outputFiles", "Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;", "mainClass", "DirectoriesScope", "kotlin-compiler"})
public final class KotlinToJVMBytecodeCompiler {
    public static final KotlinToJVMBytecodeCompiler INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final List<String> getAbsolutePaths(File directory, Module module) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)module.getSourceFiles();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void sourceFile;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            File source = new File((String)sourceFile);
            if (!source.isAbsolute()) {
                source = new File(directory, (String)sourceFile);
            }
            String string2 = source.getAbsolutePath();
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void writeOutput(CompilerConfiguration configuration, OutputFileCollection outputFiles, FqName mainClass) {
        File outputDir2;
        boolean reportOutputFiles = configuration.getBoolean(CommonConfigurationKeys.REPORT_OUTPUT_FILES);
        File jarPath = configuration.get(JVMConfigurationKeys.OUTPUT_JAR);
        MessageCollector messageCollector2 = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.Companion.getNONE());
        if (jarPath != null) {
            Boolean includeRuntime;
            Boolean bl = includeRuntime = configuration.get(JVMConfigurationKeys.INCLUDE_RUNTIME, false);
            Intrinsics.checkExpressionValueIsNotNull(bl, "includeRuntime");
            CompileEnvironmentUtil.writeToJar(jarPath, bl, mainClass, outputFiles);
            if (reportOutputFiles) {
                String message;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)outputFiles.asList();
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    OutputFile it = (OutputFile)element$iv$iv;
                    Iterable list$iv$iv = it.getSourceFiles();
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                String string = message = OutputMessageUtil.formatOutputMessage(CollectionsKt.distinct((List)destination$iv$iv), jarPath);
                Intrinsics.checkExpressionValueIsNotNull(string, "message");
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.OUTPUT, string, null, 4, null);
            }
            return;
        }
        File file2 = configuration.get(JVMConfigurationKeys.OUTPUT_DIRECTORY);
        if (file2 == null) {
            file2 = new File(".");
        }
        File file3 = outputDir2 = file2;
        Intrinsics.checkExpressionValueIsNotNull(file3, "outputDir");
        MessageCollector messageCollector3 = messageCollector2;
        Intrinsics.checkExpressionValueIsNotNull(messageCollector3, "messageCollector");
        OutputUtilsKt.writeAll(outputFiles, file3, messageCollector3, reportOutputFiles);
    }

    private final GenerationStateEventCallback createOutputFilesFlushingCallbackIfPossible(CompilerConfiguration configuration) {
        if (configuration.get(JVMConfigurationKeys.OUTPUT_DIRECTORY) == null) {
            return GenerationStateEventCallback.Companion.getDO_NOTHING();
        }
        return GenerationStateKt.GenerationStateEventCallback((Function1<? super GenerationState, Unit>)new Function1<GenerationState, Unit>(configuration){
            final /* synthetic */ CompilerConfiguration $configuration;

            public final void invoke(@NotNull GenerationState state2) {
                Intrinsics.checkParameterIsNotNull(state2, "state");
                List<OutputFile> list2 = state2.getFactory().getCurrentOutput();
                Intrinsics.checkExpressionValueIsNotNull(list2, "state.factory.currentOutput");
                SimpleOutputFileCollection currentOutput = new SimpleOutputFileCollection(list2);
                KotlinToJVMBytecodeCompiler.access$writeOutput(KotlinToJVMBytecodeCompiler.INSTANCE, this.$configuration, currentOutput, null);
                if (!this.$configuration.get(JVMConfigurationKeys.RETAIN_OUTPUT_IN_MEMORY, false).booleanValue()) {
                    state2.getFactory().releaseGeneratedOutput();
                }
            }
            {
                this.$configuration = compilerConfiguration;
                super(1);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean compileModules(@NotNull KotlinCoreEnvironment environment2, @NotNull File directory) {
        Object moduleConfiguration;
        Object ktFiles2;
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        Intrinsics.checkParameterIsNotNull(directory, "directory");
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        ModuleVisibilityManager moduleVisibilityManager = ModuleVisibilityManager.SERVICE.getInstance(environment2.getProject());
        CompilerConfiguration projectConfiguration = environment2.getConfiguration();
        List<Module> chunk = projectConfiguration.getNotNull(JVMConfigurationKeys.MODULES);
        Iterator<Module> iterator2 = chunk.iterator();
        while (iterator2.hasNext()) {
            Module module;
            Module module2 = module = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(module2, "module");
            moduleVisibilityManager.addModule(module2);
        }
        List friendPaths = environment2.getConfiguration().getList(JVMConfigurationKeys.FRIEND_PATHS);
        Iterator iterator3 = friendPaths.iterator();
        while (iterator3.hasNext()) {
            String path;
            String string = path = (String)iterator3.next();
            Intrinsics.checkExpressionValueIsNotNull(string, "path");
            moduleVisibilityManager.addFriendPath(string);
        }
        String targetDescription2 = "in targets [" + CollectionsKt.joinToString$default(chunk, null, null, null, 0, null, compileModules.targetDescription.1.INSTANCE, 31, null) + "]";
        AnalysisResult result2 = this.repeatAnalysisIfNeeded(this.analyze(environment2, targetDescription2), environment2, targetDescription2);
        if (result2 == null || !result2.getShouldGenerateCode()) {
            return false;
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        result2.throwIfError();
        LinkedHashMap outputs = org.jetbrains.kotlin.utils.CollectionsKt.newLinkedHashMapWithExpectedSize(chunk.size());
        for (Module entry : chunk) {
            Object object;
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            Project project = environment2.getProject();
            Module module = entry;
            Intrinsics.checkExpressionValueIsNotNull(module, "module");
            Object object2 = ktFiles2 = CompileEnvironmentUtil.getKtFiles(project, (Collection<String>)this.getAbsolutePaths(directory, module), projectConfiguration, compileModules.ktFiles.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull(object2, "ktFiles");
            if (!UtilsKt.checkKotlinPackageUsage(environment2, (Collection)object2)) {
                return false;
            }
            Object $receiver = object = projectConfiguration.copy();
            ((CompilerConfiguration)$receiver).put(JVMConfigurationKeys.OUTPUT_DIRECTORY, new File(entry.getOutputDirectory()));
            moduleConfiguration = object;
            object = outputs;
            Module module3 = entry;
            Intrinsics.checkExpressionValueIsNotNull(module3, "module");
            $receiver = module3;
            Object object3 = moduleConfiguration;
            Intrinsics.checkExpressionValueIsNotNull(object3, "moduleConfiguration");
            Object object4 = ktFiles2;
            Intrinsics.checkExpressionValueIsNotNull(object4, "ktFiles");
            GenerationState $i$a$1$apply = this.generate(environment2, (CompilerConfiguration)object3, result2, (List<? extends KtFile>)object4, entry);
            object.put($receiver, $i$a$1$apply);
        }
        try {
            ktFiles2 = outputs;
            for (Map.Entry entry : ktFiles2.entrySet()) {
                moduleConfiguration = entry;
                GenerationState state2 = (GenerationState)moduleConfiguration.getValue();
                ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
                this.writeOutput(state2.getConfiguration(), state2.getFactory(), null);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Iterable $receiver$iv = outputs.values();
            for (Object element$iv : $receiver$iv) {
                GenerationState p1 = (GenerationState)element$iv;
                p1.destroy();
            }
        }
    }

    public final void configureSourceRoots(@NotNull CompilerConfiguration configuration, @NotNull List<? extends Module> chunk, @NotNull File directory) {
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(chunk, "chunk");
        Intrinsics.checkParameterIsNotNull(directory, "directory");
        for (Module module : chunk) {
            ContentRootsKt.addKotlinSourceRoots(configuration, this.getAbsolutePaths(directory, module));
        }
        for (Module module : chunk) {
            for (JavaRootPath javaRootPath : module.getJavaSourceRoots()) {
                JvmContentRootsKt.addJavaSourceRoot(configuration, new File(javaRootPath.getPath()), javaRootPath.getPackagePrefix());
            }
        }
        for (Module module : chunk) {
            for (String classpathRoot : module.getClasspathRoots()) {
                JvmContentRootsKt.addJvmClasspathRoot(configuration, new File(classpathRoot));
            }
        }
        for (Module module : chunk) {
            String modularJdkRoot = module.getModularJdkRoot();
            if (modularJdkRoot == null) continue;
            configuration.put(JVMConfigurationKeys.JDK_HOME, new File(modularJdkRoot));
            break;
        }
        configuration.addAll(JVMConfigurationKeys.MODULES, (Collection)chunk);
    }

    /*
     * WARNING - void declaration
     */
    private final FqName findMainClass(GenerationState generationState, List<? extends KtFile> files2) {
        Object v0;
        block2: {
            void $receiver$iv;
            MainFunctionDetector mainFunctionDetector = new MainFunctionDetector(generationState.getBindingContext());
            Sequence sequence2 = SequencesKt.map(CollectionsKt.asSequence((Iterable)files2), (Function1)new Function1<KtFile, FqName>(mainFunctionDetector){
                final /* synthetic */ MainFunctionDetector $mainFunctionDetector;

                @Nullable
                public final FqName invoke(@NotNull KtFile file2) {
                    Intrinsics.checkParameterIsNotNull(file2, "file");
                    List<KtDeclaration> list2 = file2.getDeclarations();
                    Intrinsics.checkExpressionValueIsNotNull(list2, "file.declarations");
                    return this.$mainFunctionDetector.hasMain(list2) ? JvmFileClassUtil.getFileClassInfoNoResolve(file2).getFacadeClassFqName() : null;
                }
                {
                    this.$mainFunctionDetector = mainFunctionDetector;
                    super(1);
                }
            });
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $receiver$iv) {
                FqName it = (FqName)element$iv;
                if (!(it != null)) continue;
                if (found$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        return v0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean compileBunchOfSources(@NotNull KotlinCoreEnvironment environment2) {
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        ModuleVisibilityManager moduleVisibilityManager = ModuleVisibilityManager.SERVICE.getInstance(environment2.getProject());
        List friendPaths = environment2.getConfiguration().getList(JVMConfigurationKeys.FRIEND_PATHS);
        Iterator iterator2 = friendPaths.iterator();
        while (iterator2.hasNext()) {
            String path;
            String string = path = (String)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(string, "path");
            moduleVisibilityManager.addFriendPath(string);
        }
        if (!UtilsKt.checkKotlinPackageUsage(environment2, (Collection<? extends KtFile>)environment2.getSourceFiles())) {
            return false;
        }
        GenerationState generationState = this.analyzeAndGenerate(environment2);
        if (generationState == null) {
            return false;
        }
        GenerationState generationState2 = generationState;
        FqName mainClass = this.findMainClass(generationState2, environment2.getSourceFiles());
        try {
            this.writeOutput(environment2.getConfiguration(), generationState2.getFactory(), mainClass);
            boolean bl = true;
            return bl;
        }
        finally {
            generationState2.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ExitCode compileAndExecuteScript(@NotNull KotlinCoreEnvironment environment2, @NotNull KotlinPaths paths, @NotNull List<String> scriptArgs) {
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        Intrinsics.checkParameterIsNotNull(paths, "paths");
        Intrinsics.checkParameterIsNotNull(scriptArgs, "scriptArgs");
        Class<?> clazz = this.compileScript(environment2, paths);
        if (clazz == null) {
            return ExitCode.COMPILATION_ERROR;
        }
        Class<?> scriptClass = clazz;
        try {
            try {
                if (ReflectionUtilKt.tryConstructClassFromStringArgs(scriptClass, scriptArgs) == null) {
                    throw (Throwable)new RuntimeException("unable to find appropriate constructor for class " + scriptClass.getName() + " accepting arguments " + scriptArgs + "\n");
                }
            }
            finally {
                System.out.flush();
                System.err.flush();
            }
        }
        catch (Throwable e) {
            this.reportExceptionFromScript(e);
            return ExitCode.SCRIPT_EXECUTION_ERROR;
        }
        return ExitCode.OK;
    }

    /*
     * WARNING - void declaration
     */
    private final AnalysisResult repeatAnalysisIfNeeded(AnalysisResult result2, KotlinCoreEnvironment environment2, String targetDescription2) {
        if (result2 instanceof AnalysisResult.RetryWithAdditionalJavaRoots) {
            CompilerConfiguration configuration = environment2.getConfiguration();
            boolean oldReadOnlyValue = configuration.isReadOnly();
            configuration.setReadOnly(false);
            JvmContentRootsKt.addJavaSourceRoots$default(configuration, ((AnalysisResult.RetryWithAdditionalJavaRoots)result2).getAdditionalJavaRoots(), null, 2, null);
            configuration.setReadOnly(oldReadOnlyValue);
            if (((AnalysisResult.RetryWithAdditionalJavaRoots)result2).getAddToEnvironment()) {
                Collection<JavaSourceRoot> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = ((AnalysisResult.RetryWithAdditionalJavaRoots)result2).getAdditionalJavaRoots();
                KotlinCoreEnvironment kotlinCoreEnvironment = environment2;
                void var7_8 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    File file2 = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    JavaSourceRoot javaSourceRoot = new JavaSourceRoot((File)it, null);
                    collection.add(javaSourceRoot);
                }
                collection = (List)destination$iv$iv;
                kotlinCoreEnvironment.updateClasspath((List<? extends ContentRoot>)collection);
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(environment2){
                final /* synthetic */ KotlinCoreEnvironment $environment;

                public final void run() {
                    block1: {
                        PsiModificationTracker psiModificationTracker = PsiManager.getInstance(this.$environment.getProject()).getModificationTracker();
                        if (!(psiModificationTracker instanceof PsiModificationTrackerImpl)) {
                            psiModificationTracker = null;
                        }
                        PsiModificationTrackerImpl psiModificationTrackerImpl = (PsiModificationTrackerImpl)psiModificationTracker;
                        if (psiModificationTrackerImpl == null) break block1;
                        psiModificationTrackerImpl.incCounter();
                    }
                }
                {
                    this.$environment = kotlinCoreEnvironment;
                }
            });
            MessageCollector messageCollector2 = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            if (messageCollector2 != null) {
                messageCollector2.clear();
            }
            return this.analyze(environment2, targetDescription2);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportExceptionFromScript(Throwable exception) {
        PrintStream stream2 = System.err;
        Throwable cause = exception.getCause();
        if (!(exception instanceof InvocationTargetException) || cause == null) {
            exception.printStackTrace(stream2);
            return;
        }
        stream2.println(cause);
        StackTraceElement[] fullTrace = cause.getStackTrace();
        int relevantEntries = ((Object[])fullTrace).length - ((Object[])((InvocationTargetException)exception).getStackTrace()).length;
        int n = 0;
        int n2 = relevantEntries - 1;
        if (n <= n2) {
            while (true) {
                void i;
                stream2.println("\tat " + fullTrace[i]);
                if (i == n2) break;
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Class<?> compileScript(@NotNull KotlinCoreEnvironment environment2, @NotNull KotlinPaths paths) {
        Class<?> clazz;
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        Intrinsics.checkParameterIsNotNull(paths, "paths");
        KotlinToJVMBytecodeCompiler this_$iv = this;
        GenerationState generationState = this_$iv.analyzeAndGenerate(environment2);
        if (generationState == null) {
            clazz = null;
        } else {
            GenerationState state$iv = generationState;
            try {
                URLClassLoader uRLClassLoader;
                Object object;
                Object object2;
                GeneratedClassLoader generatedClassLoader;
                ClassFileFactory classFileFactory = state$iv.getFactory();
                GeneratedClassLoader generatedClassLoader2 = generatedClassLoader;
                GeneratedClassLoader generatedClassLoader3 = generatedClassLoader;
                ArrayList<URL> classPaths = CollectionsKt.arrayListOf(paths.getRuntimePath().toURI().toURL());
                Iterable $receiver$iv = JvmContentRootsKt.getJvmClasspathRoots(environment2.getConfiguration());
                for (Object item$iv : $receiver$iv) {
                    void it;
                    File file2 = (File)item$iv;
                    object2 = classPaths;
                    object = it.toURI().toURL();
                    object2.add(object);
                }
                $receiver$iv = classPaths;
                object = uRLClassLoader;
                object2 = uRLClassLoader;
                Iterable iterable = $receiver$iv;
                if (iterable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Iterable thisCollection$iv = iterable;
                URL[] uRLArray = thisCollection$iv.toArray(new URL[thisCollection$iv.size()]);
                if (uRLArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                URL[] uRLArray2 = uRLArray;
                ((URLClassLoader)object)(uRLArray2);
                Object object3 = object2;
                generatedClassLoader2(classFileFactory, (ClassLoader)object3, new URL[0]);
                GeneratedClassLoader classLoader$iv = generatedClassLoader3;
                KtScript ktScript = environment2.getSourceFiles().get(0).getScript();
                if (ktScript == null) {
                    String string = "Script must be parsed";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                KtScript script$iv = ktScript;
                clazz = classLoader$iv.loadClass(script$iv.getFqName().asString());
            }
            catch (Exception e$iv) {
                throw (Throwable)new RuntimeException("Failed to evaluate script: " + e$iv, e$iv);
            }
        }
        return clazz;
    }

    @Nullable
    public final Class<?> compileScript(@NotNull KotlinCoreEnvironment environment2, @NotNull ClassLoader parentClassLoader) {
        Class<?> clazz;
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        Intrinsics.checkParameterIsNotNull(parentClassLoader, "parentClassLoader");
        KotlinToJVMBytecodeCompiler this_$iv = this;
        GenerationState generationState = this_$iv.analyzeAndGenerate(environment2);
        if (generationState == null) {
            clazz = null;
        } else {
            GenerationState state$iv = generationState;
            try {
                GeneratedClassLoader generatedClassLoader;
                ClassFileFactory classFileFactory = state$iv.getFactory();
                GeneratedClassLoader generatedClassLoader2 = generatedClassLoader;
                GeneratedClassLoader generatedClassLoader3 = generatedClassLoader;
                ClassLoader classLoader = parentClassLoader;
                generatedClassLoader2(classFileFactory, classLoader, new URL[0]);
                GeneratedClassLoader classLoader$iv = generatedClassLoader3;
                KtScript ktScript = environment2.getSourceFiles().get(0).getScript();
                if (ktScript == null) {
                    String string = "Script must be parsed";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                KtScript script$iv = ktScript;
                clazz = classLoader$iv.loadClass(script$iv.getFqName().asString());
            }
            catch (Exception e$iv) {
                throw (Throwable)new RuntimeException("Failed to evaluate script: " + e$iv, e$iv);
            }
        }
        return clazz;
    }

    @Nullable
    public final GenerationState analyzeAndGenerate(@NotNull KotlinCoreEnvironment environment2) {
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        AnalysisResult analysisResult = this.repeatAnalysisIfNeeded(this.analyze(environment2, null), environment2, null);
        if (analysisResult == null) {
            return null;
        }
        AnalysisResult result2 = analysisResult;
        if (!result2.getShouldGenerateCode()) {
            return null;
        }
        result2.throwIfError();
        return this.generate(environment2, environment2.getConfiguration(), result2, environment2.getSourceFiles(), null);
    }

    private final AnalysisResult analyze(KotlinCoreEnvironment environment2, String targetDescription2) {
        MessageCollector collector2 = this.getMessageCollector(environment2);
        long analysisStart = PerformanceCounter.Companion.currentTime();
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(collector2);
        analyzerWithCompilerReport.analyzeAndReport((Collection<? extends KtFile>)environment2.getSourceFiles(), new AnalyzerWithCompilerReport.Analyzer(environment2, collector2){
            final /* synthetic */ KotlinCoreEnvironment $environment;
            final /* synthetic */ MessageCollector $collector;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public AnalysisResult analyze() {
                GlobalSearchScope globalSearchScope;
                List<T> list2;
                List list3;
                List<T> $receiver$iv;
                Project project = this.$environment.getProject();
                List<Module> list4 = this.$environment.getConfiguration().get(JVMConfigurationKeys.MODULES);
                if (list4 != null) {
                    void $receiver$iv$iv;
                    List<T> list5 = $receiver$iv = (List<T>)list4;
                    Collection destination$iv$iv = new ArrayList<E>();
                    void $receiver$iv$iv$iv = $receiver$iv$iv;
                    for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                        VirtualFile virtualFile;
                        T element$iv$iv = element$iv$iv$iv;
                        Module module = (Module)element$iv$iv;
                        if (this.$environment.findLocalFile(module.getOutputDirectory()) == null) continue;
                        VirtualFile it$iv$iv = virtualFile;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    list3 = (List)destination$iv$iv;
                } else {
                    list3 = null;
                }
                if ((list2 = ($receiver$iv = list3)) == null) {
                    list2 = CollectionsKt.emptyList();
                }
                List<T> moduleOutputs = list2;
                GlobalSearchScope sourcesOnly = TopDownAnalyzerFacadeForJVM.INSTANCE.newModuleSearchScope(project, (Collection<? extends KtFile>)this.$environment.getSourceFiles());
                if (moduleOutputs.isEmpty()) {
                    globalSearchScope = sourcesOnly;
                } else {
                    GlobalSearchScope globalSearchScope2 = sourcesOnly.uniteWith(new DirectoriesScope(project, moduleOutputs));
                    globalSearchScope = globalSearchScope2;
                    Intrinsics.checkExpressionValueIsNotNull(globalSearchScope2, "sourcesOnly.uniteWith(Di\u2026(project, moduleOutputs))");
                }
                GlobalSearchScope scope = globalSearchScope;
                return TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration$default(project, this.$environment.getSourceFiles(), new CliLightClassGenerationSupport.NoScopeRecordCliBindingTrace(), this.$environment.getConfiguration(), new Function1<GlobalSearchScope, JvmPackagePartProvider>(this){
                    final /* synthetic */ analyze.1 this$0;

                    @NotNull
                    public final JvmPackagePartProvider invoke(@NotNull GlobalSearchScope scope) {
                        Intrinsics.checkParameterIsNotNull(scope, "scope");
                        return new JvmPackagePartProvider(this.this$0.$environment, scope);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }, null, scope, 32, null);
            }

            public void reportEnvironmentErrors() {
                KotlinToJVMBytecodeCompiler.access$reportRuntimeConflicts(KotlinToJVMBytecodeCompiler.INSTANCE, this.$collector, JvmContentRootsKt.getJvmClasspathRoots(this.$environment.getConfiguration()));
            }
            {
                this.$environment = $captured_local_variable$0;
                this.$collector = $captured_local_variable$1;
            }
        });
        long analysisNanos = PerformanceCounter.Companion.currentTime() - analysisStart;
        int sourceLinesOfCode2 = environment2.getSourceLinesOfCode();
        int numberOfFiles = environment2.getSourceFiles().size();
        long time = TimeUnit.NANOSECONDS.toMillis(analysisNanos);
        float speed = (float)sourceLinesOfCode2 * (float)1000 / (float)time;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder().append("ANALYZE: ").append(numberOfFiles).append(" files (").append(sourceLinesOfCode2).append(" lines) ");
        String string = targetDescription2;
        if (string == null) {
            string = "";
        }
        String string2 = "%.3f";
        Object[] objectArray = new Object[]{Float.valueOf(speed)};
        StringBuilder stringBuilder3 = new StringBuilder().append("in ").append(time).append(" ms - ");
        StringBuilder stringBuilder4 = stringBuilder.append(stringBuilder2.append(string).toString());
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(this, *args)");
        String string4 = string3;
        String message = stringBuilder4.append(stringBuilder3.append(string4).append(" loc/s").toString()).toString();
        K2JVMCompiler.Companion.reportPerf(environment2.getConfiguration(), message);
        AnalysisResult analysisResult = analyzerWithCompilerReport.getAnalysisResult();
        return !analyzerWithCompilerReport.hasErrors() || analysisResult instanceof AnalysisResult.RetryWithAdditionalJavaRoots ? analysisResult : null;
    }

    private final GenerationState generate(KotlinCoreEnvironment environment2, CompilerConfiguration configuration, AnalysisResult result2, List<? extends KtFile> sourceFiles2, Module module) {
        File file2;
        String string;
        String string2;
        TargetId targetId;
        TargetId targetId2;
        Module p1;
        Object object;
        Object object2;
        Project project;
        ClassBuilderFactory classBuilderFactory;
        ModuleDescriptor moduleDescriptor;
        BindingContext bindingContext;
        List<? extends KtFile> list2;
        CompilerConfiguration compilerConfiguration;
        GenerationState.GenerateClassFilter generateClassFilter;
        Module module2;
        GenerationState generationState;
        Boolean bl = environment2.getProject().getUserData(Kapt2EnabledKeyKt.getIS_KAPT2_ENABLED_KEY());
        if (bl == null) {
            bl = false;
        }
        Boolean isKapt2Enabled = bl;
        GenerationState generationState2 = generationState;
        GenerationState generationState3 = generationState;
        Project project2 = environment2.getProject();
        Boolean bl2 = isKapt2Enabled;
        Intrinsics.checkExpressionValueIsNotNull(bl2, "isKapt2Enabled");
        ClassBuilderFactory classBuilderFactory2 = ClassBuilderFactories.binaries(bl2);
        ClassBuilderFactory classBuilderFactory3 = classBuilderFactory2;
        Intrinsics.checkExpressionValueIsNotNull(classBuilderFactory2, "ClassBuilderFactories.binaries(isKapt2Enabled)");
        ModuleDescriptor moduleDescriptor2 = result2.getModuleDescriptor();
        BindingContext bindingContext2 = result2.getBindingContext();
        List<? extends KtFile> list3 = sourceFiles2;
        CompilerConfiguration compilerConfiguration2 = configuration;
        GenerationState.GenerateClassFilter generateClassFilter2 = GenerationState.GenerateClassFilter.GENERATE_ALL;
        Module module3 = module;
        if (module3 != null) {
            module2 = module3;
            generateClassFilter = generateClassFilter2;
            compilerConfiguration = compilerConfiguration2;
            list2 = list3;
            bindingContext = bindingContext2;
            moduleDescriptor = moduleDescriptor2;
            classBuilderFactory = classBuilderFactory3;
            project = project2;
            object2 = generationState2;
            object = generationState3;
            p1 = module2;
            targetId2 = TargetIdKt.TargetId(p1);
            generationState3 = object;
            generationState2 = object2;
            project2 = project;
            classBuilderFactory3 = classBuilderFactory;
            moduleDescriptor2 = moduleDescriptor;
            bindingContext2 = bindingContext;
            list3 = list2;
            compilerConfiguration2 = compilerConfiguration;
            generateClassFilter2 = generateClassFilter;
            targetId = targetId2;
        } else {
            targetId = null;
        }
        Module module4 = module;
        if (module4 != null) {
            module2 = module4;
            targetId2 = targetId;
            generateClassFilter = generateClassFilter2;
            compilerConfiguration = compilerConfiguration2;
            list2 = list3;
            bindingContext = bindingContext2;
            moduleDescriptor = moduleDescriptor2;
            classBuilderFactory = classBuilderFactory3;
            project = project2;
            object2 = generationState2;
            object = generationState3;
            p1 = module2;
            string2 = p1.getModuleName();
            generationState3 = object;
            generationState2 = object2;
            project2 = project;
            classBuilderFactory3 = classBuilderFactory;
            moduleDescriptor2 = moduleDescriptor;
            bindingContext2 = bindingContext;
            list3 = list2;
            compilerConfiguration2 = compilerConfiguration;
            generateClassFilter2 = generateClassFilter;
            targetId = targetId2;
            string = string2;
        } else {
            string = null;
        }
        Module module5 = module;
        if (module5 != null) {
            module2 = module5;
            string2 = string;
            targetId2 = targetId;
            generateClassFilter = generateClassFilter2;
            compilerConfiguration = compilerConfiguration2;
            list2 = list3;
            bindingContext = bindingContext2;
            moduleDescriptor = moduleDescriptor2;
            classBuilderFactory = classBuilderFactory3;
            project = project2;
            object2 = generationState2;
            object = generationState3;
            Module it = module2;
            File file3 = new File(it.getOutputDirectory());
            generationState3 = object;
            generationState2 = object2;
            project2 = project;
            classBuilderFactory3 = classBuilderFactory;
            moduleDescriptor2 = moduleDescriptor;
            bindingContext2 = bindingContext;
            list3 = list2;
            compilerConfiguration2 = compilerConfiguration;
            generateClassFilter2 = generateClassFilter;
            targetId = targetId2;
            string = string2;
            file2 = file3;
        } else {
            file2 = null;
        }
        generationState2(project2, classBuilderFactory3, moduleDescriptor2, bindingContext2, list3, compilerConfiguration2, generateClassFilter2, targetId, string, file2, this.createOutputFilesFlushingCallbackIfPossible(configuration), null, false, 6144, null);
        GenerationState generationState4 = generationState3;
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        long generationStart = PerformanceCounter.Companion.currentTime();
        KotlinCodegenFacade.compileCorrectFiles(generationState4, CompilationErrorHandler.THROW_EXCEPTION);
        long generationNanos = PerformanceCounter.Companion.currentTime() - generationStart;
        String desc = module != null ? "target " + module.getModuleName() + "-" + module.getModuleType() + " " : "";
        int numberOfSourceFiles = sourceFiles2.size();
        int numberOfLines = environment2.countLinesOfCode(sourceFiles2);
        long time = TimeUnit.NANOSECONDS.toMillis(generationNanos);
        float speed = (float)numberOfLines * (float)1000 / (float)time;
        String string3 = "%.3f";
        Object[] objectArray = new Object[]{Float.valueOf(speed)};
        object = new StringBuilder().append("GENERATE: ").append(numberOfSourceFiles).append(" files (").append(numberOfLines).append(" lines) ").append(desc).append("in ").append(time).append(" ms - ");
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string4, "java.lang.String.format(this, *args)");
        object2 = string4;
        String message = ((StringBuilder)object).append((String)object2).append(" loc/s").toString();
        K2JVMCompiler.Companion.reportPerf(environment2.getConfiguration(), message);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        Diagnostics diagnostics = generationState4.getCollectedExtraJvmDiagnostics();
        Diagnostics diagnostics2 = result2.getBindingContext().getDiagnostics();
        Intrinsics.checkExpressionValueIsNotNull(diagnostics2, "result.bindingContext.diagnostics");
        AnalyzerWithCompilerReport.Companion.reportDiagnostics((Diagnostics)new FilteredJvmDiagnostics(diagnostics, diagnostics2), this.getMessageCollector(environment2));
        BindingContext bindingContext3 = generationState4.getExtraJvmDiagnosticsTrace().getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext3, "generationState.extraJvm\u2026sticsTrace.bindingContext");
        AnalyzerWithCompilerReport.Companion.reportBytecodeVersionErrors(bindingContext3, this.getMessageCollector(environment2));
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        return generationState4;
    }

    private final MessageCollector getMessageCollector(@NotNull KotlinCoreEnvironment $receiver) {
        MessageCollector messageCollector2 = $receiver.getConfiguration().getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkExpressionValueIsNotNull(messageCollector2, "configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        return messageCollector2;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportRuntimeConflicts(MessageCollector messageCollector2, List<? extends File> jvmClasspathRoots) {
        void $receiver$iv$iv;
        Object object;
        File it;
        Collection collection;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv;
        reportRuntimeConflicts.1 removeIdeaVersionSuffix$ = reportRuntimeConflicts.1.INSTANCE;
        Iterable iterable = $receiver$iv = (Iterable)jvmClasspathRoots;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            File file2;
            File file3 = (File)item$iv$iv;
            collection = destination$iv$iv;
            try {
                file2 = it.getCanonicalFile();
            }
            catch (IOException e) {
                file2 = it;
            }
            object = file2;
            collection.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            it = (File)element$iv$iv;
            if (!(Intrinsics.areEqual(it.getName(), "kotlin-runtime.jar") && it.exists())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List runtimes = (List)destination$iv$iv;
        Iterable $receiver$iv2 = runtimes;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it2;
            File $i$a$2$filter = (File)item$iv$iv;
            collection = destination$iv$iv2;
            String string = JarUtil.getJarAttribute((File)it2, Attributes.Name.IMPLEMENTATION_VERSION);
            reportRuntimeConflicts.1 var13_16 = reportRuntimeConflicts.1.INSTANCE;
            String string2 = string;
            if (string2 == null) {
                string2 = "";
            }
            String string3 = string2;
            object = var13_16.invoke(string3);
            collection.add(object);
        }
        List runtimeVersions = (List)destination$iv$iv2;
        if (CollectionsKt.toSet(runtimeVersions).size() > 1) {
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Conflicting versions of Kotlin runtime on classpath: " + CollectionsKt.joinToString$default(runtimes, null, null, null, 0, null, reportRuntimeConflicts.2.INSTANCE, 31, null), null, 4, null);
        }
    }

    private KotlinToJVMBytecodeCompiler() {
        INSTANCE = this;
    }

    static {
        new KotlinToJVMBytecodeCompiler();
    }

    public static final /* synthetic */ void access$writeOutput(KotlinToJVMBytecodeCompiler $this, @NotNull CompilerConfiguration configuration, @NotNull OutputFileCollection outputFiles, @Nullable FqName mainClass) {
        $this.writeOutput(configuration, outputFiles, mainClass);
    }

    public static final /* synthetic */ void access$reportRuntimeConflicts(KotlinToJVMBytecodeCompiler $this, @NotNull MessageCollector messageCollector2, @NotNull List jvmClasspathRoots) {
        $this.reportRuntimeConflicts(messageCollector2, jvmClasspathRoots);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler$DirectoriesScope;", "Lcom/intellij/psi/search/DelegatingGlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "directories", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "contains", "", "file", "toString", "", "kotlin-compiler"})
    public static final class DirectoriesScope
    extends DelegatingGlobalSearchScope {
        private final List<VirtualFile> directories;

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            boolean bl;
            block1: {
                Intrinsics.checkParameterIsNotNull(file2, "file");
                Iterable $receiver$iv = this.directories;
                for (Object element$iv : $receiver$iv) {
                    VirtualFile directory = (VirtualFile)element$iv;
                    if (!VfsUtilCore.isAncestor(directory, file2, false)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        @Override
        @NotNull
        public String toString() {
            return "All files under: " + this.directories;
        }

        public DirectoriesScope(@NotNull Project project, @NotNull List<? extends VirtualFile> directories) {
            Intrinsics.checkParameterIsNotNull(project, "project");
            Intrinsics.checkParameterIsNotNull(directories, "directories");
            super(GlobalSearchScope.allScope(project));
            this.directories = directories;
        }
    }
}

