/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ref.DebugReflectionUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CachedValueLeakChecker {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.CachedValueChecker");
    private static final boolean DO_CHECKS = ApplicationManager.getApplication().isUnitTestMode();
    private static final Set<String> ourCheckedKeys = ContainerUtil.newConcurrentSet();

    static void checkProvider(@NotNull CachedValueProvider provider, @NotNull Key key, @NotNull UserDataHolder userDataHolder) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/util/CachedValueLeakChecker", "checkProvider"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/CachedValueLeakChecker", "checkProvider"));
        }
        if (userDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userDataHolder", "com/intellij/util/CachedValueLeakChecker", "checkProvider"));
        }
        if (!DO_CHECKS) {
            return;
        }
        if (!ourCheckedKeys.add(key.toString())) {
            return;
        }
        if (!SystemInfo.isJavaVersionAtLeast("9")) {
            CachedValueLeakChecker.findReferencedPsi(provider, userDataHolder, 5);
        }
    }

    private static synchronized void findReferencedPsi(@NotNull Object root, @Nullable UserDataHolder toIgnore, int depth) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/util/CachedValueLeakChecker", "findReferencedPsi"));
        }
        Condition<Object> shouldExamineValue = value -> {
            if (value == toIgnore) {
                return false;
            }
            if (value instanceof Project || value instanceof Module || value instanceof Application) {
                return false;
            }
            return !(value instanceof PsiElement) || !(toIgnore instanceof PsiElement) || ((PsiElement)toIgnore).getContainingFile() == null || !PsiTreeUtil.isAncestor((PsiElement)value, (PsiElement)toIgnore, true);
        };
        DebugReflectionUtil.walkObjects(depth, Collections.singletonList(root), PsiElement.class, shouldExamineValue, (value, backLink) -> {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/util/CachedValueLeakChecker", "lambda$findReferencedPsi$1"));
            }
            if (value instanceof PsiElement) {
                LOG.error("Incorrect CachedValue use. Provider references PSI, causing memory leaks and possible invalid element access, provider=" + root + "\n" + backLink);
                return false;
            }
            return true;
        });
    }
}

