/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.AbstractBundle;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.java.parser.DeclarationParser;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileParser {
    private static final TokenSet IMPORT_LIST_STOPPER_SET = TokenSet.orSet(ElementType.MODIFIER_BIT_SET, TokenSet.create(JavaTokenType.CLASS_KEYWORD, JavaTokenType.INTERFACE_KEYWORD, JavaTokenType.ENUM_KEYWORD, JavaTokenType.AT));
    private final JavaParser myParser;

    public FileParser(@NotNull JavaParser javaParser) {
        if (javaParser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaParser", "com/intellij/lang/java/parser/FileParser", "<init>"));
        }
        this.myParser = javaParser;
    }

    public void parse(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/java/parser/FileParser", "parse"));
        }
        this.parseFile(builder, FileParser::stopImportListParsing, JavaErrorMessages.INSTANCE, "expected.class.or.interface");
    }

    public void parseFile(@NotNull PsiBuilder builder, @NotNull Predicate<PsiBuilder> importListStopper, @NotNull AbstractBundle bundle, @NotNull String errorMessageKey) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/java/parser/FileParser", "parseFile"));
        }
        if (importListStopper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importListStopper", "com/intellij/lang/java/parser/FileParser", "parseFile"));
        }
        if (bundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundle", "com/intellij/lang/java/parser/FileParser", "parseFile"));
        }
        if (errorMessageKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessageKey", "com/intellij/lang/java/parser/FileParser", "parseFile"));
        }
        this.parsePackageStatement(builder);
        Pair<PsiBuilder.Marker, Boolean> impListInfo = this.parseImportList(builder, importListStopper);
        Boolean firstDeclarationOk = null;
        PsiBuilder.Marker firstDeclaration = null;
        PsiBuilder.Marker module = this.myParser.getModuleParser().parse(builder);
        if (module != null) {
            firstDeclarationOk = true;
            firstDeclaration = module;
        } else {
            PsiBuilder.Marker invalidElements = null;
            while (!builder.eof()) {
                if (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                    builder.advanceLexer();
                    continue;
                }
                PsiBuilder.Marker declaration = this.parseInitial(builder);
                if (declaration != null) {
                    if (invalidElements != null) {
                        invalidElements.errorBefore(FileParser.error(bundle, errorMessageKey), declaration);
                        invalidElements = null;
                    }
                    if (firstDeclarationOk != null || !(firstDeclarationOk = Boolean.valueOf(JavaParserUtil.exprType(declaration) != JavaElementType.MODIFIER_LIST)).booleanValue()) continue;
                    firstDeclaration = declaration;
                    continue;
                }
                if (invalidElements == null) {
                    invalidElements = builder.mark();
                }
                builder.advanceLexer();
                if (firstDeclarationOk != null) continue;
                firstDeclarationOk = false;
            }
            if (invalidElements != null) {
                invalidElements.error(FileParser.error(bundle, errorMessageKey));
            }
        }
        if (((Boolean)impListInfo.second).booleanValue() && firstDeclarationOk == Boolean.TRUE) {
            ((PsiBuilder.Marker)impListInfo.first).setCustomEdgeTokenBinders(JavaParserUtil.PRECEDING_COMMENT_BINDER, null);
            firstDeclaration.setCustomEdgeTokenBinders(JavaParserUtil.SPECIAL_PRECEDING_COMMENT_BINDER, null);
        }
    }

    private static boolean stopImportListParsing(PsiBuilder b) {
        String text2;
        IElementType type2 = b.getTokenType();
        if (IMPORT_LIST_STOPPER_SET.contains(type2)) {
            return true;
        }
        return type2 == JavaTokenType.IDENTIFIER && ("open".equals(text2 = b.getTokenText()) || "module".equals(text2));
    }

    @Nullable
    protected PsiBuilder.Marker parseInitial(PsiBuilder builder) {
        return this.myParser.getDeclarationParser().parse(builder, DeclarationParser.Context.FILE);
    }

    private void parsePackageStatement(PsiBuilder builder) {
        PsiBuilder.Marker ref;
        PsiBuilder.Marker statement2 = builder.mark();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.PACKAGE_KEYWORD)) {
            PsiBuilder.Marker modList = builder.mark();
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            JavaParserUtil.done(modList, JavaElementType.MODIFIER_LIST);
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.PACKAGE_KEYWORD)) {
                statement2.rollbackTo();
                return;
            }
        }
        if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, false, false, false)) == null) {
            statement2.error(JavaErrorMessages.message("expected.class.or.interface", new Object[0]));
            return;
        }
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement2, JavaElementType.PACKAGE_STATEMENT);
    }

    @NotNull
    private Pair<PsiBuilder.Marker, Boolean> parseImportList(PsiBuilder builder, Predicate<PsiBuilder> stopper) {
        boolean isEmpty;
        PsiBuilder.Marker list2 = builder.mark();
        IElementType tokenType = builder.getTokenType();
        boolean bl = isEmpty = tokenType != JavaTokenType.IMPORT_KEYWORD && tokenType != JavaTokenType.SEMICOLON;
        if (!isEmpty) {
            PsiBuilder.Marker invalidElements = null;
            while (!builder.eof() && !stopper.test(builder)) {
                if (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                    builder.advanceLexer();
                    continue;
                }
                PsiBuilder.Marker statement2 = this.parseImportStatement(builder);
                if (statement2 != null) {
                    if (invalidElements == null) continue;
                    invalidElements.errorBefore(JavaErrorMessages.message("unexpected.token", new Object[0]), statement2);
                    invalidElements = null;
                    continue;
                }
                if (invalidElements == null) {
                    invalidElements = builder.mark();
                }
                builder.advanceLexer();
            }
            if (invalidElements != null) {
                invalidElements.error(JavaErrorMessages.message("unexpected.token", new Object[0]));
            }
        }
        JavaParserUtil.done(list2, JavaElementType.IMPORT_LIST);
        Pair<PsiBuilder.Marker, Boolean> pair = Pair.create(list2, isEmpty);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/FileParser", "parseImportList"));
        }
        return pair;
    }

    @Nullable
    private PsiBuilder.Marker parseImportStatement(PsiBuilder builder) {
        if (builder.getTokenType() != JavaTokenType.IMPORT_KEYWORD) {
            return null;
        }
        PsiBuilder.Marker statement2 = builder.mark();
        builder.advanceLexer();
        boolean isStatic = PsiBuilderUtil.expect(builder, JavaTokenType.STATIC_KEYWORD);
        IElementType type2 = isStatic ? JavaElementType.IMPORT_STATIC_STATEMENT : JavaElementType.IMPORT_STATEMENT;
        boolean isOk = this.myParser.getReferenceParser().parseImportCodeReference(builder, isStatic);
        if (isOk) {
            JavaParserUtil.semicolon(builder);
        }
        JavaParserUtil.done(statement2, type2);
        return statement2;
    }

    private static String error(@NotNull AbstractBundle bundle, @NotNull String errorMessageKey) {
        if (bundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundle", "com/intellij/lang/java/parser/FileParser", "error"));
        }
        if (errorMessageKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessageKey", "com/intellij/lang/java/parser/FileParser", "error"));
        }
        return bundle.getMessage(errorMessageKey, new Object[0]);
    }
}

