/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.when;

import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.when.EnumSwitchCodegen;
import org.jetbrains.kotlin.codegen.when.IntegralConstantsSwitchCodegen;
import org.jetbrains.kotlin.codegen.when.StringSwitchCodegen;
import org.jetbrains.kotlin.codegen.when.SwitchCodegen;
import org.jetbrains.kotlin.codegen.when.WhenByEnumsMapping;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.org.objectweb.asm.Type;

public class SwitchCodegenUtil {
    public static boolean checkAllItemsAreConstantsSatisfying(@NotNull KtWhenExpression expression, @NotNull BindingContext bindingContext, boolean shouldInlineConstVals, Function1<ConstantValue<?>, Boolean> predicate) {
        if (expression == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(0);
        }
        if (bindingContext == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(1);
        }
        for (KtWhenEntry entry : expression.getEntries()) {
            for (KtWhenCondition condition : entry.getConditions()) {
                if (!(condition instanceof KtWhenConditionWithExpression)) {
                    return false;
                }
                KtExpression patternExpression = ((KtWhenConditionWithExpression)condition).getExpression();
                if (patternExpression == null) {
                    return false;
                }
                ConstantValue<?> constant = ExpressionCodegen.getCompileTimeConstant(patternExpression, bindingContext, shouldInlineConstVals);
                if (constant != null && predicate.invoke(constant).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static Iterable<ConstantValue<?>> getAllConstants(@NotNull KtWhenExpression expression, @NotNull BindingContext bindingContext, boolean shouldInlineConstVals) {
        if (expression == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(2);
        }
        if (bindingContext == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(3);
        }
        ArrayList result2 = new ArrayList();
        for (KtWhenEntry entry : expression.getEntries()) {
            SwitchCodegenUtil.addConstantsFromEntry(result2, entry, bindingContext, shouldInlineConstVals);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static void addConstantsFromEntry(@NotNull List<ConstantValue<?>> result2, @NotNull KtWhenEntry entry, @NotNull BindingContext bindingContext, boolean shouldInlineConstVals) {
        if (result2 == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(5);
        }
        if (entry == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(6);
        }
        if (bindingContext == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(7);
        }
        for (KtWhenCondition condition : entry.getConditions()) {
            if (!(condition instanceof KtWhenConditionWithExpression)) continue;
            KtExpression patternExpression = ((KtWhenConditionWithExpression)condition).getExpression();
            assert (patternExpression != null) : "expression in when should not be null";
            result2.add(ExpressionCodegen.getCompileTimeConstant(patternExpression, bindingContext, shouldInlineConstVals));
        }
    }

    @NotNull
    public static Iterable<ConstantValue<?>> getConstantsFromEntry(@NotNull KtWhenEntry entry, @NotNull BindingContext bindingContext, boolean shouldInlineConstVals) {
        if (entry == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(8);
        }
        if (bindingContext == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(9);
        }
        ArrayList result2 = new ArrayList();
        SwitchCodegenUtil.addConstantsFromEntry(result2, entry, bindingContext, shouldInlineConstVals);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Nullable
    public static SwitchCodegen buildAppropriateSwitchCodegenIfPossible(@NotNull KtWhenExpression expression, boolean isStatement, boolean isExhaustive, @NotNull ExpressionCodegen codegen) {
        boolean shouldInlineConstVals;
        BindingContext bindingContext;
        if (expression == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(11);
        }
        if (codegen == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(12);
        }
        if (!SwitchCodegenUtil.isThereConstantEntriesButNulls(expression, bindingContext = codegen.getBindingContext(), shouldInlineConstVals = codegen.getState().getShouldInlineConstVals())) {
            return null;
        }
        Type subjectType = codegen.expressionType(expression.getSubjectExpression());
        WhenByEnumsMapping mapping2 = codegen.getBindingContext().get(CodegenBinding.MAPPING_FOR_WHEN_BY_ENUM, expression);
        if (mapping2 != null) {
            return new EnumSwitchCodegen(expression, isStatement, isExhaustive, codegen, mapping2);
        }
        if (SwitchCodegenUtil.isIntegralConstantsSwitch(expression, subjectType, bindingContext, shouldInlineConstVals)) {
            return new IntegralConstantsSwitchCodegen(expression, isStatement, isExhaustive, codegen);
        }
        if (SwitchCodegenUtil.isStringConstantsSwitch(expression, subjectType, bindingContext, shouldInlineConstVals)) {
            return new StringSwitchCodegen(expression, isStatement, isExhaustive, codegen);
        }
        return null;
    }

    private static boolean isThereConstantEntriesButNulls(@NotNull KtWhenExpression expression, @NotNull BindingContext bindingContext, boolean shouldInlineConstVals) {
        if (expression == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(13);
        }
        if (bindingContext == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(14);
        }
        for (ConstantValue<?> constant : SwitchCodegenUtil.getAllConstants(expression, bindingContext, shouldInlineConstVals)) {
            if (constant == null || constant instanceof NullValue) continue;
            return true;
        }
        return false;
    }

    private static boolean isIntegralConstantsSwitch(@NotNull KtWhenExpression expression, @NotNull Type subjectType, @NotNull BindingContext bindingContext, boolean shouldInlineConstVals) {
        int typeSort;
        if (expression == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(15);
        }
        if (subjectType == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(16);
        }
        if (bindingContext == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(17);
        }
        if ((typeSort = subjectType.getSort()) != 5 && typeSort != 2 && typeSort != 4 && typeSort != 3) {
            return false;
        }
        return SwitchCodegenUtil.checkAllItemsAreConstantsSatisfying(expression, bindingContext, shouldInlineConstVals, new Function1<ConstantValue<?>, Boolean>(){

            @Override
            public Boolean invoke(@NotNull ConstantValue<?> constant) {
                if (constant == null) {
                    1.$$$reportNull$$$0(0);
                }
                return constant instanceof IntegerValueConstant;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constant", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil$1", "invoke"));
            }
        });
    }

    private static boolean isStringConstantsSwitch(@NotNull KtWhenExpression expression, @NotNull Type subjectType, @NotNull BindingContext bindingContext, boolean shouldInlineConstVals) {
        if (expression == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(18);
        }
        if (subjectType == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(19);
        }
        if (bindingContext == null) {
            SwitchCodegenUtil.$$$reportNull$$$0(20);
        }
        if (!subjectType.getClassName().equals(String.class.getName())) {
            return false;
        }
        return SwitchCodegenUtil.checkAllItemsAreConstantsSatisfying(expression, bindingContext, shouldInlineConstVals, new Function1<ConstantValue<?>, Boolean>(){

            @Override
            public Boolean invoke(@NotNull ConstantValue<?> constant) {
                if (constant == null) {
                    2.$$$reportNull$$$0(0);
                }
                return constant instanceof StringValue || constant instanceof NullValue;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constant", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil$2", "invoke"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subjectType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllConstants";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstantsFromEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAllItemsAreConstantsSatisfying";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllConstants";
                break;
            }
            case 4: 
            case 10: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addConstantsFromEntry";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getConstantsFromEntry";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildAppropriateSwitchCodegenIfPossible";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isThereConstantEntriesButNulls";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isIntegralConstantsSwitch";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isStringConstantsSwitch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

