/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.augment;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiAugmentProvider {
    public static final ExtensionPointName<PsiAugmentProvider> EP_NAME = ExtensionPointName.create("com.intellij.lang.psiAugmentProvider");

    @NotNull
    protected <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/augment/PsiAugmentProvider", "getAugments"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/augment/PsiAugmentProvider", "getAugments"));
        }
        List list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/augment/PsiAugmentProvider", "getAugments"));
        }
        return list2;
    }

    @Nullable
    protected PsiType inferType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "com/intellij/psi/augment/PsiAugmentProvider", "inferType"));
        }
        return null;
    }

    @NotNull
    protected Set<String> transformModifiers(@NotNull PsiModifierList modifierList, @NotNull Set<String> modifiers) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "com/intellij/psi/augment/PsiAugmentProvider", "transformModifiers"));
        }
        if (modifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiers", "com/intellij/psi/augment/PsiAugmentProvider", "transformModifiers"));
        }
        Set<String> set = modifiers;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/augment/PsiAugmentProvider", "transformModifiers"));
        }
        return set;
    }

    @NotNull
    public static <Psi extends PsiElement> List<Psi> collectAugments(@NotNull PsiElement element, @NotNull Class<Psi> type2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/augment/PsiAugmentProvider", "collectAugments"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/augment/PsiAugmentProvider", "collectAugments"));
        }
        List result2 = ContainerUtil.newSmartList();
        PsiAugmentProvider.forEach(element.getProject(), provider -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/augment/PsiAugmentProvider", "lambda$collectAugments$0"));
            }
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/augment/PsiAugmentProvider", "lambda$collectAugments$0"));
            }
            result2.addAll(provider.getAugments(element, type2));
            return true;
        });
        List list2 = result2;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/augment/PsiAugmentProvider", "collectAugments"));
        }
        return list2;
    }

    @Nullable
    public static PsiType getInferredType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "com/intellij/psi/augment/PsiAugmentProvider", "getInferredType"));
        }
        Ref result2 = Ref.create();
        PsiAugmentProvider.forEach(typeElement.getProject(), provider -> {
            if (typeElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "com/intellij/psi/augment/PsiAugmentProvider", "lambda$getInferredType$1"));
            }
            PsiType type2 = provider.inferType(typeElement);
            if (type2 != null) {
                result2.set(type2);
                return false;
            }
            return true;
        });
        return (PsiType)result2.get();
    }

    @NotNull
    public static Set<String> transformModifierProperties(@NotNull PsiModifierList modifierList, @NotNull Project project, @NotNull Set<String> modifiers) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "com/intellij/psi/augment/PsiAugmentProvider", "transformModifierProperties"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/augment/PsiAugmentProvider", "transformModifierProperties"));
        }
        if (modifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiers", "com/intellij/psi/augment/PsiAugmentProvider", "transformModifierProperties"));
        }
        Ref<Set<String>> result2 = Ref.create(modifiers);
        PsiAugmentProvider.forEach(project, provider -> {
            if (modifierList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "com/intellij/psi/augment/PsiAugmentProvider", "lambda$transformModifierProperties$2"));
            }
            result2.set(provider.transformModifiers(modifierList, Collections.unmodifiableSet((Set)result2.get())));
            return true;
        });
        Set<String> set = result2.get();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/augment/PsiAugmentProvider", "transformModifierProperties"));
        }
        return set;
    }

    private static void forEach(Project project, Processor<PsiAugmentProvider> processor) {
        boolean dumb = DumbService.isDumb(project);
        for (PsiAugmentProvider provider : Extensions.getExtensions(EP_NAME)) {
            if (dumb && !DumbService.isDumbAware(provider)) continue;
            try {
                boolean goOn = processor.process(provider);
                if (goOn) continue;
                break;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                Logger.getInstance(PsiAugmentProvider.class).error("provider: " + provider, e);
            }
        }
    }
}

