/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.parser.com.sampullara.cli;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import org.jetbrains.kotlin.cli.common.parser.com.sampullara.cli.Args;
import org.jetbrains.kotlin.cli.common.parser.com.sampullara.cli.Argument;

public class PropertiesArgs {
    public static void parse(Object target, Properties arguments2) {
        Class<?> clazz = target instanceof Class ? (Class<?>)target : target.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            PropertiesArgs.processField(target, field, arguments2);
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                PropertiesArgs.processProperty(target, pd, arguments2);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    private static void processField(Object target, Field field, Properties arguments2) {
        Argument argument = field.getAnnotation(Argument.class);
        if (argument != null) {
            String name = Args.getName(argument, field);
            String alias = Args.getAlias(argument);
            Class<?> type2 = field.getType();
            Object value = arguments2.get(name);
            if (value == null && alias != null) {
                value = arguments2.get(alias);
            }
            if (value != null) {
                if (type2 == Boolean.TYPE || type2 == Boolean.class) {
                    value = true;
                }
                Args.setField(type2, field, target, value, argument.delimiter());
            } else if (argument.required()) {
                throw new IllegalArgumentException("You must set argument " + name);
            }
        }
    }

    private static void processProperty(Object target, PropertyDescriptor property, Properties arguments2) {
        Argument argument;
        Method writeMethod = property.getWriteMethod();
        if (writeMethod != null && (argument = writeMethod.getAnnotation(Argument.class)) != null) {
            String name = Args.getName(argument, property);
            String alias = Args.getAlias(argument);
            Object value = arguments2.get(name);
            if (value == null && alias != null) {
                value = arguments2.get(alias);
            }
            if (value != null) {
                Class<?> type2 = property.getPropertyType();
                if (type2 == Boolean.TYPE || type2 == Boolean.class) {
                    value = true;
                }
                Args.setProperty(type2, property, target, value, argument.delimiter());
            } else if (argument.required()) {
                throw new IllegalArgumentException("You must set argument " + name);
            }
        }
    }
}

