/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PsiDiamondTypeUtil {
    private static final Logger LOG = Logger.getInstance("#" + PsiDiamondTypeUtil.class.getName());

    private PsiDiamondTypeUtil() {
    }

    public static boolean canCollapseToDiamond(PsiNewExpression expression, PsiNewExpression context, @Nullable PsiType expectedType) {
        return PsiDiamondTypeUtil.canCollapseToDiamond(expression, context, expectedType, false);
    }

    public static boolean canChangeContextForDiamond(PsiNewExpression expression, PsiType expectedType) {
        PsiNewExpression copy = (PsiNewExpression)expression.copy();
        return PsiDiamondTypeUtil.canCollapseToDiamond(copy, copy, expectedType, true);
    }

    private static boolean canCollapseToDiamond(PsiNewExpression expression, PsiNewExpression context, @Nullable PsiType expectedType, boolean skipDiamonds) {
        PsiTypeElement[] typeElements;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement classReference;
        if (PsiUtil.getLanguageLevel(context).isAtLeast(LanguageLevel.JDK_1_7) && (classReference = expression.getClassOrAnonymousClassReference()) != null && (parameterList = classReference.getParameterList()) != null && (typeElements = parameterList.getTypeParameterElements()).length > 0) {
            if (!skipDiamonds && typeElements.length == 1 && typeElements[0].getType() instanceof PsiDiamondType) {
                return false;
            }
            PsiDiamondType.DiamondInferenceResult inferenceResult = PsiDiamondTypeImpl.resolveInferredTypes(expression, context);
            if (inferenceResult.getErrorMessage() == null) {
                List<PsiType> types = inferenceResult.getInferredTypes();
                PsiType[] typeArguments = null;
                if (expectedType instanceof PsiClassType) {
                    typeArguments = ((PsiClassType)expectedType).getParameters();
                }
                if (typeArguments == null) {
                    typeArguments = parameterList.getTypeArguments();
                }
                if (types.size() == typeArguments.length) {
                    PsiMethod method = expression.resolveMethod();
                    PsiElement resolve2 = classReference.resolve();
                    if (resolve2 instanceof PsiClass) {
                        PsiTypeParameter[] typeParameters2 = ((PsiClass)resolve2).getTypeParameters();
                        return PsiDiamondTypeUtil.areTypeArgumentsRedundant(typeArguments, expression, true, method, typeParameters2);
                    }
                }
            }
        }
        return false;
    }

    public static PsiElement replaceExplicitWithDiamond(PsiElement psiElement) {
        if (psiElement instanceof PsiReferenceParameterList) {
            PsiNewExpression expression = (PsiNewExpression)JavaPsiFacade.getElementFactory(psiElement.getProject()).createExpressionFromText("new a<>()", psiElement);
            PsiJavaCodeReferenceElement classReference = expression.getClassReference();
            LOG.assertTrue(classReference != null);
            PsiReferenceParameterList parameterList = classReference.getParameterList();
            LOG.assertTrue(parameterList != null);
            return psiElement.replace(parameterList);
        }
        return psiElement;
    }

    public static PsiElement replaceDiamondWithExplicitTypes(PsiElement element) {
        PsiElement parent2 = element.getParent();
        if (!(parent2 instanceof PsiJavaCodeReferenceElement)) {
            return parent2;
        }
        PsiJavaCodeReferenceElement javaCodeReferenceElement = (PsiJavaCodeReferenceElement)parent2;
        StringBuilder text2 = new StringBuilder();
        text2.append(javaCodeReferenceElement.getQualifiedName());
        text2.append('<');
        PsiNewExpression newExpression = PsiTreeUtil.getParentOfType(element, PsiNewExpression.class);
        PsiDiamondType.DiamondInferenceResult result2 = PsiDiamondTypeImpl.resolveInferredTypesNoCheck(newExpression, newExpression);
        text2.append(StringUtil.join(result2.getInferredTypes(), psiType -> psiType.getCanonicalText(), ","));
        text2.append('>');
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(element.getProject());
        PsiJavaCodeReferenceElement newReference = elementFactory.createReferenceFromText(text2.toString(), element);
        return CodeStyleManager.getInstance(javaCodeReferenceElement.getProject()).reformat(javaCodeReferenceElement.replace(newReference));
    }

    public static PsiExpression expandTopLevelDiamondsInside(PsiExpression expr) {
        PsiTypeElement[] typeParameterElements;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement classReference;
        if (expr instanceof PsiNewExpression && (classReference = ((PsiNewExpression)expr).getClassReference()) != null && (parameterList = classReference.getParameterList()) != null && (typeParameterElements = parameterList.getTypeParameterElements()).length == 1 && typeParameterElements[0].getType() instanceof PsiDiamondType) {
            return (PsiExpression)PsiDiamondTypeUtil.replaceDiamondWithExplicitTypes(parameterList).getParent();
        }
        return expr;
    }

    public static String getCollapsedType(PsiType type2, PsiElement context) {
        int idx;
        String typeText = type2.getCanonicalText();
        if (PsiUtil.isLanguageLevel7OrHigher(context) && (idx = typeText.indexOf(60)) >= 0) {
            return typeText.substring(0, idx) + "<>";
        }
        return typeText;
    }

    public static boolean areTypeArgumentsRedundant(PsiType[] typeArguments, PsiCallExpression expression, boolean constructorRef, @Nullable PsiMethod method, PsiTypeParameter[] typeParameters2) {
        try {
            PsiElement copy;
            PsiType typeByParent = PsiTypesUtil.getExpectedTypeByParent(expression);
            if (typeByParent != null) {
                String arrayInitializer = "new " + typeByParent.getCanonicalText() + "[]{0}";
                Project project = expression.getProject();
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance(project).getElementFactory();
                PsiNewExpression newExpr = (PsiNewExpression)elementFactory.createExpressionFromText(arrayInitializer, expression);
                newExpr = (PsiNewExpression)JavaCodeStyleManager.getInstance(project).shortenClassReferences(newExpr);
                PsiArrayInitializerExpression initializer2 = newExpr.getArrayInitializer();
                LOG.assertTrue(initializer2 != null);
                copy = initializer2.getInitializers()[0].replace(expression);
            } else {
                PsiExpressionList argumentList2 = expression.getArgumentList();
                int offset2 = (argumentList2 != null ? argumentList2 : expression).getTextRange().getStartOffset();
                PsiCall call2 = LambdaUtil.treeWalkUp(expression);
                if (call2 != null) {
                    PsiCall callCopy = LambdaUtil.copyTopLevelCall(call2);
                    copy = callCopy != null ? callCopy.findElementAt(offset2 - call2.getTextRange().getStartOffset()) : null;
                } else {
                    PsiElement startMethodElementInCopy;
                    InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(expression.getProject());
                    if (injectedLanguageManager.getInjectionHost(expression) != null) {
                        return false;
                    }
                    PsiFile containingFile = expression.getContainingFile();
                    PsiFile fileCopy = (PsiFile)containingFile.copy();
                    copy = fileCopy.findElementAt(offset2);
                    if (method != null && method.getContainingFile() == containingFile && (method = PsiTreeUtil.getParentOfType(startMethodElementInCopy = fileCopy.findElementAt(method.getTextOffset()), PsiMethod.class)) == null) {
                        return false;
                    }
                }
            }
            PsiCallExpression exprCopy = PsiTreeUtil.getParentOfType(copy, PsiCallExpression.class, false);
            if (exprCopy != null) {
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance(exprCopy.getProject()).getElementFactory();
                if (constructorRef) {
                    if (!(exprCopy instanceof PsiNewExpression) || !PsiDiamondTypeUtil.isInferenceEquivalent(typeArguments, elementFactory, (PsiNewExpression)exprCopy)) {
                        return false;
                    }
                } else {
                    LOG.assertTrue(method != null);
                    if (!PsiDiamondTypeUtil.isInferenceEquivalent(typeArguments, elementFactory, exprCopy, method, typeParameters2)) {
                        return false;
                    }
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.info(e);
            return false;
        }
        return true;
    }

    private static boolean isInferenceEquivalent(PsiType[] typeArguments, PsiElementFactory elementFactory, PsiCallExpression exprCopy, PsiMethod method, PsiTypeParameter[] typeParameters2) throws IncorrectOperationException {
        PsiReferenceParameterList list2 = ((PsiCallExpression)elementFactory.createExpressionFromText("foo()", null)).getTypeArgumentList();
        exprCopy.getTypeArgumentList().replace(list2);
        JavaResolveResult copyResult = exprCopy.resolveMethodGenerics();
        if (method != copyResult.getElement()) {
            return false;
        }
        PsiSubstitutor psiSubstitutor = copyResult.getSubstitutor();
        int length = typeParameters2.length;
        for (int i = 0; i < length; ++i) {
            PsiTypeParameter typeParameter = typeParameters2[i];
            PsiType inferredType = psiSubstitutor.getSubstitutionMap().get(typeParameter);
            if (!typeArguments[i].equals(inferredType)) {
                return false;
            }
            if (PsiUtil.resolveClassInType(method.getReturnType()) != typeParameter || PsiPrimitiveType.getUnboxedType(inferredType) == null) continue;
            return false;
        }
        return PsiDiamondTypeUtil.checkParentApplicability(exprCopy);
    }

    private static boolean isInferenceEquivalent(PsiType[] typeArguments, PsiElementFactory elementFactory, PsiNewExpression exprCopy) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement collapsedClassReference = ((PsiNewExpression)elementFactory.createExpressionFromText("new A<>()", null)).getClassOrAnonymousClassReference();
        LOG.assertTrue(collapsedClassReference != null);
        PsiReferenceParameterList diamondParameterList = collapsedClassReference.getParameterList();
        LOG.assertTrue(diamondParameterList != null);
        PsiJavaCodeReferenceElement classReference = exprCopy.getClassOrAnonymousClassReference();
        LOG.assertTrue(classReference != null);
        PsiReferenceParameterList parameterList = classReference.getParameterList();
        LOG.assertTrue(parameterList != null);
        parameterList.replace(diamondParameterList);
        PsiType[] inferredArgs = classReference.getParameterList().getTypeArguments();
        if (typeArguments.length != inferredArgs.length) {
            return false;
        }
        for (int i = 0; i < typeArguments.length; ++i) {
            PsiWildcardType wildcardType;
            PsiType bound;
            PsiType typeArgument = typeArguments[i];
            if (inferredArgs[i] instanceof PsiWildcardType && (bound = (wildcardType = (PsiWildcardType)inferredArgs[i]).getBound()) != null && (!wildcardType.isExtends() ? typeArgument.isAssignableFrom(bound) : bound.isAssignableFrom(typeArgument)) || typeArgument.equals(inferredArgs[i])) continue;
            return false;
        }
        return PsiDiamondTypeUtil.checkParentApplicability(exprCopy);
    }

    private static boolean checkParentApplicability(PsiCallExpression exprCopy) {
        while (exprCopy != null) {
            JavaResolveResult resolveResult = exprCopy.resolveMethodGenerics();
            if (resolveResult instanceof MethodCandidateInfo && !((MethodCandidateInfo)resolveResult).isApplicable()) {
                return false;
            }
            exprCopy = PsiTreeUtil.getParentOfType((PsiElement)exprCopy, PsiCallExpression.class, true);
        }
        return true;
    }

    public static void removeRedundantTypeArguments(PsiElement element) {
        for (PsiNewExpression newExpression : PsiTreeUtil.collectElementsOfType(element, PsiNewExpression.class)) {
            PsiJavaCodeReferenceElement classReference = newExpression.getClassOrAnonymousClassReference();
            if (classReference == null || !PsiDiamondTypeUtil.canCollapseToDiamond(newExpression, newExpression, null)) continue;
            PsiDiamondTypeUtil.replaceExplicitWithDiamond(classReference.getParameterList());
        }
        PsiElementFactory factory2 = JavaPsiFacade.getInstance(element.getProject()).getElementFactory();
        for (PsiMethodCallExpression call2 : PsiTreeUtil.collectElementsOfType(element, PsiMethodCallExpression.class)) {
            PsiTypeParameter[] parameters2;
            PsiType[] arguments2 = call2.getTypeArguments();
            PsiMethod method = call2.resolveMethod();
            if (method == null || arguments2.length != (parameters2 = method.getTypeParameters()).length || !PsiDiamondTypeUtil.areTypeArgumentsRedundant(arguments2, call2, false, method, parameters2)) continue;
            PsiMethodCallExpression expr = (PsiMethodCallExpression)factory2.createExpressionFromText("foo()", null);
            call2.getTypeArgumentList().replace(expr.getTypeArgumentList());
        }
    }
}

