/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.intrinsics;

import com.google.common.collect.Maps;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethods;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

class IntrinsicsMap {
    private final Map<Key, IntrinsicMethod> intrinsicsMap = Maps.newHashMap();

    IntrinsicsMap() {
    }

    private static int valueParameterCountForKey(@NotNull CallableMemberDescriptor member) {
        if (member == null) {
            IntrinsicsMap.$$$reportNull$$$0(0);
        }
        if (member instanceof PropertyDescriptor) {
            return -1;
        }
        return member.getValueParameters().size();
    }

    public void registerIntrinsic(@NotNull FqName owner, @Nullable FqNameUnsafe receiverParameter, @NotNull String name, int valueParameterCount, @NotNull IntrinsicMethod impl) {
        if (owner == null) {
            IntrinsicsMap.$$$reportNull$$$0(1);
        }
        if (name == null) {
            IntrinsicsMap.$$$reportNull$$$0(2);
        }
        if (impl == null) {
            IntrinsicsMap.$$$reportNull$$$0(3);
        }
        this.intrinsicsMap.put(new Key(owner.toUnsafe(), receiverParameter, name, valueParameterCount), impl);
    }

    @Nullable
    public IntrinsicMethod getIntrinsic(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            IntrinsicsMap.$$$reportNull$$$0(4);
        }
        Key key = new Key(DescriptorUtils.getFqName(descriptor2.getContainingDeclaration()), IntrinsicsMap.getReceiverParameterFqName(descriptor2), descriptor2.getName().asString(), IntrinsicsMap.valueParameterCountForKey(descriptor2));
        return this.intrinsicsMap.get(key);
    }

    @Nullable
    private static FqNameUnsafe getReceiverParameterFqName(@NotNull CallableMemberDescriptor descriptor2) {
        ReceiverParameterDescriptor receiverParameter;
        if (descriptor2 == null) {
            IntrinsicsMap.$$$reportNull$$$0(5);
        }
        if ((receiverParameter = descriptor2.getExtensionReceiverParameter()) == null) {
            return null;
        }
        ClassifierDescriptor classifier2 = receiverParameter.getType().getConstructor().getDeclarationDescriptor();
        if (classifier2 == null) {
            return null;
        }
        if (classifier2 instanceof TypeParameterDescriptor) {
            return IntrinsicMethods.RECEIVER_PARAMETER_FQ_NAME;
        }
        return DescriptorUtils.getFqName(classifier2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "impl";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/codegen/intrinsics/IntrinsicsMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "valueParameterCountForKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerIntrinsic";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getIntrinsic";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getReceiverParameterFqName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Key {
        private final FqNameUnsafe owner;
        private final FqNameUnsafe receiverParameter;
        private final String name;
        private final int valueParameterCount;

        private Key(@NotNull FqNameUnsafe owner, @Nullable FqNameUnsafe receiverParameter, @NotNull String name, int valueParameterCount) {
            if (owner == null) {
                Key.$$$reportNull$$$0(0);
            }
            if (name == null) {
                Key.$$$reportNull$$$0(1);
            }
            this.owner = owner;
            this.receiverParameter = receiverParameter;
            this.name = name;
            this.valueParameterCount = valueParameterCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.valueParameterCount != key.valueParameterCount) {
                return false;
            }
            if (!this.name.equals(key.name)) {
                return false;
            }
            if (!this.owner.equals(key.owner)) {
                return false;
            }
            return !(this.receiverParameter == null ? key.receiverParameter != null : !this.receiverParameter.equals(key.receiverParameter));
        }

        public int hashCode() {
            int result2 = this.owner.hashCode();
            result2 = 31 * result2 + this.name.hashCode();
            result2 = 31 * result2 + this.valueParameterCount;
            result2 = 31 * result2 + (this.receiverParameter != null ? this.receiverParameter.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/intrinsics/IntrinsicsMap$Key";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

