/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.core.JavaCoreBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiJavaModuleReference
extends PsiReferenceBase.Poly<PsiJavaModuleReferenceElement> {
    private static final Key<CachedValue<Collection<PsiJavaModule>>> K_COMPLETE = Key.create("java.module.ref.text.resolve.complete");
    private static final Key<CachedValue<Collection<PsiJavaModule>>> K_INCOMPLETE = Key.create("java.module.ref.text.resolve.incomplete");

    public PsiJavaModuleReference(@NotNull PsiJavaModuleReferenceElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiJavaModuleReference", "<init>"));
        }
        super(element, new TextRange(0, element.getTextLength()), false);
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = ((PsiJavaModuleReferenceElement)this.getElement()).getReferenceText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleReference", "getCanonicalText"));
        }
        return string;
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance(this.getProject()).resolveWithCaching(this, Resolver.INSTANCE, false, incompleteCode);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newName2) throws IncorrectOperationException {
        if (newName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/psi/impl/source/PsiJavaModuleReference", "handleElementRename"));
        }
        PsiJavaModuleReferenceElement element = (PsiJavaModuleReferenceElement)this.getElement();
        if (element instanceof PsiCompiledElement) {
            throw new IncorrectOperationException(JavaCoreBundle.message("psi.error.attempt.to.edit.class.file", element.getContainingFile()));
        }
        PsiElementFactory factory2 = PsiElementFactory.SERVICE.getInstance(element.getProject());
        PsiJavaModuleReferenceElement newElement = factory2.createModuleFromText("module " + newName2 + " {}").getNameIdentifier();
        return element.replace(newElement);
    }

    private Project getProject() {
        return ((PsiJavaModuleReferenceElement)this.getElement()).getProject();
    }

    @Nullable
    public static PsiJavaModule resolve(@NotNull PsiElement refOwner, String refText, boolean incompleteCode) {
        if (refOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refOwner", "com/intellij/psi/impl/source/PsiJavaModuleReference", "resolve"));
        }
        Collection<PsiJavaModule> modules = PsiJavaModuleReference.multiResolve(refOwner, refText, incompleteCode);
        return modules.size() == 1 ? modules.iterator().next() : null;
    }

    @NotNull
    public static Collection<PsiJavaModule> multiResolve(@NotNull PsiElement refOwner, String refText, boolean incompleteCode) {
        if (refOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refOwner", "com/intellij/psi/impl/source/PsiJavaModuleReference", "multiResolve"));
        }
        if (StringUtil.isEmpty(refText)) {
            List<PsiJavaModule> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleReference", "multiResolve"));
            }
            return list2;
        }
        CachedValuesManager manager = CachedValuesManager.getManager(refOwner.getProject());
        Key key = incompleteCode ? K_INCOMPLETE : K_COMPLETE;
        Collection collection = (Collection)manager.getCachedValue(refOwner, key, () -> {
            if (refOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refOwner", "com/intellij/psi/impl/source/PsiJavaModuleReference", "lambda$multiResolve$0"));
            }
            Collection modules = Resolver.findModules(refOwner.getContainingFile(), refText, incompleteCode);
            return CachedValueProvider.Result.create(modules, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        }, false);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleReference", "multiResolve"));
        }
        return collection;
    }

    private static class Resolver
    implements ResolveCache.PolyVariantResolver<PsiJavaModuleReference> {
        private static final ResolveCache.PolyVariantResolver<PsiJavaModuleReference> INSTANCE = new Resolver();

        private Resolver() {
        }

        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull PsiJavaModuleReference reference, boolean incompleteCode) {
            String moduleName;
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/source/PsiJavaModuleReference$Resolver", "resolve"));
            }
            PsiFile file2 = ((PsiJavaModuleReferenceElement)reference.getElement()).getContainingFile();
            Collection<PsiJavaModule> modules = Resolver.findModules(file2, moduleName = reference.getCanonicalText(), incompleteCode);
            if (!modules.isEmpty()) {
                ResolveResult[] result2 = new ResolveResult[modules.size()];
                int i = 0;
                for (PsiJavaModule module : modules) {
                    result2[i++] = new PsiElementResolveResult(module);
                }
                if (result2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleReference$Resolver", "resolve"));
                }
                return result2;
            }
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleReference$Resolver", "resolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }

        private static Collection<PsiJavaModule> findModules(PsiFile file2, String moduleName, boolean incompleteCode) {
            Project project = file2.getProject();
            GlobalSearchScope scope = incompleteCode ? GlobalSearchScope.allScope(project) : file2.getResolveScope();
            return JavaFileManager.SERVICE.getInstance(project).findModules(moduleName, scope);
        }
    }
}

