/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.preprocessor;

import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import java.io.File;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.preprocessor.Preprocessor;
import org.jetbrains.kotlin.preprocessor.PreprocessorKt;
import org.jetbrains.kotlin.preprocessor.Profile;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"main", "", "args", "", "", "([Ljava/lang/String;)V", "kotlin-compiler"})
@JvmName(name="PreprocessorCLI")
public final class PreprocessorCLI {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        if (((Object[])args).length != 3) {
            String string = "Usage: <path to sources> <output path> <profile>";
            System.out.println((Object)string);
            System.exit(1);
        }
        File sourcePath = new File(args[0]);
        File targetPath = new File(args[1]);
        Profile profile = PreprocessorKt.createProfile(args[2], targetPath);
        String string = "Preprocessing sources in " + sourcePath + " to " + targetPath + " with profile " + profile.getName();
        System.out.println((Object)string);
        try {
            new Preprocessor(null, 1, null).processSources(sourcePath, profile);
        }
        finally {
            ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.getAppScheduledExecutorService();
            if (scheduledExecutorService == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.concurrency.AppScheduledExecutorService");
            }
            AppScheduledExecutorService service = (AppScheduledExecutorService)scheduledExecutorService;
            service.shutdownAppScheduledExecutorService();
        }
    }
}

