/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassifierImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaTypeImpl;

public class JavaClassifierTypeImpl
extends JavaTypeImpl<PsiClassType>
implements JavaClassifierType {
    private ResolutionResult resolutionResult;

    public JavaClassifierTypeImpl(@NotNull PsiClassType psiClassType) {
        if (psiClassType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClassType", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "<init>"));
        }
        super(psiClassType);
    }

    @Override
    @Nullable
    public JavaClassifierImpl<?> getClassifier() {
        this.resolve();
        return this.resolutionResult.classifier;
    }

    @NotNull
    public PsiSubstitutor getSubstitutor() {
        this.resolve();
        PsiSubstitutor psiSubstitutor = this.resolutionResult.substitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "getSubstitutor"));
        }
        return psiSubstitutor;
    }

    private void resolve() {
        if (this.resolutionResult == null) {
            PsiClassType.ClassResolveResult result2 = ((PsiClassType)this.getPsi()).resolveGenerics();
            PsiClass psiClass = result2.getElement();
            PsiSubstitutor substitutor2 = result2.getSubstitutor();
            this.resolutionResult = new ResolutionResult(psiClass == null ? null : JavaClassifierImpl.create(psiClass), substitutor2, PsiClassType.isRaw(result2));
        }
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = ((PsiClassType)this.getPsi()).getCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "getCanonicalText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        String string = ((PsiClassType)this.getPsi()).getPresentableText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "getPresentableText"));
        }
        return string;
    }

    @Override
    public boolean isRaw() {
        this.resolve();
        return this.resolutionResult.isRaw;
    }

    @Override
    @NotNull
    public List<JavaType> getTypeArguments() {
        JavaClassifier classifier2 = this.getClassifier();
        if (!(classifier2 instanceof JavaClassImpl)) {
            List<JavaType> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "getTypeArguments"));
            }
            return list2;
        }
        List<PsiTypeParameter> parameters2 = JavaClassifierTypeImpl.getTypeParameters((PsiClass)((JavaElementImpl)((Object)classifier2)).getPsi());
        PsiSubstitutor substitutor2 = this.getSubstitutor();
        ArrayList<JavaType> result2 = new ArrayList<JavaType>(parameters2.size());
        for (PsiTypeParameter typeParameter : parameters2) {
            PsiType substitutedType = substitutor2.substitute(typeParameter);
            result2.add(substitutedType == null ? null : JavaTypeImpl.create(substitutedType));
        }
        ArrayList<JavaType> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "getTypeArguments"));
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiTypeParameter> getTypeParameters(@NotNull PsiClass owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "getTypeParameters"));
        }
        ArrayList result2 = null;
        for (PsiClass currentOwner = owner; currentOwner != null; currentOwner = currentOwner.getContainingClass()) {
            PsiTypeParameter[] typeParameters2 = currentOwner.getTypeParameters();
            if (typeParameters2.length > 0) {
                if (result2 == null) {
                    result2 = new ArrayList(typeParameters2.length);
                }
                Collections.addAll(result2, typeParameters2);
            }
            if (currentOwner.hasModifierProperty("static")) break;
        }
        if (result2 == null) {
            List<PsiTypeParameter> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "getTypeParameters"));
            }
            return list2;
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl", "getTypeParameters"));
        }
        return arrayList;
    }

    private static class ResolutionResult {
        private final JavaClassifierImpl<?> classifier;
        private final PsiSubstitutor substitutor;
        private final boolean isRaw;

        private ResolutionResult(@Nullable JavaClassifierImpl<?> classifier2, @NotNull PsiSubstitutor substitutor2, boolean isRaw) {
            if (substitutor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassifierTypeImpl$ResolutionResult", "<init>"));
            }
            this.classifier = classifier2;
            this.substitutor = substitutor2;
            this.isRaw = isRaw;
        }
    }
}

