/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.SMAPBuilder;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public abstract class AbstractClassBuilder
implements ClassBuilder {
    protected static final MethodVisitor EMPTY_METHOD_VISITOR = new MethodVisitor(327680){};
    protected static final FieldVisitor EMPTY_FIELD_VISITOR = new FieldVisitor(327680){};
    private String thisName;
    private final JvmSerializationBindings serializationBindings = new JvmSerializationBindings();
    private final List<FileMapping> fileMappings = new ArrayList<FileMapping>();
    private String sourceName;
    private String debugInfo;

    @Override
    @NotNull
    public FieldVisitor newField(@NotNull JvmDeclarationOrigin origin, int access, @NotNull String name2, @NotNull String desc, @Nullable String signature2, @Nullable Object value) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/AbstractClassBuilder", "newField"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/AbstractClassBuilder", "newField"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/AbstractClassBuilder", "newField"));
        }
        FieldVisitor visitor2 = this.getVisitor().visitField(access, name2, desc, signature2, value);
        if (visitor2 == null) {
            FieldVisitor fieldVisitor = EMPTY_FIELD_VISITOR;
            if (fieldVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AbstractClassBuilder", "newField"));
            }
            return fieldVisitor;
        }
        FieldVisitor fieldVisitor = visitor2;
        if (fieldVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AbstractClassBuilder", "newField"));
        }
        return fieldVisitor;
    }

    @Override
    @NotNull
    public MethodVisitor newMethod(@NotNull JvmDeclarationOrigin origin, int access, @NotNull String name2, @NotNull String desc, @Nullable String signature2, @Nullable String[] exceptions) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/AbstractClassBuilder", "newMethod"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/AbstractClassBuilder", "newMethod"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/AbstractClassBuilder", "newMethod"));
        }
        MethodVisitor visitor2 = this.getVisitor().visitMethod(access, name2, desc, signature2, exceptions);
        if (visitor2 == null) {
            MethodVisitor methodVisitor = EMPTY_METHOD_VISITOR;
            if (methodVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AbstractClassBuilder", "newMethod"));
            }
            return methodVisitor;
        }
        MethodVisitor methodVisitor = visitor2;
        if (methodVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AbstractClassBuilder", "newMethod"));
        }
        return methodVisitor;
    }

    @Override
    @NotNull
    public JvmSerializationBindings getSerializationBindings() {
        JvmSerializationBindings jvmSerializationBindings = this.serializationBindings;
        if (jvmSerializationBindings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AbstractClassBuilder", "getSerializationBindings"));
        }
        return jvmSerializationBindings;
    }

    @Override
    @NotNull
    public AnnotationVisitor newAnnotation(@NotNull String desc, boolean visible) {
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/AbstractClassBuilder", "newAnnotation"));
        }
        AnnotationVisitor annotationVisitor = this.getVisitor().visitAnnotation(desc, visible);
        if (annotationVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AbstractClassBuilder", "newAnnotation"));
        }
        return annotationVisitor;
    }

    @Override
    public void done() {
        if (!this.fileMappings.isEmpty()) {
            FileMapping origin = this.fileMappings.get(0);
            assert (this.sourceName == null || origin.getName().equals(this.sourceName)) : "Error " + origin.getName() + " != " + this.sourceName;
            this.getVisitor().visitSource(origin.getName(), new SMAPBuilder(origin.getName(), origin.getPath(), this.fileMappings).build());
        } else {
            this.getVisitor().visitSource(this.sourceName, this.debugInfo);
        }
        this.getVisitor().visitEnd();
    }

    @Override
    public void defineClass(@Nullable PsiElement origin, int version, int access, @NotNull String name2, @Nullable String signature2, @NotNull String superName, @NotNull String[] interfaces) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/AbstractClassBuilder", "defineClass"));
        }
        if (superName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superName", "org/jetbrains/kotlin/codegen/AbstractClassBuilder", "defineClass"));
        }
        if (interfaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaces", "org/jetbrains/kotlin/codegen/AbstractClassBuilder", "defineClass"));
        }
        this.thisName = name2;
        this.getVisitor().visit(version, access, name2, signature2, superName, interfaces);
    }

    @Override
    public void visitSource(@NotNull String name2, @Nullable String debug) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/AbstractClassBuilder", "visitSource"));
        }
        this.sourceName = name2;
        this.debugInfo = debug;
    }

    @Override
    public void visitOuterClass(@NotNull String owner, @Nullable String name2, @Nullable String desc) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/AbstractClassBuilder", "visitOuterClass"));
        }
        this.getVisitor().visitOuterClass(owner, name2, desc);
    }

    @Override
    public void visitInnerClass(@NotNull String name2, @Nullable String outerName, @Nullable String innerName2, int access) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/AbstractClassBuilder", "visitInnerClass"));
        }
        this.getVisitor().visitInnerClass(name2, outerName, innerName2, access);
    }

    @Override
    @NotNull
    public String getThisName() {
        assert (this.thisName != null) : "This name isn't set";
        String string = this.thisName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AbstractClassBuilder", "getThisName"));
        }
        return string;
    }

    @Override
    public void addSMAP(FileMapping mapping2) {
        this.fileMappings.add(mapping2);
    }

    public static class Concrete
    extends AbstractClassBuilder {
        private final ClassVisitor v;

        public Concrete(@NotNull ClassVisitor v) {
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/AbstractClassBuilder$Concrete", "<init>"));
            }
            this.v = v;
        }

        @Override
        @NotNull
        public ClassVisitor getVisitor() {
            ClassVisitor classVisitor2 = this.v;
            if (classVisitor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AbstractClassBuilder$Concrete", "getVisitor"));
            }
            return classVisitor2;
        }
    }
}

