/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.impl.IrTypeAliasImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrVariableImpl;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrContainerExpressionBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetEnumValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrStringConcatenationImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrThrowImpl;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.ArgumentsGenerationUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.BodyGenerator;
import org.jetbrains.kotlin.psi2ir.generators.BranchingExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.CallGenerator;
import org.jetbrains.kotlin.psi2ir.generators.CallGeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.DelegatedPropertyGenerator;
import org.jetbrains.kotlin.psi2ir.generators.ErrorExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorWithScope;
import org.jetbrains.kotlin.psi2ir.generators.LocalClassGenerator;
import org.jetbrains.kotlin.psi2ir.generators.LocalFunctionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.LoopExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.OperatorExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.ReflectionReferencesGenerator;
import org.jetbrains.kotlin.psi2ir.generators.TryCatchExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilder;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilderKt;
import org.jetbrains.kotlin.psi2ir.intermediate.IntermediateValue;
import org.jetbrains.kotlin.psi2ir.intermediate.RematerializableValueKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u00e6\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00012\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#J\u000e\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020!J&\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!2\f\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010)H\u0002J \u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u000e\u00101\u001a\u00020\u00022\u0006\u00102\u001a\u000203J\u0010\u00104\u001a\u0002052\u0006\u0010 \u001a\u000206H\u0002J\b\u00107\u001a\u000205H\u0002J\u001a\u00108\u001a\u00020\u00022\u0006\u0010 \u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010;\u001a\u00020\u00022\u0006\u0010 \u001a\u00020<2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010=\u001a\u00020\u00022\u0006\u0010 \u001a\u00020>2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010?\u001a\u00020\u00022\u0006\u0010 \u001a\u00020@2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010A\u001a\u00020\u00022\u0006\u0010 \u001a\u00020B2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010C\u001a\u00020\u00022\u0006\u0010 \u001a\u00020D2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010E\u001a\u00020\u00022\u0006\u0010 \u001a\u00020F2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010G\u001a\u00020\u00022\u0006\u0010 \u001a\u00020H2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010I\u001a\u00020\u00022\u0006\u0010J\u001a\u00020K2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010L\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020M2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010N\u001a\u00020\u00022\u0006\u0010 \u001a\u00020O2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010P\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010Q\u001a\u00020\u00022\u0006\u0010 \u001a\u00020R2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010S\u001a\u00020\u00022\u0006\u0010 \u001a\u00020T2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010U\u001a\u00020\u00022\u0006\u0010V\u001a\u00020W2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010X\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010Y\u001a\u00020\u00022\u0006\u0010 \u001a\u00020Z2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010[\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\\2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010]\u001a\u00020\u00022\u0006\u0010 \u001a\u00020^2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010_\u001a\u00020\u00022\u0006\u0010 \u001a\u00020`2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010a\u001a\u00020\u00022\u0006\u0010V\u001a\u00020b2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010c\u001a\u00020\u00022\u0006\u0010d\u001a\u00020e2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020g2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010h\u001a\u00020\u00022\u0006\u0010 \u001a\u00020i2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010j\u001a\u00020\u00022\u0006\u0010 \u001a\u00020k2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010l\u001a\u00020\u00022\u0006\u0010m\u001a\u00020,2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010n\u001a\u00020\u00022\u0006\u0010 \u001a\u0002062\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010o\u001a\u00020\u00022\u0006\u0010 \u001a\u00020p2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010q\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020r2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010s\u001a\u00020\u00022\u0006\u0010V\u001a\u00020t2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010u\u001a\u00020\u00022\u0006\u0010 \u001a\u00020v2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010w\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020x2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010y\u001a\u00020\u00022\u0006\u0010 \u001a\u00020z2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010{\u001a\u00020\u00022\u0006\u0010 \u001a\u00020|2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010}\u001a\u00020\u00022\u0006\u0010~\u001a\u00020\u007f2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0080\u0001\u001a\u00020\u00022\u0007\u0010 \u001a\u00030\u0081\u00012\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0082\u0001\u001a\u00020\u00022\u0007\u0010 \u001a\u00030\u0083\u00012\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0016J\r\u0010\u0084\u0001\u001a\u00020\u001f*\u000203H\u0002J\r\u0010\u0085\u0001\u001a\u00020\u0002*\u000203H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0086\u0001"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/ir/IrStatement;", "", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorWithScope;", "bodyGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/BodyGenerator;", "scope", "Lorg/jetbrains/kotlin/ir/builders/Scope;", "(Lorg/jetbrains/kotlin/psi2ir/generators/BodyGenerator;Lorg/jetbrains/kotlin/ir/builders/Scope;)V", "getBodyGenerator", "()Lorg/jetbrains/kotlin/psi2ir/generators/BodyGenerator;", "context", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "getContext", "()Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "getScope", "()Lorg/jetbrains/kotlin/ir/builders/Scope;", "scopeOwner", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getScopeOwner", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "declareComponentVariablesInBlock", "", "multiDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "irBlock", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrContainerExpressionBase;", "containerValue", "Lorg/jetbrains/kotlin/psi2ir/intermediate/IntermediateValue;", "generateConstantExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "constant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "generateExpression", "ktExpression", "generateExpressionForReferencedDescriptor", "descriptor", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "generateLocalDelegatedProperty", "ktProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "ktDelegate", "Lorg/jetbrains/kotlin/psi/KtPropertyDelegate;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "generateStatement", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "getReturnExpressionTarget", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "scopeOwnerAsCallable", "visitArrayAccessExpression", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "data", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "visitBlockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "visitBreakExpression", "Lorg/jetbrains/kotlin/psi/KtBreakExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitCallableReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "visitClassLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "visitClassOrObject", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "visitContinueExpression", "Lorg/jetbrains/kotlin/psi/KtContinueExpression;", "visitDestructuringDeclaration", "visitDoWhileExpression", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "visitDotQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "visitEscapeStringTemplateEntry", "entry", "Lorg/jetbrains/kotlin/psi/KtEscapeStringTemplateEntry;", "visitExpression", "visitForExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "visitLambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitLiteralStringTemplateEntry", "Lorg/jetbrains/kotlin/psi/KtLiteralStringTemplateEntry;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitObjectLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "visitPostfixExpression", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "visitPrefixExpression", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "visitProperty", "property", "visitReturnExpression", "visitSafeQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtSafeQualifiedExpression;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitStringTemplateEntryWithExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntryWithExpression;", "visitStringTemplateExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "visitThisExpression", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "visitThrowExpression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "visitTryExpression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "visitWhileExpression", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "genExpr", "genStmt", "kotlin-compiler"})
public final class StatementGenerator
extends KtVisitor
implements GeneratorWithScope {
    @NotNull
    private final BodyGenerator bodyGenerator;
    @NotNull
    private final Scope scope;

    @Override
    @NotNull
    public GeneratorContext getContext() {
        return this.bodyGenerator.getContext();
    }

    @NotNull
    public final DeclarationDescriptor getScopeOwner() {
        return this.bodyGenerator.getScopeOwner();
    }

    @NotNull
    public final IrStatement generateStatement(@NotNull KtElement ktElement) {
        Intrinsics.checkParameterIsNotNull(ktElement, "ktElement");
        return this.genStmt(ktElement);
    }

    @NotNull
    public final IrExpression generateExpression(@NotNull KtExpression ktExpression) {
        Intrinsics.checkParameterIsNotNull(ktExpression, "ktExpression");
        return this.genExpr(ktExpression);
    }

    private final IrStatement genStmt(@NotNull KtElement $receiver) {
        IrStatement irStatement;
        try {
            irStatement = (IrStatement)KotlinUtilsKt.deparenthesize($receiver).accept(this, null);
        }
        catch (Exception e) {
            irStatement = new ErrorExpressionGenerator(this).generateErrorExpression($receiver, e);
        }
        return irStatement;
    }

    private final IrExpression genExpr(@NotNull KtElement $receiver) {
        IrElement $receiver$iv = this.genStmt($receiver);
        if (!($receiver$iv instanceof IrExpression)) {
            throw (Throwable)((Object)new AssertionError((Object)("Expected " + Reflection.getOrCreateKotlinClass(IrExpression.class).getSimpleName() + ": " + $receiver$iv)));
        }
        return (IrExpression)$receiver$iv;
    }

    @NotNull
    public IrStatement visitExpression(@NotNull KtExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        String string = expression.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull(string, "expression.javaClass.simpleName");
        return GeneratorKt.createDummyExpression(this, expression, string);
    }

    @NotNull
    public IrStatement visitProperty(@NotNull KtProperty property, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(property, "property");
        WritableSlice<PsiElement, VariableDescriptor> writableSlice = BindingContext.VARIABLE;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.VARIABLE");
        VariableDescriptor variableDescriptor = (VariableDescriptor)GeneratorKt.getOrFail(this, writableSlice, property);
        KtPropertyDelegate ktPropertyDelegate = property.getDelegate();
        if (ktPropertyDelegate != null) {
            KtPropertyDelegate ktPropertyDelegate2;
            KtPropertyDelegate ktDelegate;
            KtPropertyDelegate ktPropertyDelegate3 = ktDelegate = (ktPropertyDelegate2 = ktPropertyDelegate);
            Intrinsics.checkExpressionValueIsNotNull(ktPropertyDelegate3, "ktDelegate");
            VariableDescriptor variableDescriptor2 = variableDescriptor;
            if (variableDescriptor2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors");
            }
            return this.generateLocalDelegatedProperty(property, ktPropertyDelegate3, (VariableDescriptorWithAccessors)variableDescriptor2);
        }
        int n = PsiUtilsKt.getStartOffset(property);
        int n2 = PsiUtilsKt.getEndOffset(property);
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
        VariableDescriptor variableDescriptor3 = variableDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(variableDescriptor3, "variableDescriptor");
        IrVariableImpl irLocalVariable = new IrVariableImpl(n, n2, irDeclarationOrigin, variableDescriptor3);
        KtExpression ktExpression = property.getInitializer();
        irLocalVariable.setInitializer(ktExpression != null ? this.genExpr(ktExpression) : null);
        return irLocalVariable;
    }

    private final IrStatement generateLocalDelegatedProperty(KtProperty ktProperty, KtPropertyDelegate ktDelegate, VariableDescriptorWithAccessors variableDescriptor) {
        DelegatedPropertyGenerator delegatedPropertyGenerator = new DelegatedPropertyGenerator(this.getContext());
        KtExpression ktExpression = ktDelegate.getExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        return delegatedPropertyGenerator.generateLocalDelegatedProperty(ktProperty, ktDelegate, variableDescriptor, this.genExpr(ktExpression));
    }

    @NotNull
    public IrStatement visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(multiDeclaration, "multiDeclaration");
        int n = PsiUtilsKt.getStartOffset(multiDeclaration);
        int n2 = PsiUtilsKt.getEndOffset(multiDeclaration);
        SimpleType simpleType2 = this.getContext().getBuiltIns().getUnitType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "context.builtIns.unitType");
        IrCompositeImpl irBlock = new IrCompositeImpl(n, n2, simpleType2, IrStatementOrigin.DESTRUCTURING_DECLARATION.INSTANCE);
        KtExpression ktExpression = multiDeclaration.getInitializer();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression ktInitializer = ktExpression;
        IntermediateValue containerValue = RematerializableValueKt.createTemporaryVariableInBlock(this.getScope(), this.genExpr(ktInitializer), irBlock, "container");
        this.declareComponentVariablesInBlock(multiDeclaration, irBlock, containerValue);
        return irBlock;
    }

    public final void declareComponentVariablesInBlock(@NotNull KtDestructuringDeclaration multiDeclaration, @NotNull IrContainerExpressionBase irBlock, @NotNull IntermediateValue containerValue) {
        Intrinsics.checkParameterIsNotNull(multiDeclaration, "multiDeclaration");
        Intrinsics.checkParameterIsNotNull(irBlock, "irBlock");
        Intrinsics.checkParameterIsNotNull(containerValue, "containerValue");
        CallGenerator callGenerator = new CallGenerator(this);
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)multiDeclaration.getEntries())) {
            ResolvedCall componentResolvedCall;
            int index2 = indexedValue.component1();
            KtDestructuringDeclarationEntry ktEntry = (KtDestructuringDeclarationEntry)indexedValue.component2();
            WritableSlice<KtDestructuringDeclarationEntry, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.COMPONENT_RESOLVED_CALL;
            Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.COMPONENT_RESOLVED_CALL");
            ResolvedCall resolvedCall2 = componentResolvedCall = (ResolvedCall)GeneratorKt.getOrFail(this, writableSlice, ktEntry);
            Intrinsics.checkExpressionValueIsNotNull(resolvedCall2, "componentResolvedCall");
            CallBuilder componentSubstitutedCall = ArgumentsGenerationUtilsKt.pregenerateCall(this, resolvedCall2);
            CallBuilderKt.setExplicitReceiverValue(componentSubstitutedCall, containerValue);
            WritableSlice<PsiElement, VariableDescriptor> writableSlice2 = BindingContext.VARIABLE;
            Intrinsics.checkExpressionValueIsNotNull(writableSlice2, "BindingContext.VARIABLE");
            VariableDescriptor componentVariable = (VariableDescriptor)GeneratorKt.getOrFail(this, writableSlice2, ktEntry);
            IrExpression irComponentCall = callGenerator.generateCall(PsiUtilsKt.getStartOffset(ktEntry), PsiUtilsKt.getEndOffset(ktEntry), componentSubstitutedCall, IrStatementOrigin.COMPONENT_N.Companion.withIndex(index2 + 1));
            int n = PsiUtilsKt.getStartOffset(ktEntry);
            int n2 = PsiUtilsKt.getEndOffset(ktEntry);
            IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
            VariableDescriptor variableDescriptor = componentVariable;
            Intrinsics.checkExpressionValueIsNotNull(variableDescriptor, "componentVariable");
            IrVariableImpl irComponentVar = new IrVariableImpl(n, n2, irDeclarationOrigin, variableDescriptor, irComponentCall);
            irBlock.getStatements().add(irComponentVar);
        }
    }

    @NotNull
    public IrStatement visitBlockExpression(@NotNull KtBlockExpression expression, @Nullable Void data2) {
        boolean isBlockBody;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        boolean bl = isBlockBody = expression.getParent() instanceof KtDeclarationWithBody && !(expression.getParent() instanceof KtFunctionLiteral);
        if (isBlockBody) {
            throw (Throwable)((Object)new AssertionError((Object)"Use IrBlockBody and corresponding body generator to generate blocks as function bodies"));
        }
        KotlinType kotlinType = GeneratorKt.getInferredTypeWithImplicitCasts(this, expression);
        if (kotlinType == null) {
            SimpleType simpleType2 = this.getContext().getBuiltIns().getUnitType();
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "context.builtIns.unitType");
            kotlinType = simpleType2;
        }
        KotlinType returnType = kotlinType;
        IrBlockImpl irBlock = new IrBlockImpl(PsiUtilsKt.getStartOffset(expression), PsiUtilsKt.getEndOffset(expression), returnType, null, 8, null);
        Iterable $receiver$iv = expression.getStatements();
        for (Object element$iv : $receiver$iv) {
            KtExpression it = (KtExpression)element$iv;
            irBlock.getStatements().add(this.genStmt(it));
        }
        return irBlock;
    }

    @NotNull
    public IrStatement visitReturnExpression(@NotNull KtReturnExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        CallableDescriptor returnTarget = this.getReturnExpressionTarget(expression);
        Object object = expression.getReturnedExpression();
        if (object == null || (object = this.genExpr((KtElement)object)) == null) {
            int n = PsiUtilsKt.getStartOffset(expression);
            int n2 = PsiUtilsKt.getEndOffset(expression);
            SimpleType simpleType2 = this.getContext().getBuiltIns().getUnitType();
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "context.builtIns.unitType");
            KotlinType kotlinType = simpleType2;
            ClassDescriptor classDescriptor = this.getContext().getBuiltIns().getUnit();
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "context.builtIns.unit");
            object = new IrGetObjectValueImpl(n, n2, kotlinType, classDescriptor);
        }
        Object irReturnedExpression = object;
        int n = PsiUtilsKt.getStartOffset(expression);
        int n3 = PsiUtilsKt.getEndOffset(expression);
        SimpleType simpleType3 = this.getContext().getBuiltIns().getNothingType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType3, "context.builtIns.nothingType");
        return new IrReturnImpl(n, n3, simpleType3, returnTarget, (IrExpression)irReturnedExpression);
    }

    private final CallableDescriptor scopeOwnerAsCallable() {
        DeclarationDescriptor declarationDescriptor = this.getScopeOwner();
        if (!(declarationDescriptor instanceof CallableDescriptor)) {
            declarationDescriptor = null;
        }
        CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptor;
        if (callableDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("'return' in a non-callable: " + this.getScopeOwner())));
        }
        return callableDescriptor;
    }

    private final CallableDescriptor getReturnExpressionTarget(KtReturnExpression expression) {
        CallableDescriptor callableDescriptor;
        if (!ExpressionTypingUtils.isFunctionLiteral(this.getScopeOwner()) && !ExpressionTypingUtils.isFunctionExpression(this.getScopeOwner())) {
            callableDescriptor = this.scopeOwnerAsCallable();
        } else {
            CallableDescriptor callableDescriptor2;
            KtSimpleNameExpression label = expression.getTargetLabel();
            if (label != null) {
                DeclarationDescriptor labelTargetDescriptor;
                WritableSlice<KtReferenceExpression, PsiElement> writableSlice = BindingContext.LABEL_TARGET;
                Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.LABEL_TARGET");
                PsiElement labelTarget = (PsiElement)GeneratorKt.getOrFail(this, writableSlice, label);
                ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice = BindingContext.DECLARATION_TO_DESCRIPTOR;
                Intrinsics.checkExpressionValueIsNotNull(readOnlySlice, "BindingContext.DECLARATION_TO_DESCRIPTOR");
                DeclarationDescriptor declarationDescriptor = labelTargetDescriptor = GeneratorKt.getOrFail(this, readOnlySlice, labelTarget);
                if (declarationDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableDescriptor");
                }
                callableDescriptor2 = (CallableDescriptor)declarationDescriptor;
            } else {
                callableDescriptor2 = ExpressionTypingUtils.isFunctionLiteral(this.getScopeOwner()) ? (CallableDescriptor)BindingContextUtils.getContainingFunctionSkipFunctionLiterals((DeclarationDescriptor)this.getScopeOwner(), (boolean)true).first : this.scopeOwnerAsCallable();
            }
            callableDescriptor = callableDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull(callableDescriptor2, "if (label != null) {\n   \u2026lable()\n                }");
        }
        return callableDescriptor;
    }

    @NotNull
    public IrStatement visitThrowExpression(@NotNull KtThrowExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        int n = PsiUtilsKt.getStartOffset(expression);
        int n2 = PsiUtilsKt.getEndOffset(expression);
        SimpleType simpleType2 = this.getContext().getBuiltIns().getNothingType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "context.builtIns.nothingType");
        KotlinType kotlinType = simpleType2;
        KtExpression ktExpression = expression.getThrownExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        return new IrThrowImpl(n, n2, kotlinType, this.genExpr(ktExpression));
    }

    @NotNull
    public IrExpression visitConstantExpression(@NotNull KtConstantExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        StatementGenerator statementGenerator = this;
        KtExpression ktExpression = expression;
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression, this.getContext().getBindingContext());
        if (compileTimeConstant == null) {
            String string = "KtConstantExpression was not evaluated: " + expression.getText();
            KtExpression ktExpression2 = ktExpression;
            StatementGenerator statementGenerator2 = statementGenerator;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return statementGenerator.generateConstantExpression(ktExpression, compileTimeConstant);
    }

    @NotNull
    public final IrExpression generateConstantExpression(@NotNull KtExpression expression, @NotNull CompileTimeConstant<?> constant) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(constant, "constant");
        ConstantValue<?> constantValue = constant.toConstantValue(GeneratorKt.getInferredTypeWithImplicitCastsOrFail(this, expression));
        KotlinType constantType = constantValue.getType();
        ConstantValue<?> constantValue2 = constantValue;
        if (constantValue2 instanceof StringValue) {
            irExpression = IrConstImpl.Companion.string(PsiUtilsKt.getStartOffset(expression), PsiUtilsKt.getEndOffset(expression), constantType, (String)((StringValue)constantValue).getValue());
        } else if (constantValue2 instanceof IntValue) {
            irExpression = IrConstImpl.Companion.int(PsiUtilsKt.getStartOffset(expression), PsiUtilsKt.getEndOffset(expression), constantType, ((Number)((IntValue)constantValue).getValue()).intValue());
        } else if (constantValue2 instanceof NullValue) {
            irExpression = IrConstImpl.Companion.constNull(PsiUtilsKt.getStartOffset(expression), PsiUtilsKt.getEndOffset(expression), constantType);
        } else if (constantValue2 instanceof BooleanValue) {
            irExpression = IrConstImpl.Companion.boolean(PsiUtilsKt.getStartOffset(expression), PsiUtilsKt.getEndOffset(expression), constantType, (Boolean)((BooleanValue)constantValue).getValue());
        } else if (constantValue2 instanceof LongValue) {
            irExpression = IrConstImpl.Companion.long(PsiUtilsKt.getStartOffset(expression), PsiUtilsKt.getEndOffset(expression), constantType, ((Number)((LongValue)constantValue).getValue()).longValue());
        } else if (constantValue2 instanceof DoubleValue) {
            irExpression = IrConstImpl.Companion.double(PsiUtilsKt.getStartOffset(expression), PsiUtilsKt.getEndOffset(expression), constantType, ((Number)((DoubleValue)constantValue).getValue()).doubleValue());
        } else if (constantValue2 instanceof FloatValue) {
            irExpression = IrConstImpl.Companion.float(PsiUtilsKt.getStartOffset(expression), PsiUtilsKt.getEndOffset(expression), constantType, ((Number)((FloatValue)constantValue).getValue()).floatValue());
        } else if (constantValue2 instanceof CharValue) {
            irExpression = IrConstImpl.Companion.char(PsiUtilsKt.getStartOffset(expression), PsiUtilsKt.getEndOffset(expression), constantType, ((Character)((CharValue)constantValue).getValue()).charValue());
        } else if (constantValue2 instanceof ByteValue) {
            irExpression = IrConstImpl.Companion.byte(PsiUtilsKt.getStartOffset(expression), PsiUtilsKt.getEndOffset(expression), constantType, ((Number)((ByteValue)constantValue).getValue()).byteValue());
        } else if (constantValue2 instanceof ShortValue) {
            irExpression = IrConstImpl.Companion.short(PsiUtilsKt.getStartOffset(expression), PsiUtilsKt.getEndOffset(expression), constantType, ((Number)((ShortValue)constantValue).getValue()).shortValue());
        } else {
            String string = "handle other literal types: " + constantValue.getType();
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IrStatement visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression, @Nullable Void data2) {
        IrStatement irStatement;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtStringTemplateEntry[] entries = expression.getEntries();
        KotlinType resultType = GeneratorKt.getInferredTypeWithImplicitCastsOrFail(this, expression);
        switch (((Object[])entries).length) {
            case 1: {
                IrExpression irArg = this.genExpr(entries[0]);
                irStatement = irArg instanceof IrConst && Intrinsics.areEqual(((IrConst)irArg).getKind(), IrConstKind.String.INSTANCE) ? irArg : (IrExpression)new IrStringConcatenationImpl(PsiUtilsKt.getStartOffset(expression), PsiUtilsKt.getEndOffset(expression), resultType, (Collection<? extends IrExpression>)CollectionsKt.listOf(irArg));
                break;
            }
            case 0: {
                irStatement = IrConstImpl.Companion.string(PsiUtilsKt.getStartOffset(expression), PsiUtilsKt.getEndOffset(expression), resultType, "");
                break;
            }
            default: {
                Collection<IrExpression> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                IrStringConcatenationImpl irStringConcatenationImpl;
                Object[] irArg = entries;
                KotlinType kotlinType = resultType;
                int n = PsiUtilsKt.getEndOffset(expression);
                int n2 = PsiUtilsKt.getStartOffset(expression);
                IrStringConcatenationImpl irStringConcatenationImpl2 = irStringConcatenationImpl;
                IrStringConcatenationImpl irStringConcatenationImpl3 = irStringConcatenationImpl;
                void var6_12 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
                for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                    void it;
                    void item$iv$iv = $receiver$iv$iv[i];
                    KtStringTemplateEntry ktStringTemplateEntry = (KtStringTemplateEntry)item$iv$iv;
                    collection = destination$iv$iv;
                    IrExpression irExpression = this.genExpr((KtElement)it);
                    collection.add(irExpression);
                }
                collection = (List)destination$iv$iv;
                irStringConcatenationImpl2(n2, n, kotlinType, (Collection<? extends IrExpression>)collection);
                irStatement = irStringConcatenationImpl3;
            }
        }
        return irStatement;
    }

    @NotNull
    public IrStatement visitLiteralStringTemplateEntry(@NotNull KtLiteralStringTemplateEntry entry, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(entry, "entry");
        int n = PsiUtilsKt.getStartOffset(entry);
        int n2 = PsiUtilsKt.getEndOffset(entry);
        SimpleType simpleType2 = this.getContext().getBuiltIns().getStringType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "context.builtIns.stringType");
        KotlinType kotlinType = simpleType2;
        String string = entry.getText();
        Intrinsics.checkExpressionValueIsNotNull(string, "entry.text");
        return IrConstImpl.Companion.string(n, n2, kotlinType, string);
    }

    @NotNull
    public IrStatement visitEscapeStringTemplateEntry(@NotNull KtEscapeStringTemplateEntry entry, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(entry, "entry");
        int n = PsiUtilsKt.getStartOffset(entry);
        int n2 = PsiUtilsKt.getEndOffset(entry);
        SimpleType simpleType2 = this.getContext().getBuiltIns().getStringType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "context.builtIns.stringType");
        KotlinType kotlinType = simpleType2;
        String string = entry.getUnescapedValue();
        Intrinsics.checkExpressionValueIsNotNull(string, "entry.unescapedValue");
        return IrConstImpl.Companion.string(n, n2, kotlinType, string);
    }

    @NotNull
    public IrStatement visitStringTemplateEntryWithExpression(@NotNull KtStringTemplateEntryWithExpression entry, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(entry, "entry");
        KtExpression ktExpression = entry.getExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        return this.genExpr(ktExpression);
    }

    @NotNull
    public IrExpression visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression);
        if (resolvedCall2 != null) {
            if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                CallBuilder variableCall = ArgumentsGenerationUtilsKt.pregenerateCall(this, ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall());
                return CallGeneratorKt.generateCall(new CallGenerator(this), expression, variableCall, (IrStatementOrigin)IrStatementOrigin.VARIABLE_AS_FUNCTION.INSTANCE);
            }
            CallableDescriptor descriptor2 = resolvedCall2.getResultingDescriptor();
            return this.generateExpressionForReferencedDescriptor(descriptor2, expression, resolvedCall2);
        }
        WritableSlice<KtReferenceExpression, DeclarationDescriptor> writableSlice = BindingContext.REFERENCE_TARGET;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.REFERENCE_TARGET");
        DeclarationDescriptor referenceTarget = (DeclarationDescriptor)GeneratorKt.get(this, writableSlice, expression);
        if (referenceTarget != null) {
            return this.generateExpressionForReferencedDescriptor(referenceTarget, expression, null);
        }
        return new ErrorExpressionGenerator(this).generateErrorSimpleName(expression);
    }

    private final IrExpression generateExpressionForReferencedDescriptor(DeclarationDescriptor descriptor2, KtExpression expression, ResolvedCall<?> resolvedCall2) {
        IrExpression irExpression;
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof FakeCallableDescriptorForObject) {
            irExpression = this.generateExpressionForReferencedDescriptor(((FakeCallableDescriptorForObject)descriptor2).getReferencedDescriptor(), expression, resolvedCall2);
        } else if (declarationDescriptor instanceof TypeAliasDescriptor) {
            ClassDescriptor classDescriptor = ((TypeAliasDescriptor)descriptor2).getClassDescriptor();
            if (classDescriptor == null) {
                Intrinsics.throwNpe();
            }
            irExpression = this.generateExpressionForReferencedDescriptor(classDescriptor, expression, null);
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            IrDeclarationReference irDeclarationReference;
            KotlinType kotlinType = DescriptorUtilsKt.getClassValueType((ClassDescriptor)descriptor2);
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            KotlinType classValueType = kotlinType;
            if (DescriptorUtils.isObject(descriptor2)) {
                irDeclarationReference = new IrGetObjectValueImpl(PsiUtilsKt.getStartOffset(expression), PsiUtilsKt.getEndOffset(expression), classValueType, (ClassDescriptor)descriptor2);
            } else if (DescriptorUtils.isEnumEntry(descriptor2)) {
                irDeclarationReference = new IrGetEnumValueImpl(PsiUtilsKt.getStartOffset(expression), PsiUtilsKt.getEndOffset(expression), classValueType, (ClassDescriptor)descriptor2);
            } else {
                ClassDescriptor classDescriptor = ((ClassDescriptor)descriptor2).getCompanionObjectDescriptor();
                if (classDescriptor == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Class value without companion object: " + descriptor2)));
                }
                irDeclarationReference = new IrGetObjectValueImpl(PsiUtilsKt.getStartOffset(expression), PsiUtilsKt.getEndOffset(expression), classValueType, classDescriptor);
            }
            irExpression = irDeclarationReference;
        } else if (declarationDescriptor instanceof PropertyDescriptor) {
            CallGenerator callGenerator = new CallGenerator(this);
            int n = PsiUtilsKt.getStartOffset(expression);
            int n2 = PsiUtilsKt.getEndOffset(expression);
            ResolvedCall<?> resolvedCall3 = resolvedCall2;
            if (resolvedCall3 == null) {
                Intrinsics.throwNpe();
            }
            irExpression = CallGenerator.generateCall$default(callGenerator, n, n2, ArgumentsGenerationUtilsKt.pregenerateCall(this, resolvedCall3), null, 8, null);
        } else if (declarationDescriptor instanceof SyntheticFieldDescriptor) {
            IntermediateValue receiver = ArgumentsGenerationUtilsKt.generateBackingFieldReceiver(this, expression, resolvedCall2, (SyntheticFieldDescriptor)descriptor2);
            IntermediateValue intermediateValue = receiver;
            irExpression = new IrGetFieldImpl(PsiUtilsKt.getStartOffset(expression), PsiUtilsKt.getEndOffset(expression), ((SyntheticFieldDescriptor)descriptor2).getPropertyDescriptor(), intermediateValue != null ? intermediateValue.load() : null, null, null, 48, null);
        } else {
            irExpression = declarationDescriptor instanceof VariableDescriptor ? CallGenerator.generateGetVariable$default(new CallGenerator(this), PsiUtilsKt.getStartOffset(expression), PsiUtilsKt.getEndOffset(expression), (VariableDescriptor)descriptor2, ArgumentsGenerationUtilsKt.getTypeArguments(resolvedCall2), null, 16, null) : (IrExpression)new IrErrorExpressionImpl(PsiUtilsKt.getStartOffset(expression), PsiUtilsKt.getEndOffset(expression), GeneratorKt.getInferredTypeWithImplicitCastsOrFail(this, expression), expression.getText() + (": " + descriptor2.getName() + " " + descriptor2.getClass().getSimpleName()));
        }
        return irExpression;
    }

    @NotNull
    public IrStatement visitCallExpression(@NotNull KtCallExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression);
        if (resolvedCall2 == null) {
            return new ErrorExpressionGenerator(this).generateErrorCall(expression);
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (resolvedCall3 instanceof VariableAsFunctionResolvedCall) {
            CallBuilder functionCall2 = ArgumentsGenerationUtilsKt.pregenerateCall(this, ((VariableAsFunctionResolvedCall)((Object)resolvedCall3)).getFunctionCall());
            return CallGeneratorKt.generateCall(new CallGenerator(this), expression, functionCall2, (IrStatementOrigin)IrStatementOrigin.INVOKE.INSTANCE);
        }
        return CallGenerator.generateCall$default(new CallGenerator(this), PsiUtilsKt.getStartOffset(expression), PsiUtilsKt.getEndOffset(expression), ArgumentsGenerationUtilsKt.pregenerateCall(this, resolvedCall3), null, 8, null);
    }

    @NotNull
    public IrStatement visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.INDEXED_LVALUE_GET;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.INDEXED_LVALUE_GET");
        ResolvedCall indexedGetCall = (ResolvedCall)GeneratorKt.getOrFail(this, writableSlice, expression);
        CallGenerator callGenerator = new CallGenerator(this);
        int n = PsiUtilsKt.getStartOffset(expression);
        int n2 = PsiUtilsKt.getEndOffset(expression);
        ResolvedCall resolvedCall2 = indexedGetCall;
        Intrinsics.checkExpressionValueIsNotNull(resolvedCall2, "indexedGetCall");
        return callGenerator.generateCall(n, n2, ArgumentsGenerationUtilsKt.pregenerateCall(this, resolvedCall2), IrStatementOrigin.GET_ARRAY_ELEMENT.INSTANCE);
    }

    @NotNull
    public IrStatement visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtExpression ktExpression = expression.getSelectorExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Object r = ktExpression.accept(this, data2);
        Intrinsics.checkExpressionValueIsNotNull(r, "expression.selectorExpression!!.accept(this, data)");
        return (IrStatement)r;
    }

    @NotNull
    public IrStatement visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtExpression ktExpression = expression.getSelectorExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Object r = ktExpression.accept(this, data2);
        Intrinsics.checkExpressionValueIsNotNull(r, "expression.selectorExpression!!.accept(this, data)");
        return (IrStatement)r;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IrExpression visitThisExpression(@NotNull KtThisExpression expression, @Nullable Void data2) {
        IrExpression irExpression;
        void slice$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Object object = this;
        WritableSlice<KtReferenceExpression, DeclarationDescriptor> writableSlice = BindingContext.REFERENCE_TARGET;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.REFERENCE_TARGET");
        Object object2 = writableSlice;
        KtReferenceExpression key$iv = expression.getInstanceReference();
        Object v = $receiver$iv.getContext().getBindingContext().get(slice$iv, key$iv);
        if (v == null) {
            RuntimeException runtimeException;
            KtReferenceExpression ktReferenceExpression = key$iv;
            RuntimeException runtimeException2 = runtimeException;
            RuntimeException runtimeException3 = runtimeException;
            String string = "No reference target for this";
            runtimeException2(string);
            throw (Throwable)runtimeException3;
        }
        DeclarationDescriptor referenceTarget = (DeclarationDescriptor)v;
        object = referenceTarget;
        if (object instanceof ClassDescriptor) {
            int n = PsiUtilsKt.getStartOffset(expression);
            int n2 = PsiUtilsKt.getEndOffset(expression);
            ReceiverParameterDescriptor receiverParameterDescriptor = ((ClassDescriptor)referenceTarget).getThisAsReceiverParameter();
            Intrinsics.checkExpressionValueIsNotNull(receiverParameterDescriptor, "referenceTarget.thisAsReceiverParameter");
            irExpression = new IrGetValueImpl(n, n2, receiverParameterDescriptor, null, 8, null);
        } else if (object instanceof CallableDescriptor) {
            ReceiverParameterDescriptor receiverParameterDescriptor = ((CallableDescriptor)referenceTarget).getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                String string = "No extension receiver: " + referenceTarget;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
            ReceiverParameterDescriptor extensionReceiver = receiverParameterDescriptor;
            int n = PsiUtilsKt.getStartOffset(expression);
            int n3 = PsiUtilsKt.getEndOffset(expression);
            ReceiverParameterDescriptor receiverParameterDescriptor2 = extensionReceiver;
            Intrinsics.checkExpressionValueIsNotNull(receiverParameterDescriptor2, "extensionReceiver");
            irExpression = new IrGetValueImpl(n, n3, receiverParameterDescriptor2, null, 8, null);
        } else {
            object2 = "Expected this or receiver: " + referenceTarget;
            throw (Throwable)new IllegalStateException(object2.toString());
        }
        return irExpression;
    }

    @NotNull
    public IrStatement visitBinaryExpression(@NotNull KtBinaryExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        return new OperatorExpressionGenerator(this).generateBinaryExpression(expression);
    }

    @NotNull
    public IrStatement visitPrefixExpression(@NotNull KtPrefixExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        return new OperatorExpressionGenerator(this).generatePrefixExpression(expression);
    }

    @NotNull
    public IrStatement visitPostfixExpression(@NotNull KtPostfixExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        return new OperatorExpressionGenerator(this).generatePostfixExpression(expression);
    }

    @NotNull
    public IrStatement visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        return new OperatorExpressionGenerator(this).generateCastExpression(expression);
    }

    @NotNull
    public IrStatement visitIsExpression(@NotNull KtIsExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        return new OperatorExpressionGenerator(this).generateInstanceOfExpression(expression);
    }

    @NotNull
    public IrStatement visitIfExpression(@NotNull KtIfExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        return new BranchingExpressionGenerator(this).generateIfExpression(expression);
    }

    @NotNull
    public IrStatement visitWhenExpression(@NotNull KtWhenExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        return new BranchingExpressionGenerator(this).generateWhenExpression(expression);
    }

    @NotNull
    public IrStatement visitWhileExpression(@NotNull KtWhileExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        return new LoopExpressionGenerator(this).generateWhileLoop(expression);
    }

    @NotNull
    public IrStatement visitDoWhileExpression(@NotNull KtDoWhileExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        return new LoopExpressionGenerator(this).generateDoWhileLoop(expression);
    }

    @NotNull
    public IrStatement visitForExpression(@NotNull KtForExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        return new LoopExpressionGenerator(this).generateForLoop(expression);
    }

    @NotNull
    public IrStatement visitBreakExpression(@NotNull KtBreakExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        return new LoopExpressionGenerator(this).generateBreak(expression);
    }

    @NotNull
    public IrStatement visitContinueExpression(@NotNull KtContinueExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        return new LoopExpressionGenerator(this).generateContinue(expression);
    }

    @NotNull
    public IrStatement visitTryExpression(@NotNull KtTryExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        return new TryCatchExpressionGenerator(this).generateTryCatch(expression);
    }

    @NotNull
    public IrStatement visitLambdaExpression(@NotNull KtLambdaExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        return new LocalFunctionGenerator(this).generateLambda(expression);
    }

    @NotNull
    public IrStatement visitNamedFunction(@NotNull KtNamedFunction function2, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(function2, "function");
        return new LocalFunctionGenerator(this).generateFunction(function2);
    }

    @NotNull
    public IrStatement visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        return new LocalClassGenerator(this).generateObjectLiteral(expression);
    }

    @NotNull
    public IrStatement visitClassOrObject(@NotNull KtClassOrObject classOrObject, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(classOrObject, "classOrObject");
        return new LocalClassGenerator(this).generateLocalClass(classOrObject);
    }

    @NotNull
    public IrStatement visitTypeAlias(@NotNull KtTypeAlias typeAlias, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(typeAlias, "typeAlias");
        int n = PsiUtilsKt.getStartOffset(typeAlias);
        int n2 = PsiUtilsKt.getEndOffset(typeAlias);
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
        WritableSlice<PsiElement, TypeAliasDescriptor> writableSlice = BindingContext.TYPE_ALIAS;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.TYPE_ALIAS");
        Object v = GeneratorKt.getOrFail(this, writableSlice, typeAlias);
        Intrinsics.checkExpressionValueIsNotNull(v, "getOrFail(BindingContext.TYPE_ALIAS, typeAlias)");
        return new IrTypeAliasImpl(n, n2, irDeclarationOrigin, (TypeAliasDescriptor)v);
    }

    @NotNull
    public IrStatement visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        return new ReflectionReferencesGenerator(this).generateClassLiteral(expression);
    }

    @NotNull
    public IrStatement visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        return new ReflectionReferencesGenerator(this).generateCallableReference(expression);
    }

    @NotNull
    public final BodyGenerator getBodyGenerator() {
        return this.bodyGenerator;
    }

    @Override
    @NotNull
    public Scope getScope() {
        return this.scope;
    }

    public StatementGenerator(@NotNull BodyGenerator bodyGenerator, @NotNull Scope scope) {
        Intrinsics.checkParameterIsNotNull(bodyGenerator, "bodyGenerator");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        this.bodyGenerator = bodyGenerator;
        this.scope = scope;
    }
}

