/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtEnumEntry
extends KtClass {
    public KtEnumEntry(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtEnumEntry", "<init>"));
        }
        super(node);
    }

    public KtEnumEntry(@NotNull KotlinClassStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/KtEnumEntry", "<init>"));
        }
        super(stub);
    }

    @Override
    @NotNull
    public List<KtSuperTypeListEntry> getSuperTypeListEntries() {
        KtInitializerList initializerList = this.getInitializerList();
        if (initializerList == null) {
            List<KtSuperTypeListEntry> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtEnumEntry", "getSuperTypeListEntries"));
            }
            return list2;
        }
        List<KtSuperTypeListEntry> list3 = initializerList.getInitializers();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtEnumEntry", "getSuperTypeListEntries"));
        }
        return list3;
    }

    public boolean hasInitializer() {
        return !this.getSuperTypeListEntries().isEmpty();
    }

    @Nullable
    public KtInitializerList getInitializerList() {
        return (KtInitializerList)this.getStubOrPsiChild(KtStubElementTypes.INITIALIZER_LIST);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtEnumEntry", "accept"));
        }
        return visitor2.visitEnumEntry(this, data2);
    }

    @Override
    public boolean isEquivalentTo(@Nullable PsiElement another) {
        String theirFQName;
        String containingClassQName;
        PsiEnumConstant enumConstant;
        PsiClass containingClass;
        if (another instanceof PsiEnumConstant && (containingClass = (enumConstant = (PsiEnumConstant)another).getContainingClass()) != null && (containingClassQName = containingClass.getQualifiedName()) != null && enumConstant.getName() != null && (theirFQName = containingClassQName + "." + enumConstant.getName()).equals(this.getQualifiedName())) {
            return true;
        }
        return super.isEquivalentTo(another);
    }
}

