/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtArrayAccessExpression
extends KtExpressionImpl
implements KtReferenceExpression {
    public KtArrayAccessExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtArrayAccessExpression", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtArrayAccessExpression", "accept"));
        }
        return visitor2.visitArrayAccessExpression(this, data2);
    }

    @IfNotParsed
    @Nullable
    public KtExpression getArrayExpression() {
        return this.findChildByClass(KtExpression.class);
    }

    @NotNull
    public List<KtExpression> getIndexExpressions() {
        List<KtExpression> list2 = PsiTreeUtil.getChildrenOfTypeAsList(this.getIndicesNode(), KtExpression.class);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtArrayAccessExpression", "getIndexExpressions"));
        }
        return list2;
    }

    @NotNull
    public KtContainerNode getIndicesNode() {
        KtContainerNode indicesNode = (KtContainerNode)this.findChildByType(KtNodeTypes.INDICES);
        assert (indicesNode != null) : "Can't be null because of parser";
        KtContainerNode ktContainerNode = indicesNode;
        if (ktContainerNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtArrayAccessExpression", "getIndicesNode"));
        }
        return ktContainerNode;
    }

    @NotNull
    public List<TextRange> getBracketRanges() {
        PsiElement lBracket = this.getLeftBracket();
        PsiElement rBracket = this.getRightBracket();
        if (lBracket == null || rBracket == null) {
            List<TextRange> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtArrayAccessExpression", "getBracketRanges"));
            }
            return list2;
        }
        ArrayList<TextRange> arrayList = Lists.newArrayList(lBracket.getTextRange(), rBracket.getTextRange());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtArrayAccessExpression", "getBracketRanges"));
        }
        return arrayList;
    }

    @Nullable
    public PsiElement getLeftBracket() {
        return this.getIndicesNode().findChildByType(KtTokens.LBRACKET);
    }

    @Nullable
    public PsiElement getRightBracket() {
        return this.getIndicesNode().findChildByType(KtTokens.RBRACKET);
    }
}

