/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.infos;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCandidateInfo
extends CandidateInfo {
    public static final RecursionGuard ourOverloadGuard = RecursionManager.createGuard("overload.guard");
    public static final ThreadLocal<Map<PsiElement, CurrentCandidateProperties>> CURRENT_CANDIDATE = new ThreadLocal();
    @ApplicabilityLevelConstant
    private int myApplicabilityLevel;
    @ApplicabilityLevelConstant
    private int myPertinentApplicabilityLevel;
    private final PsiElement myArgumentList;
    private final PsiType[] myArgumentTypes;
    private final PsiType[] myTypeArguments;
    private PsiSubstitutor myCalcedSubstitutor;
    private String myInferenceError;
    private final LanguageLevel myLanguageLevel;

    public MethodCandidateInfo(@NotNull PsiElement candidate, PsiSubstitutor substitutor2, boolean accessProblem, boolean staticsProblem, PsiElement argumentList2, PsiElement currFileContext, @Nullable PsiType[] argumentTypes, PsiType[] typeArguments) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/infos/MethodCandidateInfo", "<init>"));
        }
        this(candidate, substitutor2, accessProblem, staticsProblem, argumentList2, currFileContext, argumentTypes, typeArguments, PsiUtil.getLanguageLevel(argumentList2));
    }

    public MethodCandidateInfo(@NotNull PsiElement candidate, @NotNull PsiSubstitutor substitutor2, boolean accessProblem, boolean staticsProblem, PsiElement argumentList2, PsiElement currFileContext, @Nullable PsiType[] argumentTypes, PsiType[] typeArguments, @NotNull LanguageLevel languageLevel) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/infos/MethodCandidateInfo", "<init>"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/infos/MethodCandidateInfo", "<init>"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/infos/MethodCandidateInfo", "<init>"));
        }
        super(candidate, substitutor2, accessProblem, staticsProblem, currFileContext);
        this.myArgumentList = argumentList2;
        this.myArgumentTypes = argumentTypes;
        this.myTypeArguments = typeArguments;
        this.myLanguageLevel = languageLevel;
    }

    public boolean isVarargs() {
        return false;
    }

    public boolean isApplicable() {
        return this.getPertinentApplicabilityLevel() != 1;
    }

    @ApplicabilityLevelConstant
    private int getApplicabilityLevelInner() {
        PsiType[] argumentTypes = this.getArgumentTypes();
        if (argumentTypes == null) {
            return 1;
        }
        int level = PsiUtil.getApplicabilityLevel(this.getElement(), this.getSubstitutor(), argumentTypes, this.myLanguageLevel);
        if (level > 1 && !this.isTypeArgumentsApplicable()) {
            level = 1;
        }
        return level;
    }

    @ApplicabilityLevelConstant
    public int getApplicabilityLevel() {
        if (this.myApplicabilityLevel == 0) {
            this.myApplicabilityLevel = this.getApplicabilityLevelInner();
        }
        return this.myApplicabilityLevel;
    }

    @ApplicabilityLevelConstant
    public int getPertinentApplicabilityLevel() {
        if (this.myPertinentApplicabilityLevel == 0) {
            this.myPertinentApplicabilityLevel = this.getPertinentApplicabilityLevelInner();
            this.pullInferenceErrorMessagesFromSubexpressions();
        }
        return this.myPertinentApplicabilityLevel;
    }

    public int getPertinentApplicabilityLevelInner() {
        if (this.myArgumentList == null || !PsiUtil.isLanguageLevel8OrHigher(this.myArgumentList)) {
            return this.getApplicabilityLevel();
        }
        final PsiMethod method = this.getElement();
        if (this.isToInferApplicability()) {
            if (!MethodCandidateInfo.isOverloadCheck()) {
                this.getSubstitutor(false);
            }
            if (this.myInferenceError != null || !this.isPotentiallyCompatible()) {
                return 1;
            }
            return this.isVarargs() ? 2 : 3;
        }
        final PsiSubstitutor substitutor2 = this.getSubstitutor(false);
        int level = this.computeForOverloadedCandidate(new Computable<Integer>(){

            @Override
            public Integer compute() {
                PsiType[] argumentTypes = MethodCandidateInfo.this.getArgumentTypes();
                if (argumentTypes == null) {
                    return 1;
                }
                int level = PsiUtil.getApplicabilityLevel(method, substitutor2, argumentTypes, MethodCandidateInfo.this.myLanguageLevel);
                if (!MethodCandidateInfo.this.isVarargs() && level < 3) {
                    return 1;
                }
                return level;
            }
        }, substitutor2, this.isVarargs(), true);
        if (level > 1 && !this.isTypeArgumentsApplicable(new Computable<PsiSubstitutor>(){

            @Override
            public PsiSubstitutor compute() {
                return substitutor2;
            }
        })) {
            level = 1;
        }
        return level;
    }

    public boolean isToInferApplicability() {
        return this.myTypeArguments == null && this.getElement().hasTypeParameters() && !this.isRawSubstitution();
    }

    public boolean isPotentiallyCompatible() {
        if (this.myArgumentList instanceof PsiExpressionList) {
            PsiMethod method = this.getElement();
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiExpression[] expressions = ((PsiExpressionList)this.myArgumentList).getExpressions();
            if (!this.isVarargs() && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                if (expressions.length != parameters2.length) {
                    return false;
                }
            } else {
                if (expressions.length < parameters2.length - 1) {
                    return false;
                }
                if (parameters2.length == 0 && expressions.length != parameters2.length) {
                    return false;
                }
            }
            for (int i = 0; i < expressions.length; ++i) {
                PsiType formalParameterType;
                PsiExpression expression = expressions[i];
                PsiType psiType = formalParameterType = i < parameters2.length ? parameters2[i].getType() : parameters2[parameters2.length - 1].getType();
                if (formalParameterType instanceof PsiEllipsisType && this.isVarargs()) {
                    formalParameterType = ((PsiEllipsisType)formalParameterType).getComponentType();
                }
                if (MethodCandidateInfo.isPotentialCompatible(expression, this.getSiteSubstitutor().substitute(formalParameterType), method)) continue;
                return false;
            }
            if (method.hasTypeParameters() && this.myTypeArguments != null) {
                return method.getTypeParameters().length == this.myTypeArguments.length;
            }
        }
        return true;
    }

    private static boolean isPotentialCompatible(PsiExpression expression, PsiType formalType, PsiMethod method) {
        if (expression instanceof PsiFunctionalExpression) {
            PsiClass targetTypeParameter = PsiUtil.resolveClassInClassTypeOnly(formalType);
            if (targetTypeParameter instanceof PsiTypeParameter && method.equals(((PsiTypeParameter)targetTypeParameter).getOwner())) {
                return true;
            }
            if (!((PsiFunctionalExpression)expression).isPotentiallyCompatible(formalType)) {
                return false;
            }
        } else {
            if (expression instanceof PsiParenthesizedExpression) {
                return MethodCandidateInfo.isPotentialCompatible(((PsiParenthesizedExpression)expression).getExpression(), formalType, method);
            }
            if (expression instanceof PsiConditionalExpression) {
                return MethodCandidateInfo.isPotentialCompatible(((PsiConditionalExpression)expression).getThenExpression(), formalType, method) && MethodCandidateInfo.isPotentialCompatible(((PsiConditionalExpression)expression).getElseExpression(), formalType, method);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T computeForOverloadedCandidate(Computable<T> computable, PsiSubstitutor substitutor2, boolean varargs, boolean applicabilityCheck) {
        Map<PsiElement, CurrentCandidateProperties> map2 = CURRENT_CANDIDATE.get();
        if (map2 == null) {
            map2 = ContainerUtil.createConcurrentWeakMap();
            CURRENT_CANDIDATE.set(map2);
        }
        PsiElement argumentList2 = this.getMarkerList();
        CurrentCandidateProperties alreadyThere = map2.put(argumentList2, new CurrentCandidateProperties(this, substitutor2, varargs, applicabilityCheck));
        try {
            T t = computable.compute();
            return t;
        }
        finally {
            if (alreadyThere == null) {
                map2.remove(argumentList2);
            } else {
                map2.put(argumentList2, alreadyThere);
            }
        }
    }

    @NotNull
    public PsiSubstitutor getSiteSubstitutor() {
        PsiSubstitutor incompleteSubstitutor = super.getSubstitutor();
        if (this.myTypeArguments != null) {
            PsiMethod method = this.getElement();
            PsiTypeParameter[] typeParams = method.getTypeParameters();
            for (int i = 0; i < this.myTypeArguments.length && i < typeParams.length; ++i) {
                incompleteSubstitutor = incompleteSubstitutor.put(typeParams[i], this.myTypeArguments[i]);
            }
        }
        PsiSubstitutor psiSubstitutor = incompleteSubstitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "getSiteSubstitutor"));
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.getSubstitutor(true);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "getSubstitutor"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor getSubstitutor(boolean includeReturnConstraint) {
        PsiSubstitutor substitutor2 = this.myCalcedSubstitutor;
        if (substitutor2 == null || !includeReturnConstraint && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) || MethodCandidateInfo.isOverloadCheck()) {
            if (includeReturnConstraint) {
                this.myInferenceError = null;
            }
            PsiSubstitutor incompleteSubstitutor = super.getSubstitutor();
            PsiMethod method = this.getElement();
            if (this.myTypeArguments == null) {
                RecursionGuard.StackStamp stackStamp = PsiDiamondType.ourDiamondGuard.markStack();
                PsiSubstitutor inferredSubstitutor = this.inferTypeArguments(DefaultParameterTypeInferencePolicy.INSTANCE, includeReturnConstraint);
                if (!stackStamp.mayCacheNow() || MethodCandidateInfo.isOverloadCheck() || !includeReturnConstraint && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) || this.getMarkerList() != null && PsiResolveHelper.ourGraphGuard.currentStack().contains(this.getMarkerList().getParent()) || LambdaUtil.isLambdaParameterCheck()) {
                    PsiSubstitutor psiSubstitutor = inferredSubstitutor;
                    if (psiSubstitutor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "getSubstitutor"));
                    }
                    return psiSubstitutor;
                }
                this.myCalcedSubstitutor = substitutor2 = inferredSubstitutor;
            } else {
                PsiTypeParameter[] typeParams = method.getTypeParameters();
                for (int i = 0; i < this.myTypeArguments.length && i < typeParams.length; ++i) {
                    incompleteSubstitutor = incompleteSubstitutor.put(typeParams[i], this.myTypeArguments[i]);
                }
                this.myCalcedSubstitutor = substitutor2 = incompleteSubstitutor;
            }
        }
        PsiSubstitutor psiSubstitutor = substitutor2;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "getSubstitutor"));
        }
        return psiSubstitutor;
    }

    public static boolean isOverloadCheck() {
        return !ourOverloadGuard.currentStack().isEmpty();
    }

    public boolean isTypeArgumentsApplicable() {
        return this.isTypeArgumentsApplicable(new Computable<PsiSubstitutor>(){

            @Override
            public PsiSubstitutor compute() {
                return MethodCandidateInfo.this.getSubstitutor(false);
            }
        });
    }

    private boolean isTypeArgumentsApplicable(Computable<PsiSubstitutor> computable) {
        PsiMethod psiMethod = this.getElement();
        PsiTypeParameter[] typeParams = psiMethod.getTypeParameters();
        if (this.myTypeArguments != null && typeParams.length != this.myTypeArguments.length && !PsiUtil.isLanguageLevel7OrHigher(psiMethod)) {
            return typeParams.length == 0 && JavaVersionService.getInstance().isAtLeast(psiMethod, JavaSdkVersion.JDK_1_7);
        }
        return GenericsUtil.isTypeArgumentsApplicable(typeParams, computable.compute(), this.getParent());
    }

    protected PsiElement getParent() {
        return this.myArgumentList != null ? this.myArgumentList.getParent() : null;
    }

    @Override
    public boolean isValidResult() {
        return super.isValidResult() && this.isApplicable();
    }

    @Override
    @NotNull
    public PsiMethod getElement() {
        PsiMethod psiMethod = (PsiMethod)super.getElement();
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "getElement"));
        }
        return psiMethod;
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull ParameterTypeInferencePolicy policy2, boolean includeReturnConstraint) {
        if (policy2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/infos/MethodCandidateInfo", "inferTypeArguments"));
        }
        PsiSubstitutor psiSubstitutor = this.inferTypeArguments(policy2, this.myArgumentList instanceof PsiExpressionList ? ((PsiExpressionList)this.myArgumentList).getExpressions() : PsiExpression.EMPTY_ARRAY, includeReturnConstraint);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    public PsiSubstitutor inferSubstitutorFromArgs(@NotNull ParameterTypeInferencePolicy policy2, PsiExpression[] arguments2) {
        if (policy2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/infos/MethodCandidateInfo", "inferSubstitutorFromArgs"));
        }
        if (this.myTypeArguments == null) {
            return this.inferTypeArguments(policy2, arguments2, true);
        }
        return this.getSiteSubstitutor();
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(final @NotNull ParameterTypeInferencePolicy policy2, final @NotNull PsiExpression[] arguments2, boolean includeReturnConstraint) {
        if (policy2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/infos/MethodCandidateInfo", "inferTypeArguments"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/infos/MethodCandidateInfo", "inferTypeArguments"));
        }
        PsiSubstitutor psiSubstitutor = this.computeForOverloadedCandidate(new Computable<PsiSubstitutor>(){

            @Override
            public PsiSubstitutor compute() {
                PsiMethod method = MethodCandidateInfo.this.getElement();
                PsiTypeParameter[] typeParameters2 = method.getTypeParameters();
                if (MethodCandidateInfo.this.isRawSubstitution()) {
                    return JavaPsiFacade.getInstance(method.getProject()).getElementFactory().createRawSubstitutor(MethodCandidateInfo.this.mySubstitutor, typeParameters2);
                }
                PsiElement parent2 = MethodCandidateInfo.this.getParent();
                if (parent2 == null) {
                    return PsiSubstitutor.EMPTY;
                }
                Project project = method.getProject();
                JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance(project);
                return javaPsiFacade.getResolveHelper().inferTypeArguments(typeParameters2, method.getParameterList().getParameters(), arguments2, MethodCandidateInfo.this.mySubstitutor, parent2, policy2, MethodCandidateInfo.this.myLanguageLevel);
            }
        }, super.getSubstitutor(), policy2.isVarargsIgnored() || this.isVarargs(), !includeReturnConstraint);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/infos/MethodCandidateInfo", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    public boolean isRawSubstitution() {
        PsiClass containingClass;
        PsiMethod method = this.getElement();
        return !method.hasModifierProperty("static") && (containingClass = method.getContainingClass()) != null && PsiUtil.isRawSubstitutor(containingClass, this.mySubstitutor);
    }

    protected PsiElement getMarkerList() {
        return this.myArgumentList;
    }

    public boolean isInferencePossible() {
        return this.myArgumentList != null && this.myArgumentList.isValid();
    }

    public static CurrentCandidateProperties getCurrentMethod(PsiElement context) {
        Map<PsiElement, CurrentCandidateProperties> currentMethodCandidates = CURRENT_CANDIDATE.get();
        return currentMethodCandidates != null ? currentMethodCandidates.get(context) : null;
    }

    public static void updateSubstitutor(PsiElement context, PsiSubstitutor newSubstitutor) {
        CurrentCandidateProperties candidateProperties = MethodCandidateInfo.getCurrentMethod(context);
        if (candidateProperties != null) {
            candidateProperties.setSubstitutor(newSubstitutor);
        }
    }

    public PsiType[] getArgumentTypes() {
        return this.myArgumentTypes;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.isVarargs() == ((MethodCandidateInfo)o).isVarargs();
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (this.isVarargs() ? 1 : 0);
    }

    public void setInferenceError(String inferenceError) {
        this.myInferenceError = inferenceError;
    }

    public String getInferenceErrorMessage() {
        return this.myInferenceError;
    }

    public String getParentInferenceErrorMessage(PsiExpressionList list2) {
        PsiElement parent2;
        String errorMessage2 = this.getInferenceErrorMessage();
        while (errorMessage2 == null && (list2 = PsiTreeUtil.getParentOfType((PsiElement)list2, PsiExpressionList.class, true, PsiCodeBlock.class)) != null && (parent2 = list2.getParent()) instanceof PsiCallExpression) {
            JavaResolveResult resolveResult = ((PsiCallExpression)parent2).resolveMethodGenerics();
            if (!(resolveResult instanceof MethodCandidateInfo)) continue;
            errorMessage2 = ((MethodCandidateInfo)resolveResult).getInferenceErrorMessage();
        }
        return errorMessage2;
    }

    private void pullInferenceErrorMessagesFromSubexpressions() {
        if (this.myPertinentApplicabilityLevel == 1 && this.myArgumentList instanceof PsiExpressionList) {
            String errorMessage2 = null;
            for (PsiExpression expression : ((PsiExpressionList)this.myArgumentList).getExpressions()) {
                String message = MethodCandidateInfo.clearErrorMessageInSubexpressions(expression);
                if (message == null) continue;
                errorMessage2 = message;
            }
            if (errorMessage2 != null) {
                this.setInferenceError(errorMessage2);
            }
        }
    }

    private static String clearErrorMessageInSubexpressions(PsiExpression expression) {
        PsiDiamondType diamondType;
        JavaResolveResult result2;
        if ((expression = PsiUtil.skipParenthesizedExprDown(expression)) instanceof PsiConditionalExpression) {
            String message = MethodCandidateInfo.clearErrorMessageInSubexpressions(((PsiConditionalExpression)expression).getThenExpression());
            if (message != null) {
                return message;
            }
            return MethodCandidateInfo.clearErrorMessageInSubexpressions(((PsiConditionalExpression)expression).getElseExpression());
        }
        if (expression instanceof PsiCallExpression && (result2 = expression instanceof PsiNewExpression ? ((diamondType = PsiDiamondType.getDiamondType((PsiNewExpression)expression)) != null ? diamondType.getStaticFactory() : ((PsiCallExpression)expression).resolveMethodGenerics()) : ((PsiCallExpression)expression).resolveMethodGenerics()) instanceof MethodCandidateInfo) {
            String message = ((MethodCandidateInfo)result2).getInferenceErrorMessage();
            ((MethodCandidateInfo)result2).setInferenceError(null);
            return message;
        }
        return null;
    }

    public CurrentCandidateProperties createProperties() {
        return new CurrentCandidateProperties(this, this.getSiteSubstitutor(), this.isVarargs(), false);
    }

    public static @interface ApplicabilityLevelConstant {
    }

    public static class ApplicabilityLevel {
        public static final int NOT_APPLICABLE = 1;
        public static final int VARARGS = 2;
        public static final int FIXED_ARITY = 3;
    }

    public static class CurrentCandidateProperties {
        private final MethodCandidateInfo myMethod;
        private PsiSubstitutor mySubstitutor;
        private boolean myVarargs;
        private boolean myApplicabilityCheck;

        private CurrentCandidateProperties(MethodCandidateInfo info, PsiSubstitutor substitutor2, boolean varargs, boolean applicabilityCheck) {
            this.myMethod = info;
            this.mySubstitutor = substitutor2;
            this.myVarargs = varargs;
            this.myApplicabilityCheck = applicabilityCheck;
        }

        public PsiMethod getMethod() {
            return this.myMethod.getElement();
        }

        public MethodCandidateInfo getInfo() {
            return this.myMethod;
        }

        public PsiSubstitutor getSubstitutor() {
            return this.mySubstitutor;
        }

        public void setSubstitutor(PsiSubstitutor substitutor2) {
            this.mySubstitutor = substitutor2;
        }

        public boolean isVarargs() {
            return this.myVarargs;
        }

        public void setVarargs(boolean varargs) {
            this.myVarargs = varargs;
        }

        public boolean isApplicabilityCheck() {
            return this.myApplicabilityCheck;
        }

        public void setApplicabilityCheck(boolean applicabilityCheck) {
            this.myApplicabilityCheck = applicabilityCheck;
        }
    }
}

