/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarVirtualFile;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreJarHandler
extends ZipHandler {
    private final CoreJarFileSystem myFileSystem;
    private final VirtualFile myRoot;

    public CoreJarHandler(@NotNull CoreJarFileSystem fileSystem, @NotNull String path) {
        if (fileSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSystem", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "<init>"));
        }
        super(path);
        this.myFileSystem = fileSystem;
        HashMap<ArchiveHandler.EntryInfo, CoreJarVirtualFile> entries = new HashMap<ArchiveHandler.EntryInfo, CoreJarVirtualFile>();
        Map<String, ArchiveHandler.EntryInfo> entriesMap = this.getEntriesMap();
        for (ArchiveHandler.EntryInfo info : entriesMap.values()) {
            this.getOrCreateFile(info, entries);
        }
        ArchiveHandler.EntryInfo rootInfo = this.getEntryInfo("");
        this.myRoot = rootInfo != null ? this.getOrCreateFile(rootInfo, entries) : null;
    }

    @NotNull
    private CoreJarVirtualFile getOrCreateFile(@NotNull ArchiveHandler.EntryInfo info, @NotNull Map<ArchiveHandler.EntryInfo, CoreJarVirtualFile> entries) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "getOrCreateFile"));
        }
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "getOrCreateFile"));
        }
        CoreJarVirtualFile file2 = entries.get(info);
        if (file2 == null) {
            FileAttributes attributes = new FileAttributes(info.isDirectory, false, false, false, info.length, info.timestamp, false);
            ArchiveHandler.EntryInfo parent2 = info.parent;
            file2 = new CoreJarVirtualFile(this, info.shortName.toString(), attributes, parent2 != null ? this.getOrCreateFile(parent2, entries) : null);
            entries.put(info, file2);
        }
        CoreJarVirtualFile coreJarVirtualFile = file2;
        if (coreJarVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "getOrCreateFile"));
        }
        return coreJarVirtualFile;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String pathInJar) {
        if (pathInJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathInJar", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "findFileByPath"));
        }
        return this.myRoot != null ? this.myRoot.findFileByRelativePath(pathInJar) : null;
    }

    @NotNull
    public CoreJarFileSystem getFileSystem() {
        CoreJarFileSystem coreJarFileSystem = this.myFileSystem;
        if (coreJarFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "getFileSystem"));
        }
        return coreJarFileSystem;
    }
}

