/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.LocalTimeCounter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtFunctionTypeReceiver;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactory$CallableBuilder$WhenMappings;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeCodeFragment;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00a4\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0006\u00b0\u0001\u00b1\u0001\u00b2\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\rJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010&\u001a\u00020'2\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010(\u001a\u00020\rJ\u0006\u0010)\u001a\u00020\rJ\u000e\u0010*\u001a\u00020+2\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020\rJ\u001d\u0010/\u001a\u0002H0\"\b\b\u0000\u00100*\u0002012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u00102J\u000e\u00103\u001a\u0002042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u00105\u001a\u0002042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u00106\u001a\u0002042\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u00107\u001a\u00020\rJ\u0006\u00108\u001a\u00020\rJ\u0006\u00109\u001a\u00020\u001bJ\u0006\u0010:\u001a\u00020;J\u000e\u0010<\u001a\u00020=2\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010>\u001a\u00020?J\u000e\u0010@\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010A\u001a\u00020B2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\rJ\u0010\u0010C\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010D\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010D\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010E\u001a\u00020\u000f2\u0006\u0010F\u001a\u00020\bJ\u000e\u0010G\u001a\u00020H2\u0006\u0010F\u001a\u00020\bJ\u001e\u0010I\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\bJ\u000e\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020PJ\u000e\u0010Q\u001a\u00020R2\u0006\u0010O\u001a\u00020PJ\u000e\u0010S\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\bJ\"\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u00152\u0006\u0010W\u001a\u00020\u00152\n\b\u0002\u0010X\u001a\u0004\u0018\u00010\u0015J\u000e\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\J\u000e\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020\bJ\u0016\u0010`\u001a\u00020a2\u0006\u0010b\u001a\u00020\b2\u0006\u0010c\u001a\u00020\bJ\u0013\u0010d\u001a\u00070e\u00a2\u0006\u0002\bf2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010g\u001a\u00020\r2\u0006\u0010h\u001a\u00020iJ\u000e\u0010j\u001a\u00020k2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010j\u001a\u00020k2\u0006\u0010h\u001a\u00020iJ\u000e\u0010l\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\bJ\u0006\u0010m\u001a\u00020\rJ\u000e\u0010m\u001a\u00020\r2\u0006\u0010n\u001a\u00020oJ\u000e\u0010p\u001a\u00020q2\u0006\u0010\u0016\u001a\u00020\bJ\u000e\u0010r\u001a\u00020s2\u0006\u0010t\u001a\u00020uJ\u0010\u0010v\u001a\u0004\u0018\u00010s2\u0006\u0010t\u001a\u00020uJ\u000e\u0010w\u001a\u00020N2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010x\u001a\u00020e2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010y\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010z\u001a\u00020{J\u0010\u0010z\u001a\u00020{2\b\u0010|\u001a\u0004\u0018\u00010\bJ\u000e\u0010}\u001a\u00020~2\u0006\u0010\u0007\u001a\u00020\bJ!\u0010}\u001a\u00020~2\u0006\u0010\u0016\u001a\u00020\b2\b\u0010\u007f\u001a\u0004\u0018\u00010\b2\u0007\u0010\u0080\u0001\u001a\u00020\u0019J,\u0010}\u001a\u00020~2\u0006\u0010\u0016\u001a\u00020\b2\b\u0010\u007f\u001a\u0004\u0018\u00010\b2\u0007\u0010\u0080\u0001\u001a\u00020\u00192\t\u0010\u0081\u0001\u001a\u0004\u0018\u00010\bJ6\u0010}\u001a\u00020~2\b\u0010|\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\b2\b\u0010\u007f\u001a\u0004\u0018\u00010\b2\u0007\u0010\u0080\u0001\u001a\u00020\u00192\t\u0010\u0081\u0001\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u0082\u0001\u001a\u00030\u0083\u00012\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001J\u0011\u0010\u0086\u0001\u001a\u00030\u0087\u00012\u0007\u0010\u0088\u0001\u001a\u00020\bJ\u0007\u0010\u0089\u0001\u001a\u00020\rJ\u000f\u0010\u008a\u0001\u001a\u00020q2\u0006\u0010\u0016\u001a\u00020\bJ\u000f\u0010\u008b\u0001\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\bJ\u0010\u0010\u008c\u0001\u001a\u00020\u001b2\u0007\u0010\u008d\u0001\u001a\u00020\u0015J\u0007\u0010\u008e\u0001\u001a\u00020\rJ\u0011\u0010\u008f\u0001\u001a\u00030\u0090\u00012\u0007\u0010\u0091\u0001\u001a\u00020\bJ\u0010\u0010\u0092\u0001\u001a\u00030\u0093\u00012\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0094\u0001\u001a\u00030\u0095\u00012\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\u0096\u0001\u001a\u00030\u0097\u0001J\u000f\u0010\u0098\u0001\u001a\u00020P2\u0006\u0010\u007f\u001a\u00020\bJ\u001a\u0010\u0099\u0001\u001a\r \u009b\u0001*\u0005\u0018\u00010\u009a\u00010\u009a\u00012\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u009c\u0001\u001a\u00030\u009d\u00012\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\u009e\u0001\u001a\u00030\u009f\u00012\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\rJ\u0011\u0010\u00a0\u0001\u001a\u0004\u0018\u00010P2\u0006\u0010\u007f\u001a\u00020\bJ\u0010\u0010\u00a1\u0001\u001a\u00030\u00a2\u00012\u0006\u0010\u0007\u001a\u00020\bJ\u0015\u0010\u00a3\u0001\u001a\b0\u00a4\u0001\u00a2\u0006\u0002\bf2\u0006\u0010\u0007\u001a\u00020\bJ\u0007\u0010\u00a5\u0001\u001a\u00020\rJ\u0007\u0010\u00a6\u0001\u001a\u00020\rJ\u0011\u0010\u00a7\u0001\u001a\u00030\u00a8\u00012\u0007\u0010\u00a9\u0001\u001a\u00020\bJ\u0007\u0010\u00aa\u0001\u001a\u00020\rJ\u000f\u0010\u00aa\u0001\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\u00ab\u0001\u001a\u000f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00ac\u0001J\u0011\u0010\u00ad\u0001\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0019\u0010\u00ae\u0001\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000f\u0010\u00af\u0001\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00b3\u0001"}, d2={"Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "creareDelegatedSuperTypeEntry", "Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;", "text", "", "createAnalyzableFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "fileName", "contextToAnalyzeIn", "Lcom/intellij/psi/PsiElement;", "createAnnotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "createAnonymousInitializer", "Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;", "createArgument", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "name", "Lorg/jetbrains/kotlin/name/Name;", "isSpread", "", "createBlock", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "bodyText", "createBlockCodeFragment", "Lorg/jetbrains/kotlin/psi/KtBlockCodeFragment;", "context", "createBlockStringTemplateEntry", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntryWithExpression;", "createCallArguments", "Lorg/jetbrains/kotlin/psi/KtValueArgumentList;", "createCallableReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "createClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "createColon", "createComma", "createComment", "Lcom/intellij/psi/PsiComment;", "createCompanionObject", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "createConstructorKeyword", "createDeclaration", "TDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "createDestructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "createDestructuringDeclarationInFor", "createDestructuringParameter", "createDot", "createEQ", "createEmptyBody", "createEmptyClassBody", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "createEnumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "createEnumEntryInitializerList", "Lorg/jetbrains/kotlin/psi/KtInitializerList;", "createExpression", "createExpressionCodeFragment", "Lorg/jetbrains/kotlin/psi/KtExpressionCodeFragment;", "createExpressionIfPossible", "createFile", "createFileAnnotation", "annotationText", "createFileAnnotationListWithAnnotation", "Lorg/jetbrains/kotlin/psi/KtFileAnnotationList;", "createFileWithLightClassSupport", "createFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "funDecl", "createFunctionTypeParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "createFunctionTypeReceiver", "Lorg/jetbrains/kotlin/psi/KtFunctionTypeReceiver;", "createIdentifier", "createIf", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "condition", "thenExpr", "elseExpr", "createImportDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "importPath", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "createLabeledExpression", "Lorg/jetbrains/kotlin/psi/KtLabeledExpression;", "labelName", "createLambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "parameters", "body", "createLambdaParameterList", "Lorg/jetbrains/kotlin/psi/KtParameterList;", "Lorg/jetbrains/annotations/Nullable;", "createModifier", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "createModifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "createNameIdentifier", "createNewLine", "lineBreaks", "", "createOperationName", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "createPackageDirective", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "createPackageDirectiveIfNeeded", "createParameter", "createParameterList", "createPhysicalFile", "createPrimaryConstructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "modifiers", "createProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "type", "isVar", "initializer", "createPropertyGetter", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "createSafeCallNode", "Lcom/intellij/lang/ASTNode;", "createSecondaryConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "decl", "createSemicolon", "createSimpleName", "createSimpleNameStringTemplateEntry", "createSingleStatementBlock", "statement", "createStar", "createStringTemplate", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "content", "createSuperTypeCallEntry", "Lorg/jetbrains/kotlin/psi/KtSuperTypeCallEntry;", "createSuperTypeEntry", "Lorg/jetbrains/kotlin/psi/KtSuperTypeEntry;", "createThisExpression", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "createType", "createTypeArgument", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "kotlin.jvm.PlatformType", "createTypeArguments", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "createTypeCodeFragment", "Lorg/jetbrains/kotlin/psi/KtTypeCodeFragment;", "createTypeIfPossible", "createTypeParameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "createTypeParameterList", "Lorg/jetbrains/kotlin/psi/KtTypeParameterList;", "createValKeyword", "createVarKeyword", "createWhenEntry", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "entryText", "createWhiteSpace", "createWhitespaceAndArrow", "Lkotlin/Pair;", "doCreateExpression", "doCreateFile", "wrapInABlockWrapper", "BlockWrapper", "CallableBuilder", "ClassHeaderBuilder", "kotlin-compiler"})
public final class KtPsiFactory {
    private final Project project;

    @NotNull
    public final PsiElement createValKeyword() {
        KtProperty property = this.createProperty("val x = 1");
        PsiElement psiElement = property.getValOrVarKeyword();
        Intrinsics.checkExpressionValueIsNotNull(psiElement, "property.valOrVarKeyword");
        return psiElement;
    }

    @NotNull
    public final PsiElement createVarKeyword() {
        KtProperty property = this.createProperty("var x = 1");
        PsiElement psiElement = property.getValOrVarKeyword();
        Intrinsics.checkExpressionValueIsNotNull(psiElement, "property.valOrVarKeyword");
        return psiElement;
    }

    @NotNull
    public final ASTNode createSafeCallNode() {
        KtExpression ktExpression = this.createExpression("a?.b");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSafeQualifiedExpression");
        }
        return ((KtSafeQualifiedExpression)ktExpression).getOperationTokenNode();
    }

    private final KtExpression doCreateExpression(String text) {
        KtExpression expression;
        KtExpression ktExpression = this.createProperty("val x =" + "\n" + text).getInitializer();
        if (ktExpression == null) {
            String string = "Failed to create expression from text: '" + text + "'";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        KtExpression ktExpression2 = expression = ktExpression;
        Intrinsics.checkExpressionValueIsNotNull(ktExpression2, "expression");
        return ktExpression2;
    }

    @NotNull
    public final KtExpression createExpression(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtExpression expression = this.doCreateExpression(text);
        boolean bl = Intrinsics.areEqual(expression.getText(), text);
        if (_Assertions.ENABLED && !bl) {
            String string = "Failed to create expression from text: '" + text + "', resulting expression's text was: '" + expression.getText() + "'";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return expression;
    }

    @Nullable
    public final KtExpression createExpressionIfPossible(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtExpression expression = this.doCreateExpression(text);
        return Intrinsics.areEqual(expression.getText(), text) ? expression : (KtExpression)null;
    }

    @NotNull
    public final KtThisExpression createThisExpression() {
        KtExpression ktExpression = this.createExpression("this.x");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
        }
        KtExpression ktExpression2 = ((KtQualifiedExpression)ktExpression).getReceiverExpression();
        if (ktExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtThisExpression");
        }
        return (KtThisExpression)ktExpression2;
    }

    @NotNull
    public final KtValueArgumentList createCallArguments(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtProperty property = this.createProperty("val x = foo " + text);
        KtExpression ktExpression = property.getInitializer();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
        }
        KtValueArgumentList ktValueArgumentList = ((KtCallExpression)ktExpression).getValueArgumentList();
        if (ktValueArgumentList == null) {
            Intrinsics.throwNpe();
        }
        return ktValueArgumentList;
    }

    @NotNull
    public final KtTypeArgumentList createTypeArguments(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtProperty property = this.createProperty("val x = foo" + text + "()");
        KtExpression ktExpression = property.getInitializer();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
        }
        KtTypeArgumentList ktTypeArgumentList = ((KtCallExpression)ktExpression).getTypeArgumentList();
        if (ktTypeArgumentList == null) {
            Intrinsics.throwNpe();
        }
        return ktTypeArgumentList;
    }

    public final KtTypeProjection createTypeArgument(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        return CollectionsKt.first(this.createTypeArguments("<" + text + ">").getArguments());
    }

    @NotNull
    public final KtTypeReference createType(@NotNull String type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        KtTypeReference typeReference = this.createTypeIfPossible(type2);
        if (typeReference == null || Intrinsics.areEqual(typeReference.getText(), type2) ^ true) {
            throw (Throwable)new IllegalArgumentException("Incorrect type: " + type2);
        }
        return typeReference;
    }

    @Nullable
    public final KtTypeReference createTypeIfPossible(@NotNull String type2) {
        KtTypeReference typeReference;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        KtTypeReference ktTypeReference = typeReference = this.createProperty("val x : " + type2).getTypeReference();
        return Intrinsics.areEqual(ktTypeReference != null ? ktTypeReference.getText() : null, type2) ? typeReference : (KtTypeReference)null;
    }

    @NotNull
    public final KtFunctionTypeReceiver createFunctionTypeReceiver(@NotNull KtTypeReference typeReference) {
        Intrinsics.checkParameterIsNotNull(typeReference, "typeReference");
        KtTypeElement ktTypeElement = this.createType("A.() -> B").getTypeElement();
        if (ktTypeElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunctionType");
        }
        KtFunctionTypeReceiver ktFunctionTypeReceiver = ((KtFunctionType)ktTypeElement).getReceiver();
        if (ktFunctionTypeReceiver == null) {
            Intrinsics.throwNpe();
        }
        KtFunctionTypeReceiver ktFunctionTypeReceiver2 = ktFunctionTypeReceiver;
        KtFunctionTypeReceiver $receiver = ktFunctionTypeReceiver2;
        $receiver.getTypeReference().replace(typeReference);
        KtFunctionTypeReceiver ktFunctionTypeReceiver3 = ktFunctionTypeReceiver2;
        Intrinsics.checkExpressionValueIsNotNull(ktFunctionTypeReceiver3, "(createType(\"A.() -> B\")\u2026.replace(typeReference) }");
        return ktFunctionTypeReceiver3;
    }

    @NotNull
    public final KtParameter createFunctionTypeParameter(@NotNull KtTypeReference typeReference) {
        Intrinsics.checkParameterIsNotNull(typeReference, "typeReference");
        KtTypeElement ktTypeElement = this.createType("(A) -> B").getTypeElement();
        if (ktTypeElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunctionType");
        }
        KtParameter ktParameter = CollectionsKt.first(((KtFunctionType)ktTypeElement).getParameters());
        KtParameter $receiver = ktParameter;
        KtTypeReference ktTypeReference = $receiver.getTypeReference();
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        ktTypeReference.replace(typeReference);
        KtParameter ktParameter2 = ktParameter;
        Intrinsics.checkExpressionValueIsNotNull(ktParameter2, "(createType(\"(A) -> B\").\u2026.replace(typeReference) }");
        return ktParameter2;
    }

    @NotNull
    public final PsiElement createStar() {
        PsiElement psiElement = this.createType("List<*>").findElementAt(5);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final PsiElement createComma() {
        PsiElement psiElement = this.createType("T<X, Y>").findElementAt(3);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final PsiElement createDot() {
        PsiElement psiElement = this.createType("T.(X)").findElementAt(1);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final PsiElement createColon() {
        PsiElement psiElement = this.createProperty("val x: Int").findElementAt(5);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final PsiElement createEQ() {
        PsiElement psiElement = this.createFunction("fun foo() = foo").getEqualsToken();
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final PsiElement createSemicolon() {
        PsiElement psiElement = this.createProperty("val x: Int;").findElementAt(10);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final Pair<PsiElement, PsiElement> createWhitespaceAndArrow() {
        KtTypeElement ktTypeElement = this.createType("() -> Int").getTypeElement();
        if (ktTypeElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunctionType");
        }
        KtFunctionType functionType = (KtFunctionType)ktTypeElement;
        PsiElement psiElement = functionType.findElementAt(2);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement2 = functionType.findElementAt(3);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return new Pair<PsiElement, PsiElement>(psiElement, psiElement2);
    }

    @NotNull
    public final PsiElement createWhiteSpace() {
        return this.createWhiteSpace(" ");
    }

    @NotNull
    public final PsiElement createWhiteSpace(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        PsiElement psiElement = this.createProperty("val" + text + "x: Int").findElementAt(3);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final PsiElement createNewLine() {
        return this.createWhiteSpace("\n ");
    }

    @NotNull
    public final PsiElement createNewLine(int lineBreaks) {
        return this.createWhiteSpace(StringsKt.repeat("\n", lineBreaks));
    }

    @NotNull
    public final KtClass createClass(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        return (KtClass)this.createDeclaration(text);
    }

    @NotNull
    public final KtObjectDeclaration createCompanionObject() {
        return CollectionsKt.first(this.createClass("class A {\n companion object{\n}\n}").getCompanionObjects());
    }

    @NotNull
    public final KtAnnotationEntry createFileAnnotation(@NotNull String annotationText) {
        Intrinsics.checkParameterIsNotNull(annotationText, "annotationText");
        KtAnnotationEntry ktAnnotationEntry = CollectionsKt.first(this.createFileAnnotationListWithAnnotation(annotationText).getAnnotationEntries());
        Intrinsics.checkExpressionValueIsNotNull(ktAnnotationEntry, "createFileAnnotationList\u2026annotationEntries.first()");
        return ktAnnotationEntry;
    }

    @NotNull
    public final KtFileAnnotationList createFileAnnotationListWithAnnotation(@NotNull String annotationText) {
        Intrinsics.checkParameterIsNotNull(annotationText, "annotationText");
        KtFileAnnotationList ktFileAnnotationList = this.createFile("@file:" + annotationText).getFileAnnotationList();
        if (ktFileAnnotationList == null) {
            Intrinsics.throwNpe();
        }
        return ktFileAnnotationList;
    }

    @NotNull
    public final KtFile createFile(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        return this.createFile("dummy.kt", text);
    }

    private final KtFile doCreateFile(String fileName, String text) {
        PsiFile psiFile = PsiFileFactory.getInstance(this.project).createFileFromText(fileName, KotlinFileType.INSTANCE, (CharSequence)text, LocalTimeCounter.currentTime(), false);
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        return (KtFile)psiFile;
    }

    @NotNull
    public final KtFile createFile(@NotNull String fileName, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtFile file = this.doCreateFile(fileName, text);
        KtPsiFactoryKt.setDoNotAnalyze(file, KtPsiFactoryKt.access$getDO_NOT_ANALYZE_NOTIFICATION$p());
        return file;
    }

    @NotNull
    public final KtFile createAnalyzableFile(@NotNull String fileName, @NotNull String text, @NotNull PsiElement contextToAnalyzeIn) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        Intrinsics.checkParameterIsNotNull(text, "text");
        Intrinsics.checkParameterIsNotNull(contextToAnalyzeIn, "contextToAnalyzeIn");
        KtFile file = this.doCreateFile(fileName, text);
        KtPsiFactoryKt.setAnalysisContext(file, contextToAnalyzeIn);
        return file;
    }

    @NotNull
    public final KtFile createFileWithLightClassSupport(@NotNull String fileName, @NotNull String text, @NotNull PsiElement contextToAnalyzeIn) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        Intrinsics.checkParameterIsNotNull(text, "text");
        Intrinsics.checkParameterIsNotNull(contextToAnalyzeIn, "contextToAnalyzeIn");
        KtFile file = this.createPhysicalFile(fileName, text);
        KtPsiFactoryKt.setAnalysisContext(file, contextToAnalyzeIn);
        return file;
    }

    @NotNull
    public final KtFile createPhysicalFile(@NotNull String fileName, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        Intrinsics.checkParameterIsNotNull(text, "text");
        PsiFile psiFile = PsiFileFactory.getInstance(this.project).createFileFromText(fileName, KotlinFileType.INSTANCE, (CharSequence)text, LocalTimeCounter.currentTime(), true);
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        return (KtFile)psiFile;
    }

    @NotNull
    public final KtProperty createProperty(@Nullable String modifiers, @NotNull String name, @Nullable String type2, boolean isVar, @Nullable String initializer2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        String string = modifiers;
        StringBuilder stringBuilder = new StringBuilder();
        String it = string;
        String string2 = it + " ";
        String text = stringBuilder.append(string2).append(isVar ? " var " : " val ").append(name).append(type2 != null ? ":" + type2 : "").append(initializer2 == null ? "" : " = " + initializer2).toString();
        return this.createProperty(text);
    }

    @NotNull
    public final KtProperty createProperty(@NotNull String name, @Nullable String type2, boolean isVar, @Nullable String initializer2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return this.createProperty(null, name, type2, isVar, initializer2);
    }

    @NotNull
    public final KtProperty createProperty(@NotNull String name, @Nullable String type2, boolean isVar) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return this.createProperty(name, type2, isVar, null);
    }

    @NotNull
    public final KtProperty createProperty(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        return (KtProperty)this.createDeclaration(text);
    }

    @NotNull
    public final KtPropertyAccessor createPropertyGetter(@NotNull KtExpression expression) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtProperty property = this.createProperty("val x get() = 1");
        KtPropertyAccessor ktPropertyAccessor = property.getGetter();
        if (ktPropertyAccessor == null) {
            Intrinsics.throwNpe();
        }
        KtPropertyAccessor getter = ktPropertyAccessor;
        KtExpression ktExpression = getter.getBodyExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression bodyExpression = ktExpression;
        bodyExpression.replace(expression);
        KtPropertyAccessor ktPropertyAccessor2 = getter;
        Intrinsics.checkExpressionValueIsNotNull(ktPropertyAccessor2, "getter");
        return ktPropertyAccessor2;
    }

    @NotNull
    public final KtDestructuringDeclaration createDestructuringDeclaration(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtExpression ktExpression = this.createFunction("fun foo() {" + text + "}").getBodyExpression();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
        }
        KtExpression ktExpression2 = CollectionsKt.first(((KtBlockExpression)ktExpression).getStatements());
        if (ktExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDestructuringDeclaration");
        }
        return (KtDestructuringDeclaration)ktExpression2;
    }

    @NotNull
    public final KtDestructuringDeclaration createDestructuringDeclarationInFor(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtExpression ktExpression = this.createFunction("fun foo() {for (" + text + " in foo) {} }").getBodyExpression();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
        }
        KtExpression ktExpression2 = CollectionsKt.first(((KtBlockExpression)ktExpression).getStatements());
        if (ktExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtForExpression");
        }
        KtDestructuringDeclaration ktDestructuringDeclaration = ((KtForExpression)ktExpression2).getDestructuringParameter();
        if (ktDestructuringDeclaration == null) {
            Intrinsics.throwNpe();
        }
        return ktDestructuringDeclaration;
    }

    @NotNull
    public final KtDestructuringDeclaration createDestructuringParameter(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtNamedFunction dummyFun = this.createFunction("fun foo() { for (" + text + " in foo) {} }");
        KtExpression ktExpression = dummyFun.getBodyExpression();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
        }
        KtExpression ktExpression2 = CollectionsKt.first(((KtBlockExpression)ktExpression).getStatements());
        if (ktExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtForExpression");
        }
        KtDestructuringDeclaration ktDestructuringDeclaration = ((KtForExpression)ktExpression2).getDestructuringParameter();
        if (ktDestructuringDeclaration == null) {
            Intrinsics.throwNpe();
        }
        return ktDestructuringDeclaration;
    }

    @NotNull
    public final <TDeclaration extends KtDeclaration> TDeclaration createDeclaration(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtFile file = this.createFile(text);
        List<KtDeclaration> declarations = file.getDeclarations();
        boolean bl = declarations.size() == 1;
        if (_Assertions.ENABLED && !bl) {
            String string = declarations.size() + " declarations in " + text;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KtDeclaration ktDeclaration = CollectionsKt.first(declarations);
        if (ktDeclaration == null) {
            throw new TypeCastException("null cannot be cast to non-null type TDeclaration");
        }
        KtDeclaration result2 = ktDeclaration;
        return (TDeclaration)result2;
    }

    @NotNull
    public final PsiElement createNameIdentifier(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        PsiElement psiElement = this.createProperty(name, null, false).getNameIdentifier();
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final KtSimpleNameExpression createSimpleName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        KtExpression ktExpression = this.createProperty(name, null, false, name).getInitializer();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSimpleNameExpression");
        }
        return (KtSimpleNameExpression)ktExpression;
    }

    @NotNull
    public final KtSimpleNameExpression createOperationName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        KtExpression ktExpression = this.createExpression("0 " + name + " 0");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        KtSimpleNameExpression ktSimpleNameExpression = ((KtBinaryExpression)ktExpression).getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull(ktSimpleNameExpression, "(createExpression(\"0 $na\u2026ssion).operationReference");
        return ktSimpleNameExpression;
    }

    @NotNull
    public final PsiElement createIdentifier(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        PsiElement psiElement = this.createSimpleName(name).getIdentifier();
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final KtNamedFunction createFunction(@NotNull String funDecl) {
        Intrinsics.checkParameterIsNotNull(funDecl, "funDecl");
        return (KtNamedFunction)this.createDeclaration(funDecl);
    }

    @Nullable
    public final KtCallableReferenceExpression createCallableReferenceExpression(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtExpression ktExpression = this.createExpression(text);
        if (!(ktExpression instanceof KtCallableReferenceExpression)) {
            ktExpression = null;
        }
        return (KtCallableReferenceExpression)ktExpression;
    }

    @NotNull
    public final KtSecondaryConstructor createSecondaryConstructor(@NotNull String decl) {
        Intrinsics.checkParameterIsNotNull(decl, "decl");
        return CollectionsKt.first(this.createClass("class Foo {" + "\n" + " " + decl + " " + "\n" + "}").getSecondaryConstructors());
    }

    @NotNull
    public final KtModifierList createModifierList(@NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkParameterIsNotNull(modifier, "modifier");
        String string = modifier.getValue();
        Intrinsics.checkExpressionValueIsNotNull(string, "modifier.value");
        return this.createModifierList(string);
    }

    @NotNull
    public final KtModifierList createModifierList(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtModifierList ktModifierList = this.createProperty(text + " val x").getModifierList();
        if (ktModifierList == null) {
            Intrinsics.throwNpe();
        }
        return ktModifierList;
    }

    @NotNull
    public final PsiElement createModifier(@NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkParameterIsNotNull(modifier, "modifier");
        String string = modifier.getValue();
        Intrinsics.checkExpressionValueIsNotNull(string, "modifier.value");
        PsiElement psiElement = this.createModifierList(string).getModifier(modifier);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final KtAnnotationEntry createAnnotationEntry(@NotNull String text) {
        KtModifierList modifierList;
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtModifierList ktModifierList = modifierList = this.createProperty(text + " val x").getModifierList();
        if (ktModifierList == null) {
            Intrinsics.throwNpe();
        }
        KtAnnotationEntry ktAnnotationEntry = CollectionsKt.first(ktModifierList.getAnnotationEntries());
        Intrinsics.checkExpressionValueIsNotNull(ktAnnotationEntry, "modifierList!!.annotationEntries.first()");
        return ktAnnotationEntry;
    }

    @NotNull
    public final KtBlockExpression createEmptyBody() {
        KtExpression ktExpression = this.createFunction("fun foo() {}").getBodyExpression();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
        }
        return (KtBlockExpression)ktExpression;
    }

    @NotNull
    public final KtAnonymousInitializer createAnonymousInitializer() {
        return CollectionsKt.first(this.createClass("class A { init {} }").getAnonymousInitializers());
    }

    @NotNull
    public final KtClassBody createEmptyClassBody() {
        KtClassBody ktClassBody = this.createClass("class A(){}").getBody();
        if (ktClassBody == null) {
            Intrinsics.throwNpe();
        }
        return ktClassBody;
    }

    @NotNull
    public final KtParameter createParameter(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        return CollectionsKt.first(this.createClass("class A(" + text + ")").getPrimaryConstructorParameters());
    }

    @NotNull
    public final KtParameterList createParameterList(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtParameterList ktParameterList = this.createFunction("fun foo" + text + "{}").getValueParameterList();
        if (ktParameterList == null) {
            Intrinsics.throwNpe();
        }
        return ktParameterList;
    }

    @NotNull
    public final KtTypeParameterList createTypeParameterList(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtTypeParameterList ktTypeParameterList = this.createClass("class Foo" + text).getTypeParameterList();
        if (ktTypeParameterList == null) {
            Intrinsics.throwNpe();
        }
        return ktTypeParameterList;
    }

    @NotNull
    public final KtTypeParameter createTypeParameter(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtTypeParameter ktTypeParameter = CollectionsKt.first(this.createTypeParameterList("<" + text + ">").getParameters());
        if (ktTypeParameter == null) {
            Intrinsics.throwNpe();
        }
        return ktTypeParameter;
    }

    @NotNull
    public final KtParameterList createLambdaParameterList(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtParameterList ktParameterList = this.createLambdaExpression(text, "0").getFunctionLiteral().getValueParameterList();
        if (ktParameterList == null) {
            Intrinsics.throwNpe();
        }
        return ktParameterList;
    }

    @NotNull
    public final KtLambdaExpression createLambdaExpression(@NotNull String parameters2, @NotNull String body) {
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        Intrinsics.checkParameterIsNotNull(body, "body");
        CharSequence charSequence = parameters2;
        KtExpression ktExpression = charSequence.length() > 0 ? this.createExpression("{ " + parameters2 + " -> " + body + " }") : this.createExpression("{ " + body + " }");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtLambdaExpression");
        }
        return (KtLambdaExpression)ktExpression;
    }

    @NotNull
    public final KtEnumEntry createEnumEntry(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtDeclaration ktDeclaration = ((KtClass)this.createDeclaration("enum class E {" + text + "}")).getDeclarations().get(0);
        if (ktDeclaration == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtEnumEntry");
        }
        return (KtEnumEntry)ktDeclaration;
    }

    @NotNull
    public final KtInitializerList createEnumEntryInitializerList() {
        KtInitializerList ktInitializerList = this.createEnumEntry("Entry()").getInitializerList();
        if (ktInitializerList == null) {
            Intrinsics.throwNpe();
        }
        return ktInitializerList;
    }

    @NotNull
    public final KtWhenEntry createWhenEntry(@NotNull String entryText) {
        Intrinsics.checkParameterIsNotNull(entryText, "entryText");
        KtNamedFunction function = this.createFunction("fun foo() { when(12) { " + entryText + " } }");
        KtWhenEntry whenEntry = PsiTreeUtil.findChildOfType(function, KtWhenEntry.class);
        boolean bl = whenEntry != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Couldn't generate when entry";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KtWhenEntry ktWhenEntry = whenEntry;
        if (ktWhenEntry == null) {
            Intrinsics.throwNpe();
        }
        bl = Intrinsics.areEqual(entryText, ktWhenEntry.getText());
        if (_Assertions.ENABLED && !bl) {
            String string = "Generate when entry text differs from the given text";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return whenEntry;
    }

    @NotNull
    public final KtStringTemplateEntryWithExpression createBlockStringTemplateEntry(@NotNull KtExpression expression) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtExpression ktExpression = this.createExpression("\"${" + expression.getText() + "}\"");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        }
        KtStringTemplateExpression stringTemplateExpression = (KtStringTemplateExpression)ktExpression;
        KtStringTemplateEntry ktStringTemplateEntry = stringTemplateExpression.getEntries()[0];
        if (ktStringTemplateEntry == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression");
        }
        return (KtStringTemplateEntryWithExpression)ktStringTemplateEntry;
    }

    @NotNull
    public final KtStringTemplateEntryWithExpression createSimpleNameStringTemplateEntry(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        KtExpression ktExpression = this.createExpression("\"" + "$" + name + "\"");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        }
        KtStringTemplateExpression stringTemplateExpression = (KtStringTemplateExpression)ktExpression;
        KtStringTemplateEntry ktStringTemplateEntry = stringTemplateExpression.getEntries()[0];
        if (ktStringTemplateEntry == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression");
        }
        return (KtStringTemplateEntryWithExpression)ktStringTemplateEntry;
    }

    @NotNull
    public final KtStringTemplateExpression createStringTemplate(@NotNull String content) {
        Intrinsics.checkParameterIsNotNull(content, "content");
        KtExpression ktExpression = this.createExpression("\"" + content + "\"");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        }
        return (KtStringTemplateExpression)ktExpression;
    }

    @NotNull
    public final KtPackageDirective createPackageDirective(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        KtPackageDirective ktPackageDirective = this.createFile("package " + fqName2.asString()).getPackageDirective();
        if (ktPackageDirective == null) {
            Intrinsics.throwNpe();
        }
        return ktPackageDirective;
    }

    @Nullable
    public final KtPackageDirective createPackageDirectiveIfNeeded(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return fqName2.isRoot() ? (KtPackageDirective)null : this.createPackageDirective(fqName2);
    }

    @NotNull
    public final KtImportDirective createImportDirective(@NotNull ImportPath importPath) {
        Intrinsics.checkParameterIsNotNull(importPath, "importPath");
        if (importPath.fqnPart().isRoot()) {
            throw (Throwable)new IllegalArgumentException("import path must not be empty");
        }
        StringBuilder importDirectiveBuilder = new StringBuilder("import ");
        importDirectiveBuilder.append(importPath.getPathStr());
        Name alias = importPath.getAlias();
        if (alias != null) {
            importDirectiveBuilder.append(" as ").append(alias.asString());
        }
        String string = importDirectiveBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "importDirectiveBuilder.toString()");
        KtFile file = this.createFile(string);
        KtImportDirective ktImportDirective = CollectionsKt.first(file.getImportDirectives());
        Intrinsics.checkExpressionValueIsNotNull(ktImportDirective, "file.importDirectives.first()");
        return ktImportDirective;
    }

    @NotNull
    public final KtPrimaryConstructor createPrimaryConstructor() {
        KtPrimaryConstructor ktPrimaryConstructor = this.createClass("class A()").getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            Intrinsics.throwNpe();
        }
        return ktPrimaryConstructor;
    }

    @NotNull
    public final KtPrimaryConstructor createPrimaryConstructor(@Nullable String modifiers) {
        Object object;
        block3: {
            block2: {
                object = modifiers;
                if (object == null) break block2;
                String string = object;
                String it = string;
                object = this.createClass("class A " + modifiers + " constructor()").getPrimaryConstructor();
                if (object != null) break block3;
            }
            object = this.createPrimaryConstructor();
        }
        return object;
    }

    @NotNull
    public final PsiElement createConstructorKeyword() {
        KtPrimaryConstructor ktPrimaryConstructor = this.createClass("class A constructor()").getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement = ktPrimaryConstructor.getConstructorKeyword();
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    @NotNull
    public final KtLabeledExpression createLabeledExpression(@NotNull String labelName) {
        Intrinsics.checkParameterIsNotNull(labelName, "labelName");
        KtExpression ktExpression = this.createExpression(labelName + "@ 1");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtLabeledExpression");
        }
        return (KtLabeledExpression)ktExpression;
    }

    @NotNull
    public final KtTypeCodeFragment createTypeCodeFragment(@NotNull String text, @Nullable PsiElement context) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        return new KtTypeCodeFragment(this.project, "fragment.kt", text, context);
    }

    @NotNull
    public final KtExpressionCodeFragment createExpressionCodeFragment(@NotNull String text, @Nullable PsiElement context) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        return new KtExpressionCodeFragment(this.project, "fragment.kt", text, null, context);
    }

    @NotNull
    public final KtBlockCodeFragment createBlockCodeFragment(@NotNull String text, @Nullable PsiElement context) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        return new KtBlockCodeFragment(this.project, "fragment.kt", text, null, context);
    }

    @NotNull
    public final KtIfExpression createIf(@NotNull KtExpression condition, @NotNull KtExpression thenExpr, @Nullable KtExpression elseExpr) {
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull(condition, "condition");
        Intrinsics.checkParameterIsNotNull(thenExpr, "thenExpr");
        if (elseExpr != null) {
            KtExpression ktExpression2 = CreateByPatternKt.createExpressionByPattern(this, "if ($0) $1 else $2", condition, thenExpr, elseExpr);
            if (ktExpression2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
            }
            ktExpression = (KtIfExpression)ktExpression2;
        } else {
            ktExpression = CreateByPatternKt.createExpressionByPattern(this, "if ($0) $1", condition, thenExpr);
        }
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
        }
        return (KtIfExpression)ktExpression;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KtIfExpression createIf$default(KtPsiFactory ktPsiFactory, KtExpression ktExpression, KtExpression ktExpression2, KtExpression ktExpression3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createIf");
        }
        if ((n & 4) != 0) {
            ktExpression3 = null;
        }
        return ktPsiFactory.createIf(ktExpression, ktExpression2, ktExpression3);
    }

    @NotNull
    public final KtValueArgument createArgument(@Nullable KtExpression expression, @Nullable Name name, boolean isSpread) {
        KtValueArgumentList argumentList2 = (KtValueArgumentList)CreateByPatternKt.buildByPattern((Function2)new Function2<String, Object[], KtValueArgumentList>(this){
            final /* synthetic */ KtPsiFactory this$0;

            @NotNull
            public final KtValueArgumentList invoke(@NotNull String pattern, @NotNull Object[] args) {
                Intrinsics.checkParameterIsNotNull(pattern, "pattern");
                Intrinsics.checkParameterIsNotNull(args, "args");
                return (KtValueArgumentList)CreateByPatternKt.createByPattern(pattern, Arrays.copyOf(args, args.length), (Function1)new Function1<String, KtValueArgumentList>(this){
                    final /* synthetic */ createArgument.argumentList.1 this$0;

                    @NotNull
                    public final KtValueArgumentList invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull(it, "it");
                        return this.this$0.this$0.createCallArguments(it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = ktPsiFactory;
                super(2);
            }
        }, (Function1)new Function1<BuilderByPattern<KtValueArgumentList>, Unit>(name, isSpread, expression){
            final /* synthetic */ Name $name;
            final /* synthetic */ boolean $isSpread;
            final /* synthetic */ KtExpression $expression;

            public final void invoke(@NotNull BuilderByPattern<KtValueArgumentList> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                $receiver.appendFixedText("(");
                if (this.$name != null) {
                    $receiver.appendName(this.$name);
                    $receiver.appendFixedText("=");
                }
                if (this.$isSpread) {
                    $receiver.appendFixedText("*");
                }
                $receiver.appendExpression(this.$expression);
                $receiver.appendFixedText(")");
            }
            {
                this.$name = name;
                this.$isSpread = bl;
                this.$expression = ktExpression;
                super(1);
            }
        });
        KtValueArgument ktValueArgument = CollectionsKt.single(argumentList2.getArguments());
        Intrinsics.checkExpressionValueIsNotNull(ktValueArgument, "argumentList.arguments.single()");
        return ktValueArgument;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KtValueArgument createArgument$default(KtPsiFactory ktPsiFactory, KtExpression ktExpression, Name name, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createArgument");
        }
        if ((n & 2) != 0) {
            name = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return ktPsiFactory.createArgument(ktExpression, name, bl);
    }

    @NotNull
    public final KtValueArgument createArgument(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtValueArgument ktValueArgument = CollectionsKt.first(this.createCallArguments("(" + text + ")").getArguments());
        if (ktValueArgument == null) {
            Intrinsics.throwNpe();
        }
        return ktValueArgument;
    }

    @NotNull
    public final KtSuperTypeCallEntry createSuperTypeCallEntry(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtSuperTypeListEntry ktSuperTypeListEntry = CollectionsKt.first(this.createClass("class A: " + text).getSuperTypeListEntries());
        if (ktSuperTypeListEntry == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSuperTypeCallEntry");
        }
        return (KtSuperTypeCallEntry)ktSuperTypeListEntry;
    }

    @NotNull
    public final KtSuperTypeEntry createSuperTypeEntry(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtSuperTypeListEntry ktSuperTypeListEntry = CollectionsKt.first(this.createClass("class A: " + text).getSuperTypeListEntries());
        if (ktSuperTypeListEntry == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSuperTypeEntry");
        }
        return (KtSuperTypeEntry)ktSuperTypeListEntry;
    }

    @NotNull
    public final KtConstructorDelegationCall creareDelegatedSuperTypeEntry(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        CharSequence charSequence = text;
        String colonOrEmpty = charSequence.length() == 0 ? "" : ": ";
        return CollectionsKt.first(this.createClass("class A { constructor()" + colonOrEmpty + text + " {}").getSecondaryConstructors()).getDelegationCall();
    }

    @NotNull
    public final KtBlockExpression createBlock(@NotNull String bodyText) {
        Intrinsics.checkParameterIsNotNull(bodyText, "bodyText");
        KtExpression ktExpression = this.createFunction("fun foo() {" + "\n" + bodyText + "\n" + "}").getBodyExpression();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
        }
        return (KtBlockExpression)ktExpression;
    }

    @NotNull
    public final KtBlockExpression createSingleStatementBlock(@NotNull KtExpression statement) {
        Intrinsics.checkParameterIsNotNull(statement, "statement");
        KtExpression ktExpression = ((KtNamedFunction)CreateByPatternKt.createDeclarationByPattern(this, "fun foo() {\n$0\n}", statement)).getBodyExpression();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
        }
        return (KtBlockExpression)ktExpression;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PsiComment createComment(@NotNull String text) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(text, "text");
        KtFile file = this.createFile(text);
        Object[] objectArray = file.getChildren();
        void var5_4 = $receiver$iv;
        Object object = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            if (!(element$iv$iv instanceof PsiComment)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List comments = (List)destination$iv$iv;
        PsiComment comment = (PsiComment)CollectionsKt.single(comments);
        boolean bl = Intrinsics.areEqual(comment.getText(), text);
        if (_Assertions.ENABLED && !bl) {
            object = "Assertion failed";
            throw (Throwable)((Object)new AssertionError(object));
        }
        return comment;
    }

    @NotNull
    public final KtBlockExpression wrapInABlockWrapper(@NotNull KtExpression expression) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        if (expression instanceof KtBlockExpression) {
            return (KtBlockExpression)expression;
        }
        KtNamedFunction function = this.createFunction("fun f() { " + expression.getText() + " }");
        KtExpression ktExpression = function.getBodyExpression();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
        }
        KtBlockExpression block = (KtBlockExpression)ktExpression;
        return new BlockWrapper(block, expression);
    }

    public KtPsiFactory(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull(project, "project");
        this.project = project;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0006\u0010\f\u001a\u00020\u000bJ$\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000bJ\b\u0010\u0013\u001a\u00020\bH\u0002J\u001f\u0010\u0014\u001a\u00020\b2\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0016\u00a2\u0006\u0002\b\u0017J\u0014\u0010\u0018\u001a\u00020\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0014\u0010\u0019\u001a\u00020\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/psi/KtPsiFactory$ClassHeaderBuilder;", "", "()V", "sb", "Ljava/lang/StringBuilder;", "state", "Lorg/jetbrains/kotlin/psi/KtPsiFactory$ClassHeaderBuilder$State;", "appendInAngleBrackets", "", "values", "", "", "asString", "baseClass", "name", "typeArguments", "isInterface", "", "modifier", "placeKeyword", "transform", "f", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "typeConstraints", "typeParameters", "State", "kotlin-compiler"})
    public static final class ClassHeaderBuilder {
        private final StringBuilder sb = new StringBuilder();
        private State state = State.MODIFIERS;

        @NotNull
        public final ClassHeaderBuilder modifier(@NotNull String modifier) {
            Intrinsics.checkParameterIsNotNull(modifier, "modifier");
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.MODIFIERS);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.sb.append(modifier);
            return this;
        }

        private final void placeKeyword() {
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.MODIFIERS);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            CharSequence charSequence = this.sb;
            if (charSequence.length() > 0) {
                this.sb.append(" ");
            }
            this.sb.append("class ");
            this.state = State.NAME;
        }

        @NotNull
        public final ClassHeaderBuilder name(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            this.placeKeyword();
            this.sb.append(name);
            this.state = State.TYPE_PARAMETERS;
            return this;
        }

        private final void appendInAngleBrackets(Collection<String> values) {
            Collection<String> collection = values;
            if (!collection.isEmpty()) {
                this.sb.append(CollectionsKt.joinToString$default(values, ", ", "<", ">", 0, null, null, 56, null));
            }
        }

        @NotNull
        public final ClassHeaderBuilder typeParameters(@NotNull Collection<String> values) {
            Intrinsics.checkParameterIsNotNull(values, "values");
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.TYPE_PARAMETERS);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.appendInAngleBrackets(values);
            this.state = State.BASE_CLASS;
            return this;
        }

        @NotNull
        public final ClassHeaderBuilder baseClass(@NotNull String name, @NotNull Collection<String> typeArguments2, boolean isInterface) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(typeArguments2, "typeArguments");
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.BASE_CLASS);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.sb.append(" : " + name);
            this.appendInAngleBrackets(typeArguments2);
            if (!isInterface) {
                this.sb.append("()");
            }
            this.state = State.TYPE_CONSTRAINTS;
            return this;
        }

        @NotNull
        public final ClassHeaderBuilder typeConstraints(@NotNull Collection<String> values) {
            Intrinsics.checkParameterIsNotNull(values, "values");
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.TYPE_CONSTRAINTS);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (!values.isEmpty()) {
                this.sb.append(CollectionsKt.joinToString$default(values, ", ", " where ", "", -1, "", null, 32, null));
            }
            this.state = State.DONE;
            return this;
        }

        public final void transform(@NotNull Function1<? super StringBuilder, Unit> f) {
            Intrinsics.checkParameterIsNotNull(f, "f");
            f.invoke(this.sb);
        }

        @NotNull
        public final String asString() {
            if (Intrinsics.areEqual((Object)this.state, (Object)State.DONE) ^ true) {
                this.state = State.DONE;
            }
            String string = this.sb.toString();
            Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
            return string;
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/psi/KtPsiFactory$ClassHeaderBuilder$State;", "", "(Ljava/lang/String;I)V", "MODIFIERS", "NAME", "TYPE_PARAMETERS", "BASE_CLASS", "TYPE_CONSTRAINTS", "DONE", "kotlin-compiler"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State MODIFIERS;
            public static final /* enum */ State NAME;
            public static final /* enum */ State TYPE_PARAMETERS;
            public static final /* enum */ State BASE_CLASS;
            public static final /* enum */ State TYPE_CONSTRAINTS;
            public static final /* enum */ State DONE;
            private static final /* synthetic */ State[] $VALUES;

            static {
                State[] stateArray = new State[6];
                State[] stateArray2 = stateArray;
                stateArray[0] = MODIFIERS = new State();
                stateArray[1] = NAME = new State();
                stateArray[2] = TYPE_PARAMETERS = new State();
                stateArray[3] = BASE_CLASS = new State();
                stateArray[4] = TYPE_CONSTRAINTS = new State();
                stateArray[5] = DONE = new State();
                $VALUES = stateArray;
            }

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String string) {
                return Enum.valueOf(State.class, string);
            }
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u0000 &2\u00020\u0001:\u0003&'(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\nJ\b\u0010\r\u001a\u00020\nH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\nJ\u0010\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0013\u001a\u00020\nJ\u0006\u0010\u0014\u001a\u00020\u0000J\"\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\nJ\b\u0010\u0018\u001a\u00020\u000fH\u0002J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\nJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\nJ\u001f\u0010\u001e\u001a\u00020\u000f2\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0 \u00a2\u0006\u0002\b!J\u0014\u0010\"\u001a\u00020\u00002\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0$J\u0016\u0010%\u001a\u00020\u00002\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0$R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/psi/KtPsiFactory$CallableBuilder;", "", "target", "Lorg/jetbrains/kotlin/psi/KtPsiFactory$CallableBuilder$Target;", "(Lorg/jetbrains/kotlin/psi/KtPsiFactory$CallableBuilder$Target;)V", "sb", "Ljava/lang/StringBuilder;", "state", "Lorg/jetbrains/kotlin/psi/KtPsiFactory$CallableBuilder$State;", "asString", "", "blockBody", "body", "bodyPrefix", "closeParams", "", "initializer", "lazyBody", "modifier", "name", "noReturnType", "param", "type", "defaultValue", "placeKeyword", "receiver", "receiverType", "returnType", "superDelegation", "argumentList", "transform", "f", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "typeConstraints", "values", "", "typeParams", "Companion", "State", "Target", "kotlin-compiler"})
    public static final class CallableBuilder {
        private final StringBuilder sb;
        private State state;
        private final Target target;
        @NotNull
        private static final String CONSTRUCTOR_NAME;
        public static final Companion Companion;

        private final void closeParams() {
            if (Intrinsics.areEqual((Object)this.target, (Object)Target.FUNCTION) || Intrinsics.areEqual((Object)this.target, (Object)Target.CONSTRUCTOR)) {
                boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.FIRST_PARAM) || Intrinsics.areEqual((Object)this.state, (Object)State.REST_PARAMS);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                this.sb.append(")");
            }
            this.state = State.TYPE_CONSTRAINTS;
        }

        private final void placeKeyword() {
            String string;
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.MODIFIERS);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            CharSequence charSequence = this.sb;
            if (charSequence.length() > 0) {
                this.sb.append(" ");
            }
            switch (KtPsiFactory$CallableBuilder$WhenMappings.$EnumSwitchMapping$0[this.target.ordinal()]) {
                case 1: {
                    string = "fun";
                    break;
                }
                case 2: {
                    string = "";
                    break;
                }
                case 3: {
                    string = "val";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String keyword = string;
            this.sb.append(keyword + " ");
            this.state = State.RECEIVER;
        }

        private final String bodyPrefix() {
            String string;
            switch (KtPsiFactory$CallableBuilder$WhenMappings.$EnumSwitchMapping$1[this.target.ordinal()]) {
                case 1: 
                case 2: {
                    string = "";
                    break;
                }
                case 3: {
                    string = "\nget()";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        @NotNull
        public final CallableBuilder modifier(@NotNull String modifier) {
            Intrinsics.checkParameterIsNotNull(modifier, "modifier");
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.MODIFIERS);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.sb.append(modifier);
            return this;
        }

        @NotNull
        public final CallableBuilder typeParams(@NotNull Collection<String> values) {
            Intrinsics.checkParameterIsNotNull(values, "values");
            this.placeKeyword();
            if (!values.isEmpty()) {
                this.sb.append(CollectionsKt.joinToString$default(values, ", ", "<", "> ", -1, "", null, 32, null));
            }
            return this;
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CallableBuilder typeParams$default(CallableBuilder callableBuilder, Collection collection, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: typeParams");
            }
            if ((n & 1) != 0) {
                collection = CollectionsKt.emptyList();
            }
            return callableBuilder.typeParams(collection);
        }

        @NotNull
        public final CallableBuilder receiver(@NotNull String receiverType) {
            Intrinsics.checkParameterIsNotNull(receiverType, "receiverType");
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.RECEIVER);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.sb.append(receiverType).append(".");
            this.state = State.NAME;
            return this;
        }

        @NotNull
        public final CallableBuilder name(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.NAME) || Intrinsics.areEqual((Object)this.state, (Object)State.RECEIVER);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            bl = Intrinsics.areEqual(name, Companion.getCONSTRUCTOR_NAME()) ^ true || Intrinsics.areEqual((Object)this.target, (Object)Target.CONSTRUCTOR);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.sb.append(name);
            switch (KtPsiFactory$CallableBuilder$WhenMappings.$EnumSwitchMapping$2[this.target.ordinal()]) {
                case 1: 
                case 2: {
                    this.sb.append("(");
                    this.state = State.FIRST_PARAM;
                    break;
                }
                default: {
                    this.state = State.TYPE_CONSTRAINTS;
                }
            }
            return this;
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CallableBuilder name$default(CallableBuilder callableBuilder, String string, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: name");
            }
            if ((n & 1) != 0) {
                String string2 = Companion.getCONSTRUCTOR_NAME();
                Intrinsics.checkExpressionValueIsNotNull(string2, "CONSTRUCTOR_NAME");
                string = string2;
            }
            return callableBuilder.name(string);
        }

        @NotNull
        public final CallableBuilder param(@NotNull String name, @NotNull String type2, @Nullable String defaultValue) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(type2, "type");
            boolean bl = Intrinsics.areEqual((Object)this.target, (Object)Target.FUNCTION) || Intrinsics.areEqual((Object)this.target, (Object)Target.CONSTRUCTOR);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            bl = Intrinsics.areEqual((Object)this.state, (Object)State.FIRST_PARAM) || Intrinsics.areEqual((Object)this.state, (Object)State.REST_PARAMS);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (Intrinsics.areEqual((Object)this.state, (Object)State.REST_PARAMS)) {
                this.sb.append(", ");
            }
            this.sb.append(name).append(": ").append(type2);
            if (defaultValue != null) {
                this.sb.append("= ").append(defaultValue);
            }
            if (Intrinsics.areEqual((Object)this.state, (Object)State.FIRST_PARAM)) {
                this.state = State.REST_PARAMS;
            }
            return this;
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CallableBuilder param$default(CallableBuilder callableBuilder, String string, String string2, String string3, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: param");
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            return callableBuilder.param(string, string2, string3);
        }

        @NotNull
        public final CallableBuilder returnType(@NotNull String type2) {
            Intrinsics.checkParameterIsNotNull(type2, "type");
            this.closeParams();
            this.sb.append(": ").append(type2);
            return this;
        }

        @NotNull
        public final CallableBuilder noReturnType() {
            this.closeParams();
            return this;
        }

        @NotNull
        public final CallableBuilder typeConstraints(@NotNull Collection<String> values) {
            Intrinsics.checkParameterIsNotNull(values, "values");
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.TYPE_CONSTRAINTS) && Intrinsics.areEqual((Object)this.target, (Object)Target.CONSTRUCTOR) ^ true;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (!values.isEmpty()) {
                this.sb.append(CollectionsKt.joinToString$default(values, ", ", " where ", "", -1, "", null, 32, null));
            }
            this.state = State.BODY;
            return this;
        }

        @NotNull
        public final CallableBuilder superDelegation(@NotNull String argumentList2) {
            Intrinsics.checkParameterIsNotNull(argumentList2, "argumentList");
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.TYPE_CONSTRAINTS) && Intrinsics.areEqual((Object)this.target, (Object)Target.CONSTRUCTOR);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.sb.append(": super").append(argumentList2);
            this.state = State.BODY;
            return this;
        }

        @NotNull
        public final CallableBuilder blockBody(@NotNull String body) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            boolean bl = Intrinsics.areEqual((Object)this.state, (Object)State.BODY) || Intrinsics.areEqual((Object)this.state, (Object)State.TYPE_CONSTRAINTS);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.sb.append(this.bodyPrefix()).append(" {\n").append(body).append("\n}");
            this.state = State.DONE;
            return this;
        }

        @NotNull
        public final CallableBuilder initializer(@NotNull String body) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            boolean bl = Intrinsics.areEqual((Object)this.target, (Object)Target.READ_ONLY_PROPERTY) && (Intrinsics.areEqual((Object)this.state, (Object)State.BODY) || Intrinsics.areEqual((Object)this.state, (Object)State.TYPE_CONSTRAINTS));
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.sb.append(" = ").append(body);
            this.state = State.DONE;
            return this;
        }

        @NotNull
        public final CallableBuilder lazyBody(@NotNull String body) {
            Intrinsics.checkParameterIsNotNull(body, "body");
            boolean bl = Intrinsics.areEqual((Object)this.target, (Object)Target.READ_ONLY_PROPERTY) && (Intrinsics.areEqual((Object)this.state, (Object)State.BODY) || Intrinsics.areEqual((Object)this.state, (Object)State.TYPE_CONSTRAINTS));
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.sb.append(" by kotlin.lazy {\n").append(body).append("\n}");
            this.state = State.DONE;
            return this;
        }

        public final void transform(@NotNull Function1<? super StringBuilder, Unit> f) {
            Intrinsics.checkParameterIsNotNull(f, "f");
            f.invoke(this.sb);
        }

        @NotNull
        public final String asString() {
            if (Intrinsics.areEqual((Object)this.state, (Object)State.DONE) ^ true) {
                this.state = State.DONE;
            }
            String string = this.sb.toString();
            Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
            return string;
        }

        public CallableBuilder(@NotNull Target target) {
            Intrinsics.checkParameterIsNotNull((Object)target, "target");
            this.target = target;
            this.sb = new StringBuilder();
            this.state = State.MODIFIERS;
        }

        static {
            Companion = new Companion(null);
            CONSTRUCTOR_NAME = KtTokens.CONSTRUCTOR_KEYWORD.getValue();
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/psi/KtPsiFactory$CallableBuilder$Target;", "", "(Ljava/lang/String;I)V", "FUNCTION", "CONSTRUCTOR", "READ_ONLY_PROPERTY", "kotlin-compiler"})
        public static final class Target
        extends Enum<Target> {
            public static final /* enum */ Target FUNCTION;
            public static final /* enum */ Target CONSTRUCTOR;
            public static final /* enum */ Target READ_ONLY_PROPERTY;
            private static final /* synthetic */ Target[] $VALUES;

            static {
                Target[] targetArray = new Target[3];
                Target[] targetArray2 = targetArray;
                targetArray[0] = FUNCTION = new Target();
                targetArray[1] = CONSTRUCTOR = new Target();
                targetArray[2] = READ_ONLY_PROPERTY = new Target();
                $VALUES = targetArray;
            }

            public static Target[] values() {
                return (Target[])$VALUES.clone();
            }

            public static Target valueOf(String string) {
                return Enum.valueOf(Target.class, string);
            }
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/psi/KtPsiFactory$CallableBuilder$State;", "", "(Ljava/lang/String;I)V", "MODIFIERS", "NAME", "RECEIVER", "FIRST_PARAM", "REST_PARAMS", "TYPE_CONSTRAINTS", "BODY", "DONE", "kotlin-compiler"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State MODIFIERS;
            public static final /* enum */ State NAME;
            public static final /* enum */ State RECEIVER;
            public static final /* enum */ State FIRST_PARAM;
            public static final /* enum */ State REST_PARAMS;
            public static final /* enum */ State TYPE_CONSTRAINTS;
            public static final /* enum */ State BODY;
            public static final /* enum */ State DONE;
            private static final /* synthetic */ State[] $VALUES;

            static {
                State[] stateArray = new State[8];
                State[] stateArray2 = stateArray;
                stateArray[0] = MODIFIERS = new State();
                stateArray[1] = NAME = new State();
                stateArray[2] = RECEIVER = new State();
                stateArray[3] = FIRST_PARAM = new State();
                stateArray[4] = REST_PARAMS = new State();
                stateArray[5] = TYPE_CONSTRAINTS = new State();
                stateArray[6] = BODY = new State();
                stateArray[7] = DONE = new State();
                $VALUES = stateArray;
            }

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String string) {
                return Enum.valueOf(State.class, string);
            }
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/psi/KtPsiFactory$CallableBuilder$Companion;", "", "()V", "CONSTRUCTOR_NAME", "", "Lorg/jetbrains/annotations/NotNull;", "getCONSTRUCTOR_NAME", "()Ljava/lang/String;", "kotlin-compiler"})
        public static final class Companion {
            @NotNull
            public final String getCONSTRUCTOR_NAME() {
                return CONSTRUCTOR_NAME;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/psi/KtPsiFactory$BlockWrapper;", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "Lorg/jetbrains/kotlin/psi/KtPsiUtil$KtExpressionWrapper;", "fakeBlockExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/psi/KtBlockExpression;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "getBaseExpression", "getStatements", "", "kotlin-compiler"})
    private static final class BlockWrapper
    extends KtBlockExpression
    implements KtPsiUtil.KtExpressionWrapper {
        private final KtExpression expression;

        @Override
        @NotNull
        public List<KtExpression> getStatements() {
            return CollectionsKt.listOf(this.expression);
        }

        @Override
        @NotNull
        public KtExpression getBaseExpression() {
            return this.expression;
        }

        public BlockWrapper(@NotNull KtBlockExpression fakeBlockExpression, @NotNull KtExpression expression) {
            Intrinsics.checkParameterIsNotNull(fakeBlockExpression, "fakeBlockExpression");
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            super(fakeBlockExpression.getNode());
            this.expression = expression;
        }
    }
}

