/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.util.PerformanceCounter;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClass;", "Lorg/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "className", "Lorg/jetbrains/kotlin/name/ClassId;", "classHeader", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "innerClasses", "Lorg/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$InnerClassesInfo;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;Lorg/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$InnerClassesInfo;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "location", "", "getLocation", "()Ljava/lang/String;", "equals", "", "other", "", "getFileContents", "", "hashCode", "", "toString", "Factory", "kotlin-compiler"})
public final class VirtualFileKotlinClass
extends FileBasedKotlinClass {
    @NotNull
    private final VirtualFile file;
    private static final Logger LOG;
    private static final PerformanceCounter perfCounter;
    public static final Factory Factory;

    @Override
    @NotNull
    public String getLocation() {
        String string = this.file.getPath();
        Intrinsics.checkExpressionValueIsNotNull(string, "file.path");
        return string;
    }

    @Override
    @NotNull
    protected byte[] getFileContents() {
        try {
            byte[] byArray = this.file.contentsToByteArray();
            Intrinsics.checkExpressionValueIsNotNull(byArray, "file.contentsToByteArray()");
            return byArray;
        }
        catch (IOException e) {
            VirtualFileKotlinClass.Factory.getLOG().error(VirtualFileKotlinClass.Factory.renderFileReadingErrorMessage(this.file), e);
            throw (Throwable)ExceptionUtilsKt.rethrow(e);
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof VirtualFileKotlinClass && Intrinsics.areEqual(((VirtualFileKotlinClass)other).file, this.file);
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.file;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    private VirtualFileKotlinClass(VirtualFile file, ClassId className2, KotlinClassHeader classHeader, FileBasedKotlinClass.InnerClassesInfo innerClasses2) {
        super(className2, classHeader, innerClasses2);
        this.file = file;
    }

    static {
        Factory = new Factory(null);
        LOG = Logger.getInstance(VirtualFileKotlinClass.class);
        perfCounter = PerformanceCounter.Companion.create$default(PerformanceCounter.Companion, "Binary class from Kotlin file", false, 2, null);
    }

    public /* synthetic */ VirtualFileKotlinClass(@NotNull VirtualFile file, @NotNull ClassId className2, @NotNull KotlinClassHeader classHeader, @NotNull FileBasedKotlinClass.InnerClassesInfo innerClasses2, DefaultConstructorMarker $constructor_marker) {
        this(file, className2, classHeader, innerClasses2);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClass$Factory;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "perfCounter", "Lorg/jetbrains/kotlin/util/PerformanceCounter;", "getPerfCounter", "()Lorg/jetbrains/kotlin/util/PerformanceCounter;", "create", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClass;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileContent", "", "renderFileReadingErrorMessage", "", "kotlin-compiler"})
    public static final class Factory {
        private final Logger getLOG() {
            return LOG;
        }

        private final PerformanceCounter getPerfCounter() {
            return perfCounter;
        }

        @Deprecated(message="Use KotlinBinaryClassCache")
        @Nullable
        public final VirtualFileKotlinClass create(@NotNull VirtualFile file, @Nullable byte[] fileContent) {
            Intrinsics.checkParameterIsNotNull(file, "file");
            return (VirtualFileKotlinClass)this.getPerfCounter().time((Function0)new Function0<VirtualFileKotlinClass>(file, fileContent){
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ byte[] $fileContent;

                @Nullable
                public final VirtualFileKotlinClass invoke() {
                    boolean bl = Intrinsics.areEqual(this.$file.getFileType(), JavaClassFileType.INSTANCE);
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Trying to read binary data from a non-class file " + this.$file;
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    try {
                        byte[] byteContent;
                        byte[] byArray = this.$fileContent;
                        if (this.$fileContent == null) {
                            byte[] byArray2 = this.$file.contentsToByteArray(false);
                            byArray = byArray2;
                            Intrinsics.checkExpressionValueIsNotNull(byArray2, "file.contentsToByteArray(false)");
                        }
                        byte[] byArray3 = byteContent = byArray;
                        if (!(byArray3.length == 0)) {
                            return (VirtualFileKotlinClass)FileBasedKotlinClass.create(byteContent, (Function3)new Function3<ClassId, KotlinClassHeader, FileBasedKotlinClass.InnerClassesInfo, VirtualFileKotlinClass>(this){
                                final /* synthetic */ create.1 this$0;

                                @NotNull
                                public final VirtualFileKotlinClass invoke(ClassId name, KotlinClassHeader header, FileBasedKotlinClass.InnerClassesInfo innerClasses2) {
                                    VirtualFile virtualFile = this.this$0.$file;
                                    ClassId classId = name;
                                    Intrinsics.checkExpressionValueIsNotNull(classId, "name");
                                    KotlinClassHeader kotlinClassHeader = header;
                                    Intrinsics.checkExpressionValueIsNotNull(kotlinClassHeader, "header");
                                    FileBasedKotlinClass.InnerClassesInfo innerClassesInfo = innerClasses2;
                                    Intrinsics.checkExpressionValueIsNotNull(innerClassesInfo, "innerClasses");
                                    return new VirtualFileKotlinClass(virtualFile, classId, kotlinClassHeader, innerClassesInfo, null);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(3);
                                }
                            });
                        }
                    }
                    catch (FileNotFoundException e) {
                    }
                    catch (Throwable e) {
                        org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass$Factory.access$getLOG$p(VirtualFileKotlinClass.Factory).warn(org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass$Factory.access$renderFileReadingErrorMessage(VirtualFileKotlinClass.Factory, this.$file));
                    }
                    return null;
                }
                {
                    this.$file = virtualFile;
                    this.$fileContent = byArray;
                    super(0);
                }
            });
        }

        private final String renderFileReadingErrorMessage(VirtualFile file) {
            return "Could not read file: " + file.getPath() + "; size in bytes: " + file.getLength() + "; file type: " + file.getFileType().getName();
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

