/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.facade;

import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.util.TextOutput;
import com.google.dart.compiler.util.TextOutputImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputBinaryFile;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFile;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFileCollection;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.facade.SourceMapBuilderConsumer;
import org.jetbrains.kotlin.js.sourceMap.JsSourceGenerationVisitor;
import org.jetbrains.kotlin.js.sourceMap.SourceMap3Builder;
import org.jetbrains.kotlin.js.sourceMap.SourceMapBuilder;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/facade/TranslationResult;", "", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "(Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;)V", "getDiagnostics", "()Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "Fail", "Success", "kotlin-compiler"})
public abstract class TranslationResult {
    @NotNull
    private final Diagnostics diagnostics;

    @NotNull
    public final Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    protected TranslationResult(@NotNull Diagnostics diagnostics2) {
        Intrinsics.checkParameterIsNotNull(diagnostics2, "diagnostics");
        this.diagnostics = diagnostics2;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/js/facade/TranslationResult$Fail;", "Lorg/jetbrains/kotlin/js/facade/TranslationResult;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "(Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;)V", "kotlin-compiler"})
    public static final class Fail
    extends TranslationResult {
        public Fail(@NotNull Diagnostics diagnostics2) {
            Intrinsics.checkParameterIsNotNull(diagnostics2, "diagnostics");
            super(diagnostics2);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0012\u001a\u00020\fJ\u001a\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/js/facade/TranslationResult$Success;", "Lorg/jetbrains/kotlin/js/facade/TranslationResult;", "config", "Lorg/jetbrains/kotlin/js/config/JsConfig;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "program", "Lcom/google/dart/compiler/backend/js/ast/JsProgram;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "importedModules", "", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "(Lorg/jetbrains/kotlin/js/config/JsConfig;Ljava/util/List;Lcom/google/dart/compiler/backend/js/ast/JsProgram;Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;Ljava/util/List;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "getProgram", "()Lcom/google/dart/compiler/backend/js/ast/JsProgram;", "getCode", "output", "Lcom/google/dart/compiler/util/TextOutput;", "sourceMapBuilder", "Lorg/jetbrains/kotlin/js/sourceMap/SourceMapBuilder;", "getOutputFiles", "Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;", "outputFile", "Ljava/io/File;", "outputPrefixFile", "outputPostfixFile", "kotlin-compiler"})
    public static final class Success
    extends TranslationResult {
        private final JsConfig config;
        private final List<KtFile> files;
        @NotNull
        private final JsProgram program;
        private final List<String> importedModules;
        private final ModuleDescriptor moduleDescriptor;

        @NotNull
        public final String getCode() {
            return this.getCode(new TextOutputImpl(), null);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final OutputFileCollection getOutputFiles(@NotNull File outputFile, @Nullable File outputPrefixFile, @Nullable File outputPostfixFile) {
            Object metaFileName;
            Object virtualFile;
            ModuleKind it;
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            Object object;
            Object prefix;
            Intrinsics.checkParameterIsNotNull(outputFile, "outputFile");
            TextOutputImpl output = new TextOutputImpl();
            SourceMap3Builder sourceMapBuilder = this.config.isSourcemap() ? new SourceMap3Builder(outputFile, output, new SourceMapBuilderConsumer()) : (SourceMap3Builder)null;
            String code = this.getCode(output, sourceMapBuilder);
            Object object2 = outputPrefixFile;
            if (object2 == null || (object2 = FilesKt.readText$default((File)object2, null, 1, null)) == null) {
                object2 = prefix = "";
            }
            if ((object = outputPostfixFile) == null || (object = FilesKt.readText$default((File)object, null, 1, null)) == null) {
                object = "";
            }
            Object postfix = object;
            Iterable iterable = this.files;
            void var11_10 = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                File file;
                KtFile ktFile = (KtFile)item$iv$iv;
                void var20_16 = destination$iv$iv;
                virtualFile = ((PsiFileImpl)((Object)it)).getOriginalFile().getVirtualFile();
                if (virtualFile == null) {
                    file = new File(((KtFile)((Object)it)).getName());
                } else {
                    File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                    file = file2;
                    Intrinsics.checkExpressionValueIsNotNull(file2, "VfsUtilCore.virtualToIoFile(virtualFile)");
                }
                File file3 = file;
                var20_16.add(file3);
            }
            List sourceFiles2 = (List)destination$iv$iv;
            String string = outputFile.getName();
            Intrinsics.checkExpressionValueIsNotNull(string, "outputFile.name");
            SimpleOutputFile jsFile = new SimpleOutputFile(sourceFiles2, string, (String)prefix + code + (String)postfix);
            ArrayList<OutputFile> outputFiles = CollectionsKt.arrayListOf(jsFile);
            if (this.config.isMetaInfo()) {
                Object item$iv$iv;
                String string2 = outputFile.getName();
                Intrinsics.checkExpressionValueIsNotNull(string2, "outputFile.name");
                metaFileName = KotlinJavascriptMetadataUtils.INSTANCE.replaceSuffix(string2);
                String string3 = this.config.getModuleId();
                Intrinsics.checkExpressionValueIsNotNull(string3, "config.moduleId");
                ModuleKind moduleKind = this.config.getModuleKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleKind, "config.moduleKind");
                item$iv$iv = this.importedModules;
                it = moduleKind;
                virtualFile = this.moduleDescriptor;
                JsModuleDescriptor<Object> moduleDescription = new JsModuleDescriptor<Object>(string3, it, (List<String>)item$iv$iv, virtualFile);
                String metaFileContent = KotlinJavascriptSerializationUtil.INSTANCE.metadataAsString(moduleDescription);
                ArrayList sourceFilesForMetaFile = new ArrayList(sourceFiles2);
                SimpleOutputFile jsMetaFile = new SimpleOutputFile(sourceFilesForMetaFile, (String)metaFileName, metaFileContent);
                outputFiles.add(jsMetaFile);
            }
            if (this.config.isKjsm()) {
                void $receiver$iv2;
                metaFileName = KotlinJavascriptSerializationUtil.INSTANCE.toContentMap(this.moduleDescriptor);
                Iterator iterator2 = $receiver$iv2;
                Iterator iterator3 = iterator2.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it2 = element$iv = iterator3.next();
                    outputFiles.add(new SimpleOutputBinaryFile(CollectionsKt.emptyList(), this.config.getModuleId() + '/' + (String)it2.getKey(), (byte[])it2.getValue()));
                }
            }
            if (sourceMapBuilder != null) {
                sourceMapBuilder.skipLinesAtBeginning(StringUtil.getLineBreakCount((CharSequence)prefix));
                String string4 = sourceMapBuilder.getOutFile().getName();
                Intrinsics.checkExpressionValueIsNotNull(string4, "sourceMapBuilder.outFile.name");
                String string5 = sourceMapBuilder.build();
                Intrinsics.checkExpressionValueIsNotNull(string5, "sourceMapBuilder.build()");
                SimpleOutputFile sourceMapFile = new SimpleOutputFile(sourceFiles2, string4, string5);
                outputFiles.add(sourceMapFile);
            }
            return new SimpleOutputFileCollection((List<? extends OutputFile>)outputFiles);
        }

        private final String getCode(TextOutput output, SourceMapBuilder sourceMapBuilder) {
            this.program.accept(new JsSourceGenerationVisitor(output, sourceMapBuilder));
            return output.toString();
        }

        @NotNull
        public final JsProgram getProgram() {
            return this.program;
        }

        public Success(@NotNull JsConfig config, @NotNull List<? extends KtFile> files2, @NotNull JsProgram program, @NotNull Diagnostics diagnostics2, @NotNull List<String> importedModules, @NotNull ModuleDescriptor moduleDescriptor) {
            Intrinsics.checkParameterIsNotNull(config, "config");
            Intrinsics.checkParameterIsNotNull(files2, "files");
            Intrinsics.checkParameterIsNotNull(program, "program");
            Intrinsics.checkParameterIsNotNull(diagnostics2, "diagnostics");
            Intrinsics.checkParameterIsNotNull(importedModules, "importedModules");
            Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
            super(diagnostics2);
            this.config = config;
            this.files = files2;
            this.program = program;
            this.importedModules = importedModules;
            this.moduleDescriptor = moduleDescriptor;
        }
    }
}

