/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.builder;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.builder.InnerKotlinClassLightClassData;
import org.jetbrains.kotlin.asJava.builder.InvalidLightClassData;
import org.jetbrains.kotlin.asJava.builder.LightClassConstructionContext;
import org.jetbrains.kotlin.asJava.builder.LightClassDataProvider;
import org.jetbrains.kotlin.asJava.builder.OutermostKotlinClassLightClassData;
import org.jetbrains.kotlin.asJava.builder.WithFileStubAndExtraDiagnostics;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.PackageContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.JvmFileClassesProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0016J\u0016\u0010$\u001a\u00020%2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0016J\b\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/asJava/builder/LightClassDataProviderForClassOrObject;", "Lorg/jetbrains/kotlin/asJava/builder/LightClassDataProvider;", "Lorg/jetbrains/kotlin/asJava/builder/WithFileStubAndExtraDiagnostics;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;)V", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "files", "", "getFiles", "()Ljava/util/Collection;", "generateClassFilter", "Lorg/jetbrains/kotlin/codegen/state/GenerationState$GenerateClassFilter;", "getGenerateClassFilter", "()Lorg/jetbrains/kotlin/codegen/state/GenerationState$GenerateClassFilter;", "isLocal", "", "()Z", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "createLightClassData", "javaFileStub", "Lcom/intellij/psi/impl/java/stubs/PsiJavaFileStub;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "extraDiagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "generate", "", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "getContext", "Lorg/jetbrains/kotlin/asJava/builder/LightClassConstructionContext;", "toString", "", "kotlin-compiler"})
public final class LightClassDataProviderForClassOrObject
extends LightClassDataProvider<WithFileStubAndExtraDiagnostics> {
    private final KtClassOrObject classOrObject;

    private final KtFile getFile() {
        KtFile ktFile = this.classOrObject.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull(ktFile, "classOrObject.getContainingKtFile()");
        return ktFile;
    }

    @Override
    public boolean isLocal() {
        return this.classOrObject.isLocal();
    }

    @Override
    @NotNull
    public LightClassConstructionContext getContext(@NotNull Collection<? extends KtFile> files2) {
        Intrinsics.checkParameterIsNotNull(files2, "files");
        LightClassConstructionContext lightClassConstructionContext = LightClassGenerationSupport.getInstance(this.classOrObject.getProject()).getContextForClassOrObject(this.classOrObject);
        Intrinsics.checkExpressionValueIsNotNull(lightClassConstructionContext, "LightClassGenerationSupp\u2026ssOrObject(classOrObject)");
        return lightClassConstructionContext;
    }

    @Override
    @NotNull
    public WithFileStubAndExtraDiagnostics createLightClassData(@NotNull PsiJavaFileStub javaFileStub, @NotNull BindingContext bindingContext, @NotNull Diagnostics extraDiagnostics) {
        Intrinsics.checkParameterIsNotNull(javaFileStub, "javaFileStub");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(extraDiagnostics, "extraDiagnostics");
        ClassDescriptor classDescriptor = (ClassDescriptor)bindingContext.get(BindingContext.CLASS, this.classOrObject);
        if (classDescriptor == null) {
            return InvalidLightClassData.INSTANCE;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        Collection<ClassDescriptor> allInnerClasses = CodegenBinding.getAllInnerClasses(bindingContext, classDescriptor2);
        HashMap<KtClassOrObject, InnerKotlinClassLightClassData> innerClassesMap = ContainerUtil.newHashMap();
        for (ClassDescriptor innerClassDescriptor : allInnerClasses) {
            KtClassOrObject declaration;
            DeclarationDescriptor declarationDescriptor = innerClassDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "innerClassDescriptor");
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
            if (!(psiElement instanceof KtClassOrObject)) {
                psiElement = null;
            }
            if ((KtClassOrObject)psiElement == null) {
                continue;
            }
            innerClassesMap.put(declaration, new InnerKotlinClassLightClassData(declaration));
        }
        Map map2 = innerClassesMap;
        Intrinsics.checkExpressionValueIsNotNull(map2, "innerClassesMap");
        return new OutermostKotlinClassLightClassData(javaFileStub, extraDiagnostics, this.classOrObject, map2);
    }

    @Override
    @NotNull
    public Collection<KtFile> getFiles() {
        return CollectionsKt.listOf(this.getFile());
    }

    @Override
    @NotNull
    public FqName getPackageFqName() {
        FqName fqName2 = this.getFile().getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "file.packageFqName");
        return fqName2;
    }

    @Override
    @NotNull
    public GenerationState.GenerateClassFilter getGenerateClassFilter() {
        return new GenerationState.GenerateClassFilter(this){
            final /* synthetic */ LightClassDataProviderForClassOrObject this$0;

            public boolean shouldGeneratePackagePart(@NotNull KtFile jetFile) {
                Intrinsics.checkParameterIsNotNull(jetFile, "jetFile");
                return true;
            }

            public boolean shouldAnnotateClass(@NotNull KtClassOrObject processingClassOrObject) {
                Intrinsics.checkParameterIsNotNull(processingClassOrObject, "processingClassOrObject");
                return this.shouldGenerateClass(processingClassOrObject);
            }

            public boolean shouldGenerateClass(@NotNull KtClassOrObject processingClassOrObject) {
                Intrinsics.checkParameterIsNotNull(processingClassOrObject, "processingClassOrObject");
                if (LightClassDataProviderForClassOrObject.access$getClassOrObject$p(this.this$0) == processingClassOrObject) {
                    return true;
                }
                if (PsiTreeUtil.isAncestor(LightClassDataProviderForClassOrObject.access$getClassOrObject$p(this.this$0), processingClassOrObject, true) || PsiTreeUtil.isAncestor(processingClassOrObject, LightClassDataProviderForClassOrObject.access$getClassOrObject$p(this.this$0), true)) {
                    return true;
                }
                if (LightClassDataProviderForClassOrObject.access$getClassOrObject$p(this.this$0).isLocal() && processingClassOrObject.isLocal()) {
                    PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)LightClassDataProviderForClassOrObject.access$getClassOrObject$p(this.this$0), (PsiElement)processingClassOrObject);
                    return commonParent != null && !(commonParent instanceof PsiFile);
                }
                return false;
            }

            public boolean shouldGenerateScript(@NotNull KtScript script) {
                Intrinsics.checkParameterIsNotNull(script, "script");
                return PsiTreeUtil.isAncestor(script, LightClassDataProviderForClassOrObject.access$getClassOrObject$p(this.this$0), false);
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @Override
    public void generate(@NotNull GenerationState state2, @NotNull Collection<? extends KtFile> files2) {
        Intrinsics.checkParameterIsNotNull(state2, "state");
        Intrinsics.checkParameterIsNotNull(files2, "files");
        PackageCodegen packageCodegen = state2.getFactory().forPackage(this.getPackageFqName(), files2);
        KtFile file = this.classOrObject.getContainingKtFile();
        JvmFileClassesProvider jvmFileClassesProvider = state2.getFileClassesProvider();
        KtFile ktFile = file;
        Intrinsics.checkExpressionValueIsNotNull(ktFile, "file");
        Type packagePartType = FileClasses.getFileClassType(jvmFileClassesProvider, ktFile);
        PackageContext context = state2.getRootContext().intoPackagePart(packageCodegen.getPackageFragment(), packagePartType, file);
        packageCodegen.generateClassOrObject(this.classOrObject, context);
        state2.getFactory().asList();
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + " for " + this.classOrObject.getName();
    }

    public LightClassDataProviderForClassOrObject(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkParameterIsNotNull(classOrObject, "classOrObject");
        Project project = classOrObject.getProject();
        Intrinsics.checkExpressionValueIsNotNull(project, "classOrObject.project");
        super(project);
        this.classOrObject = classOrObject;
    }

    @NotNull
    public static final /* synthetic */ KtClassOrObject access$getClassOrObject$p(LightClassDataProviderForClassOrObject $this) {
        return $this.classOrObject;
    }
}

