/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.augment.TypeAnnotationModifier;
import com.intellij.psi.impl.light.LightTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceIncorporationPhase;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceVariable
extends LightTypeParameter {
    private final PsiElement myContext;
    private boolean myThrownBound;
    private final Map<InferenceBound, List<PsiType>> myBounds = new HashMap<InferenceBound, List<PsiType>>();
    private final String myName;
    private PsiType myInstantiation = PsiType.NULL;

    public PsiTypeParameter getParameter() {
        return this.getDelegate();
    }

    InferenceVariable(PsiElement context, PsiTypeParameter parameter, String name) {
        super(parameter);
        this.myName = name;
        this.myContext = context;
        TypeConversionUtil.markAsFreshVariable(this, context);
    }

    public PsiType getInstantiation() {
        return this.myInstantiation;
    }

    public void setInstantiation(PsiType instantiation) {
        this.myInstantiation = instantiation;
    }

    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        ArrayList<PsiClassType> result2 = new ArrayList<PsiClassType>();
        for (PsiType type2 : this.getBounds(InferenceBound.UPPER)) {
            if (!(type2 instanceof PsiClassType)) continue;
            result2.add((PsiClassType)type2);
        }
        PsiClassType[] psiClassTypeArray = result2.toArray(new PsiClassType[result2.size()]);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceVariable", "getExtendsListTypes"));
        }
        return psiClassTypeArray;
    }

    public static void addBound(PsiType inferenceVariableType, PsiType boundType, InferenceBound inferenceBound, InferenceSession session) {
        InferenceVariable variable = session.getInferenceVariable(inferenceVariableType);
        if (variable != null) {
            for (TypeAnnotationModifier modifier : TypeAnnotationModifier.EP_NAME.getExtensions()) {
                TypeAnnotationProvider annotationProvider;
                if (!(boundType instanceof PsiClassType) || (annotationProvider = modifier.modifyAnnotations(inferenceVariableType, (PsiClassType)boundType)) == null) continue;
                boundType = boundType.annotate(annotationProvider);
            }
            variable.addBound(boundType, inferenceBound, session.myIncorporationPhase);
        }
    }

    public boolean addBound(PsiType classType, InferenceBound inferenceBound, @Nullable InferenceIncorporationPhase incorporationPhase) {
        if (inferenceBound == InferenceBound.EQ && PsiUtil.resolveClassInClassTypeOnly(classType) == this) {
            return false;
        }
        List<PsiType> bounds = this.myBounds.get((Object)inferenceBound);
        if (bounds == null) {
            bounds = new ArrayList<PsiType>();
            this.myBounds.put(inferenceBound, bounds);
        }
        if (classType == null) {
            classType = PsiType.NULL;
        }
        if (incorporationPhase == null || !bounds.contains(classType)) {
            bounds.add(classType);
            if (incorporationPhase != null) {
                incorporationPhase.addBound(this, classType, inferenceBound);
            }
            return true;
        }
        return false;
    }

    public List<PsiType> getBounds(InferenceBound inferenceBound) {
        List<PsiType> bounds = this.myBounds.get((Object)inferenceBound);
        return bounds != null ? new ArrayList<PsiType>(bounds) : Collections.emptyList();
    }

    public List<PsiType> getReadOnlyBounds(InferenceBound inferenceBound) {
        List<PsiType> bounds = this.myBounds.get((Object)inferenceBound);
        return bounds != null ? bounds : Collections.emptyList();
    }

    public Set<InferenceVariable> getDependencies(InferenceSession session) {
        LinkedHashSet<InferenceVariable> dependencies = new LinkedHashSet<InferenceVariable>();
        this.collectBoundDependencies(session, dependencies);
        this.collectTransitiveDependencies(session, dependencies, dependencies);
        if (!session.hasCapture(this) && dependencies.isEmpty()) {
            return dependencies;
        }
        if (!session.hasCapture(this)) {
            return dependencies;
        }
        Iterator iterator2 = dependencies.iterator();
        while (iterator2.hasNext()) {
            if (session.hasCapture((InferenceVariable)iterator2.next())) continue;
            iterator2.remove();
        }
        session.collectCaptureDependencies(this, dependencies);
        return dependencies;
    }

    private void collectTransitiveDependencies(InferenceSession session, Set<InferenceVariable> dependencies, Set<InferenceVariable> rootDependencies) {
        LinkedHashSet<InferenceVariable> newDependencies = new LinkedHashSet<InferenceVariable>();
        for (InferenceVariable dependency : dependencies) {
            dependency.collectBoundDependencies(session, newDependencies);
        }
        newDependencies.removeAll(rootDependencies);
        newDependencies.remove(this);
        if (!newDependencies.isEmpty()) {
            rootDependencies.addAll(newDependencies);
            this.collectTransitiveDependencies(session, newDependencies, rootDependencies);
        }
    }

    private void collectBoundDependencies(InferenceSession session, Set<InferenceVariable> dependencies) {
        for (Collection collection : this.myBounds.values()) {
            if (collection == null) continue;
            for (PsiType bound : collection) {
                session.collectDependencies(bound, dependencies);
            }
        }
    }

    public boolean isThrownBound() {
        return this.myThrownBound;
    }

    public void setThrownBound() {
        this.myThrownBound = true;
    }

    @Override
    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/source/resolve/graphInference/InferenceVariable", "isInheritor"));
        }
        for (PsiType type2 : this.getBounds(InferenceBound.UPPER)) {
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(type2);
            if (psiClass == null) continue;
            if (this.getManager().areElementsEquivalent(baseClass, psiClass)) {
                return true;
            }
            if (!checkDeep || !psiClass.isInheritor(baseClass, true)) continue;
            return true;
        }
        return super.isInheritor(baseClass, checkDeep);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        if (this == another) {
            return true;
        }
        return this.getDelegate() == another && this.myContext != null && !PsiTreeUtil.isAncestor(((PsiTypeParameter)another).getOwner(), this.myContext, false);
    }

    @Override
    public boolean useDelegateToSubstitute() {
        return false;
    }

    @Override
    public String toString() {
        return this.getDelegate().toString();
    }

    @Override
    public PsiTypeParameterListOwner getOwner() {
        return null;
    }

    @Override
    @Nullable
    public String getName() {
        return this.myName;
    }

    public PsiElement getCallContext() {
        return this.myContext;
    }
}

