/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public abstract class AbstractExtensionPointBean
implements PluginAware {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.extensions.AbstractExtensionPointBean");
    protected PluginDescriptor myPluginDescriptor;

    @Override
    public final void setPluginDescriptor(PluginDescriptor pluginDescriptor) {
        this.myPluginDescriptor = pluginDescriptor;
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.myPluginDescriptor;
    }

    @NotNull
    public final <T> Class<T> findClass(String className2) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(className2, true, this.getLoaderForClass());
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/AbstractExtensionPointBean", "findClass"));
        }
        return clazz;
    }

    @Nullable
    public final <T> Class<T> findClassNoExceptions(String className2) {
        try {
            return this.findClass(className2);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Problem loading class " + className2 + " from plugin " + this.myPluginDescriptor.getPluginId().getIdString(), e);
            return null;
        }
    }

    @NotNull
    public ClassLoader getLoaderForClass() {
        ClassLoader classLoader = this.myPluginDescriptor == null ? this.getClass().getClassLoader() : this.myPluginDescriptor.getPluginClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/AbstractExtensionPointBean", "getLoaderForClass"));
        }
        return classLoader;
    }

    @NotNull
    public final <T> T instantiate(String className2, @NotNull PicoContainer container) throws ClassNotFoundException {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/openapi/extensions/AbstractExtensionPointBean", "instantiate"));
        }
        T t = AbstractExtensionPointBean.instantiate(this.findClass(className2), container);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/AbstractExtensionPointBean", "instantiate"));
        }
        return t;
    }

    @NotNull
    public static <T> T instantiate(@NotNull Class<T> aClass2, @NotNull PicoContainer container) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/openapi/extensions/AbstractExtensionPointBean", "instantiate"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/openapi/extensions/AbstractExtensionPointBean", "instantiate"));
        }
        T t = AbstractExtensionPointBean.instantiate(aClass2, container, false);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/AbstractExtensionPointBean", "instantiate"));
        }
        return t;
    }

    @NotNull
    public static <T> T instantiate(@NotNull Class<T> aClass2, @NotNull PicoContainer container, boolean allowNonPublicClasses) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/openapi/extensions/AbstractExtensionPointBean", "instantiate"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/openapi/extensions/AbstractExtensionPointBean", "instantiate"));
        }
        Object object = new CachingConstructorInjectionComponentAdapter(aClass2.getName(), aClass2, null, allowNonPublicClasses).getComponentInstance(container);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/AbstractExtensionPointBean", "instantiate"));
        }
        return (T)object;
    }
}

