/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.annotation.WrappedAnnotated;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public abstract class AnnotationCodegen {
    public static final List<JvmFlagAnnotation> FIELD_FLAGS = Arrays.asList(new JvmFlagAnnotation("kotlin.jvm.Volatile", 64), new JvmFlagAnnotation("kotlin.jvm.Transient", 128));
    public static final List<JvmFlagAnnotation> METHOD_FLAGS = Arrays.asList(new JvmFlagAnnotation("kotlin.jvm.Strictfp", 2048), new JvmFlagAnnotation("kotlin.jvm.Synchronized", 32));
    private static final AnnotationVisitor NO_ANNOTATION_VISITOR = new AnnotationVisitor(327680){};
    private final KotlinTypeMapper typeMapper;
    private static final Map<KotlinTarget, ElementType> annotationTargetMap = new EnumMap<KotlinTarget, ElementType>(KotlinTarget.class);
    private static final Map<KotlinRetention, RetentionPolicy> annotationRetentionMap;

    private AnnotationCodegen(KotlinTypeMapper mapper) {
        this.typeMapper = mapper;
    }

    public void genAnnotations(@Nullable Annotated annotated, @Nullable Type returnType2) {
        this.genAnnotations(annotated, returnType2, null);
    }

    public void genAnnotations(@Nullable Annotated annotated, @Nullable Type returnType2, @Nullable AnnotationUseSiteTarget allowedTarget) {
        if (annotated == null) {
            return;
        }
        HashSet<String> annotationDescriptorsAlreadyPresent = new HashSet<String>();
        Annotations annotations2 = annotated.getAnnotations();
        for (AnnotationWithTarget annotationWithTarget : annotations2.getAllAnnotations()) {
            ClassDescriptor classDescriptor;
            AnnotationDescriptor annotation2 = annotationWithTarget.getAnnotation();
            AnnotationUseSiteTarget annotationTarget = annotationWithTarget.getTarget();
            if (allowedTarget == null && annotationTarget != null || allowedTarget != null && annotationTarget != null && allowedTarget != annotationTarget) continue;
            Set<KotlinTarget> applicableTargets = AnnotationChecker.applicableTargetSet(annotation2);
            if (annotated instanceof AnonymousFunctionDescriptor && !applicableTargets.contains((Object)KotlinTarget.FUNCTION) && !applicableTargets.contains((Object)KotlinTarget.PROPERTY_GETTER) && !applicableTargets.contains((Object)KotlinTarget.PROPERTY_SETTER)) {
                assert (applicableTargets.contains((Object)KotlinTarget.EXPRESSION)) : "Inconsistent target list for lambda annotation: " + applicableTargets + " on " + annotated;
                continue;
            }
            if (annotated instanceof ClassDescriptor && !applicableTargets.contains((Object)KotlinTarget.CLASS) && !applicableTargets.contains((Object)KotlinTarget.ANNOTATION_CLASS) && (classDescriptor = (ClassDescriptor)annotated).getVisibility() == Visibilities.LOCAL) {
                assert (applicableTargets.contains((Object)KotlinTarget.EXPRESSION)) : "Inconsistent target list for object literal annotation: " + applicableTargets + " on " + annotated;
                continue;
            }
            String descriptor2 = this.genAnnotation(annotation2);
            if (descriptor2 == null) continue;
            annotationDescriptorsAlreadyPresent.add(descriptor2);
        }
        this.generateAdditionalAnnotations(annotated, returnType2, annotationDescriptorsAlreadyPresent);
    }

    private void generateAdditionalAnnotations(@NotNull Annotated annotated, @Nullable Type returnType2, @NotNull Set<String> annotationDescriptorsAlreadyPresent) {
        ClassDescriptor classDescriptor;
        if (annotated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "generateAdditionalAnnotations"));
        }
        if (annotationDescriptorsAlreadyPresent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDescriptorsAlreadyPresent", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "generateAdditionalAnnotations"));
        }
        Annotated unwrapped = annotated;
        if (annotated instanceof WrappedAnnotated) {
            unwrapped = ((WrappedAnnotated)annotated).getOriginalAnnotated();
        }
        if (unwrapped instanceof CallableDescriptor) {
            CallableDescriptor descriptor2 = (CallableDescriptor)unwrapped;
            if (AnnotationCodegen.isInvisibleFromTheOutside(descriptor2)) {
                return;
            }
            if (descriptor2 instanceof ValueParameterDescriptor && AnnotationCodegen.isInvisibleFromTheOutside(descriptor2.getContainingDeclaration())) {
                return;
            }
            if (returnType2 != null && !AsmUtil.isPrimitive(returnType2)) {
                this.generateNullabilityAnnotation(descriptor2.getReturnType(), annotationDescriptorsAlreadyPresent);
            }
        }
        if (unwrapped instanceof ClassDescriptor && (classDescriptor = (ClassDescriptor)unwrapped).getKind() == ClassKind.ANNOTATION_CLASS) {
            this.generateDocumentedAnnotation(classDescriptor, annotationDescriptorsAlreadyPresent);
            this.generateRetentionAnnotation(classDescriptor, annotationDescriptorsAlreadyPresent);
            this.generateTargetAnnotation(classDescriptor, annotationDescriptorsAlreadyPresent);
        }
    }

    private static boolean isInvisibleFromTheOutside(@Nullable DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof CallableMemberDescriptor && KotlinTypeMapper.isAccessor((CallableMemberDescriptor)descriptor2)) {
            return false;
        }
        if (descriptor2 instanceof MemberDescriptor) {
            return AsmUtil.getVisibilityAccessFlag((MemberDescriptor)descriptor2) == 2;
        }
        return false;
    }

    private void generateNullabilityAnnotation(@Nullable KotlinType type2, @NotNull Set<String> annotationDescriptorsAlreadyPresent) {
        Flexibility flexibility;
        if (annotationDescriptorsAlreadyPresent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDescriptorsAlreadyPresent", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "generateNullabilityAnnotation"));
        }
        if (type2 == null) {
            return;
        }
        if (AnnotationCodegen.isBareTypeParameterWithNullableUpperBound(type2)) {
            return;
        }
        if (FlexibleTypesKt.isFlexible(type2) && !TypeUtils.isNullableType((flexibility = FlexibleTypesKt.flexibility(type2)).getLowerBound()) && TypeUtils.isNullableType(flexibility.getUpperBound())) {
            AnnotationDescriptor notNull = type2.getAnnotations().findAnnotation(JvmAnnotationNames.JETBRAINS_NOT_NULL_ANNOTATION);
            if (notNull != null) {
                this.generateAnnotationIfNotPresent(annotationDescriptorsAlreadyPresent, NotNull.class);
            }
            return;
        }
        boolean isNullableType = TypeUtils.isNullableType(type2);
        Class annotationClass = isNullableType ? Nullable.class : NotNull.class;
        this.generateAnnotationIfNotPresent(annotationDescriptorsAlreadyPresent, annotationClass);
    }

    private void generateTargetAnnotation(@NotNull ClassDescriptor classDescriptor, @NotNull Set<String> annotationDescriptorsAlreadyPresent) {
        Set<ElementType> javaTargets;
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "generateTargetAnnotation"));
        }
        if (annotationDescriptorsAlreadyPresent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDescriptorsAlreadyPresent", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "generateTargetAnnotation"));
        }
        String descriptor2 = Type.getType(Target.class).getDescriptor();
        if (!annotationDescriptorsAlreadyPresent.add(descriptor2)) {
            return;
        }
        Set<KotlinTarget> targets = AnnotationChecker.Companion.applicableTargetSet(classDescriptor);
        if (targets == null) {
            javaTargets = this.getJavaTargetList(classDescriptor);
            if (javaTargets == null) {
                return;
            }
        } else {
            javaTargets = EnumSet.noneOf(ElementType.class);
            for (KotlinTarget target : targets) {
                if (annotationTargetMap.get((Object)target) == null) continue;
                javaTargets.add(annotationTargetMap.get((Object)target));
            }
        }
        AnnotationVisitor visitor2 = this.visitAnnotation(descriptor2, true);
        AnnotationVisitor arrayVisitor = visitor2.visitArray("value");
        for (ElementType javaTarget : javaTargets) {
            arrayVisitor.visitEnum(null, Type.getType(ElementType.class).getDescriptor(), javaTarget.name());
        }
        arrayVisitor.visitEnd();
        visitor2.visitEnd();
    }

    private void generateRetentionAnnotation(@NotNull ClassDescriptor classDescriptor, @NotNull Set<String> annotationDescriptorsAlreadyPresent) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "generateRetentionAnnotation"));
        }
        if (annotationDescriptorsAlreadyPresent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDescriptorsAlreadyPresent", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "generateRetentionAnnotation"));
        }
        RetentionPolicy policy = this.getRetentionPolicy(classDescriptor);
        String descriptor2 = Type.getType(Retention.class).getDescriptor();
        if (!annotationDescriptorsAlreadyPresent.add(descriptor2)) {
            return;
        }
        AnnotationVisitor visitor2 = this.visitAnnotation(descriptor2, true);
        visitor2.visitEnum("value", Type.getType(RetentionPolicy.class).getDescriptor(), policy.name());
        visitor2.visitEnd();
    }

    private void generateDocumentedAnnotation(@NotNull ClassDescriptor classDescriptor, @NotNull Set<String> annotationDescriptorsAlreadyPresent) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "generateDocumentedAnnotation"));
        }
        if (annotationDescriptorsAlreadyPresent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDescriptorsAlreadyPresent", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "generateDocumentedAnnotation"));
        }
        boolean documented = DescriptorUtilsKt.isDocumentedAnnotation(classDescriptor);
        if (!documented) {
            return;
        }
        String descriptor2 = Type.getType(Documented.class).getDescriptor();
        if (!annotationDescriptorsAlreadyPresent.add(descriptor2)) {
            return;
        }
        AnnotationVisitor visitor2 = this.visitAnnotation(descriptor2, true);
        visitor2.visitEnd();
    }

    private void generateAnnotationIfNotPresent(Set<String> annotationDescriptorsAlreadyPresent, Class<?> annotationClass) {
        String descriptor2 = Type.getType(annotationClass).getDescriptor();
        if (!annotationDescriptorsAlreadyPresent.contains(descriptor2)) {
            this.visitAnnotation(descriptor2, false).visitEnd();
        }
    }

    private static boolean isBareTypeParameterWithNullableUpperBound(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "isBareTypeParameterWithNullableUpperBound"));
        }
        ClassifierDescriptor classifier2 = type2.getConstructor().getDeclarationDescriptor();
        return !type2.isMarkedNullable() && classifier2 instanceof TypeParameterDescriptor && TypeUtils.hasNullableSuperType(type2);
    }

    public void generateAnnotationDefaultValue(@NotNull ConstantValue<?> value, @NotNull KotlinType expectedType) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "generateAnnotationDefaultValue"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "generateAnnotationDefaultValue"));
        }
        AnnotationVisitor visitor2 = this.visitAnnotation(null, false);
        this.genCompileTimeValue(null, value, visitor2);
        visitor2.visitEnd();
    }

    @Nullable
    private String genAnnotation(@NotNull AnnotationDescriptor annotationDescriptor) {
        if (annotationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDescriptor", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "genAnnotation"));
        }
        ClassifierDescriptor classifierDescriptor = annotationDescriptor.getType().getConstructor().getDeclarationDescriptor();
        assert (classifierDescriptor != null) : "Annotation descriptor has no class: " + annotationDescriptor;
        RetentionPolicy rp = this.getRetentionPolicy(classifierDescriptor);
        if (rp == RetentionPolicy.SOURCE && !this.typeMapper.getClassBuilderMode().generateSourceRetentionAnnotations) {
            return null;
        }
        String descriptor2 = this.typeMapper.mapType(annotationDescriptor.getType()).getDescriptor();
        AnnotationVisitor annotationVisitor = this.visitAnnotation(descriptor2, rp == RetentionPolicy.RUNTIME);
        this.genAnnotationArguments(annotationDescriptor, annotationVisitor);
        annotationVisitor.visitEnd();
        return descriptor2;
    }

    private void genAnnotationArguments(AnnotationDescriptor annotationDescriptor, AnnotationVisitor annotationVisitor) {
        for (Map.Entry<ValueParameterDescriptor, ConstantValue<?>> entry : annotationDescriptor.getAllValueArguments().entrySet()) {
            ValueParameterDescriptor descriptor2 = entry.getKey();
            String name = descriptor2.getName().asString();
            this.genCompileTimeValue(name, entry.getValue(), annotationVisitor);
        }
    }

    private void genCompileTimeValue(final @Nullable String name, @NotNull ConstantValue<?> value, final @NotNull AnnotationVisitor annotationVisitor) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "genCompileTimeValue"));
        }
        if (annotationVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationVisitor", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "genCompileTimeValue"));
        }
        AnnotationArgumentVisitor<Void, Void> argumentVisitor = new AnnotationArgumentVisitor<Void, Void>(){

            @Override
            public Void visitLongValue(@NotNull LongValue value, Void data) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/AnnotationCodegen$2", "visitLongValue"));
                }
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitIntValue(IntValue value, Void data) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitShortValue(ShortValue value, Void data) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitByteValue(ByteValue value, Void data) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitDoubleValue(DoubleValue value, Void data) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitFloatValue(FloatValue value, Void data) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitBooleanValue(BooleanValue value, Void data) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitCharValue(CharValue value, Void data) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitStringValue(StringValue value, Void data) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitEnumValue(EnumValue value, Void data) {
                String propertyName = ((ClassDescriptor)value.getValue()).getName().asString();
                annotationVisitor.visitEnum(name, AnnotationCodegen.this.typeMapper.mapType(value.getType()).getDescriptor(), propertyName);
                return null;
            }

            @Override
            public Void visitArrayValue(ArrayValue value, Void data) {
                AnnotationVisitor visitor2 = annotationVisitor.visitArray(name);
                for (ConstantValue argument : (List)value.getValue()) {
                    AnnotationCodegen.this.genCompileTimeValue(null, argument, visitor2);
                }
                visitor2.visitEnd();
                return null;
            }

            @Override
            public Void visitAnnotationValue(AnnotationValue value, Void data) {
                String internalAnnName = AnnotationCodegen.this.typeMapper.mapType(((AnnotationDescriptor)value.getValue()).getType()).getDescriptor();
                AnnotationVisitor visitor2 = annotationVisitor.visitAnnotation(name, internalAnnName);
                AnnotationCodegen.this.genAnnotationArguments((AnnotationDescriptor)value.getValue(), visitor2);
                visitor2.visitEnd();
                return null;
            }

            @Override
            public Void visitKClassValue(KClassValue value, Void data) {
                annotationVisitor.visit(name, AnnotationCodegen.this.typeMapper.mapType(value.getValue()));
                return null;
            }

            private Void visitSimpleValue(ConstantValue<?> value) {
                annotationVisitor.visit(name, value.getValue());
                return null;
            }

            @Override
            public Void visitErrorValue(ErrorValue value, Void data) {
                return this.visitUnsupportedValue(value);
            }

            @Override
            public Void visitNullValue(NullValue value, Void data) {
                return this.visitUnsupportedValue(value);
            }

            private Void visitUnsupportedValue(ConstantValue<?> value) {
                ClassBuilderMode mode = AnnotationCodegen.this.typeMapper.getClassBuilderMode();
                if (mode.generateBodies) {
                    throw new IllegalStateException("Don't know how to compile annotation value " + value);
                }
                return null;
            }
        };
        value.accept(argumentVisitor, null);
    }

    @Nullable
    private Set<ElementType> getJavaTargetList(ClassDescriptor descriptor2) {
        ConstantValue<?> compileTimeConstant;
        Collection<ConstantValue<?>> valueArguments2;
        AnnotationDescriptor targetAnnotation = descriptor2.getAnnotations().findAnnotation(new FqName(Target.class.getName()));
        if (targetAnnotation != null && !(valueArguments2 = targetAnnotation.getAllValueArguments().values()).isEmpty() && (compileTimeConstant = valueArguments2.iterator().next()) instanceof ArrayValue) {
            List values = (List)((ArrayValue)compileTimeConstant).getValue();
            EnumSet<ElementType> result2 = EnumSet.noneOf(ElementType.class);
            for (ConstantValue value : values) {
                ClassDescriptor enumEntry;
                KotlinType classObjectType;
                if (!(value instanceof EnumValue) || (classObjectType = DescriptorUtilsKt.getClassValueType(enumEntry = (ClassDescriptor)((EnumValue)value).getValue())) == null || !"java/lang/annotation/ElementType".equals(this.typeMapper.mapType(classObjectType).getInternalName())) continue;
                result2.add(ElementType.valueOf(enumEntry.getName().asString()));
            }
            return result2;
        }
        return null;
    }

    @NotNull
    private RetentionPolicy getRetentionPolicy(@NotNull Annotated descriptor2) {
        ClassDescriptor enumEntry;
        KotlinType classObjectType;
        ConstantValue<?> compileTimeConstant;
        Collection<ConstantValue<?>> valueArguments2;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "getRetentionPolicy"));
        }
        KotlinRetention retention = DescriptorUtilsKt.getAnnotationRetention(descriptor2);
        if (retention != null) {
            RetentionPolicy retentionPolicy = annotationRetentionMap.get((Object)retention);
            if (retentionPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "getRetentionPolicy"));
            }
            return retentionPolicy;
        }
        AnnotationDescriptor retentionAnnotation = descriptor2.getAnnotations().findAnnotation(new FqName(Retention.class.getName()));
        if (retentionAnnotation != null && !(valueArguments2 = retentionAnnotation.getAllValueArguments().values()).isEmpty() && (compileTimeConstant = valueArguments2.iterator().next()) instanceof EnumValue && (classObjectType = DescriptorUtilsKt.getClassValueType(enumEntry = (ClassDescriptor)((EnumValue)compileTimeConstant).getValue())) != null && "java/lang/annotation/RetentionPolicy".equals(this.typeMapper.mapType(classObjectType).getInternalName())) {
            RetentionPolicy retentionPolicy = RetentionPolicy.valueOf(enumEntry.getName().asString());
            if (retentionPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "getRetentionPolicy"));
            }
            return retentionPolicy;
        }
        RetentionPolicy retentionPolicy = RetentionPolicy.RUNTIME;
        if (retentionPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "getRetentionPolicy"));
        }
        return retentionPolicy;
    }

    @NotNull
    abstract AnnotationVisitor visitAnnotation(String var1, boolean var2);

    public static AnnotationCodegen forClass(final ClassVisitor cv, KotlinTypeMapper mapper) {
        return new AnnotationCodegen(mapper){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(cv.visitAnnotation(descr, visible));
                if (annotationVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AnnotationCodegen$3", "visitAnnotation"));
                }
                return annotationVisitor;
            }
        };
    }

    public static AnnotationCodegen forMethod(final MethodVisitor mv, KotlinTypeMapper mapper) {
        return new AnnotationCodegen(mapper){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(mv.visitAnnotation(descr, visible));
                if (annotationVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AnnotationCodegen$4", "visitAnnotation"));
                }
                return annotationVisitor;
            }
        };
    }

    public static AnnotationCodegen forField(final FieldVisitor fv, KotlinTypeMapper mapper) {
        return new AnnotationCodegen(mapper){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(fv.visitAnnotation(descr, visible));
                if (annotationVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AnnotationCodegen$5", "visitAnnotation"));
                }
                return annotationVisitor;
            }
        };
    }

    public static AnnotationCodegen forParameter(final int parameter, final MethodVisitor mv, KotlinTypeMapper mapper) {
        return new AnnotationCodegen(mapper){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(mv.visitParameterAnnotation(parameter, descr, visible));
                if (annotationVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AnnotationCodegen$6", "visitAnnotation"));
                }
                return annotationVisitor;
            }
        };
    }

    public static AnnotationCodegen forAnnotationDefaultValue(final MethodVisitor mv, KotlinTypeMapper mapper) {
        return new AnnotationCodegen(mapper){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(mv.visitAnnotationDefault());
                if (annotationVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AnnotationCodegen$7", "visitAnnotation"));
                }
                return annotationVisitor;
            }
        };
    }

    @NotNull
    private static AnnotationVisitor safe(@Nullable AnnotationVisitor av) {
        AnnotationVisitor annotationVisitor = av == null ? NO_ANNOTATION_VISITOR : av;
        if (annotationVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "safe"));
        }
        return annotationVisitor;
    }

    static {
        annotationTargetMap.put(KotlinTarget.CLASS, ElementType.TYPE);
        annotationTargetMap.put(KotlinTarget.ANNOTATION_CLASS, ElementType.ANNOTATION_TYPE);
        annotationTargetMap.put(KotlinTarget.CONSTRUCTOR, ElementType.CONSTRUCTOR);
        annotationTargetMap.put(KotlinTarget.LOCAL_VARIABLE, ElementType.LOCAL_VARIABLE);
        annotationTargetMap.put(KotlinTarget.FUNCTION, ElementType.METHOD);
        annotationTargetMap.put(KotlinTarget.PROPERTY_GETTER, ElementType.METHOD);
        annotationTargetMap.put(KotlinTarget.PROPERTY_SETTER, ElementType.METHOD);
        annotationTargetMap.put(KotlinTarget.FIELD, ElementType.FIELD);
        annotationTargetMap.put(KotlinTarget.VALUE_PARAMETER, ElementType.PARAMETER);
        annotationRetentionMap = new EnumMap<KotlinRetention, RetentionPolicy>(KotlinRetention.class);
        annotationRetentionMap.put(KotlinRetention.SOURCE, RetentionPolicy.SOURCE);
        annotationRetentionMap.put(KotlinRetention.BINARY, RetentionPolicy.CLASS);
        annotationRetentionMap.put(KotlinRetention.RUNTIME, RetentionPolicy.RUNTIME);
    }

    public static final class JvmFlagAnnotation {
        private final FqName fqName;
        private final int jvmFlag;

        public JvmFlagAnnotation(@NotNull String fqName2, int jvmFlag) {
            if (fqName2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/codegen/AnnotationCodegen$JvmFlagAnnotation", "<init>"));
            }
            this.fqName = new FqName(fqName2);
            this.jvmFlag = jvmFlag;
        }

        public boolean hasAnnotation(@NotNull Annotated annotated) {
            if (annotated == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/kotlin/codegen/AnnotationCodegen$JvmFlagAnnotation", "hasAnnotation"));
            }
            return Annotations.Companion.findAnyAnnotation(annotated.getAnnotations(), this.fqName) != null;
        }

        public int getJvmFlag() {
            return this.jvmFlag;
        }
    }
}

