/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SignatureParsing {
    private SignatureParsing() {
    }

    @NotNull
    public static List<Pair<String, String[]>> parseTypeParametersDeclaration(CharacterIterator signature2, Function<String, String> mapping) throws ClsFormatException {
        if (signature2.current() != '<') {
            List<Pair<String, String[]>> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/SignatureParsing", "parseTypeParametersDeclaration"));
            }
            return list2;
        }
        ArrayList<Pair<String, String[]>> typeParameters = ContainerUtil.newArrayList();
        signature2.next();
        while (signature2.current() != '>') {
            typeParameters.add(SignatureParsing.parseTypeParameter(signature2, mapping));
        }
        signature2.next();
        ArrayList<Pair<String, String[]>> arrayList = typeParameters;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/SignatureParsing", "parseTypeParametersDeclaration"));
        }
        return arrayList;
    }

    private static Pair<String, String[]> parseTypeParameter(CharacterIterator signature2, Function<String, String> mapping) throws ClsFormatException {
        StringBuilder name = new StringBuilder();
        while (signature2.current() != ':' && signature2.current() != '\uffff') {
            name.append(signature2.current());
            signature2.next();
        }
        if (signature2.current() == '\uffff') {
            throw new ClsFormatException();
        }
        String parameterName = mapping.fun(name.toString());
        List bounds = null;
        boolean jlo = false;
        while (signature2.current() == ':') {
            signature2.next();
            String bound = SignatureParsing.parseTopLevelClassRefSignature(signature2, mapping);
            if (bound == null) continue;
            if (bounds == null) {
                if ("java.lang.Object".equals(bound)) {
                    jlo = true;
                    continue;
                }
                bounds = ContainerUtil.newSmartList();
                if (jlo) {
                    bounds.add("java.lang.Object");
                }
            }
            bounds.add(bound);
        }
        return Pair.pair(parameterName, ArrayUtil.toStringArray(bounds));
    }

    @Nullable
    public static String parseTopLevelClassRefSignature(CharacterIterator signature2, Function<String, String> mapping) throws ClsFormatException {
        switch (signature2.current()) {
            case 'L': {
                return SignatureParsing.parseParameterizedClassRefSignature(signature2, mapping);
            }
            case 'T': {
                return SignatureParsing.parseTypeVariableRefSignature(signature2);
            }
        }
        return null;
    }

    private static String parseTypeVariableRefSignature(CharacterIterator signature2) throws ClsFormatException {
        StringBuilder id = new StringBuilder();
        signature2.next();
        while (signature2.current() != ';' && signature2.current() != '>' && signature2.current() != '\uffff') {
            id.append(signature2.current());
            signature2.next();
        }
        if (signature2.current() == '\uffff') {
            throw new ClsFormatException();
        }
        if (signature2.current() == ';') {
            signature2.next();
        }
        return id.toString();
    }

    private static String parseParameterizedClassRefSignature(CharacterIterator signature2, Function<String, String> mapping) throws ClsFormatException {
        StringBuilder canonicalText = new StringBuilder();
        boolean mapped = false;
        signature2.next();
        while (signature2.current() != ';' && signature2.current() != '\uffff') {
            char c = signature2.current();
            if (c == '<') {
                canonicalText = new StringBuilder(mapping.fun(canonicalText.toString()));
                mapped = true;
                boolean firstArg = true;
                signature2.next();
                do {
                    canonicalText.append(firstArg ? (char)'<' : ',').append(SignatureParsing.parseClassOrTypeVariableElement(signature2, mapping));
                    firstArg = false;
                } while (signature2.current() != '>');
                canonicalText.append('>');
            } else if (c != ' ') {
                canonicalText.append(c);
            }
            signature2.next();
        }
        if (signature2.current() == '\uffff') {
            throw new ClsFormatException();
        }
        signature2.next();
        String text = canonicalText.toString();
        if (!mapped) {
            text = mapping.fun(text);
        }
        return text;
    }

    private static String parseClassOrTypeVariableElement(CharacterIterator signature2, Function<String, String> mapping) throws ClsFormatException {
        char variance = SignatureParsing.parseVariance(signature2);
        if (variance == '*') {
            return SignatureParsing.decorateTypeText(null, variance);
        }
        int dimensions = SignatureParsing.parseDimensions(signature2);
        String text = SignatureParsing.parseTypeWithoutVariance(signature2, mapping);
        if (text == null) {
            throw new ClsFormatException();
        }
        if (dimensions > 0) {
            text = text + StringUtil.repeat("[]", dimensions);
        }
        return SignatureParsing.decorateTypeText(text, variance);
    }

    private static String decorateTypeText(String canonical, char variance) {
        switch (variance) {
            case '\u0000': {
                return canonical;
            }
            case '+': {
                return "? extends " + canonical;
            }
            case '-': {
                return "? super " + canonical;
            }
            case '*': {
                return "?";
            }
        }
        assert (false) : "unknown variance";
        return null;
    }

    private static char parseVariance(CharacterIterator signature2) {
        char variance;
        switch (signature2.current()) {
            case '*': 
            case '+': 
            case '-': {
                variance = signature2.current();
                signature2.next();
                break;
            }
            case '.': 
            case '=': {
                signature2.next();
            }
            default: {
                variance = '\u0000';
            }
        }
        return variance;
    }

    private static int parseDimensions(CharacterIterator signature2) {
        int dimensions = 0;
        while (signature2.current() == '[') {
            ++dimensions;
            signature2.next();
        }
        return dimensions;
    }

    @NotNull
    public static String parseTypeString(CharacterIterator signature2, Function<String, String> mapping) throws ClsFormatException {
        int dimensions = SignatureParsing.parseDimensions(signature2);
        String text = SignatureParsing.parseTypeWithoutVariance(signature2, mapping);
        if (text == null) {
            throw new ClsFormatException();
        }
        if (dimensions > 0) {
            text = text + StringUtil.repeat("[]", dimensions);
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/SignatureParsing", "parseTypeString"));
        }
        return string;
    }

    @Nullable
    private static String parseTypeWithoutVariance(CharacterIterator signature2, Function<String, String> mapping) throws ClsFormatException {
        String text = null;
        switch (signature2.current()) {
            case 'L': {
                text = SignatureParsing.parseParameterizedClassRefSignature(signature2, mapping);
                break;
            }
            case 'T': {
                text = SignatureParsing.parseTypeVariableRefSignature(signature2);
                break;
            }
            case 'B': {
                text = "byte";
                signature2.next();
                break;
            }
            case 'C': {
                text = "char";
                signature2.next();
                break;
            }
            case 'D': {
                text = "double";
                signature2.next();
                break;
            }
            case 'F': {
                text = "float";
                signature2.next();
                break;
            }
            case 'I': {
                text = "int";
                signature2.next();
                break;
            }
            case 'J': {
                text = "long";
                signature2.next();
                break;
            }
            case 'S': {
                text = "short";
                signature2.next();
                break;
            }
            case 'Z': {
                text = "boolean";
                signature2.next();
                break;
            }
            case 'V': {
                text = "void";
                signature2.next();
            }
        }
        return text;
    }
}

