/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.UIUtil;
import javax.swing.UIManager;

public class JBUI {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.JBUI");
    private static float scaleFactor = 1.0f;

    private static void calculateScaleFactor() {
        if (SystemInfo.isMac) {
            LOG.info("UI scale factor: 1.0");
            scaleFactor = 1.0f;
            return;
        }
        if (SystemProperties.has("hidpi") && !SystemProperties.is("hidpi")) {
            LOG.info("UI scale factor: 1.0");
            scaleFactor = 1.0f;
            return;
        }
        UIUtil.initSystemFontData();
        Pair<String, Integer> fdata = UIUtil.getSystemFontData();
        int size = fdata != null ? fdata.getSecond().intValue() : Fonts.label().getSize();
        JBUI.setScaleFactor((float)size / 12.0f);
    }

    public static void setScaleFactor(float scale) {
        if (SystemProperties.has("hidpi") && !SystemProperties.is("hidpi")) {
            return;
        }
        scale = scale < 1.25f ? 1.0f : (scale < 1.5f ? 1.25f : (scale < 1.75f ? 1.5f : (scale < 2.0f ? 1.75f : 2.0f)));
        if (SystemInfo.isLinux && scale == 1.25f) {
            scale = 1.0f;
        }
        if (scaleFactor == scale) {
            return;
        }
        LOG.info("UI scale factor: " + scale);
        scaleFactor = scale;
        IconLoader.setScale(scale);
    }

    public static float scale(float f) {
        return f * scaleFactor;
    }

    static {
        JBUI.calculateScaleFactor();
    }

    public static class Fonts {
        public static JBFont label() {
            return JBFont.create(UIManager.getFont("Label.font"), false);
        }
    }
}

