/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JBIterator<E>
implements Iterator<E> {
    private static final Object NONE = new String("#none");
    private static final Object STOP = new String("#stop");
    private static final Object SKIP = new String("#skip");
    private Object myCurrent = NONE;
    private Object myNext = NONE;
    private Op myFirstOp = new Op<Object>(null);
    private Op myLastOp = this.myFirstOp;
    private static final Condition<JBIterator<?>> ADVANCE = new Condition<JBIterator<?>>(){

        @Override
        public boolean value(JBIterator<?> it) {
            return it.advance();
        }
    };

    @NotNull
    public static <E> JBIterator<E> from(@NotNull Iterator<E> it) {
        if (it == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "it", "com/intellij/util/containers/JBIterator", "from"));
        }
        JBIterator<E> jBIterator = it instanceof JBIterator ? (JBIterator<E>)it : JBIterator.wrap(it);
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "from"));
        }
        return jBIterator;
    }

    @NotNull
    static <E> JBIterator<E> wrap(final @NotNull Iterator<E> it) {
        if (it == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "it", "com/intellij/util/containers/JBIterator", "wrap"));
        }
        JBIterator jBIterator = new JBIterator<E>(){

            @Override
            protected E nextImpl() {
                return it.hasNext() ? it.next() : this.stop();
            }
        };
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "wrap"));
        }
        return jBIterator;
    }

    protected abstract E nextImpl();

    protected void currentChanged() {
    }

    @Nullable
    protected final E stop() {
        this.myNext = STOP;
        return null;
    }

    @Nullable
    protected final E skip() {
        this.myNext = SKIP;
        return null;
    }

    @Override
    public final boolean hasNext() {
        this.peekNext();
        return this.myNext != STOP;
    }

    @Override
    public final E next() {
        this.advance();
        return this.current();
    }

    public final boolean advance() {
        this.myCurrent = NONE;
        this.peekNext();
        if (this.myNext == STOP) {
            return false;
        }
        this.myCurrent = this.myNext;
        this.myNext = NONE;
        this.currentChanged();
        return true;
    }

    public final E current() {
        if (this.myCurrent == NONE) {
            throw new NoSuchElementException();
        }
        return (E)this.myCurrent;
    }

    private void peekNext() {
        if (this.myNext != NONE) {
            return;
        }
        Object o = NONE;
        Op op = this.myFirstOp;
        while (op != null) {
            Object object = o = op.impl == null ? this.nextImpl() : op.apply(o);
            if (this.myNext == SKIP) {
                o = this.myNext = NONE;
                op = null;
            }
            if (this.myNext == STOP) {
                return;
            }
            op = op == null ? this.myFirstOp : op.nextOp;
        }
        this.myNext = o;
    }

    @NotNull
    public final <T> JBIterator<T> transform(@NotNull Function<? super E, T> function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/util/containers/JBIterator", "transform"));
        }
        JBIterator jBIterator = (JBIterator)this.addOp(true, new TransformOp<E, T>(function));
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "transform"));
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> filter(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/JBIterator", "filter"));
        }
        JBIterator jBIterator = (JBIterator)this.addOp(true, new FilterOp<E>(condition));
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "filter"));
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> take(int count) {
        JBIterator jBIterator = (JBIterator)this.addOp(this.myLastOp.impl != null, new WhileOp(new CountDown(count)));
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "take"));
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> takeWhile(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/JBIterator", "takeWhile"));
        }
        JBIterator jBIterator = (JBIterator)this.addOp(true, new WhileOp<E>(condition));
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "takeWhile"));
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> skip(int count) {
        JBIterator jBIterator = this.skipWhile(new CountDown(count));
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "skip"));
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> skipWhile(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/JBIterator", "skipWhile"));
        }
        JBIterator jBIterator = (JBIterator)this.addOp(true, new SkipOp<E>(condition));
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "skipWhile"));
        }
        return jBIterator;
    }

    @NotNull
    private <T> T addOp(boolean last, @NotNull Op op) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/util/containers/JBIterator", "addOp"));
        }
        if (last) {
            this.myLastOp = this.myLastOp.nextOp = op;
        } else {
            op.nextOp = this.myFirstOp;
            this.myFirstOp = op;
        }
        JBIterator jBIterator = this;
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "addOp"));
        }
        return (T)jBIterator;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        JBIterable<Op> ops = this.operationsImpl();
        return "{cur=" + this.myCurrent + "; next=" + this.myNext + (ops.isEmpty() ? "" : "; ops[" + ops.size() + "]=" + ops) + "}";
    }

    @NotNull
    private JBIterable<Op> operationsImpl() {
        JBIterable<Op> jBIterable = JBIterable.generate(this.myFirstOp.nextOp, new Function<Op, Op>(){

            @Override
            public Op fun(Op op) {
                return op.nextOp;
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterator", "operationsImpl"));
        }
        return jBIterable;
    }

    static String toShortString(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/containers/JBIterator", "toShortString"));
        }
        String fqn = o.getClass().getName();
        return StringUtil.replace(o.toString(), fqn, StringUtil.getShortName(fqn, '.'));
    }

    private class SkipOp<E>
    extends Op<Condition<? super E>> {
        boolean active;

        SkipOp(Condition<? super E> condition) {
            super(condition);
            this.active = true;
        }

        @Override
        public Object apply(Object o) {
            if (this.active && ((Condition)this.impl).value(o)) {
                return JBIterator.this.skip();
            }
            this.active = false;
            return o;
        }
    }

    private class WhileOp<E>
    extends Op<Condition<? super E>> {
        WhileOp(Condition<? super E> condition) {
            super(condition);
        }

        @Override
        public Object apply(Object o) {
            return ((Condition)this.impl).value(o) ? o : JBIterator.this.stop();
        }
    }

    private class FilterOp<E>
    extends Op<Condition<? super E>> {
        FilterOp(Condition<? super E> condition) {
            super(condition);
        }

        @Override
        public Object apply(Object o) {
            return ((Condition)this.impl).value(o) ? o : JBIterator.this.skip();
        }
    }

    private static class TransformOp<E, T>
    extends Op<Function<? super E, T>> {
        TransformOp(Function<? super E, T> function) {
            super(function);
        }

        @Override
        public Object apply(Object o) {
            return ((Function)this.impl).fun(o);
        }
    }

    private static class CountDown<A>
    implements Condition<A> {
        int cur;

        public CountDown(int count) {
            this.cur = count;
        }

        @Override
        public boolean value(A a) {
            return this.cur > 0 && this.cur-- != 0;
        }
    }

    private static class Op<T> {
        final T impl;
        Op nextOp;

        public Op(T impl) {
            this.impl = impl;
        }

        Object apply(Object o) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.impl == null ? "" : JBIterator.toShortString(this.impl);
        }
    }
}

