/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLock;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeElement
extends ElementBase
implements ASTNode,
Cloneable {
    public static final TreeElement[] EMPTY_ARRAY = new TreeElement[0];
    private TreeElement myNextSibling;
    private TreeElement myPrevSibling;
    private CompositeElement myParent;
    private final IElementType myType;
    private volatile int myStartOffsetInParent;

    public TreeElement(@NotNull IElementType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/TreeElement", "<init>"));
        }
        this.myStartOffsetInParent = -1;
        this.myType = type2;
    }

    static PsiFileImpl getCachedFile(TreeElement each) {
        FileElement node = (FileElement)SharedImplUtil.findFileElement(each);
        return node == null ? null : (PsiFileImpl)node.getCachedPsi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Object clone() {
        TreeElement clone = (TreeElement)super.clone();
        Object object = PsiLock.LOCK;
        synchronized (object) {
            clone.myNextSibling = null;
            clone.myPrevSibling = null;
            clone.myParent = null;
            clone.myStartOffsetInParent = -1;
        }
        TreeElement treeElement = clone;
        if (treeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/TreeElement", "clone"));
        }
        return treeElement;
    }

    @Override
    public ASTNode copyElement() {
        CharTable table = SharedImplUtil.findCharTableByTree(this);
        return ChangeUtil.copyElement(this, table);
    }

    public PsiManagerEx getManager() {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null) {
            return PsiManagerEx.getInstanceEx(project);
        }
        TreeElement element = this;
        while (element.getTreeParent() != null) {
            element = element.getTreeParent();
        }
        if (element instanceof FileElement) {
            return element.getManager();
        }
        if (this.getTreeParent() != null) {
            return this.getTreeParent().getManager();
        }
        return null;
    }

    @Override
    public abstract LeafElement findLeafElementAt(int var1);

    @NotNull
    public abstract char[] textToCharArray();

    @Override
    public abstract TreeElement getFirstChildNode();

    @Override
    public abstract TreeElement getLastChildNode();

    public abstract int getNotCachedLength();

    public abstract int getCachedLength();

    @Override
    public TextRange getTextRange() {
        int start = this.getStartOffset();
        return new TextRange(start, start + this.getTextLength());
    }

    @Override
    public int getStartOffset() {
        int result2 = 0;
        TreeElement current = this;
        while (current.myParent != null) {
            result2 += current.getStartOffsetInParent();
            current = current.myParent;
        }
        return result2;
    }

    public final int getStartOffsetInParent() {
        TreeElement prev;
        if (this.myParent == null) {
            return -1;
        }
        int offsetInParent = this.myStartOffsetInParent;
        if (offsetInParent != -1) {
            return offsetInParent;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TreeElement cur = this;
        while ((prev = cur.getTreePrev()) != null) {
            cur = prev;
            offsetInParent = cur.myStartOffsetInParent;
            if (offsetInParent == -1) continue;
            break;
        }
        if (offsetInParent == -1) {
            offsetInParent = 0;
            cur.myStartOffsetInParent = 0;
        }
        while (cur != this) {
            TreeElement next = cur.getTreeNext();
            next.myStartOffsetInParent = offsetInParent += cur.getTextLength();
            cur = next;
        }
        return offsetInParent;
    }

    public int getTextOffset() {
        return this.getStartOffset();
    }

    public boolean textMatches(@NotNull CharSequence buffer, int startOffset, int endOffset) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/source/tree/TreeElement", "textMatches"));
        }
        return this.textMatches(buffer, startOffset) == endOffset;
    }

    protected abstract int textMatches(@NotNull CharSequence var1, int var2);

    public boolean textMatches(@NotNull CharSequence seq) {
        if (seq == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "com/intellij/psi/impl/source/tree/TreeElement", "textMatches"));
        }
        return this.textMatches(seq, 0, seq.length());
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/TreeElement", "textMatches"));
        }
        return this.getTextLength() == element.getTextLength() && this.textMatches(element.getText());
    }

    @NonNls
    public String toString() {
        return "Element(" + this.getElementType() + ")";
    }

    @Override
    public final CompositeElement getTreeParent() {
        return this.myParent;
    }

    @Override
    public final TreeElement getTreePrev() {
        return this.myPrevSibling;
    }

    final void setTreeParent(CompositeElement parent2) {
        if (parent2 == this.myParent) {
            return;
        }
        PsiFileImpl file = TreeElement.getCachedFile(this);
        if (file != null) {
            file.beforeAstChange();
        }
        this.myParent = parent2;
        if (parent2 != null && parent2.getElementType() != TokenType.DUMMY_HOLDER) {
            DebugUtil.revalidateNode(this);
        }
    }

    final void setTreePrev(TreeElement prev) {
        this.myPrevSibling = prev;
        TreeElement.clearRelativeOffsets(this);
    }

    @Override
    public final TreeElement getTreeNext() {
        return this.myNextSibling;
    }

    final void setTreeNext(TreeElement next) {
        this.myNextSibling = next;
        TreeElement.clearRelativeOffsets(next);
    }

    static void clearRelativeOffsets(TreeElement element) {
        for (TreeElement cur = element; cur != null && cur.myStartOffsetInParent != -1; cur = cur.getTreeNext()) {
            cur.myStartOffsetInParent = -1;
        }
    }

    public void clearCaches() {
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public abstract int hc();

    public abstract void acceptTree(TreeElementVisitor var1);

    protected void onInvalidated() {
        DebugUtil.onInvalidated(this);
    }

    public void rawInsertBeforeMe(@NotNull TreeElement firstNew) {
        if (firstNew == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstNew", "com/intellij/psi/impl/source/tree/TreeElement", "rawInsertBeforeMe"));
        }
        TreeElement anchorPrev = this.getTreePrev();
        if (anchorPrev == null) {
            firstNew.rawRemoveUpToLast();
            CompositeElement p = this.getTreeParent();
            if (p != null) {
                p.setFirstChildNode(firstNew);
            }
            while (true) {
                TreeElement treeNext = firstNew.getTreeNext();
                assert (treeNext != this) : "Attempt to create cycle";
                firstNew.setTreeParent(p);
                if (treeNext == null) break;
                firstNew = treeNext;
            }
            this.setTreePrev(firstNew);
            firstNew.setTreeNext(this);
            if (p != null) {
                p.subtreeChanged();
            }
        } else {
            anchorPrev.rawInsertAfterMe(firstNew);
        }
        DebugUtil.checkTreeStructure(this);
    }

    public void rawInsertAfterMe(@NotNull TreeElement firstNew) {
        if (firstNew == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstNew", "com/intellij/psi/impl/source/tree/TreeElement", "rawInsertAfterMe"));
        }
        this.rawInsertAfterMeWithoutNotifications(firstNew);
        CompositeElement parent2 = this.getTreeParent();
        if (parent2 != null) {
            parent2.subtreeChanged();
        }
    }

    final void rawInsertAfterMeWithoutNotifications(@NotNull TreeElement firstNew) {
        if (firstNew == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstNew", "com/intellij/psi/impl/source/tree/TreeElement", "rawInsertAfterMeWithoutNotifications"));
        }
        firstNew.rawRemoveUpToWithoutNotifications(null, false);
        CompositeElement p = this.getTreeParent();
        TreeElement treeNext = this.getTreeNext();
        firstNew.setTreePrev(this);
        this.setTreeNext(firstNew);
        while (true) {
            TreeElement n = firstNew.getTreeNext();
            assert (n != this) : "Attempt to create cycle";
            firstNew.setTreeParent(p);
            if (n == null) break;
            firstNew = n;
        }
        if (treeNext == null) {
            if (p != null) {
                firstNew.setTreeParent(p);
                p.setLastChildNode(firstNew);
            }
        } else {
            firstNew.setTreeNext(treeNext);
            treeNext.setTreePrev(firstNew);
        }
        DebugUtil.checkTreeStructure(this);
    }

    public void rawRemove() {
        TreeElement next = this.getTreeNext();
        CompositeElement parent2 = this.getTreeParent();
        TreeElement prev = this.getTreePrev();
        if (prev != null) {
            prev.setTreeNext(next);
        } else if (parent2 != null) {
            parent2.setFirstChildNode(next);
        }
        if (next != null) {
            next.setTreePrev(prev);
        } else if (parent2 != null) {
            parent2.setLastChildNode(prev);
        }
        DebugUtil.checkTreeStructure(parent2);
        DebugUtil.checkTreeStructure(prev);
        DebugUtil.checkTreeStructure(next);
        this.invalidate();
    }

    public void rawReplaceWithList(TreeElement firstNew) {
        if (firstNew != null) {
            this.rawInsertAfterMeWithoutNotifications(firstNew);
        }
        this.rawRemove();
    }

    protected void invalidate() {
        CompositeElement parent2 = this.getTreeParent();
        if (parent2 != null) {
            parent2.subtreeChanged();
        }
        this.onInvalidated();
        this.setTreeNext(null);
        this.setTreePrev(null);
        this.setTreeParent(null);
    }

    public void rawRemoveUpToLast() {
        this.rawRemoveUpTo(null);
    }

    public void rawRemoveUpTo(@Nullable TreeElement end) {
        CompositeElement parent2 = this.getTreeParent();
        this.rawRemoveUpToWithoutNotifications(end, true);
        if (parent2 != null) {
            parent2.subtreeChanged();
        }
    }

    final void rawRemoveUpToWithoutNotifications(@Nullable TreeElement end, boolean invalidate) {
        TreeElement element;
        TreeElement endPrev;
        if (this == end) {
            return;
        }
        CompositeElement parent2 = this.getTreeParent();
        TreeElement startPrev = this.getTreePrev();
        TreeElement treeElement = endPrev = end != null ? end.getTreePrev() : null;
        assert (end == null || end.getTreeParent() == parent2) : "Trying to remove non-child";
        if (end != null) {
            for (element = this; element != end && element != null; element = element.getTreeNext()) {
            }
            assert (element == end) : end + " is not successor of " + this + " in the .getTreeNext() chain";
        }
        if (parent2 != null) {
            if (this.getTreePrev() == null) {
                parent2.setFirstChildNode(end);
            }
            if (end == null) {
                parent2.setLastChildNode(startPrev);
            }
        }
        if (startPrev != null) {
            startPrev.setTreeNext(end);
        }
        if (end != null) {
            end.setTreePrev(startPrev);
        }
        this.setTreePrev(null);
        if (endPrev != null) {
            endPrev.setTreeNext(null);
        }
        if (parent2 != null) {
            for (element = this; element != null; element = element.getTreeNext()) {
                element.setTreeParent(null);
                if (!invalidate) continue;
                element.onInvalidated();
            }
        }
        DebugUtil.checkTreeStructure(parent2);
        DebugUtil.checkTreeStructure(this);
    }

    @Override
    @NotNull
    public IElementType getElementType() {
        IElementType iElementType = this.myType;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/TreeElement", "getElementType"));
        }
        return iElementType;
    }
}

