/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.OriginInfoAwareElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.light.LightParameter;
import com.intellij.psi.impl.light.LightParameterListBuilder;
import com.intellij.psi.impl.light.LightReferenceListBuilder;
import com.intellij.psi.impl.light.LightTypeParameter;
import com.intellij.psi.impl.light.LightTypeParameterListBuilder;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightMethodBuilder
extends LightElement
implements OriginInfoAwareElement,
PsiMethod {
    private final String myName;
    private Computable<PsiType> myReturnType;
    private final PsiModifierList myModifierList;
    private final PsiParameterList myParameterList;
    private final PsiTypeParameterList myTypeParameterList;
    private final PsiReferenceList myThrowsList;
    private Icon myBaseIcon;
    private PsiClass myContainingClass;
    private boolean myConstructor;
    private String myMethodKind = "LightMethodBuilder";
    private String myOriginInfo;

    public LightMethodBuilder(PsiClass constructedClass, Language language) {
        this(constructedClass.getManager(), language, constructedClass.getName());
        this.setContainingClass(constructedClass);
    }

    public LightMethodBuilder(PsiManager manager, String name) {
        this(manager, JavaLanguage.INSTANCE, name);
    }

    public LightMethodBuilder(PsiManager manager, Language language, String name) {
        this(manager, language, name, new LightParameterListBuilder(manager, language), new LightModifierList(manager, language, new String[0]));
    }

    public LightMethodBuilder(PsiManager manager, Language language, String name, PsiParameterList parameterList, PsiModifierList modifierList) {
        this(manager, language, name, parameterList, modifierList, new LightReferenceListBuilder(manager, language, PsiReferenceList.Role.THROWS_LIST), new LightTypeParameterListBuilder(manager, language));
    }

    public LightMethodBuilder(PsiManager manager, Language language, String name, PsiParameterList parameterList, PsiModifierList modifierList, PsiReferenceList throwsList, PsiTypeParameterList typeParameterList) {
        super(manager, language);
        this.myName = name;
        this.myParameterList = parameterList;
        this.myModifierList = modifierList;
        this.myThrowsList = throwsList;
        this.myTypeParameterList = typeParameterList;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters(this);
    }

    @Override
    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = PsiImplUtil.getTypeParameters(this);
        if (psiTypeParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "getTypeParameters"));
        }
        return psiTypeParameterArray;
    }

    @Override
    public PsiTypeParameterList getTypeParameterList() {
        return this.myTypeParameterList;
    }

    @Override
    public PsiDocComment getDocComment() {
        return null;
    }

    @Override
    public boolean isDeprecated() {
        return PsiImplUtil.isDeprecatedByDocTag(this) || PsiImplUtil.isDeprecatedByAnnotation(this);
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightMethodBuilder", "setName"));
        }
        String className = this.myContainingClass == null ? "null" : this.myContainingClass.getQualifiedName();
        throw new UnsupportedOperationException("Please don't rename light methods: writable=" + this.isWritable() + "; class=" + this.getClass() + "; name=" + this.getName() + "; inClass=" + className);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignature hierarchicalMethodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature(this);
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "getHierarchicalMethodSignature"));
        }
        return hierarchicalMethodSignature;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightMethodBuilder", "hasModifierProperty"));
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = this.myModifierList;
        if (psiModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "getModifierList"));
        }
        return psiModifierList;
    }

    public LightMethodBuilder addModifiers(String ... modifiers) {
        for (String modifier : modifiers) {
            this.addModifier(modifier);
        }
        return this;
    }

    public LightMethodBuilder addModifier(String modifier) {
        ((LightModifierList)this.myModifierList).addModifier(modifier);
        return this;
    }

    public LightMethodBuilder setModifiers(String ... modifiers) {
        ((LightModifierList)this.myModifierList).clearModifiers();
        this.addModifiers(modifiers);
        return this;
    }

    @Override
    public PsiType getReturnType() {
        return this.myReturnType == null ? null : this.myReturnType.compute();
    }

    public LightMethodBuilder setMethodReturnType(Computable<PsiType> returnType2) {
        this.myReturnType = returnType2;
        return this;
    }

    public LightMethodBuilder setMethodReturnType(PsiType returnType2) {
        return this.setMethodReturnType(new Computable.PredefinedValueComputable<PsiType>(returnType2));
    }

    public LightMethodBuilder setMethodReturnType(final @NotNull String returnType2) {
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/intellij/psi/impl/light/LightMethodBuilder", "setMethodReturnType"));
        }
        return this.setMethodReturnType((Computable<PsiType>)new Computable.NotNullCachedComputable<PsiType>(){

            @Override
            @NotNull
            protected PsiType internalCompute() {
                PsiClassType psiClassType = JavaPsiFacade.getInstance(LightMethodBuilder.this.myManager.getProject()).getElementFactory().createTypeByFQClassName(returnType2, LightMethodBuilder.this.getResolveScope());
                if (psiClassType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder$1", "internalCompute"));
                }
                return psiClassType;
            }
        });
    }

    @Override
    public PsiTypeElement getReturnTypeElement() {
        return null;
    }

    @Override
    @NotNull
    public PsiParameterList getParameterList() {
        PsiParameterList psiParameterList = this.myParameterList;
        if (psiParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "getParameterList"));
        }
        return psiParameterList;
    }

    public LightMethodBuilder addParameter(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/psi/impl/light/LightMethodBuilder", "addParameter"));
        }
        ((LightParameterListBuilder)this.myParameterList).addParameter(parameter);
        return this;
    }

    public LightMethodBuilder addParameter(@NotNull String name, @NotNull String type2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightMethodBuilder", "addParameter"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/light/LightMethodBuilder", "addParameter"));
        }
        return this.addParameter(name, JavaPsiFacade.getElementFactory(this.getProject()).createTypeFromText(type2, this));
    }

    public LightMethodBuilder addParameter(@NotNull String name, @NotNull PsiType type2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightMethodBuilder", "addParameter"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/light/LightMethodBuilder", "addParameter"));
        }
        return this.addParameter(new LightParameter(name, type2, this, (Language)JavaLanguage.INSTANCE));
    }

    public LightMethodBuilder addParameter(@NotNull String name, @NotNull PsiType type2, boolean isVarArgs) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightMethodBuilder", "addParameter"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/light/LightMethodBuilder", "addParameter"));
        }
        if (isVarArgs && !(type2 instanceof PsiEllipsisType)) {
            type2 = new PsiEllipsisType(type2);
        }
        return this.addParameter(new LightParameter(name, type2, this, JavaLanguage.INSTANCE, isVarArgs));
    }

    public LightMethodBuilder addException(PsiClassType type2) {
        ((LightReferenceListBuilder)this.myThrowsList).addReference(type2);
        return this;
    }

    public LightMethodBuilder addException(String fqName2) {
        ((LightReferenceListBuilder)this.myThrowsList).addReference(fqName2);
        return this;
    }

    @Override
    @NotNull
    public PsiReferenceList getThrowsList() {
        PsiReferenceList psiReferenceList = this.myThrowsList;
        if (psiReferenceList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "getThrowsList"));
        }
        return psiReferenceList;
    }

    @Override
    public PsiCodeBlock getBody() {
        return null;
    }

    public LightMethodBuilder setConstructor(boolean constructor) {
        this.myConstructor = constructor;
        return this;
    }

    @Override
    public boolean isConstructor() {
        return this.myConstructor;
    }

    @Override
    public boolean isVarArgs() {
        return PsiImplUtil.isVarArgs(this);
    }

    @Override
    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor2) {
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/light/LightMethodBuilder", "getSignature"));
        }
        MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = MethodSignatureBackedByPsiMethod.create(this, substitutor2);
        if (methodSignatureBackedByPsiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "getSignature"));
        }
        return methodSignatureBackedByPsiMethod;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    @NotNull
    public PsiMethod[] findSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, checkAccess);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, parentClass);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        List<MethodSignatureBackedByPsiMethod> list2 = PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic(this, checkAccess);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "findSuperMethodSignaturesIncludingStatic"));
        }
        return list2;
    }

    @Override
    public PsiMethod findDeepestSuperMethod() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethod(this);
    }

    @Override
    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findDeepestSuperMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "findDeepestSuperMethods"));
        }
        return psiMethodArray;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/light/LightMethodBuilder", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitMethod(this);
        }
    }

    @Override
    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    public LightMethodBuilder setContainingClass(PsiClass containingClass) {
        this.myContainingClass = containingClass;
        return this;
    }

    public LightMethodBuilder setMethodKind(String debugKindName) {
        this.myMethodKind = debugKindName;
        return this;
    }

    @Override
    public String toString() {
        return this.myMethodKind + ":" + this.getName();
    }

    @Override
    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.myBaseIcon != null ? this.myBaseIcon : (this.hasModifierProperty("abstract") ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON);
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(methodIcon, this, false);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    public LightMethodBuilder setBaseIcon(Icon baseIcon) {
        this.myBaseIcon = baseIcon;
        return this;
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope(this);
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethodBuilder", "getUseScope"));
        }
        return searchScope;
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        PsiClass containingClass = this.getContainingClass();
        return containingClass == null ? null : containingClass.getContainingFile();
    }

    @Override
    public PsiElement getContext() {
        PsiElement navElement = this.getNavigationElement();
        if (navElement != this) {
            return navElement;
        }
        PsiClass cls = this.getContainingClass();
        if (cls != null) {
            return cls;
        }
        return this.getContainingFile();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LightMethodBuilder that = (LightMethodBuilder)o;
        if (this.myConstructor != that.myConstructor) {
            return false;
        }
        if (this.myBaseIcon != null ? !this.myBaseIcon.equals(that.myBaseIcon) : that.myBaseIcon != null) {
            return false;
        }
        if (this.myContainingClass != null ? !this.myContainingClass.equals(that.myContainingClass) : that.myContainingClass != null) {
            return false;
        }
        if (!this.myMethodKind.equals(that.myMethodKind)) {
            return false;
        }
        if (!this.myModifierList.equals(that.myModifierList)) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        if (!this.myParameterList.equals(that.myParameterList)) {
            return false;
        }
        return !(this.myReturnType != null ? !this.myReturnType.equals(that.myReturnType) : that.myReturnType != null);
    }

    public int hashCode() {
        int result2 = this.myName.hashCode();
        result2 = 31 * result2 + (this.myReturnType != null ? this.myReturnType.hashCode() : 0);
        result2 = 31 * result2 + this.myModifierList.hashCode();
        result2 = 31 * result2 + this.myParameterList.hashCode();
        result2 = 31 * result2 + (this.myBaseIcon != null ? this.myBaseIcon.hashCode() : 0);
        result2 = 31 * result2 + (this.myContainingClass != null ? this.myContainingClass.hashCode() : 0);
        result2 = 31 * result2 + (this.myConstructor ? 1 : 0);
        result2 = 31 * result2 + this.myMethodKind.hashCode();
        return result2;
    }

    public LightMethodBuilder addTypeParameter(PsiTypeParameter parameter) {
        ((LightTypeParameterListBuilder)this.myTypeParameterList).addParameter(new LightTypeParameter(parameter));
        return this;
    }

    @Override
    @Nullable
    public String getOriginInfo() {
        return this.myOriginInfo;
    }

    public void setOriginInfo(@Nullable String originInfo) {
        this.myOriginInfo = originInfo;
    }
}

