/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PossiblyInnerType;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterUtilsKt;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.renderer.ClassifierNamePolicy;
import org.jetbrains.kotlin.renderer.CustomFlexibleRendering;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererImpl$WhenMappings;
import org.jetbrains.kotlin.renderer.DescriptorRendererModifier;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptionsImpl;
import org.jetbrains.kotlin.renderer.OverrideRenderingPolicy;
import org.jetbrains.kotlin.renderer.ParameterNameRenderingPolicy;
import org.jetbrains.kotlin.renderer.RenderingFormat;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.deserialization.NotFoundClasses;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.LazyType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00c8\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u008a\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010z\u001a\u00020{2\u0006\u0010|\u001a\u00020}2\u0006\u0010~\u001a\u00020\u007fH\u0002J\"\u0010\u0080\u0001\u001a\u00020{2\u000f\u0010\u0081\u0001\u001a\n\u0012\u0005\u0012\u00030\u0083\u00010\u0082\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J\n\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0002J\u001d\u0010\u0086\u0001\u001a\u00020\u00072\b\u0010\u0087\u0001\u001a\u00030\u0085\u00012\b\u0010\u0088\u0001\u001a\u00030\u0085\u0001H\u0002J\u0014\u0010\u0089\u0001\u001a\u00030\u0085\u00012\b\u0010\u008a\u0001\u001a\u00030\u0085\u0001H\u0002J\n\u0010\u008b\u0001\u001a\u00030\u0085\u0001H\u0002J\n\u0010\u008c\u0001\u001a\u00030\u0085\u0001H\u0002J\u0013\u0010\u008d\u0001\u001a\u00020\u00072\b\u0010\u008e\u0001\u001a\u00030\u008f\u0001H\u0002J\u0013\u0010\u0090\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u0091\u0001\u001a\u00020}H\u0016J\u001a\u0010\u0092\u0001\u001a\u00020{2\u0007\u0010|\u001a\u00030\u0093\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J\u001b\u0010\u0094\u0001\u001a\u00020{2\b\u0010\u0095\u0001\u001a\u00030\u0096\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J\u001a\u0010\u0097\u0001\u001a\n\u0012\u0005\u0012\u00030\u0085\u00010\u0082\u00012\u0007\u0010|\u001a\u00030\u0098\u0001H\u0002J \u0010\u0099\u0001\u001a\u00030\u0085\u00012\b\u0010\u009a\u0001\u001a\u00030\u0098\u00012\n\u0010\u009b\u0001\u001a\u0005\u0018\u00010\u009c\u0001H\u0016J\u001b\u0010\u009d\u0001\u001a\u00020{2\b\u0010\u009e\u0001\u001a\u00030\u009f\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J\u001b\u0010\u00a0\u0001\u001a\u00020{2\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J\u001b\u0010\u00a3\u0001\u001a\u00020{2\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J\u0014\u0010\u00a4\u0001\u001a\u00030\u0085\u00012\b\u0010\u00a1\u0001\u001a\u00030\u00a5\u0001H\u0016J\u0018\u0010@\u001a\u00020{2\u0006\u0010|\u001a\u00020}2\u0006\u0010~\u001a\u00020\u007fH\u0002J\u0018\u0010\u00a6\u0001\u001a\u00030\u0085\u00012\f\u0010\u00a7\u0001\u001a\u0007\u0012\u0002\b\u00030\u00a8\u0001H\u0002J\u001b\u0010\u00a9\u0001\u001a\u00020{2\b\u0010\u00aa\u0001\u001a\u00030\u00ab\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J\u001a\u0010\u00ac\u0001\u001a\u00020{2\u0007\u0010\u00ad\u0001\u001a\u00020\u00072\u0006\u0010~\u001a\u00020\u007fH\u0002J\u0013\u0010\u00ae\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u00af\u0001\u001a\u00020ZH\u0002J\u0014\u0010\u00b0\u0001\u001a\u00030\u0085\u00012\b\u0010\u00b1\u0001\u001a\u00030\u0085\u0001H\u0002J\u0013\u0010\u00b2\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u00af\u0001\u001a\u00020ZH\u0002J\u001e\u0010\u00b3\u0001\u001a\u00030\u0085\u00012\b\u0010\u0087\u0001\u001a\u00030\u0085\u00012\b\u0010\u0088\u0001\u001a\u00030\u0085\u0001H\u0002J\u001c\u0010\u00b3\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u0087\u0001\u001a\u00020Z2\u0007\u0010\u0088\u0001\u001a\u00020ZH\u0002J\u001b\u0010\u00b4\u0001\u001a\u00030\u0085\u00012\u000f\u0010\u00b5\u0001\u001a\n\u0012\u0005\u0012\u00030\u00b6\u00010\u0082\u0001H\u0002J\u0014\u0010\u00b4\u0001\u001a\u00030\u0085\u00012\b\u0010\u00b7\u0001\u001a\u00030\u00b8\u0001H\u0016J\u001b\u0010\u00b9\u0001\u001a\u00020{2\b\u0010\u00ba\u0001\u001a\u00030\u0096\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J\u0013\u0010\u00bb\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u00af\u0001\u001a\u00020ZH\u0002J\u0013\u0010\u00bc\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u00af\u0001\u001a\u00020ZH\u0002J\u001b\u0010\u00bd\u0001\u001a\u00020{2\b\u0010\u00be\u0001\u001a\u00030\u00bf\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J\u001a\u0010\u00c0\u0001\u001a\u00020{2\u0007\u0010\u00c1\u0001\u001a\u00020\u00072\u0006\u0010~\u001a\u00020\u007fH\u0002J\u0014\u0010\u00c2\u0001\u001a\u00030\u0085\u00012\b\u0010\u00b1\u0001\u001a\u00030\u0085\u0001H\u0002J\u001b\u0010\u00c3\u0001\u001a\u00020{2\b\u0010\u00c4\u0001\u001a\u00030\u00c5\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J\u001b\u0010\u00c6\u0001\u001a\u00020{2\b\u0010\u00c7\u0001\u001a\u00030\u008f\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J\u0014\u0010\u00c8\u0001\u001a\u00030\u0085\u00012\b\u0010\u00c9\u0001\u001a\u00030\u0085\u0001H\u0016J\u001b\u0010\u00ca\u0001\u001a\u00020{2\b\u0010\u00cb\u0001\u001a\u00030\u00cc\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J\u001b\u0010\u00cd\u0001\u001a\u00020{2\b\u0010\u008e\u0001\u001a\u00030\u008f\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J\u0019\u0010\u00ce\u0001\u001a\u00020{2\u0006\u0010|\u001a\u00020}2\u0006\u0010~\u001a\u00020\u007fH\u0002J\u0014\u0010\u00ce\u0001\u001a\u00030\u0085\u00012\b\u0010\u00cf\u0001\u001a\u00030\u00b6\u0001H\u0016J\u0013\u0010\u00d0\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u00af\u0001\u001a\u00020ZH\u0002J\u001b\u0010\u00d1\u0001\u001a\u00020{2\b\u0010\u00c7\u0001\u001a\u00030\u008f\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J\u001b\u0010\u00d2\u0001\u001a\u00020{2\b\u0010\u00d3\u0001\u001a\u00030\u00d4\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J\u001b\u0010\u00d5\u0001\u001a\u00020{2\b\u0010\u00d6\u0001\u001a\u00030\u00d7\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J\u0014\u0010\u00d8\u0001\u001a\u00030\u0085\u00012\b\u0010\u00d9\u0001\u001a\u00030\u00da\u0001H\u0002J\u001b\u0010\u00db\u0001\u001a\u00020{2\b\u0010\u00dc\u0001\u001a\u00030\u00c5\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J\u001b\u0010\u00dd\u0001\u001a\u00020{2\b\u0010\u00de\u0001\u001a\u00030\u00df\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J\u001b\u0010\u00e0\u0001\u001a\u00020{2\b\u0010\u00de\u0001\u001a\u00030\u00df\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J\u0011\u0010\u00e1\u0001\u001a\u00020{2\u0006\u0010~\u001a\u00020\u007fH\u0002J\u001b\u0010\u00e2\u0001\u001a\u00020{2\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J\u0013\u0010\u00e3\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u00af\u0001\u001a\u00020ZH\u0016J\u001b\u0010\u00e4\u0001\u001a\u00030\u0085\u00012\u000f\u0010\u00e5\u0001\u001a\n\u0012\u0005\u0012\u00030\u0083\u00010\u0082\u0001H\u0016J\u0014\u0010\u00e6\u0001\u001a\u00030\u0085\u00012\b\u0010\u00e7\u0001\u001a\u00030\u00e8\u0001H\u0016J\u001f\u0010\u00e9\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u00af\u0001\u001a\u00020Z2\n\b\u0002\u0010\u00e7\u0001\u001a\u00030\u00e8\u0001H\u0002J$\u0010\u00ea\u0001\u001a\u00020{2\b\u0010\u00eb\u0001\u001a\u00030\u00ec\u00012\u0006\u0010~\u001a\u00020\u007f2\u0007\u0010\u00ed\u0001\u001a\u00020\u0007H\u0002J\"\u0010\u00ee\u0001\u001a\u00020{2\u0006\u0010~\u001a\u00020\u007f2\u000f\u0010\u00ef\u0001\u001a\n\u0012\u0005\u0012\u00030\u00ec\u00010\u0082\u0001H\u0002J+\u0010\u00f0\u0001\u001a\u00020{2\u000f\u0010\u00ef\u0001\u001a\n\u0012\u0005\u0012\u00030\u00ec\u00010\u0082\u00012\u0006\u0010~\u001a\u00020\u007f2\u0007\u0010\u00f1\u0001\u001a\u00020\u0007H\u0002J\u0014\u0010\u00f2\u0001\u001a\u00030\u0085\u00012\b\u0010\u00f3\u0001\u001a\u00030\u0083\u0001H\u0016J\u001b\u0010\u00f4\u0001\u001a\u00020{2\b\u0010\u00be\u0001\u001a\u00030\u00bf\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J-\u0010\u00f5\u0001\u001a\u00020{2\b\u0010\u00f6\u0001\u001a\u00030\u00f7\u00012\u0007\u0010\u00f8\u0001\u001a\u00020\u00072\u0006\u0010~\u001a\u00020\u007f2\u0007\u0010\u00ed\u0001\u001a\u00020\u0007H\u0002J$\u0010\u00f9\u0001\u001a\u00030\u0085\u00012\u000f\u0010\u00fa\u0001\u001a\n\u0012\u0005\u0012\u00030\u00f7\u00010\u00fb\u00012\u0007\u0010\u00fc\u0001\u001a\u00020\u0007H\u0016J+\u0010\u00f9\u0001\u001a\u00020{2\u000f\u0010\u00fa\u0001\u001a\n\u0012\u0005\u0012\u00030\u00f7\u00010\u00fb\u00012\u0007\u0010\u00fc\u0001\u001a\u00020\u00072\u0006\u0010~\u001a\u00020\u007fH\u0002J-\u0010\u00fd\u0001\u001a\u00020{2\b\u0010\u00be\u0001\u001a\u00030\u00bf\u00012\u0007\u0010\u00f8\u0001\u001a\u00020\u00072\u0006\u0010~\u001a\u00020\u007f2\u0007\u0010\u00ed\u0001\u001a\u00020\u0007H\u0002J\u001b\u0010\u00fe\u0001\u001a\u00020{2\b\u0010\u00ff\u0001\u001a\u00030\u0080\u00022\u0006\u0010~\u001a\u00020\u007fH\u0002J\"\u0010\u0081\u0002\u001a\u00020{2\u000f\u0010\u00ef\u0001\u001a\n\u0012\u0005\u0012\u00030\u00ec\u00010\u0082\u00012\u0006\u0010~\u001a\u00020\u007fH\u0002J>\u0010\u0082\u0002\u001a\u0005\u0018\u00010\u0085\u00012\b\u0010\u0083\u0002\u001a\u00030\u0085\u00012\b\u0010\u0084\u0002\u001a\u00030\u0085\u00012\b\u0010\u0085\u0002\u001a\u00030\u0085\u00012\b\u0010\u0086\u0002\u001a\u00030\u0085\u00012\b\u0010\u0087\u0002\u001a\u00030\u0085\u0001H\u0002J\u0012\u0010\u0088\u0002\u001a\u00020\u00072\u0007\u0010\u00af\u0001\u001a\u00020ZH\u0002J\u0012\u0010\u0089\u0002\u001a\u00020\u00072\u0007\u0010\u00fc\u0001\u001a\u00020\u0007H\u0002R\u0018\u0010\u0006\u001a\u00020\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\u00020\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u0018\u0010\u000f\u001a\u00020\u0010X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\u00020\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\t\"\u0004\b\u0017\u0010\u000bR\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u0018\u0010\"\u001a\u00020\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b#\u0010\t\"\u0004\b$\u0010\u000bR\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0019X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b'\u0010\u001c\"\u0004\b(\u0010\u001eR\u0018\u0010)\u001a\u00020\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b*\u0010\t\"\u0004\b+\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0018\u0010.\u001a\u00020/X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0018\u00104\u001a\u000205X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0018\u0010:\u001a\u00020\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b;\u0010\t\"\u0004\b<\u0010\u000bR\u0018\u0010=\u001a\u00020\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b>\u0010\t\"\u0004\b?\u0010\u000bR\u0018\u0010@\u001a\u00020\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\bA\u0010\t\"\u0004\bB\u0010\u000bR\u0018\u0010C\u001a\u00020\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\bD\u0010\t\"\u0004\bE\u0010\u000bR\u0018\u0010F\u001a\u00020\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\bG\u0010\t\"\u0004\bH\u0010\u000bR\u0018\u0010I\u001a\u00020\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\bJ\u0010\t\"\u0004\bK\u0010\u000bR\u0018\u0010L\u001a\u00020\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\bM\u0010\t\"\u0004\bN\u0010\u000bR\u0018\u0010O\u001a\u00020\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\bP\u0010\t\"\u0004\bQ\u0010\u000bR\u0018\u0010R\u001a\u00020SX\u0096\u000f\u00a2\u0006\f\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR$\u0010X\u001a\u000e\u0012\u0004\u0012\u00020Z\u0012\u0004\u0012\u00020Z0YX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b[\u0010\\\"\u0004\b]\u0010^R\u0018\u0010_\u001a\u00020\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b`\u0010\t\"\u0004\ba\u0010\u000bR\u0018\u0010b\u001a\u00020\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\bc\u0010\t\"\u0004\bd\u0010\u000bR\u0018\u0010e\u001a\u00020fX\u0096\u000f\u00a2\u0006\f\u001a\u0004\bg\u0010h\"\u0004\bi\u0010jR\u0018\u0010k\u001a\u00020\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\bl\u0010\t\"\u0004\bm\u0010\u000bR\u0018\u0010n\u001a\u00020\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\bo\u0010\t\"\u0004\bp\u0010\u000bR\u0018\u0010q\u001a\u00020\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\br\u0010\t\"\u0004\bs\u0010\u000bR\u0018\u0010t\u001a\u00020\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\bu\u0010\t\"\u0004\bv\u0010\u000bR\u0018\u0010w\u001a\u00020\u0007X\u0096\u000f\u00a2\u0006\f\u001a\u0004\bx\u0010\t\"\u0004\by\u0010\u000b\u00a8\u0006\u008b\u0002"}, d2={"Lorg/jetbrains/kotlin/renderer/DescriptorRendererImpl;", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "Lorg/jetbrains/kotlin/renderer/DescriptorRendererOptions;", "options", "Lorg/jetbrains/kotlin/renderer/DescriptorRendererOptionsImpl;", "(Lorg/jetbrains/kotlin/renderer/DescriptorRendererOptionsImpl;)V", "alwaysRenderModifiers", "", "getAlwaysRenderModifiers", "()Z", "setAlwaysRenderModifiers", "(Z)V", "classWithPrimaryConstructor", "getClassWithPrimaryConstructor", "setClassWithPrimaryConstructor", "classifierNamePolicy", "Lorg/jetbrains/kotlin/renderer/ClassifierNamePolicy;", "getClassifierNamePolicy", "()Lorg/jetbrains/kotlin/renderer/ClassifierNamePolicy;", "setClassifierNamePolicy", "(Lorg/jetbrains/kotlin/renderer/ClassifierNamePolicy;)V", "debugMode", "getDebugMode", "setDebugMode", "excludedAnnotationClasses", "", "Lorg/jetbrains/kotlin/name/FqName;", "getExcludedAnnotationClasses", "()Ljava/util/Set;", "setExcludedAnnotationClasses", "(Ljava/util/Set;)V", "excludedTypeAnnotationClasses", "getExcludedTypeAnnotationClasses", "setExcludedTypeAnnotationClasses", "includePropertyConstant", "getIncludePropertyConstant", "setIncludePropertyConstant", "modifiers", "Lorg/jetbrains/kotlin/renderer/DescriptorRendererModifier;", "getModifiers", "setModifiers", "normalizedVisibilities", "getNormalizedVisibilities", "setNormalizedVisibilities", "getOptions", "()Lorg/jetbrains/kotlin/renderer/DescriptorRendererOptionsImpl;", "overrideRenderingPolicy", "Lorg/jetbrains/kotlin/renderer/OverrideRenderingPolicy;", "getOverrideRenderingPolicy", "()Lorg/jetbrains/kotlin/renderer/OverrideRenderingPolicy;", "setOverrideRenderingPolicy", "(Lorg/jetbrains/kotlin/renderer/OverrideRenderingPolicy;)V", "parameterNameRenderingPolicy", "Lorg/jetbrains/kotlin/renderer/ParameterNameRenderingPolicy;", "getParameterNameRenderingPolicy", "()Lorg/jetbrains/kotlin/renderer/ParameterNameRenderingPolicy;", "setParameterNameRenderingPolicy", "(Lorg/jetbrains/kotlin/renderer/ParameterNameRenderingPolicy;)V", "receiverAfterName", "getReceiverAfterName", "setReceiverAfterName", "renderAccessors", "getRenderAccessors", "setRenderAccessors", "renderCompanionObjectName", "getRenderCompanionObjectName", "setRenderCompanionObjectName", "renderDefaultAnnotationArguments", "getRenderDefaultAnnotationArguments", "setRenderDefaultAnnotationArguments", "renderDefaultValues", "getRenderDefaultValues", "setRenderDefaultValues", "secondaryConstructorsAsPrimary", "getSecondaryConstructorsAsPrimary", "setSecondaryConstructorsAsPrimary", "showInternalKeyword", "getShowInternalKeyword", "setShowInternalKeyword", "startFromName", "getStartFromName", "setStartFromName", "textFormat", "Lorg/jetbrains/kotlin/renderer/RenderingFormat;", "getTextFormat", "()Lorg/jetbrains/kotlin/renderer/RenderingFormat;", "setTextFormat", "(Lorg/jetbrains/kotlin/renderer/RenderingFormat;)V", "typeNormalizer", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getTypeNormalizer", "()Lkotlin/jvm/functions/Function1;", "setTypeNormalizer", "(Lkotlin/jvm/functions/Function1;)V", "uninferredTypeParameterAsName", "getUninferredTypeParameterAsName", "setUninferredTypeParameterAsName", "unitReturnType", "getUnitReturnType", "setUnitReturnType", "valueParametersHandler", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer$ValueParametersHandler;", "getValueParametersHandler", "()Lorg/jetbrains/kotlin/renderer/DescriptorRenderer$ValueParametersHandler;", "setValueParametersHandler", "(Lorg/jetbrains/kotlin/renderer/DescriptorRenderer$ValueParametersHandler;)V", "verbose", "getVerbose", "setVerbose", "withDefinedIn", "getWithDefinedIn", "setWithDefinedIn", "withoutReturnType", "getWithoutReturnType", "setWithoutReturnType", "withoutSuperTypes", "getWithoutSuperTypes", "setWithoutSuperTypes", "withoutTypeParameters", "getWithoutTypeParameters", "setWithoutTypeParameters", "appendDefinedIn", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "builder", "Ljava/lang/StringBuilder;", "appendTypeProjections", "typeProjections", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "arrow", "", "differsOnlyInNullability", "lower", "upper", "escape", "string", "gt", "lt", "overridesSomething", "callable", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "render", "declarationDescriptor", "renderAccessorModifiers", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "renderAdditionalModifiers", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "renderAndSortAnnotationArguments", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "renderAnnotation", "annotation", "target", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "renderAnnotations", "annotated", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotated;", "renderClass", "klass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "renderClassKindPrefix", "renderClassifierName", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "renderConstant", "value", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "renderConstructor", "constructor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "renderData", "isData", "renderDefaultType", "type", "renderError", "keyword", "renderFlexibleType", "renderFlexibleTypeWithBothBounds", "renderFqName", "pathSegments", "Lorg/jetbrains/kotlin/name/Name;", "fqName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "renderFunction", "function", "renderFunctionType", "renderInflexibleType", "renderInitializer", "variable", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "renderInner", "isInner", "renderKeyword", "renderLateInit", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "renderMemberKind", "callableMember", "renderMessage", "message", "renderModality", "modality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "renderModalityForCallable", "renderName", "name", "renderNormalizedType", "renderOverride", "renderPackageFragment", "fragment", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "renderPackageView", "packageView", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "renderPossiblyInnerType", "possiblyInnerType", "Lorg/jetbrains/kotlin/descriptors/PossiblyInnerType;", "renderProperty", "property", "renderReceiver", "callableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "renderReceiverAfterName", "renderSpaceIfNeeded", "renderSuperTypes", "renderType", "renderTypeArguments", "typeArguments", "renderTypeConstructor", "typeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "renderTypeConstructorAndArguments", "renderTypeParameter", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "topLevel", "renderTypeParameterList", "typeParameters", "renderTypeParameters", "withSpace", "renderTypeProjection", "typeProjection", "renderValVarPrefix", "renderValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "includeName", "renderValueParameters", "parameters", "", "synthesizedParameterNames", "renderVariable", "renderVisibility", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "renderWhereSuffix", "replacePrefixes", "lowerRendered", "lowerPrefix", "upperRendered", "upperPrefix", "foldedPrefix", "shouldRenderAsPrettyFunctionType", "shouldRenderParameterNames", "RenderDeclarationDescriptorVisitor", "kotlin-compiler"})
public final class DescriptorRendererImpl
extends DescriptorRenderer
implements DescriptorRendererOptions {
    @NotNull
    private final DescriptorRendererOptionsImpl options;

    private final String renderKeyword(String keyword) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                return keyword;
            }
            case 2: {
                return "<b>" + keyword + "</b>";
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final String renderError(String keyword) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$1[this.getTextFormat().ordinal()]) {
            case 1: {
                return keyword;
            }
            case 2: {
                return "<font color=red><b>" + keyword + "</b></font>";
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final String escape(String string) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$2[this.getTextFormat().ordinal()]) {
            case 1: {
                return string;
            }
            case 2: {
                return StringsKt.replace$default(StringsKt.replace$default(string, "<", "&lt;", false, 4, null), ">", "&gt;", false, 4, null);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final String lt() {
        return this.escape("<");
    }

    private final String gt() {
        return this.escape(">");
    }

    private final String arrow() {
        String string;
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$3[this.getTextFormat().ordinal()]) {
            case 1: {
                string = this.escape("->");
                break;
            }
            case 2: {
                string = "&rarr;";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    @NotNull
    public String renderMessage(@NotNull String message) {
        String string;
        Intrinsics.checkParameterIsNotNull(message, "message");
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$4[this.getTextFormat().ordinal()]) {
            case 1: {
                string = message;
                break;
            }
            case 2: {
                string = "<i>" + message + "</i>";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    @NotNull
    public String renderName(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return this.escape(RenderingUtilsKt.render(name));
    }

    private final void renderName(DeclarationDescriptor descriptor2, StringBuilder builder) {
        Name name = descriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull(name, "descriptor.name");
        builder.append(this.renderName(name));
    }

    private final void renderCompanionObjectName(DeclarationDescriptor descriptor2, StringBuilder builder) {
        if (this.getRenderCompanionObjectName()) {
            if (this.getStartFromName()) {
                builder.append("companion object");
            }
            this.renderSpaceIfNeeded(builder);
            DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
            if (containingDeclaration != null) {
                builder.append("of ");
                Name name = containingDeclaration.getName();
                Intrinsics.checkExpressionValueIsNotNull(name, "containingDeclaration.name");
                builder.append(this.renderName(name));
            }
        }
        if (this.getVerbose() || Intrinsics.areEqual(descriptor2.getName(), SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT) ^ true) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(builder);
            }
            Name name = descriptor2.getName();
            Intrinsics.checkExpressionValueIsNotNull(name, "descriptor.name");
            builder.append(this.renderName(name));
        }
    }

    @Override
    @NotNull
    public String renderFqName(@NotNull FqNameUnsafe fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        List<Name> list2 = fqName2.pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list2, "fqName.pathSegments()");
        return this.renderFqName(list2);
    }

    private final String renderFqName(List<Name> pathSegments) {
        return this.escape(RenderingUtilsKt.renderFqName(pathSegments));
    }

    @Override
    @NotNull
    public String renderClassifierName(@NotNull ClassifierDescriptor klass) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        if (ErrorUtils.isError(klass)) {
            return klass.getTypeConstructor().toString();
        }
        return this.getClassifierNamePolicy().renderClassifier(klass, this);
    }

    @Override
    @NotNull
    public String renderType(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return this.renderNormalizedType(this.getTypeNormalizer().invoke(type2));
    }

    private final String renderNormalizedType(KotlinType type2) {
        if (type2 instanceof LazyType && this.getDebugMode()) {
            return type2.toString();
        }
        if (DynamicTypesKt.isDynamic(type2)) {
            return "dynamic";
        }
        if (FlexibleTypesKt.isFlexible(type2)) {
            if (this.getDebugMode()) {
                return this.renderFlexibleTypeWithBothBounds(FlexibleTypesKt.flexibility(type2).getLowerBound(), FlexibleTypesKt.flexibility(type2).getUpperBound());
            }
            return this.renderFlexibleType(type2);
        }
        return this.renderInflexibleType(type2);
    }

    private final String renderFlexibleTypeWithBothBounds(KotlinType lower, KotlinType upper) {
        return this.renderFlexibleTypeWithBothBounds(this.renderNormalizedType(lower), this.renderNormalizedType(upper));
    }

    private final String renderFlexibleTypeWithBothBounds(String lower, String upper) {
        return "(" + lower + ".." + upper + ")";
    }

    private final String renderInflexibleType(KotlinType type2) {
        String customResult;
        Unit unit;
        boolean bl = !FlexibleTypesKt.isFlexible(type2);
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string = "Flexible types not allowed here: " + this.renderNormalizedType(type2);
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        KotlinType $receiver$iv = type2;
        CustomFlexibleRendering customFlexibleRendering = $receiver$iv.getCapability(CustomFlexibleRendering.class);
        String string = customResult = customFlexibleRendering != null ? customFlexibleRendering.renderInflexible(type2, this) : null;
        if (customResult != null) {
            return customResult;
        }
        if (Intrinsics.areEqual(type2, TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE) || TypeUtils.isDontCarePlaceholder(type2)) {
            return "???";
        }
        if (ErrorUtils.isUninferredParameter(type2)) {
            if (this.getUninferredTypeParameterAsName()) {
                TypeConstructor typeConstructor2 = type2.getConstructor();
                if (typeConstructor2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.types.ErrorUtils.UninferredParameterTypeConstructor");
                }
                String string2 = ((ErrorUtils.UninferredParameterTypeConstructor)typeConstructor2).getTypeParameterDescriptor().getName().toString();
                Intrinsics.checkExpressionValueIsNotNull(string2, "(type.constructor as Uni\u2026escriptor.name.toString()");
                return this.renderError(string2);
            }
            return "???";
        }
        if (type2.isError()) {
            return this.renderDefaultType(type2);
        }
        if (this.shouldRenderAsPrettyFunctionType(type2)) {
            return this.renderFunctionType(type2);
        }
        return this.renderDefaultType(type2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldRenderAsPrettyFunctionType(KotlinType type2) {
        Object element$iv;
        TypeProjection it;
        if (!FunctionTypesKt.isFunctionType(type2)) return false;
        Iterable $receiver$iv = type2.getArguments();
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
        } while (!(it = (TypeProjection)(element$iv = iterator2.next())).isStarProjection());
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final String renderFlexibleType(KotlinType type2) {
        void upperRendered;
        void lowerRendered;
        void $receiver$iv;
        KotlinType lower = FlexibleTypesKt.flexibility(type2).getLowerBound();
        KotlinType upper = FlexibleTypesKt.flexibility(type2).getUpperBound();
        KotlinType kotlinType = type2;
        Object object = $receiver$iv.getCapability(CustomFlexibleRendering.class);
        if (object == null || (object = object.renderBounds(FlexibleTypesKt.flexibility(type2), this)) == null) {
            object = new Pair<String, String>(this.renderInflexibleType(lower), this.renderInflexibleType(upper));
        }
        Pair<String, String> pair = object;
        String string = pair.component1();
        String string2 = pair.component2();
        pair = null;
        if (this.differsOnlyInNullability((String)lowerRendered, (String)upperRendered)) {
            if (StringsKt.startsWith$default((String)upperRendered, "(", false, 2, null)) {
                return "(" + (String)lowerRendered + ")!";
            }
            return (String)lowerRendered + "!";
        }
        ClassifierNamePolicy classifierNamePolicy = this.getClassifierNamePolicy();
        ClassifierDescriptor classifierDescriptor = TypeUtilsKt.getBuiltIns(type2).getCollection();
        Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor, "type.builtIns.collection");
        String kotlinCollectionsPrefix = StringsKt.substringBefore$default(classifierNamePolicy.renderClassifier(classifierDescriptor, this), "Collection", null, 2, null);
        String mutablePrefix = "Mutable";
        String simpleCollection = this.replacePrefixes((String)lowerRendered, kotlinCollectionsPrefix + mutablePrefix, (String)upperRendered, kotlinCollectionsPrefix, kotlinCollectionsPrefix + "(" + mutablePrefix + ")");
        if (simpleCollection != null) {
            return simpleCollection;
        }
        String mutableEntry = this.replacePrefixes((String)lowerRendered, kotlinCollectionsPrefix + "MutableMap.MutableEntry", (String)upperRendered, kotlinCollectionsPrefix + "Map.Entry", kotlinCollectionsPrefix + "(Mutable)Map.(Mutable)Entry");
        if (mutableEntry != null) {
            return mutableEntry;
        }
        ClassifierNamePolicy classifierNamePolicy2 = this.getClassifierNamePolicy();
        ClassifierDescriptor classifierDescriptor2 = TypeUtilsKt.getBuiltIns(type2).getArray();
        Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor2, "type.builtIns.array");
        String kotlinPrefix = StringsKt.substringBefore$default(classifierNamePolicy2.renderClassifier(classifierDescriptor2, this), "Array", null, 2, null);
        String array = this.replacePrefixes((String)lowerRendered, kotlinPrefix + this.escape("Array<"), (String)upperRendered, kotlinPrefix + this.escape("Array<out "), kotlinPrefix + this.escape("Array<(out) "));
        if (array != null) {
            return array;
        }
        return this.renderFlexibleTypeWithBothBounds((String)lowerRendered, (String)upperRendered);
    }

    @Override
    @NotNull
    public String renderTypeArguments(@NotNull List<? extends TypeProjection> typeArguments2) {
        Intrinsics.checkParameterIsNotNull(typeArguments2, "typeArguments");
        if (typeArguments2.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder $receiver = stringBuilder;
        $receiver.append(this.lt());
        this.appendTypeProjections(typeArguments2, $receiver);
        $receiver.append(this.gt());
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final String renderDefaultType(KotlinType type2) {
        StringBuilder sb = new StringBuilder();
        this.renderAnnotations(type2, sb);
        if (type2.isError()) {
            sb.append(type2.getConstructor().toString());
            List<TypeProjection> list2 = type2.getArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, "type.arguments");
            sb.append(this.renderTypeArguments(list2));
        } else {
            sb.append(DescriptorRendererImpl.renderTypeConstructorAndArguments$default(this, type2, null, 2, null));
        }
        if (type2.isMarkedNullable()) {
            sb.append("?");
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    private final String renderTypeConstructorAndArguments(KotlinType type2, TypeConstructor typeConstructor2) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder $receiver = stringBuilder;
        PossiblyInnerType possiblyInnerType = TypeParameterUtilsKt.buildPossiblyInnerType(type2);
        if (possiblyInnerType == null) {
            $receiver.append(this.renderTypeConstructor(typeConstructor2));
            List<TypeProjection> list2 = type2.getArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, "type.arguments");
            $receiver.append(this.renderTypeArguments(list2));
        } else {
            $receiver.append(this.renderPossiblyInnerType(possiblyInnerType));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    static /* bridge */ /* synthetic */ String renderTypeConstructorAndArguments$default(DescriptorRendererImpl descriptorRendererImpl, KotlinType kotlinType, TypeConstructor typeConstructor2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: renderTypeConstructorAndArguments");
        }
        if ((n & 2) != 0) {
            TypeConstructor typeConstructor3 = kotlinType.getConstructor();
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "type.constructor");
            typeConstructor2 = typeConstructor3;
        }
        return descriptorRendererImpl.renderTypeConstructorAndArguments(kotlinType, typeConstructor2);
    }

    private final String renderPossiblyInnerType(PossiblyInnerType possiblyInnerType) {
        StringBuilder $receiver;
        StringBuilder stringBuilder;
        block3: {
            Object object;
            block2: {
                stringBuilder = new StringBuilder();
                $receiver = stringBuilder;
                object = possiblyInnerType.getOuterType();
                if (object == null) break block2;
                PossiblyInnerType possiblyInnerType2 = object;
                PossiblyInnerType it = possiblyInnerType2;
                $receiver.append(this.renderPossiblyInnerType(it));
                $receiver.append('.');
                Name name = possiblyInnerType.getClassDescriptor().getName();
                Intrinsics.checkExpressionValueIsNotNull(name, "possiblyInnerType.classDescriptor.name");
                object = $receiver.append(this.renderName(name));
                if (object != null) break block3;
            }
            TypeConstructor typeConstructor2 = possiblyInnerType.getClassDescriptor().getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "possiblyInnerType.classDescriptor.typeConstructor");
            object = $receiver.append(this.renderTypeConstructor(typeConstructor2));
        }
        $receiver.append(this.renderTypeArguments(possiblyInnerType.getArguments()));
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public String renderTypeConstructor(@NotNull TypeConstructor typeConstructor2) {
        String string;
        ClassifierDescriptor cd;
        Intrinsics.checkParameterIsNotNull(typeConstructor2, "typeConstructor");
        ClassifierDescriptor classifierDescriptor = cd = typeConstructor2.getDeclarationDescriptor();
        if (classifierDescriptor instanceof TypeParameterDescriptor || classifierDescriptor instanceof ClassDescriptor) {
            string = this.renderClassifierName(cd);
        } else if (Intrinsics.areEqual(classifierDescriptor, null)) {
            string = typeConstructor2.toString();
        } else {
            String string2 = "Unexpected classifier: " + cd.getClass();
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    @Override
    @NotNull
    public String renderTypeProjection(@NotNull TypeProjection typeProjection) {
        Intrinsics.checkParameterIsNotNull(typeProjection, "typeProjection");
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder $receiver = stringBuilder;
        this.appendTypeProjections(CollectionsKt.listOf(typeProjection), $receiver);
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void appendTypeProjections(List<? extends TypeProjection> typeProjections, StringBuilder builder) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = typeProjections;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string;
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            void var13_10 = destination$iv$iv;
            if (it.isStarProjection()) {
                string = "*";
            } else {
                KotlinType kotlinType = it.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "it.type");
                String type2 = this.renderType(kotlinType);
                string = Intrinsics.areEqual((Object)it.getProjectionKind(), (Object)Variance.INVARIANT) ? type2 : (Object)((Object)it.getProjectionKind()) + " " + type2;
            }
            String string2 = string;
            var13_10.add(string2);
        }
        CollectionsKt.joinTo$default((List)destination$iv$iv, builder, ", ", null, null, 0, null, null, 124, null);
    }

    private final String renderFunctionType(KotlinType type2) {
        KotlinType receiverType;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder $receiver = stringBuilder;
        boolean isNullable = type2.isMarkedNullable();
        if (isNullable) {
            $receiver.append("(");
        }
        if ((receiverType = FunctionTypesKt.getReceiverTypeFromFunctionType(type2)) != null) {
            boolean surroundReceiver;
            boolean bl = surroundReceiver = this.shouldRenderAsPrettyFunctionType(receiverType) && !receiverType.isMarkedNullable();
            if (surroundReceiver) {
                $receiver.append("(");
            }
            $receiver.append(this.renderNormalizedType(receiverType));
            if (surroundReceiver) {
                $receiver.append(")");
            }
            $receiver.append(".");
        }
        $receiver.append("(");
        this.appendTypeProjections(FunctionTypesKt.getValueParameterTypesFromFunctionType(type2), $receiver);
        $receiver.append(") ").append(this.arrow()).append(" ");
        $receiver.append(this.renderNormalizedType(FunctionTypesKt.getReturnTypeFromFunctionType(type2)));
        if (isNullable) {
            $receiver.append(")?");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void appendDefinedIn(DeclarationDescriptor descriptor2, StringBuilder builder) {
        if (descriptor2 instanceof PackageFragmentDescriptor || descriptor2 instanceof PackageViewDescriptor) {
            return;
        }
        if (descriptor2 instanceof ModuleDescriptor) {
            builder.append(" is a module");
            return;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (containingDeclaration != null && !(containingDeclaration instanceof ModuleDescriptor)) {
            String string;
            builder.append(" ").append(this.renderMessage("defined in")).append(" ");
            FqNameUnsafe fqName2 = DescriptorUtils.getFqName(containingDeclaration);
            if (fqName2.isRoot()) {
                string = "root package";
            } else {
                FqNameUnsafe fqNameUnsafe = fqName2;
                Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "fqName");
                string = this.renderFqName(fqNameUnsafe);
            }
            builder.append(string);
        }
    }

    private final void renderAnnotations(Annotated annotated, StringBuilder builder) {
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.ANNOTATIONS) ^ true) {
            return;
        }
        Set<FqName> excluded = annotated instanceof KotlinType ? this.getExcludedTypeAnnotationClasses() : this.getExcludedAnnotationClasses();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder $receiver = stringBuilder;
        List<AnnotationWithTarget> sortedAnnotations = annotated.getAnnotations().getAllAnnotations();
        for (AnnotationWithTarget annotationWithTarget : sortedAnnotations) {
            AnnotationDescriptor annotation2 = annotationWithTarget.component1();
            AnnotationUseSiteTarget target = annotationWithTarget.component2();
            ClassifierDescriptor classifierDescriptor = annotation2.getType().getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            ClassDescriptor annotationClass = (ClassDescriptor)classifierDescriptor;
            if (excluded.contains(DescriptorUtils.getFqNameSafe(annotationClass))) continue;
            $receiver.append(this.renderAnnotation(annotation2, target)).append(" ");
        }
        StringBuilder annotationsBuilder = stringBuilder;
        builder.append((CharSequence)annotationsBuilder);
    }

    @Override
    @NotNull
    public String renderAnnotation(@NotNull AnnotationDescriptor annotation2, @Nullable AnnotationUseSiteTarget target) {
        KotlinType annotationType;
        Intrinsics.checkParameterIsNotNull(annotation2, "annotation");
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder $receiver = stringBuilder;
        $receiver.append('@');
        if (target != null) {
            $receiver.append(target.getRenderName() + ":");
        }
        KotlinType kotlinType = annotationType = annotation2.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "annotationType");
        $receiver.append(this.renderType(kotlinType));
        if (this.getVerbose()) {
            CollectionsKt.joinTo$default(this.renderAndSortAnnotationArguments(annotation2), $receiver, ", ", "(", ")", 0, null, null, 112, null);
            if (annotationType.isError() || annotationType.getConstructor().getDeclarationDescriptor() instanceof NotFoundClasses.MockClassDescriptor) {
                $receiver.append(" /* annotation class not found */");
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> renderAndSortAnnotationArguments(AnnotationDescriptor descriptor2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        String string;
        Collection collection;
        Collection destination$iv$iv2;
        ValueParameterDescriptor it;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2;
        List list2;
        void destination$iv$iv3;
        Object element$iv$iv2;
        Iterable $receiver$iv$iv3;
        Map<ValueParameterDescriptor, ConstantValue<?>> allValueArguments2 = descriptor2.getAllValueArguments();
        ClassDescriptor classDescriptor = this.getRenderDefaultAnnotationArguments() ? TypeUtils.getClassDescriptor(descriptor2.getType()) : (ClassDescriptor)null;
        Object object = classDescriptor;
        if (object != null && (object = object.getUnsubstitutedPrimaryConstructor()) != null && (object = object.getValueParameters()) != null) {
            void $receiver$iv3;
            Iterable iterable = (Iterable)object;
            void var6_5 = $receiver$iv3;
            Collection collection2 = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv3) {
                ValueParameterDescriptor it2 = (ValueParameterDescriptor)element$iv$iv2;
                if (!it2.declaresDefaultValue()) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            list2 = (List)destination$iv$iv3;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List parameterDescriptorsWithDefaultValue = list2;
        $receiver$iv$iv3 = parameterDescriptorsWithDefaultValue;
        destination$iv$iv3 = $receiver$iv2;
        Collection collection3 = new ArrayList();
        for (Object element$iv$iv3 : $receiver$iv$iv2) {
            it = (ValueParameterDescriptor)element$iv$iv3;
            if (!(!allValueArguments2.containsKey(it))) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            it = (ValueParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv2;
            string = it.getName().asString() + " = ...";
            collection.add(string);
        }
        List defaultList = (List)destination$iv$iv2;
        $receiver$iv$iv2 = allValueArguments2.entrySet();
        destination$iv$iv2 = $receiver$iv;
        element$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string2;
            void entry;
            Map.Entry $i$a$2$map = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            String name = ((ValueParameterDescriptor)entry.getKey()).getName().asString();
            if (!parameterDescriptorsWithDefaultValue.contains(entry.getKey())) {
                ConstantValue constantValue = (ConstantValue)entry.getValue();
                Intrinsics.checkExpressionValueIsNotNull(constantValue, "entry.value");
                string2 = this.renderConstant(constantValue);
            } else {
                string2 = "...";
            }
            String value = string2;
            string = name + " = " + value;
            collection.add(string);
        }
        List argumentList2 = (List)destination$iv$iv;
        return CollectionsKt.sorted(CollectionsKt.plus((Collection)defaultList, (Iterable)argumentList2));
    }

    /*
     * WARNING - void declaration
     */
    private final String renderConstant(ConstantValue<?> value) {
        String string;
        ConstantValue<?> constantValue = value;
        if (constantValue instanceof ArrayValue) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv = (Iterable)((ArrayValue)value).getValue();
            Iterable iterable = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ConstantValue constantValue2 = (ConstantValue)item$iv$iv;
                void var12_9 = destination$iv$iv;
                String string2 = this.renderConstant((ConstantValue<?>)it);
                var12_9.add(string2);
            }
            string = CollectionsKt.joinToString$default((List)destination$iv$iv, ", ", "{", "}", 0, null, null, 56, null);
        } else {
            string = constantValue instanceof AnnotationValue ? StringsKt.removePrefix(DescriptorRenderer.renderAnnotation$default(this, (AnnotationDescriptor)((AnnotationValue)value).getValue(), null, 2, null), (CharSequence)"@") : (constantValue instanceof KClassValue ? this.renderType(((KClassValue)value).getValue()) + "::class" : value.toString());
        }
        return string;
    }

    private final void renderVisibility(Visibility visibility, StringBuilder builder) {
        Visibility visibility2 = visibility;
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.VISIBILITY) ^ true) {
            return;
        }
        if (this.getNormalizedVisibilities()) {
            visibility2 = visibility2.normalize();
        }
        if (!this.getShowInternalKeyword() && Intrinsics.areEqual(visibility2, Visibilities.DEFAULT_VISIBILITY)) {
            return;
        }
        builder.append(this.renderKeyword(visibility2.getDisplayName())).append(" ");
    }

    private final void renderModality(Modality modality, StringBuilder builder) {
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.MODALITY) ^ true) {
            return;
        }
        String string = modality.name();
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).toLowerCase()");
        String keyword = string3;
        builder.append(this.renderKeyword(keyword)).append(" ");
    }

    private final void renderInner(boolean isInner, StringBuilder builder) {
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.INNER) ^ true) {
            return;
        }
        if (isInner) {
            builder.append(this.renderKeyword("inner")).append(" ");
        }
    }

    private final void renderData(boolean isData, StringBuilder builder) {
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.DATA) ^ true || !isData) {
            return;
        }
        builder.append(this.renderKeyword("data")).append(" ");
    }

    private final void renderModalityForCallable(CallableMemberDescriptor callable, StringBuilder builder) {
        if (!DescriptorUtils.isTopLevelDeclaration(callable) || Intrinsics.areEqual((Object)callable.getModality(), (Object)Modality.FINAL) ^ true) {
            if (this.overridesSomething(callable) && Intrinsics.areEqual((Object)this.getOverrideRenderingPolicy(), (Object)OverrideRenderingPolicy.RENDER_OVERRIDE) && Intrinsics.areEqual((Object)callable.getModality(), (Object)Modality.OPEN)) {
                return;
            }
            Modality modality = callable.getModality();
            Intrinsics.checkExpressionValueIsNotNull((Object)modality, "callable.modality");
            this.renderModality(modality, builder);
        }
    }

    private final void renderOverride(CallableMemberDescriptor callableMember, StringBuilder builder) {
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.OVERRIDE) ^ true) {
            return;
        }
        if (this.overridesSomething(callableMember) && Intrinsics.areEqual((Object)this.getOverrideRenderingPolicy(), (Object)OverrideRenderingPolicy.RENDER_OPEN) ^ true) {
            builder.append("override ");
            if (this.getVerbose()) {
                builder.append("/*").append(callableMember.getOverriddenDescriptors().size()).append("*/ ");
            }
        }
    }

    private final void renderMemberKind(CallableMemberDescriptor callableMember, StringBuilder builder) {
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.MEMBER_KIND) ^ true) {
            return;
        }
        if (this.getVerbose() && Intrinsics.areEqual((Object)callableMember.getKind(), (Object)CallableMemberDescriptor.Kind.DECLARATION) ^ true) {
            String string = callableMember.getKind().name();
            StringBuilder stringBuilder = builder.append("/*");
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).toLowerCase()");
            String string4 = string3;
            stringBuilder.append(string4).append("*/ ");
        }
    }

    private final void renderLateInit(PropertyDescriptor propertyDescriptor, StringBuilder builder) {
        if (propertyDescriptor.isLateInit()) {
            builder.append("lateinit ");
        }
    }

    private final void renderAdditionalModifiers(FunctionDescriptor functionDescriptor, StringBuilder builder) {
        FunctionDescriptor it;
        Iterable $receiver$iv;
        if (functionDescriptor.isOperator()) {
            boolean bl;
            block9: {
                $receiver$iv = functionDescriptor.getOverriddenDescriptors();
                for (Object element$iv : $receiver$iv) {
                    it = (FunctionDescriptor)element$iv;
                    if (!it.isOperator()) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
            if (bl || this.getAlwaysRenderModifiers()) {
                builder.append("operator ");
            }
        }
        if (functionDescriptor.isInfix()) {
            boolean bl;
            block10: {
                $receiver$iv = functionDescriptor.getOverriddenDescriptors();
                for (Object element$iv : $receiver$iv) {
                    it = (FunctionDescriptor)element$iv;
                    if (!it.isInfix()) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
            if (bl || this.getAlwaysRenderModifiers()) {
                builder.append("infix ");
            }
        }
        if (functionDescriptor.isExternal()) {
            builder.append("external ");
        }
        if (functionDescriptor.isInline()) {
            builder.append("inline ");
        }
        if (functionDescriptor.isTailrec()) {
            builder.append("tailrec ");
        }
    }

    @Override
    @NotNull
    public String render(@NotNull DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkParameterIsNotNull(declarationDescriptor, "declarationDescriptor");
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder $receiver = stringBuilder;
        declarationDescriptor.accept(new RenderDeclarationDescriptorVisitor(), $receiver);
        if (this.getWithDefinedIn()) {
            this.appendDefinedIn(declarationDescriptor, $receiver);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void renderTypeParameter(TypeParameterDescriptor typeParameter, StringBuilder builder, boolean topLevel) {
        if (topLevel) {
            builder.append(this.lt());
        }
        if (this.getVerbose()) {
            builder.append("/*").append(typeParameter.getIndex()).append("*/ ");
        }
        if (typeParameter.isReified()) {
            builder.append(this.renderKeyword("reified")).append(" ");
        }
        String variance = typeParameter.getVariance().getLabel();
        CharSequence charSequence = variance;
        if (!(charSequence.length() == 0)) {
            builder.append(this.renderKeyword(variance)).append(" ");
        }
        this.renderAnnotations(typeParameter, builder);
        this.renderName(typeParameter, builder);
        int upperBoundsCount = typeParameter.getUpperBounds().size();
        if (upperBoundsCount > 1 && !topLevel || upperBoundsCount == 1) {
            KotlinType upperBound = typeParameter.getUpperBounds().iterator().next();
            if (!KotlinBuiltIns.isDefaultBound(upperBound)) {
                StringBuilder stringBuilder = builder.append(" : ");
                KotlinType kotlinType = upperBound;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "upperBound");
                stringBuilder.append(this.renderType(kotlinType));
            }
        } else if (topLevel) {
            boolean first = true;
            for (KotlinType upperBound : typeParameter.getUpperBounds()) {
                if (KotlinBuiltIns.isDefaultBound(upperBound)) continue;
                if (first) {
                    builder.append(" : ");
                } else {
                    builder.append(" & ");
                }
                KotlinType kotlinType = upperBound;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "upperBound");
                builder.append(this.renderType(kotlinType));
                first = false;
            }
        }
        if (topLevel) {
            builder.append(this.gt());
        }
    }

    private final void renderTypeParameters(List<? extends TypeParameterDescriptor> typeParameters, StringBuilder builder, boolean withSpace) {
        if (this.getWithoutTypeParameters()) {
            return;
        }
        if (!typeParameters.isEmpty()) {
            builder.append(this.lt());
            this.renderTypeParameterList(builder, typeParameters);
            builder.append(this.gt());
            if (withSpace) {
                builder.append(" ");
            }
        }
    }

    private final void renderTypeParameterList(StringBuilder builder, List<? extends TypeParameterDescriptor> typeParameters) {
        Iterator<? extends TypeParameterDescriptor> iterator2 = typeParameters.iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor typeParameterDescriptor = iterator2.next();
            this.renderTypeParameter(typeParameterDescriptor, builder, false);
            if (!iterator2.hasNext()) continue;
            builder.append(", ");
        }
    }

    private final void renderFunction(FunctionDescriptor function, StringBuilder builder) {
        if (!this.getStartFromName()) {
            this.renderAnnotations(function, builder);
            Visibility visibility = function.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull(visibility, "function.visibility");
            this.renderVisibility(visibility, builder);
            this.renderModalityForCallable(function, builder);
            this.renderAdditionalModifiers(function, builder);
            this.renderOverride(function, builder);
            this.renderMemberKind(function, builder);
            if (this.getVerbose() && function.isHiddenToOvercomeSignatureClash()) {
                builder.append("/*isHiddenToOvercomeSignatureClash*/ ");
            }
            builder.append(this.renderKeyword("fun")).append(" ");
            List<TypeParameterDescriptor> list2 = function.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "function.typeParameters");
            this.renderTypeParameters(list2, builder, true);
            this.renderReceiver(function, builder);
        }
        this.renderName(function, builder);
        Collection collection = function.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(collection, "function.valueParameters");
        this.renderValueParameters(collection, function.hasSynthesizedParameterNames(), builder);
        this.renderReceiverAfterName(function, builder);
        KotlinType returnType2 = function.getReturnType();
        if (!(this.getWithoutReturnType() || !this.getUnitReturnType() && returnType2 != null && KotlinBuiltIns.isUnit(returnType2))) {
            builder.append(": ").append(returnType2 == null ? "[NULL]" : this.renderType(returnType2));
        }
        List<TypeParameterDescriptor> list3 = function.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, "function.typeParameters");
        this.renderWhereSuffix(list3, builder);
    }

    private final void renderReceiverAfterName(CallableDescriptor callableDescriptor, StringBuilder builder) {
        if (!this.getReceiverAfterName()) {
            return;
        }
        ReceiverParameterDescriptor receiver = callableDescriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            StringBuilder stringBuilder = builder.append(" on ");
            KotlinType kotlinType = receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "receiver.type");
            stringBuilder.append(this.renderType(kotlinType));
        }
    }

    private final void renderReceiver(CallableDescriptor callableDescriptor, StringBuilder builder) {
        ReceiverParameterDescriptor receiver = callableDescriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            KotlinType type2;
            KotlinType kotlinType = type2 = receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "type");
            String result2 = this.renderType(kotlinType);
            KotlinType kotlinType2 = type2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "type");
            if (this.shouldRenderAsPrettyFunctionType(kotlinType2) && !TypeUtils.isNullableType(type2)) {
                result2 = "(" + result2 + ")";
            }
            builder.append(result2).append(".");
        }
    }

    private final void renderConstructor(ConstructorDescriptor constructor, StringBuilder builder) {
        this.renderAnnotations(constructor, builder);
        Visibility visibility = constructor.getVisibility();
        Intrinsics.checkExpressionValueIsNotNull(visibility, "constructor.visibility");
        this.renderVisibility(visibility, builder);
        this.renderMemberKind(constructor, builder);
        builder.append(this.renderKeyword("constructor"));
        if (this.getSecondaryConstructorsAsPrimary()) {
            ClassDescriptor classDescriptor = constructor.getContainingDeclaration();
            builder.append(" ");
            DeclarationDescriptor declarationDescriptor = classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "classDescriptor");
            this.renderName(declarationDescriptor, builder);
            List<TypeParameterDescriptor> list2 = constructor.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "constructor.typeParameters");
            this.renderTypeParameters(list2, builder, false);
        }
        Collection collection = constructor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(collection, "constructor.valueParameters");
        this.renderValueParameters(collection, constructor.hasSynthesizedParameterNames(), builder);
        if (this.getSecondaryConstructorsAsPrimary()) {
            List<TypeParameterDescriptor> list3 = constructor.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list3, "constructor.typeParameters");
            this.renderWhereSuffix(list3, builder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderWhereSuffix(List<? extends TypeParameterDescriptor> typeParameters, StringBuilder builder) {
        if (this.getWithoutTypeParameters()) {
            return;
        }
        ArrayList upperBoundStrings = new ArrayList(0);
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
            void $receiver$iv;
            Iterable iterable = CollectionsKt.drop((Iterable)typeParameterDescriptor.getUpperBounds(), 1);
            for (Object item$iv : $receiver$iv) {
                void it;
                KotlinType kotlinType = (KotlinType)item$iv;
                Collection collection = upperBoundStrings;
                StringBuilder stringBuilder = new StringBuilder();
                Name name = typeParameterDescriptor.getName();
                Intrinsics.checkExpressionValueIsNotNull(name, "typeParameter.name");
                StringBuilder stringBuilder2 = stringBuilder.append(this.renderName(name)).append(" : ");
                void v3 = it;
                Intrinsics.checkExpressionValueIsNotNull(v3, "it");
                String string = stringBuilder2.append(this.renderType((KotlinType)v3)).toString();
                collection.add(string);
            }
        }
        if (!upperBoundStrings.isEmpty()) {
            builder.append(" ").append(this.renderKeyword("where")).append(" ");
            CollectionsKt.joinTo$default(upperBoundStrings, builder, ", ", null, null, 0, null, null, 124, null);
        }
    }

    @Override
    @NotNull
    public String renderValueParameters(@NotNull Collection<? extends ValueParameterDescriptor> parameters2, boolean synthesizedParameterNames) {
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder $receiver = stringBuilder;
        this.renderValueParameters(parameters2, synthesizedParameterNames, $receiver);
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void renderValueParameters(Collection<? extends ValueParameterDescriptor> parameters2, boolean synthesizedParameterNames, StringBuilder builder) {
        boolean includeNames = this.shouldRenderParameterNames(synthesizedParameterNames);
        int parameterCount = parameters2.size();
        this.getValueParametersHandler().appendBeforeValueParameters(parameterCount, builder);
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)parameters2)) {
            int index2 = indexedValue.component1();
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)indexedValue.component2();
            this.getValueParametersHandler().appendBeforeValueParameter(parameter, index2, parameterCount, builder);
            this.renderValueParameter(parameter, includeNames, builder, false);
            this.getValueParametersHandler().appendAfterValueParameter(parameter, index2, parameterCount, builder);
        }
        this.getValueParametersHandler().appendAfterValueParameters(parameterCount, builder);
    }

    private final boolean shouldRenderParameterNames(boolean synthesizedParameterNames) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$5[this.getParameterNameRenderingPolicy().ordinal()]) {
            case 1: {
                return true;
            }
            case 2: {
                return !synthesizedParameterNames;
            }
            case 3: {
                return false;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final void renderValueParameter(ValueParameterDescriptor valueParameter, boolean includeName, StringBuilder builder, boolean topLevel) {
        boolean withDefaultValue;
        if (topLevel) {
            builder.append(this.renderKeyword("value-parameter")).append(" ");
        }
        if (this.getVerbose()) {
            builder.append("/*").append(valueParameter.getIndex()).append("*/ ");
        }
        this.renderAnnotations(valueParameter, builder);
        if (valueParameter.isCrossinline()) {
            builder.append("crossinline ");
        }
        if (valueParameter.isNoinline()) {
            builder.append("noinline ");
        }
        this.renderVariable(valueParameter, includeName, builder, topLevel);
        boolean bl = this.getRenderDefaultValues() && (this.getDebugMode() ? valueParameter.declaresDefaultValue() : DescriptorUtilsKt.hasDefaultValue(valueParameter)) ? true : (withDefaultValue = false);
        if (withDefaultValue) {
            builder.append(" = ...");
        }
    }

    private final void renderValVarPrefix(VariableDescriptor variable, StringBuilder builder) {
        if (!(variable instanceof ValueParameterDescriptor)) {
            builder.append(this.renderKeyword(variable.isVar() ? "var" : "val")).append(" ");
        }
    }

    private final void renderVariable(VariableDescriptor variable, boolean includeName, StringBuilder builder, boolean topLevel) {
        KotlinType realType = variable.getType();
        VariableDescriptor variableDescriptor = variable;
        if (!(variableDescriptor instanceof ValueParameterDescriptor)) {
            variableDescriptor = null;
        }
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)variableDescriptor;
        KotlinType varargElementType = valueParameterDescriptor != null ? valueParameterDescriptor.getVarargElementType() : null;
        KotlinType kotlinType = varargElementType;
        if (kotlinType == null) {
            KotlinType kotlinType2 = realType;
            kotlinType = kotlinType2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "realType");
        }
        KotlinType typeToRender = kotlinType;
        if (varargElementType != null) {
            builder.append(this.renderKeyword("vararg")).append(" ");
        }
        if (topLevel && !this.getStartFromName()) {
            this.renderValVarPrefix(variable, builder);
        }
        if (includeName) {
            this.renderName(variable, builder);
            builder.append(": ");
        }
        builder.append(this.renderType(typeToRender));
        this.renderInitializer(variable, builder);
        if (this.getVerbose() && varargElementType != null) {
            StringBuilder stringBuilder = builder.append(" /*");
            KotlinType kotlinType3 = realType;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "realType");
            stringBuilder.append(this.renderType(kotlinType3)).append("*/");
        }
    }

    private final void renderProperty(PropertyDescriptor property, StringBuilder builder) {
        if (!this.getStartFromName()) {
            this.renderAnnotations(property, builder);
            Visibility visibility = property.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull(visibility, "property.visibility");
            this.renderVisibility(visibility, builder);
            if (property.isConst()) {
                builder.append("const ");
            }
            this.renderModalityForCallable(property, builder);
            this.renderOverride(property, builder);
            this.renderLateInit(property, builder);
            this.renderMemberKind(property, builder);
            this.renderValVarPrefix(property, builder);
            List<TypeParameterDescriptor> list2 = property.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "property.typeParameters");
            this.renderTypeParameters(list2, builder, true);
            this.renderReceiver(property, builder);
        }
        this.renderName(property, builder);
        StringBuilder stringBuilder = builder.append(": ");
        KotlinType kotlinType = property.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "property.type");
        stringBuilder.append(this.renderType(kotlinType));
        this.renderReceiverAfterName(property, builder);
        this.renderInitializer(property, builder);
        List<TypeParameterDescriptor> list3 = property.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, "property.typeParameters");
        this.renderWhereSuffix(list3, builder);
    }

    private final void renderInitializer(VariableDescriptor variable, StringBuilder builder) {
        if (this.getIncludePropertyConstant()) {
            StringBuilder stringBuilder;
            ConstantValue<?> constantValue = variable.getCompileTimeInitializer();
            if (constantValue != null) {
                ConstantValue<?> constantValue2 = constantValue;
                ConstantValue<?> constant = constantValue2;
                StringBuilder stringBuilder2 = builder.append(" = ");
                ConstantValue<?> constantValue3 = constant;
                Intrinsics.checkExpressionValueIsNotNull(constantValue3, "constant");
                stringBuilder = stringBuilder2.append(this.escape(this.renderConstant(constantValue3)));
            } else {
                stringBuilder = null;
            }
        }
    }

    private final void renderClass(ClassDescriptor klass, StringBuilder builder) {
        ConstructorDescriptor primaryConstructor2;
        List<TypeParameterDescriptor> typeParameters;
        boolean isEnumEntry = Intrinsics.areEqual((Object)klass.getKind(), (Object)ClassKind.ENUM_ENTRY);
        if (!this.getStartFromName()) {
            this.renderAnnotations(klass, builder);
            if (!isEnumEntry) {
                Visibility visibility = klass.getVisibility();
                Intrinsics.checkExpressionValueIsNotNull(visibility, "klass.visibility");
                this.renderVisibility(visibility, builder);
            }
            if (!(Intrinsics.areEqual((Object)klass.getKind(), (Object)ClassKind.INTERFACE) && Intrinsics.areEqual((Object)klass.getModality(), (Object)Modality.ABSTRACT) || klass.getKind().isSingleton() && Intrinsics.areEqual((Object)klass.getModality(), (Object)Modality.FINAL))) {
                Modality modality = klass.getModality();
                Intrinsics.checkExpressionValueIsNotNull((Object)modality, "klass.modality");
                this.renderModality(modality, builder);
            }
            this.renderInner(klass.isInner(), builder);
            this.renderData(klass.isData(), builder);
            this.renderClassKindPrefix(klass, builder);
        }
        if (!DescriptorUtils.isCompanionObject(klass)) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(builder);
            }
            this.renderName(klass, builder);
        } else {
            this.renderCompanionObjectName(klass, builder);
        }
        if (isEnumEntry) {
            return;
        }
        List<TypeParameterDescriptor> list2 = typeParameters = klass.getDeclaredTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "typeParameters");
        this.renderTypeParameters(list2, builder, false);
        if (this.getVerbose() && klass.isInner() && klass.getTypeConstructor().getParameters().size() > typeParameters.size()) {
            builder.append(" /*captured type parameters: ");
            List<TypeParameterDescriptor> constructorTypeParameters = klass.getTypeConstructor().getParameters();
            this.renderTypeParameterList(builder, constructorTypeParameters.subList(typeParameters.size(), constructorTypeParameters.size()));
            builder.append("*/");
        }
        if (!klass.getKind().isSingleton() && this.getClassWithPrimaryConstructor() && (primaryConstructor2 = klass.getUnsubstitutedPrimaryConstructor()) != null) {
            builder.append(" ");
            this.renderAnnotations(primaryConstructor2, builder);
            Visibility visibility = primaryConstructor2.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull(visibility, "primaryConstructor.visibility");
            this.renderVisibility(visibility, builder);
            builder.append("constructor");
            Collection collection = primaryConstructor2.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(collection, "primaryConstructor.valueParameters");
            this.renderValueParameters(collection, primaryConstructor2.hasSynthesizedParameterNames(), builder);
        }
        this.renderSuperTypes(klass, builder);
        List<TypeParameterDescriptor> list3 = typeParameters;
        Intrinsics.checkExpressionValueIsNotNull(list3, "typeParameters");
        this.renderWhereSuffix(list3, builder);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderSuperTypes(ClassDescriptor klass, StringBuilder builder) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        if (this.getWithoutSuperTypes()) {
            return;
        }
        if (KotlinBuiltIns.isNothing(klass.getDefaultType())) {
            return;
        }
        Collection<KotlinType> supertypes2 = klass.getTypeConstructor().getSupertypes();
        if (supertypes2.isEmpty() || supertypes2.size() == 1 && KotlinBuiltIns.isAnyOrNullableAny(supertypes2.iterator().next())) {
            return;
        }
        this.renderSpaceIfNeeded(builder);
        builder.append(": ");
        Iterable iterable = supertypes2;
        void var5_5 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            void var13_10 = destination$iv$iv;
            void v0 = it;
            Intrinsics.checkExpressionValueIsNotNull(v0, "it");
            String string = this.renderType((KotlinType)v0);
            var13_10.add(string);
        }
        CollectionsKt.joinTo$default((List)destination$iv$iv, builder, ", ", null, null, 0, null, null, 124, null);
    }

    private final void renderClassKindPrefix(ClassDescriptor klass, StringBuilder builder) {
        builder.append(this.renderKeyword(DescriptorRenderer.Companion.getClassKindPrefix(klass)));
    }

    private final void renderPackageView(PackageViewDescriptor packageView, StringBuilder builder) {
        builder.append(this.renderKeyword("package")).append(" ");
        FqNameUnsafe fqNameUnsafe = packageView.getFqName().toUnsafe();
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "packageView.fqName.toUnsafe()");
        builder.append(this.renderFqName(fqNameUnsafe));
        if (this.getDebugMode()) {
            builder.append(" in context of ");
            this.renderName(packageView.getModule(), builder);
        }
    }

    private final void renderPackageFragment(PackageFragmentDescriptor fragment, StringBuilder builder) {
        builder.append(this.renderKeyword("package-fragment")).append(" ");
        FqNameUnsafe fqNameUnsafe = fragment.getFqName().toUnsafe();
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "fragment.fqName.toUnsafe()");
        builder.append(this.renderFqName(fqNameUnsafe));
        if (this.getDebugMode()) {
            builder.append(" in ");
            this.renderName(fragment.getContainingDeclaration(), builder);
        }
    }

    private final void renderAccessorModifiers(PropertyAccessorDescriptor descriptor2, StringBuilder builder) {
        if (descriptor2.isExternal()) {
            builder.append("external ");
        }
    }

    private final void renderSpaceIfNeeded(StringBuilder builder) {
        int length = builder.length();
        if (length == 0 || builder.charAt(length - 1) != ' ') {
            builder.append(' ');
        }
    }

    private final String replacePrefixes(String lowerRendered, String lowerPrefix, String upperRendered, String upperPrefix, String foldedPrefix) {
        if (StringsKt.startsWith$default(lowerRendered, lowerPrefix, false, 2, null) && StringsKt.startsWith$default(upperRendered, upperPrefix, false, 2, null)) {
            String string = lowerRendered;
            int n = lowerPrefix.length();
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).substring(startIndex)");
            String lowerWithoutPrefix = string3;
            String string4 = upperRendered;
            int n2 = upperPrefix.length();
            String string5 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull(string6, "(this as java.lang.String).substring(startIndex)");
            String upperWithoutPrefix = string6;
            String flexibleCollectionName = foldedPrefix + lowerWithoutPrefix;
            if (Intrinsics.areEqual(lowerWithoutPrefix, upperWithoutPrefix)) {
                return flexibleCollectionName;
            }
            if (this.differsOnlyInNullability(lowerWithoutPrefix, upperWithoutPrefix)) {
                return flexibleCollectionName + "!";
            }
        }
        return null;
    }

    private final boolean differsOnlyInNullability(String lower, String upper) {
        return Intrinsics.areEqual(lower, StringsKt.replace$default(upper, "?", "", false, 4, null)) || StringsKt.endsWith$default(upper, "?", false, 2, null) && Intrinsics.areEqual(lower + "?", upper) || Intrinsics.areEqual("(" + lower + ")?", upper);
    }

    private final boolean overridesSomething(CallableMemberDescriptor callable) {
        return !callable.getOverriddenDescriptors().isEmpty();
    }

    @NotNull
    public final DescriptorRendererOptionsImpl getOptions() {
        return this.options;
    }

    public DescriptorRendererImpl(@NotNull DescriptorRendererOptionsImpl options) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(options, "options");
        this.options = options;
        boolean bl = this.options.isLocked();
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
    }

    @Override
    public boolean getAlwaysRenderModifiers() {
        return this.options.getAlwaysRenderModifiers();
    }

    @Override
    public void setAlwaysRenderModifiers(boolean bl) {
        this.options.setAlwaysRenderModifiers(bl);
    }

    @Override
    public boolean getClassWithPrimaryConstructor() {
        return this.options.getClassWithPrimaryConstructor();
    }

    @Override
    public void setClassWithPrimaryConstructor(boolean bl) {
        this.options.setClassWithPrimaryConstructor(bl);
    }

    @Override
    @NotNull
    public ClassifierNamePolicy getClassifierNamePolicy() {
        return this.options.getClassifierNamePolicy();
    }

    @Override
    public void setClassifierNamePolicy(@NotNull ClassifierNamePolicy classifierNamePolicy) {
        Intrinsics.checkParameterIsNotNull(classifierNamePolicy, "<set-?>");
        this.options.setClassifierNamePolicy(classifierNamePolicy);
    }

    @Override
    public boolean getDebugMode() {
        return this.options.getDebugMode();
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.options.setDebugMode(bl);
    }

    @Override
    @NotNull
    public Set<FqName> getExcludedAnnotationClasses() {
        return this.options.getExcludedAnnotationClasses();
    }

    @Override
    public void setExcludedAnnotationClasses(@NotNull Set<FqName> set) {
        Intrinsics.checkParameterIsNotNull(set, "<set-?>");
        this.options.setExcludedAnnotationClasses(set);
    }

    @Override
    @NotNull
    public Set<FqName> getExcludedTypeAnnotationClasses() {
        return this.options.getExcludedTypeAnnotationClasses();
    }

    @Override
    public void setExcludedTypeAnnotationClasses(@NotNull Set<FqName> set) {
        Intrinsics.checkParameterIsNotNull(set, "<set-?>");
        this.options.setExcludedTypeAnnotationClasses(set);
    }

    @Override
    public boolean getIncludePropertyConstant() {
        return this.options.getIncludePropertyConstant();
    }

    @Override
    public void setIncludePropertyConstant(boolean bl) {
        this.options.setIncludePropertyConstant(bl);
    }

    @Override
    @NotNull
    public Set<DescriptorRendererModifier> getModifiers() {
        return this.options.getModifiers();
    }

    @Override
    public void setModifiers(@NotNull Set<? extends DescriptorRendererModifier> set) {
        Intrinsics.checkParameterIsNotNull(set, "<set-?>");
        this.options.setModifiers(set);
    }

    @Override
    public boolean getNormalizedVisibilities() {
        return this.options.getNormalizedVisibilities();
    }

    @Override
    public void setNormalizedVisibilities(boolean bl) {
        this.options.setNormalizedVisibilities(bl);
    }

    @Override
    @NotNull
    public OverrideRenderingPolicy getOverrideRenderingPolicy() {
        return this.options.getOverrideRenderingPolicy();
    }

    @Override
    public void setOverrideRenderingPolicy(@NotNull OverrideRenderingPolicy overrideRenderingPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)overrideRenderingPolicy, "<set-?>");
        this.options.setOverrideRenderingPolicy(overrideRenderingPolicy);
    }

    @Override
    @NotNull
    public ParameterNameRenderingPolicy getParameterNameRenderingPolicy() {
        return this.options.getParameterNameRenderingPolicy();
    }

    @Override
    public void setParameterNameRenderingPolicy(@NotNull ParameterNameRenderingPolicy parameterNameRenderingPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)parameterNameRenderingPolicy, "<set-?>");
        this.options.setParameterNameRenderingPolicy(parameterNameRenderingPolicy);
    }

    @Override
    public boolean getReceiverAfterName() {
        return this.options.getReceiverAfterName();
    }

    @Override
    public void setReceiverAfterName(boolean bl) {
        this.options.setReceiverAfterName(bl);
    }

    @Override
    public boolean getRenderAccessors() {
        return this.options.getRenderAccessors();
    }

    @Override
    public void setRenderAccessors(boolean bl) {
        this.options.setRenderAccessors(bl);
    }

    @Override
    public boolean getRenderCompanionObjectName() {
        return this.options.getRenderCompanionObjectName();
    }

    @Override
    public void setRenderCompanionObjectName(boolean bl) {
        this.options.setRenderCompanionObjectName(bl);
    }

    @Override
    public boolean getRenderDefaultAnnotationArguments() {
        return this.options.getRenderDefaultAnnotationArguments();
    }

    @Override
    public void setRenderDefaultAnnotationArguments(boolean bl) {
        this.options.setRenderDefaultAnnotationArguments(bl);
    }

    @Override
    public boolean getRenderDefaultValues() {
        return this.options.getRenderDefaultValues();
    }

    @Override
    public void setRenderDefaultValues(boolean bl) {
        this.options.setRenderDefaultValues(bl);
    }

    @Override
    public boolean getSecondaryConstructorsAsPrimary() {
        return this.options.getSecondaryConstructorsAsPrimary();
    }

    @Override
    public void setSecondaryConstructorsAsPrimary(boolean bl) {
        this.options.setSecondaryConstructorsAsPrimary(bl);
    }

    @Override
    public boolean getShowInternalKeyword() {
        return this.options.getShowInternalKeyword();
    }

    @Override
    public void setShowInternalKeyword(boolean bl) {
        this.options.setShowInternalKeyword(bl);
    }

    @Override
    public boolean getStartFromName() {
        return this.options.getStartFromName();
    }

    @Override
    public void setStartFromName(boolean bl) {
        this.options.setStartFromName(bl);
    }

    @Override
    @NotNull
    public RenderingFormat getTextFormat() {
        return this.options.getTextFormat();
    }

    @Override
    public void setTextFormat(@NotNull RenderingFormat renderingFormat) {
        Intrinsics.checkParameterIsNotNull((Object)renderingFormat, "<set-?>");
        this.options.setTextFormat(renderingFormat);
    }

    @Override
    @NotNull
    public Function1<KotlinType, KotlinType> getTypeNormalizer() {
        return this.options.getTypeNormalizer();
    }

    @Override
    public void setTypeNormalizer(@NotNull Function1<? super KotlinType, ? extends KotlinType> function1) {
        Intrinsics.checkParameterIsNotNull(function1, "<set-?>");
        this.options.setTypeNormalizer(function1);
    }

    @Override
    public boolean getUninferredTypeParameterAsName() {
        return this.options.getUninferredTypeParameterAsName();
    }

    @Override
    public void setUninferredTypeParameterAsName(boolean bl) {
        this.options.setUninferredTypeParameterAsName(bl);
    }

    @Override
    public boolean getUnitReturnType() {
        return this.options.getUnitReturnType();
    }

    @Override
    public void setUnitReturnType(boolean bl) {
        this.options.setUnitReturnType(bl);
    }

    @Override
    @NotNull
    public DescriptorRenderer.ValueParametersHandler getValueParametersHandler() {
        return this.options.getValueParametersHandler();
    }

    @Override
    public void setValueParametersHandler(@NotNull DescriptorRenderer.ValueParametersHandler valueParametersHandler) {
        Intrinsics.checkParameterIsNotNull(valueParametersHandler, "<set-?>");
        this.options.setValueParametersHandler(valueParametersHandler);
    }

    @Override
    public boolean getVerbose() {
        return this.options.getVerbose();
    }

    @Override
    public void setVerbose(boolean bl) {
        this.options.setVerbose(bl);
    }

    @Override
    public boolean getWithDefinedIn() {
        return this.options.getWithDefinedIn();
    }

    @Override
    public void setWithDefinedIn(boolean bl) {
        this.options.setWithDefinedIn(bl);
    }

    @Override
    public boolean getWithoutReturnType() {
        return this.options.getWithoutReturnType();
    }

    @Override
    public void setWithoutReturnType(boolean bl) {
        this.options.setWithoutReturnType(bl);
    }

    @Override
    public boolean getWithoutSuperTypes() {
        return this.options.getWithoutSuperTypes();
    }

    @Override
    public void setWithoutSuperTypes(boolean bl) {
        this.options.setWithoutSuperTypes(bl);
    }

    @Override
    public boolean getWithoutTypeParameters() {
        return this.options.getWithoutTypeParameters();
    }

    @Override
    public void setWithoutTypeParameters(boolean bl) {
        this.options.setWithoutTypeParameters(bl);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010 \u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020!2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\"\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020#2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020%2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/renderer/DescriptorRendererImpl$RenderDeclarationDescriptorVisitor;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorVisitor;", "", "Ljava/lang/StringBuilder;", "(Lorg/jetbrains/kotlin/renderer/DescriptorRendererImpl;)V", "visitClassDescriptor", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "builder", "visitConstructorDescriptor", "constructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "visitFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "visitModuleDeclaration", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "visitPackageFragmentDescriptor", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "visitPackageViewDescriptor", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "visitPropertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "visitPropertyGetterDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyGetterDescriptor;", "visitPropertySetterDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertySetterDescriptor;", "visitReceiverParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "data", "visitScriptDescriptor", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "visitTypeParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "visitValueParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "visitVariableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "kotlin-compiler"})
    private final class RenderDeclarationDescriptorVisitor
    implements DeclarationDescriptorVisitor<Unit, StringBuilder> {
        @Override
        public void visitValueParameterDescriptor(@NotNull ValueParameterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderValueParameter(descriptor2, true, builder, true);
        }

        @Override
        public void visitVariableDescriptor(@NotNull VariableDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderVariable(descriptor2, true, builder, true);
        }

        @Override
        public void visitPropertyDescriptor(@NotNull PropertyDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderProperty(descriptor2, builder);
        }

        @Override
        public void visitPropertyGetterDescriptor(@NotNull PropertyGetterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            if (DescriptorRendererImpl.this.getRenderAccessors()) {
                DescriptorRendererImpl.this.renderAccessorModifiers(descriptor2, builder);
                builder.append("getter for ");
                PropertyDescriptor propertyDescriptor = descriptor2.getCorrespondingProperty();
                Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "descriptor.correspondingProperty");
                DescriptorRendererImpl.this.renderProperty(propertyDescriptor, builder);
            } else {
                this.visitFunctionDescriptor((FunctionDescriptor)descriptor2, builder);
            }
        }

        @Override
        public void visitPropertySetterDescriptor(@NotNull PropertySetterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            if (DescriptorRendererImpl.this.getRenderAccessors()) {
                DescriptorRendererImpl.this.renderAccessorModifiers(descriptor2, builder);
                builder.append("setter for ");
                PropertyDescriptor propertyDescriptor = descriptor2.getCorrespondingProperty();
                Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "descriptor.correspondingProperty");
                DescriptorRendererImpl.this.renderProperty(propertyDescriptor, builder);
            } else {
                this.visitFunctionDescriptor((FunctionDescriptor)descriptor2, builder);
            }
        }

        @Override
        public void visitFunctionDescriptor(@NotNull FunctionDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderFunction(descriptor2, builder);
        }

        @Override
        public void visitReceiverParameterDescriptor(@NotNull ReceiverParameterDescriptor descriptor2, @NotNull StringBuilder data) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(data, "data");
            throw (Throwable)new UnsupportedOperationException("Don't render receiver parameters");
        }

        @Override
        public void visitConstructorDescriptor(@NotNull ConstructorDescriptor constructorDescriptor, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(constructorDescriptor, "constructorDescriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderConstructor(constructorDescriptor, builder);
        }

        @Override
        public void visitTypeParameterDescriptor(@NotNull TypeParameterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderTypeParameter(descriptor2, builder, true);
        }

        @Override
        public void visitPackageFragmentDescriptor(@NotNull PackageFragmentDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderPackageFragment(descriptor2, builder);
        }

        @Override
        public void visitPackageViewDescriptor(@NotNull PackageViewDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderPackageView(descriptor2, builder);
        }

        @Override
        public void visitModuleDeclaration(@NotNull ModuleDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderName(descriptor2, builder);
        }

        @Override
        public void visitScriptDescriptor(@NotNull ScriptDescriptor scriptDescriptor, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            this.visitClassDescriptor((ClassDescriptor)scriptDescriptor, builder);
        }

        @Override
        public void visitClassDescriptor(@NotNull ClassDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderClass(descriptor2, builder);
        }
    }
}

