/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public final class PooledThreadExecutor {
    private static final Logger LOG = Logger.getInstance("#org.jetbrains.ide.PooledThreadExecutor");
    private static final AtomicInteger myAliveThreads = new AtomicInteger();
    private static final AtomicInteger seq = new AtomicInteger();
    private static final int ourReasonableThreadPoolSize = Registry.intValue("core.pooled.threads");
    private static final ExecutorService ourThreadExecutorsService;
    public static final ExecutorService INSTANCE;

    static {
        INSTANCE = ourThreadExecutorsService = new ThreadPoolExecutor(3, Integer.MAX_VALUE, 300L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                if (r == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "org/jetbrains/ide/PooledThreadExecutor$1", "newThread"));
                }
                int count = myAliveThreads.incrementAndGet();
                Thread thread2 = new Thread(r, "ApplicationImpl pooled thread " + seq.incrementAndGet()){

                    @Override
                    public void interrupt() {
                        LOG.debug("Interrupted worker, will remove from pool");
                        super.interrupt();
                    }

                    @Override
                    public void run() {
                        try {
                            super.run();
                        }
                        catch (Throwable t) {
                            LOG.debug("Worker exits due to exception", t);
                        }
                        finally {
                            myAliveThreads.decrementAndGet();
                        }
                    }
                };
                if (count > ourReasonableThreadPoolSize && ApplicationInfoImpl.getShadowInstance().isEAP()) {
                    File file = PerformanceWatcher.getInstance().dumpThreads("newPooledThread/", true);
                    LOG.info("Not enough pooled threads" + (file != null ? "; dumped threads into file '" + file.getPath() + "'" : ""));
                }
                thread2.setPriority(4);
                Thread thread3 = thread2;
                if (thread3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/PooledThreadExecutor$1", "newThread"));
                }
                return thread3;
            }
        });
    }
}

