/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.ConstructorHeaderCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/ConstructorHeaderCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "kotlin-compiler"})
public final class ConstructorHeaderCallChecker
implements CallChecker {
    public static final ConstructorHeaderCallChecker INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        boolean bl;
        ClassDescriptor labelReferenceClass;
        ClassDescriptor classDescriptor;
        Sequence<HierarchicalScope> $receiver$iv;
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        ClassDescriptor dispatchReceiverClass = ConstructorHeaderCallCheckerKt.access$getClassDescriptorForImplicitReceiver$p(resolvedCall.getDispatchReceiver());
        ClassDescriptor extensionReceiverClass = ConstructorHeaderCallCheckerKt.access$getClassDescriptorForImplicitReceiver$p(resolvedCall.getExtensionReceiver());
        KtElement ktElement = resolvedCall.getCall().getCallElement();
        if (!(ktElement instanceof KtInstanceExpressionWithLabel)) {
            ktElement = null;
        }
        KtInstanceExpressionWithLabel ktInstanceExpressionWithLabel = (KtInstanceExpressionWithLabel)ktElement;
        if (ktInstanceExpressionWithLabel != null) {
            KtInstanceExpressionWithLabel ktInstanceExpressionWithLabel2 = ktInstanceExpressionWithLabel;
            KtInstanceExpressionWithLabel instanceExpressionWithLabel = (KtInstanceExpressionWithLabel)((Object)$receiver$iv);
            Object v = context.trace.get(BindingContext.REFERENCE_TARGET, instanceExpressionWithLabel.getInstanceReference());
            if (!(v instanceof ClassDescriptor)) {
                v = null;
            }
            classDescriptor = (ClassDescriptor)v;
        } else {
            classDescriptor = labelReferenceClass = null;
        }
        if (dispatchReceiverClass == null && extensionReceiverClass == null && labelReferenceClass == null) {
            return;
        }
        $receiver$iv = ScopeUtilsKt.getParentsWithSelf(context.scope);
        Iterator<HierarchicalScope> iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return;
            HierarchicalScope element$iv = iterator2.next();
            HierarchicalScope it = element$iv;
            if (it instanceof LexicalScope && Intrinsics.areEqual((Object)((LexicalScope)it).getKind(), (Object)LexicalScopeKind.CONSTRUCTOR_HEADER)) {
                DeclarationDescriptor declarationDescriptor = ((LexicalScope)it).getOwnerDescriptor();
                if (declarationDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ConstructorDescriptor");
                }
                if (SetsKt.setOf(dispatchReceiverClass, extensionReceiverClass, labelReferenceClass).contains(((ConstructorDescriptor)declarationDescriptor).getContainingDeclaration())) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        boolean bl2 = true;
        if (!bl2) return;
        KtExpression ktExpression = context.call.getCalleeExpression();
        if (ktExpression == null) return;
        context.trace.report(Errors.INSTANCE_ACCESS_BEFORE_SUPER_CALL.on(ktExpression, (DeclarationDescriptor)resolvedCall.getResultingDescriptor()));
    }

    private ConstructorHeaderCallChecker() {
        INSTANCE = this;
    }

    static {
        new ConstructorHeaderCallChecker();
    }
}

